/*!
 * Font Awesome Icon Picker
 * https://fa-regularbelous.github.io/fontawesome-iconpicker/
 *
 * @author Javi Aguilar, itsjavi.com
 * @license MIT License
 * @see https://github.com/fa-regularbelous/fontawesome-iconpicker/blob/master/LICENSE
 */


(function(e) {
    if (typeof define === "function" && define.amd) {
        define([ "jquery" ], e);
    } else {
        e(jQuery);
    }
})(function(j) {
    j.ui = j.ui || {};
    var e = j.ui.version = "1.12.1";
    (function() {
        var r, y = Math.max, x = Math.abs, s = /left|center|right/, i = /top|center|bottom/, f = /[\+\-]\d+(\.[\d]+)?%?/, l = /^\w+/, c = /%$/, a = j.fn.pos;
        function q(e, a, t) {
            return [ parseFloat(e[0]) * (c.test(e[0]) ? a / 100 : 1), parseFloat(e[1]) * (c.test(e[1]) ? t / 100 : 1) ];
        }
        function C(e, a) {
            return parseInt(j.css(e, a), 10) || 0;
        }
        function t(e) {
            var a = e[0];
            if (a.nodeType === 9) {
                return {
                    width: e.width(),
                    height: e.height(),
                    offset: {
                        top: 0,
                        left: 0
                    }
                };
            }
            if (j.isWindow(a)) {
                return {
                    width: e.width(),
                    height: e.height(),
                    offset: {
                        top: e.scrollTop(),
                        left: e.scrollLeft()
                    }
                };
            }
            if (a.preventDefault) {
                return {
                    width: 0,
                    height: 0,
                    offset: {
                        top: a.pageY,
                        left: a.pageX
                    }
                };
            }
            return {
                width: e.outerWidth(),
                height: e.outerHeight(),
                offset: e.offset()
            };
        }
        j.pos = {
            scrollbarWidth: function() {
                if (r !== undefined) {
                    return r;
                }
                var e, a, t = j("<div " + "style='display:block;position:absolute;width:50px;height:50px;overflow:hidden;'>" + "<div style='height:100px;width:auto;'></div></div>"), s = t.children()[0];
                j("body").append(t);
                e = s.offsetWidth;
                t.css("overflow", "scroll");
                a = s.offsetWidth;
                if (e === a) {
                    a = t[0].clientWidth;
                }
                t.remove();
                return r = e - a;
            },
            getScrollInfo: function(e) {
                var a = e.isWindow || e.isDocument ? "" : e.element.css("overflow-x"), t = e.isWindow || e.isDocument ? "" : e.element.css("overflow-y"), s = a === "scroll" || a === "auto" && e.width < e.element[0].scrollWidth, r = t === "scroll" || t === "auto" && e.height < e.element[0].scrollHeight;
                return {
                    width: r ? j.pos.scrollbarWidth() : 0,
                    height: s ? j.pos.scrollbarWidth() : 0
                };
            },
            getWithinInfo: function(e) {
                var a = j(e || window), t = j.isWindow(a[0]), s = !!a[0] && a[0].nodeType === 9, r = !t && !s;
                return {
                    element: a,
                    isWindow: t,
                    isDocument: s,
                    offset: r ? j(e).offset() : {
                        left: 0,
                        top: 0
                    },
                    scrollLeft: a.scrollLeft(),
                    scrollTop: a.scrollTop(),
                    width: a.outerWidth(),
                    height: a.outerHeight()
                };
            }
        };
        j.fn.pos = function(h) {
            if (!h || !h.of) {
                return a.apply(this, arguments);
            }
            h = j.extend({}, h);
            var m, p, d, u, T, e, g = j(h.of), b = j.pos.getWithinInfo(h.within), k = j.pos.getScrollInfo(b), w = (h.collision || "flip").split(" "), v = {};
            e = t(g);
            if (g[0].preventDefault) {
                h.at = "left top";
            }
            p = e.width;
            d = e.height;
            u = e.offset;
            T = j.extend({}, u);
            j.each([ "my", "at" ], function() {
                var e = (h[this] || "").split(" "), a, t;
                if (e.length === 1) {
                    e = s.test(e[0]) ? e.concat([ "center" ]) : i.test(e[0]) ? [ "center" ].concat(e) : [ "center", "center" ];
                }
                e[0] = s.test(e[0]) ? e[0] : "center";
                e[1] = i.test(e[1]) ? e[1] : "center";
                a = f.exec(e[0]);
                t = f.exec(e[1]);
                v[this] = [ a ? a[0] : 0, t ? t[0] : 0 ];
                h[this] = [ l.exec(e[0])[0], l.exec(e[1])[0] ];
            });
            if (w.length === 1) {
                w[1] = w[0];
            }
            if (h.at[0] === "right") {
                T.left += p;
            } else if (h.at[0] === "center") {
                T.left += p / 2;
            }
            if (h.at[1] === "bottom") {
                T.top += d;
            } else if (h.at[1] === "center") {
                T.top += d / 2;
            }
            m = q(v.at, p, d);
            T.left += m[0];
            T.top += m[1];
            return this.each(function() {
                var t, e, f = j(this), l = f.outerWidth(), c = f.outerHeight(), a = C(this, "marginLeft"), s = C(this, "marginTop"), r = l + a + C(this, "marginRight") + k.width, i = c + s + C(this, "marginBottom") + k.height, o = j.extend({}, T), n = q(v.my, f.outerWidth(), f.outerHeight());
                if (h.my[0] === "right") {
                    o.left -= l;
                } else if (h.my[0] === "center") {
                    o.left -= l / 2;
                }
                if (h.my[1] === "bottom") {
                    o.top -= c;
                } else if (h.my[1] === "center") {
                    o.top -= c / 2;
                }
                o.left += n[0];
                o.top += n[1];
                t = {
                    marginLeft: a,
                    marginTop: s
                };
                j.each([ "left", "top" ], function(e, a) {
                    if (j.ui.pos[w[e]]) {
                        j.ui.pos[w[e]][a](o, {
                            targetWidth: p,
                            targetHeight: d,
                            elemWidth: l,
                            elemHeight: c,
                            collisionPosition: t,
                            collisionWidth: r,
                            collisionHeight: i,
                            offset: [ m[0] + n[0], m[1] + n[1] ],
                            my: h.my,
                            at: h.at,
                            within: b,
                            elem: f
                        });
                    }
                });
                if (h.using) {
                    e = function(e) {
                        var a = u.left - o.left, t = a + p - l, s = u.top - o.top, r = s + d - c, i = {
                            target: {
                                element: g,
                                left: u.left,
                                top: u.top,
                                width: p,
                                height: d
                            },
                            element: {
                                element: f,
                                left: o.left,
                                top: o.top,
                                width: l,
                                height: c
                            },
                            horizontal: t < 0 ? "left" : a > 0 ? "right" : "center",
                            vertical: r < 0 ? "top" : s > 0 ? "bottom" : "middle"
                        };
                        if (p < l && x(a + t) < p) {
                            i.horizontal = "center";
                        }
                        if (d < c && x(s + r) < d) {
                            i.vertical = "middle";
                        }
                        if (y(x(a), x(t)) > y(x(s), x(r))) {
                            i.important = "horizontal";
                        } else {
                            i.important = "vertical";
                        }
                        h.using.call(this, e, i);
                    };
                }
                f.offset(j.extend(o, {
                    using: e
                }));
            });
        };
        j.ui.pos = {
            _trigger: function(e, a, t, s) {
                if (a.elem) {
                    a.elem.trigger({
                        type: t,
                        position: e,
                        positionData: a,
                        triggered: s
                    });
                }
            },
            fit: {
                left: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "fitLeft");
                    var t = a.within, s = t.isWindow ? t.scrollLeft : t.offset.left, r = t.width, i = e.left - a.collisionPosition.marginLeft, f = s - i, l = i + a.collisionWidth - r - s, c;
                    if (a.collisionWidth > r) {
                        if (f > 0 && l <= 0) {
                            c = e.left + f + a.collisionWidth - r - s;
                            e.left += f - c;
                        } else if (l > 0 && f <= 0) {
                            e.left = s;
                        } else {
                            if (f > l) {
                                e.left = s + r - a.collisionWidth;
                            } else {
                                e.left = s;
                            }
                        }
                    } else if (f > 0) {
                        e.left += f;
                    } else if (l > 0) {
                        e.left -= l;
                    } else {
                        e.left = y(e.left - i, e.left);
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "fitLeft");
                },
                top: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "fitTop");
                    var t = a.within, s = t.isWindow ? t.scrollTop : t.offset.top, r = a.within.height, i = e.top - a.collisionPosition.marginTop, f = s - i, l = i + a.collisionHeight - r - s, c;
                    if (a.collisionHeight > r) {
                        if (f > 0 && l <= 0) {
                            c = e.top + f + a.collisionHeight - r - s;
                            e.top += f - c;
                        } else if (l > 0 && f <= 0) {
                            e.top = s;
                        } else {
                            if (f > l) {
                                e.top = s + r - a.collisionHeight;
                            } else {
                                e.top = s;
                            }
                        }
                    } else if (f > 0) {
                        e.top += f;
                    } else if (l > 0) {
                        e.top -= l;
                    } else {
                        e.top = y(e.top - i, e.top);
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "fitTop");
                }
            },
            flip: {
                left: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "flipLeft");
                    var t = a.within, s = t.offset.left + t.scrollLeft, r = t.width, i = t.isWindow ? t.scrollLeft : t.offset.left, f = e.left - a.collisionPosition.marginLeft, l = f - i, c = f + a.collisionWidth - r - i, o = a.my[0] === "left" ? -a.elemWidth : a.my[0] === "right" ? a.elemWidth : 0, n = a.at[0] === "left" ? a.targetWidth : a.at[0] === "right" ? -a.targetWidth : 0, h = -2 * a.offset[0], m, p;
                    if (l < 0) {
                        m = e.left + o + n + h + a.collisionWidth - r - s;
                        if (m < 0 || m < x(l)) {
                            e.left += o + n + h;
                        }
                    } else if (c > 0) {
                        p = e.left - a.collisionPosition.marginLeft + o + n + h - i;
                        if (p > 0 || x(p) < c) {
                            e.left += o + n + h;
                        }
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "flipLeft");
                },
                top: function(e, a) {
                    j.ui.pos._trigger(e, a, "posCollide", "flipTop");
                    var t = a.within, s = t.offset.top + t.scrollTop, r = t.height, i = t.isWindow ? t.scrollTop : t.offset.top, f = e.top - a.collisionPosition.marginTop, l = f - i, c = f + a.collisionHeight - r - i, o = a.my[1] === "top", n = o ? -a.elemHeight : a.my[1] === "bottom" ? a.elemHeight : 0, h = a.at[1] === "top" ? a.targetHeight : a.at[1] === "bottom" ? -a.targetHeight : 0, m = -2 * a.offset[1], p, d;
                    if (l < 0) {
                        d = e.top + n + h + m + a.collisionHeight - r - s;
                        if (d < 0 || d < x(l)) {
                            e.top += n + h + m;
                        }
                    } else if (c > 0) {
                        p = e.top - a.collisionPosition.marginTop + n + h + m - i;
                        if (p > 0 || x(p) < c) {
                            e.top += n + h + m;
                        }
                    }
                    j.ui.pos._trigger(e, a, "posCollided", "flipTop");
                }
            },
            flipfit: {
                left: function() {
                    j.ui.pos.flip.left.apply(this, arguments);
                    j.ui.pos.fit.left.apply(this, arguments);
                },
                top: function() {
                    j.ui.pos.flip.top.apply(this, arguments);
                    j.ui.pos.fit.top.apply(this, arguments);
                }
            }
        };
        (function() {
            var e, a, t, s, r, i = document.getElementsByTagName("body")[0], f = document.createElement("div");
            e = document.createElement(i ? "div" : "body");
            t = {
                visibility: "hidden",
                width: 0,
                height: 0,
                border: 0,
                margin: 0,
                background: "none"
            };
            if (i) {
                j.extend(t, {
                    position: "absolute",
                    left: "-1000px",
                    top: "-1000px"
                });
            }
            for (r in t) {
                e.style[r] = t[r];
            }
            e.appendChild(f);
            a = i || document.documentElement;
            a.insertBefore(e, a.firstChild);
            f.style.cssText = "position: absolute; left: 10.7432222px;";
            s = j(f).offset().left;
            j.support.offsetFractions = s > 10 && s < 11;
            e.innerHTML = "";
            a.removeChild(e);
        })();
    })();
    var a = j.ui.position;
});

(function(e) {
    "use strict";
    if (typeof define === "function" && define.amd) {
        define([ "jquery" ], e);
    } else if (window.jQuery && !window.jQuery.fn.iconpicker) {
        e(window.jQuery);
    }
})(function(c) {
    "use strict";
    var f = {
        isEmpty: function(e) {
            return e === false || e === "" || e === null || e === undefined;
        },
        isEmptyObject: function(e) {
            return this.isEmpty(e) === true || e.length === 0;
        },
        isElement: function(e) {
            return c(e).length > 0;
        },
        isString: function(e) {
            return typeof e === "string" || e instanceof String;
        },
        isArray: function(e) {
            return c.isArray(e);
        },
        inArray: function(e, a) {
            return c.inArray(e, a) !== -1;
        },
        throwError: function(e) {
            throw "Font Awesome Icon Picker Exception: " + e;
        }
    };
    var t = function(e, a) {
        this._id = t._idCounter++;
        this.element = c(e).addClass("iconpicker-element");
        this._trigger("iconpickerCreate", {
            iconpickerValue: this.iconpickerValue
        });
        this.options = c.extend({}, t.defaultOptions, this.element.data(), a);
        this.options.templates = c.extend({}, t.defaultOptions.templates, this.options.templates);
        this.options.originalPlacement = this.options.placement;
        this.container = f.isElement(this.options.container) ? c(this.options.container) : false;
        if (this.container === false) {
            if (this.element.is(".dropdown-toggle")) {
                this.container = c("~ .dropdown-menu:first", this.element);
            } else {
                this.container = this.element.is("input,textarea,button,.btn") ? this.element.parent() : this.element;
            }
        }
        this.container.addClass("iconpicker-container");
        if (this.isDropdownMenu()) {
            this.options.placement = "inline";
        }
        this.input = this.element.is("input,textarea") ? this.element.addClass("iconpicker-input") : false;
        if (this.input === false) {
            this.input = this.container.find(this.options.input);
            if (!this.input.is("input,textarea")) {
                this.input = false;
            }
        }
        this.component = this.isDropdownMenu() ? this.container.parent().find(this.options.component) : this.container.find(this.options.component);
        if (this.component.length === 0) {
            this.component = false;
        } else {
            this.component.find("i").addClass("iconpicker-component");
        }
        this._createPopover();
        this._createIconpicker();
        if (this.getAcceptButton().length === 0) {
            this.options.mustAccept = false;
        }
        if (this.isInputGroup()) {
            this.container.parent().append(this.popover);
        } else {
            this.container.append(this.popover);
        }
        this._bindElementEvents();
        this._bindWindowEvents();
        this.update(this.options.selected);
        if (this.isInline()) {
            this.show();
        }
        this._trigger("iconpickerCreated", {
            iconpickerValue: this.iconpickerValue
        });
    };
    t._idCounter = 0;
    t.defaultOptions = {
        title: false,
        selected: false,
        defaultValue: false,
        placement: "bottom",
        collision: "none",
        animation: true,
        hideOnSelect: false,
        showFooter: false,
        searchInFooter: false,
        mustAccept: false,
        selectedCustomClass: "bg-primary",
        icons: [],
        fullClassFormatter: function(e) {
            return e;
        },
        input: "input,.iconpicker-input",
        inputSearch: false,
        container: false,
        component: ".input-group-addon,.iconpicker-component",
        templates: {
            popover: '<div class="iconpicker-popover popover"><div class="arrow"></div>' + '<div class="popover-title"></div><div class="popover-content"></div></div>',
            footer: '<div class="popover-footer"></div>',
            buttons: '<button class="iconpicker-btn iconpicker-btn-cancel btn btn-default btn-sm">Cancel</button>' + ' <button class="iconpicker-btn iconpicker-btn-accept btn btn-primary btn-sm">Accept</button>',
            search: '<input type="search" class="form-control iconpicker-search" placeholder="Type to filter" />',
            iconpicker: '<div class="iconpicker"><div class="iconpicker-items"></div></div>',
            iconpickerItem: '<a role="button" href="javascript:;" class="iconpicker-item"><i></i></a>'
        }
    };
    t.batch = function(e, a) {
        var t = Array.prototype.slice.call(arguments, 2);
        return c(e).each(function() {
            var e = c(this).data("iconpicker");
            if (!!e) {
                e[a].apply(e, t);
            }
        });
    };
    t.prototype = {
        constructor: t,
        options: {},
        _id: 0,
        _trigger: function(e, a) {
            a = a || {};
            this.element.trigger(c.extend({
                type: e,
                iconpickerInstance: this
            }, a));
        },
        _createPopover: function() {
            this.popover = c(this.options.templates.popover);
            var e = this.popover.find(".popover-title");
            if (!!this.options.title) {
                e.append(c('<div class="popover-title-text">' + this.options.title + "</div>"));
            }
            if (this.hasSeparatedSearchInput() && !this.options.searchInFooter) {
                e.append(this.options.templates.search);
            } else if (!this.options.title) {
                e.remove();
            }
            if (this.options.showFooter && !f.isEmpty(this.options.templates.footer)) {
                var a = c(this.options.templates.footer);
                if (this.hasSeparatedSearchInput() && this.options.searchInFooter) {
                    a.append(c(this.options.templates.search));
                }
                if (!f.isEmpty(this.options.templates.buttons)) {
                    a.append(c(this.options.templates.buttons));
                }
                this.popover.append(a);
            }
            if (this.options.animation === true) {
                this.popover.addClass("fade");
            }
            return this.popover;
        },
        _createIconpicker: function() {
            var t = this;
            this.iconpicker = c(this.options.templates.iconpicker);
            var e = function(e) {
                var a = c(this);
                if (a.is("i")) {
                    a = a.parent();
                }
                t._trigger("iconpickerSelect", {
                    iconpickerItem: a,
                    iconpickerValue: t.iconpickerValue
                });
                if (t.options.mustAccept === false) {
                    t.update(a.data("iconpickerValue"));
                    t._trigger("iconpickerSelected", {
                        iconpickerItem: this,
                        iconpickerValue: t.iconpickerValue
                    });
                } else {
                    t.update(a.data("iconpickerValue"), true);
                }
                if (t.options.hideOnSelect && t.options.mustAccept === false) {
                    t.hide();
                }
            };
            var a = c(this.options.templates.iconpickerItem);
            var s = [];
            for (var r in this.options.icons) {
                if (typeof this.options.icons[r].title === "string") {
                    var i = a.clone();
                    i.find("i").addClass(this.options.fullClassFormatter(this.options.icons[r].title));
                    i.data("iconpickerValue", this.options.icons[r].title).on("click.iconpicker", e);
                    i.attr("title", "." + this.options.icons[r].title);
                    if (this.options.icons[r].searchTerms.length > 0) {
                        var f = "";
                        for (var l = 0; l < this.options.icons[r].searchTerms.length; l++) {
                            f = f + this.options.icons[r].searchTerms[l] + " ";
                        }
                        i.attr("data-search-terms", f);
                    }
                    s.push(i);
                }
            }
            this.iconpicker.find(".iconpicker-items").append(s);
            this.popover.find(".popover-content").append(this.iconpicker);
            return this.iconpicker;
        },
        _isEventInsideIconpicker: function(e) {
            var a = c(e.target);
            if ((!a.hasClass("iconpicker-element") || a.hasClass("iconpicker-element") && !a.is(this.element)) && a.parents(".iconpicker-popover").length === 0) {
                return false;
            }
            return true;
        },
        _bindElementEvents: function() {
            var a = this;
            this.getSearchInput().on("keyup.iconpicker", function() {
                a.filter(c(this).val().toLowerCase());
            });
            this.getAcceptButton().on("click.iconpicker", function() {
                var e = a.iconpicker.find(".iconpicker-selected").get(0);
                a.update(a.iconpickerValue);
                a._trigger("iconpickerSelected", {
                    iconpickerItem: e,
                    iconpickerValue: a.iconpickerValue
                });
                if (!a.isInline()) {
                    a.hide();
                }
            });
            this.getCancelButton().on("click.iconpicker", function() {
                if (!a.isInline()) {
                    a.hide();
                }
            });
            this.element.on("focus.iconpicker", function(e) {
                a.show();
                e.stopPropagation();
            });
            if (this.hasComponent()) {
                this.component.on("click.iconpicker", function() {
                    a.toggle();
                });
            }
            if (this.hasInput()) {
                this.input.on("keyup.iconpicker", function(e) {
                    if (!f.inArray(e.keyCode, [ 38, 40, 37, 39, 16, 17, 18, 9, 8, 91, 93, 20, 46, 186, 190, 46, 78, 188, 44, 86 ])) {
                        a.update();
                    } else {
                        a._updateFormGroupStatus(a.getValid(this.value) !== false);
                    }
                    if (a.options.inputSearch === true) {
                        a.filter(c(this).val().toLowerCase());
                    }
                });
            }
        },
        _bindWindowEvents: function() {
            var e = c(window.document);
            var a = this;
            var t = ".iconpicker.inst" + this._id;
            c(window).on("resize.iconpicker" + t + " orientationchange.iconpicker" + t, function(e) {
                if (a.popover.hasClass("in")) {
                    a.updatePlacement();
                }
            });
            if (!a.isInline()) {
                e.on("mouseup" + t, function(e) {
                    if (!a._isEventInsideIconpicker(e) && !a.isInline()) {
                        a.hide();
                    }
                });
            }
        },
        _unbindElementEvents: function() {
            this.popover.off(".iconpicker");
            this.element.off(".iconpicker");
            if (this.hasInput()) {
                this.input.off(".iconpicker");
            }
            if (this.hasComponent()) {
                this.component.off(".iconpicker");
            }
            if (this.hasContainer()) {
                this.container.off(".iconpicker");
            }
        },
        _unbindWindowEvents: function() {
            c(window).off(".iconpicker.inst" + this._id);
            c(window.document).off(".iconpicker.inst" + this._id);
        },
        updatePlacement: function(e, a) {
            e = e || this.options.placement;
            this.options.placement = e;
            a = a || this.options.collision;
            a = a === true ? "flip" : a;
            var t = {
                at: "right bottom",
                my: "right top",
                of: this.hasInput() && !this.isInputGroup() ? this.input : this.container,
                collision: a === true ? "flip" : a,
                within: window
            };
            this.popover.removeClass("inline topLeftCorner topLeft top topRight topRightCorner " + "rightTop right rightBottom bottomRight bottomRightCorner " + "bottom bottomLeft bottomLeftCorner leftBottom left leftTop");
            if (typeof e === "object") {
                return this.popover.pos(c.extend({}, t, e));
            }
            switch (e) {
              case "inline":
                {
                    t = false;
                }
                break;

              case "topLeftCorner":
                {
                    t.my = "right bottom";
                    t.at = "left top";
                }
                break;

              case "topLeft":
                {
                    t.my = "left bottom";
                    t.at = "left top";
                }
                break;

              case "top":
                {
                    t.my = "center bottom";
                    t.at = "center top";
                }
                break;

              case "topRight":
                {
                    t.my = "right bottom";
                    t.at = "right top";
                }
                break;

              case "topRightCorner":
                {
                    t.my = "left bottom";
                    t.at = "right top";
                }
                break;

              case "rightTop":
                {
                    t.my = "left bottom";
                    t.at = "right center";
                }
                break;

              case "right":
                {
                    t.my = "left center";
                    t.at = "right center";
                }
                break;

              case "rightBottom":
                {
                    t.my = "left top";
                    t.at = "right center";
                }
                break;

              case "bottomRightCorner":
                {
                    t.my = "left top";
                    t.at = "right bottom";
                }
                break;

              case "bottomRight":
                {
                    t.my = "right top";
                    t.at = "right bottom";
                }
                break;

              case "bottom":
                {
                    t.my = "center top";
                    t.at = "center bottom";
                }
                break;

              case "bottomLeft":
                {
                    t.my = "left top";
                    t.at = "left bottom";
                }
                break;

              case "bottomLeftCorner":
                {
                    t.my = "right top";
                    t.at = "left bottom";
                }
                break;

              case "leftBottom":
                {
                    t.my = "right top";
                    t.at = "left center";
                }
                break;

              case "left":
                {
                    t.my = "right center";
                    t.at = "left center";
                }
                break;

              case "leftTop":
                {
                    t.my = "right bottom";
                    t.at = "left center";
                }
                break;

              default:
                {
                    return false;
                }
                break;
            }
            this.popover.css({
                display: this.options.placement === "inline" ? "" : "block"
            });
            if (t !== false) {
                this.popover.pos(t).css("maxWidth", c(window).width() - this.container.offset().left - 5);
            } else {
                this.popover.css({
                    top: "auto",
                    right: "auto",
                    bottom: "auto",
                    left: "auto",
                    maxWidth: "none"
                });
            }
            this.popover.addClass(this.options.placement);
            return true;
        },
        _updateComponents: function() {
            this.iconpicker.find(".iconpicker-item.iconpicker-selected").removeClass("iconpicker-selected " + this.options.selectedCustomClass);
            if (this.iconpickerValue) {
                this.iconpicker.find("." + this.options.fullClassFormatter(this.iconpickerValue).replace(/ /g, ".")).parent().addClass("iconpicker-selected " + this.options.selectedCustomClass);
            }
            if (this.hasComponent()) {
                var e = this.component.find("i");
                if (e.length > 0) {
                    e.attr("class", this.options.fullClassFormatter(this.iconpickerValue));
                } else {
                    this.component.html(this.getHtml());
                }
            }
        },
        _updateFormGroupStatus: function(e) {
            if (this.hasInput()) {
                if (e !== false) {
                    this.input.parents(".form-group:first").removeClass("has-error");
                } else {
                    this.input.parents(".form-group:first").addClass("has-error");
                }
                return true;
            }
            return false;
        },
        getValid: function(e) {
            if (!f.isString(e)) {
                e = "";
            }
            var a = e === "";
            e = c.trim(e);
            var t = false;
            for (var s = 0; s < this.options.icons.length; s++) {
                if (this.options.icons[s].title === e) {
                    t = true;
                    break;
                }
            }
            if (t || a) {
                return e;
            }
            return false;
        },
        setValue: function(e) {
            
            var a = this.getValid(e);
            if (a !== false) {
                this.iconpickerValue = a;
                this._trigger("iconpickerSetValue", {
                    iconpickerValue: a
                });
                return this.iconpickerValue;
            } else {
                this._trigger("iconpickerInvalid", {
                    iconpickerValue: e
                });
                return false;
            }
        },
        getHtml: function() {
            return '<i class="' + this.options.fullClassFormatter(this.iconpickerValue) + '"></i>';
        },
        setSourceValue: function(e) {
            
            e = this.setValue(e);
            if (e !== false && e !== "") {
                if (this.hasInput()) {
                    this.input.val(this.getHtml());
                } else {
                    this.element.data("iconpickerValue", this.iconpickerValue);
                }
                this._trigger("iconpickerSetSourceValue", {
                    iconpickerValue: e
                });
            }
            return e;
        },
        getSourceValue: function(e) {
            e = e || this.options.defaultValue;
            var a = e;
            if (this.hasInput()) {
                a = this.input.val();
            } else {
                a = this.element.data("iconpickerValue");
            }
            if (a === undefined || a === "" || a === null || a === false) {
                a = e;
            }
            return a;
        },
        hasInput: function() {
            return this.input !== false;
        },
        isInputSearch: function() {
            return this.hasInput() && this.options.inputSearch === true;
        },
        isInputGroup: function() {
            return this.container.is(".input-group");
        },
        isDropdownMenu: function() {
            return this.container.is(".dropdown-menu");
        },
        hasSeparatedSearchInput: function() {
            return this.options.templates.search !== false && !this.isInputSearch();
        },
        hasComponent: function() {
            return this.component !== false;
        },
        hasContainer: function() {
            return this.container !== false;
        },
        getAcceptButton: function() {
            return this.popover.find(".iconpicker-btn-accept");
        },
        getCancelButton: function() {
            return this.popover.find(".iconpicker-btn-cancel");
        },
        getSearchInput: function() {
            return this.popover.find(".iconpicker-search");
        },
        filter: function(r) {
            if (f.isEmpty(r)) {
                this.iconpicker.find(".iconpicker-item").show();
                return c(false);
            } else {
                var i = [];
                this.iconpicker.find(".iconpicker-item").each(function() {
                    var e = c(this);
                    var a = e.attr("title").toLowerCase();
                    var t = e.attr("data-search-terms") ? e.attr("data-search-terms").toLowerCase() : "";
                    a = a + " " + t;
                    var s = false;
                    try {
                        s = new RegExp("(^|\\W)" + r, "g");
                    } catch (e) {
                        s = false;
                    }
                    if (s !== false && a.match(s)) {
                        i.push(e);
                        e.show();
                    } else {
                        e.hide();
                    }
                });
                return i;
            }
        },
        show: function() {
            if (this.popover.hasClass("in")) {
                return false;
            }
            c.iconpicker.batch(c(".iconpicker-popover.in:not(.inline)").not(this.popover), "hide");
            this._trigger("iconpickerShow", {
                iconpickerValue: this.iconpickerValue
            });
            this.updatePlacement();
            this.popover.addClass("in");
            setTimeout(c.proxy(function() {
                this.popover.css("display", this.isInline() ? "" : "block");
                this._trigger("iconpickerShown", {
                    iconpickerValue: this.iconpickerValue
                });
            }, this), this.options.animation ? 300 : 1);
        },
        hide: function() {
            if (!this.popover.hasClass("in")) {
                return false;
            }
            this._trigger("iconpickerHide", {
                iconpickerValue: this.iconpickerValue
            });
            this.popover.removeClass("in");
            setTimeout(c.proxy(function() {
                this.popover.css("display", "none");
                this.getSearchInput().val("");
                this.filter("");
                this._trigger("iconpickerHidden", {
                    iconpickerValue: this.iconpickerValue
                });
            }, this), this.options.animation ? 300 : 1);
        },
        toggle: function() {
            if (this.popover.is(":visible")) {
                this.hide();
            } else {
                this.show(true);
            }
        },
        update: function(e, a) {
            

            
            e = e ? e : this.getSourceValue(this.iconpickerValue);
            this._trigger("iconpickerUpdate", {
                iconpickerValue: this.iconpickerValue
            });
            if (a === true) {
                e = this.setValue(e);
            } else {
                e = this.setSourceValue(e);
                this._updateFormGroupStatus(e !== false);
            }
            if (e !== false) {
                this._updateComponents();
            }
            this._trigger("iconpickerUpdated", {
                iconpickerValue: this.iconpickerValue
            });
            return e;
        },
        destroy: function() {
            this._trigger("iconpickerDestroy", {
                iconpickerValue: this.iconpickerValue
            });
            this.element.removeData("iconpicker").removeData("iconpickerValue").removeClass("iconpicker-element");
            this._unbindElementEvents();
            this._unbindWindowEvents();
            c(this.popover).remove();
            this._trigger("iconpickerDestroyed", {
                iconpickerValue: this.iconpickerValue
            });
        },
        disable: function() {
            if (this.hasInput()) {
                this.input.prop("disabled", true);
                return true;
            }
            return false;
        },
        enable: function() {
            if (this.hasInput()) {
                this.input.prop("disabled", false);
                return true;
            }
            return false;
        },
        isDisabled: function() {
            if (this.hasInput()) {
                return this.input.prop("disabled") === true;
            }
            return false;
        },
        isInline: function() {
            return this.options.placement === "inline" || this.popover.hasClass("inline");
        }
    };
    c.iconpicker = t;
    c.fn.iconpicker = function(a) {
        return this.each(function() {
            var e = c(this);
            if (!e.data("iconpicker")) {
                e.data("iconpicker", new t(this, typeof a === "object" ? a : {}));
            }
        });
    };
    t.defaultOptions = c.extend(t.defaultOptions, {
        icons: [ 
        {
            title: "fa-brands fa-500px",
            searchTerms: []
        }, {
            title: "fa-brands fa-accessible-icon",
            searchTerms: [ "accessibility", "handicap", "person", "wheelchair", "wheelchair-alt" ]
        }, {
            title: "fa-brands fa-accusoft",
            searchTerms: []
        }, {
            title: "fa-brands fa-acquisitions-incorporated",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, {
            title: "fa-solid fa-ad",
            searchTerms: []
        }, {
            title: "fa-solid fa-address-book",
            searchTerms: []
        }, {
            title: "fa-regular fa-address-book",
            searchTerms: []
        }, {
            title: "fa-solid fa-address-card",
            searchTerms: []
        }, {
            title: "fa-regular fa-address-card",
            searchTerms: []
        }, {
            title: "fa-solid fa-adjust",
            searchTerms: [ "contrast" ]
        }, {
            title: "fa-brands fa-adn",
            searchTerms: []
        }, {
            title: "fa-brands fa-adversal",
            searchTerms: []
        }, {
            title: "fa-brands fa-affiliatetheme",
            searchTerms: []
        }, {
            title: "fa-solid fa-air-freshener",
            searchTerms: []
        }, {
            title: "fa-brands fa-algolia",
            searchTerms: []
        }, {
            title: "fa-solid fa-align-center",
            searchTerms: [ "middle", "text" ]
        }, {
            title: "fa-solid fa-align-justify",
            searchTerms: [ "text" ]
        }, {
            title: "fa-solid fa-align-left",
            searchTerms: [ "text" ]
        }, {
            title: "fa-solid fa-align-right",
            searchTerms: [ "text" ]
        }, {
            title: "fa-brands fa-alipay",
            searchTerms: []
        }, {
            title: "fa-solid fa-allergies",
            searchTerms: [ "freckles", "hand", "intolerances", "pox", "spots" ]
        }, {
            title: "fa-brands fa-amazon",
            searchTerms: []
        }, {
            title: "fa-brands fa-amazon-pay",
            searchTerms: []
        }, {
            title: "fa-solid fa-ambulance",
            searchTerms: [ "help", "machine", "support", "vehicle" ]
        }, {
            title: "fa-solid fa-american-sign-language-interpreting",
            searchTerms: []
        }, {
            title: "fa-brands fa-amilia",
            searchTerms: []
        }, {
            title: "fa-solid fa-anchor",
            searchTerms: [ "link" ]
        }, {
            title: "fa-brands fa-android",
            searchTerms: [ "robot" ]
        }, {
            title: "fa-brands fa-angellist",
            searchTerms: []
        }, {
            title: "fa-solid fa-angle-double-down",
            searchTerms: [ "arrows" ]
        }, {
            title: "fa-solid fa-angle-double-left",
            searchTerms: [ "arrows", "back", "laquo", "previous", "quote" ]
        }, {
            title: "fa-solid fa-angle-double-right",
            searchTerms: [ "arrows", "forward", "next", "quote", "raquo" ]
        }, {
            title: "fa-solid fa-angle-double-up",
            searchTerms: [ "arrows" ]
        }, {
            title: "fa-solid fa-angle-down",
            searchTerms: [ "arrow" ]
        }, {
            title: "fa-solid fa-angle-left",
            searchTerms: [ "arrow", "back", "previous" ]
        }, {
            title: "fa-solid fa-angle-right",
            searchTerms: [ "arrow", "forward", "next" ]
        }, {
            title: "fa-solid fa-angle-up",
            searchTerms: [ "arrow" ]
        }, {
            title: "fa-solid fa-angry",
            searchTerms: [ "disapprove", "emoticon", "face", "mad", "upset" ]
        }, {
            title: "fa-regular fa-angry",
            searchTerms: [ "disapprove", "emoticon", "face", "mad", "upset" ]
        }, {
            title: "fa-brands fa-angrycreative",
            searchTerms: []
        }, {
            title: "fa-brands fa-angular",
            searchTerms: []
        }, {
            title: "fa-solid fa-ankh",
            searchTerms: [ "amulet", "copper", "coptic christianity", "copts", "crux ansata", "egyptian", "venus" ]
        }, {
            title: "fa-brands fa-app-store",
            searchTerms: []
        }, {
            title: "fa-brands fa-app-store-ios",
            searchTerms: []
        }, {
            title: "fa-brands fa-apper",
            searchTerms: []
        }, {
            title: "fa-brands fa-apple",
            searchTerms: [ "food", "fruit", "mac", "osx" ]
        }, {
            title: "fa-solid fa-apple-alt",
            searchTerms: [ "fall", "food", "fruit", "fuji", "macintosh", "seasonal" ]
        }, {
            title: "fa-brands fa-apple-pay",
            searchTerms: []
        }, {
            title: "fa-solid fa-archive",
            searchTerms: [ "box", "package", "storage" ]
        }, {
            title: "fa-solid fa-archway",
            searchTerms: [ "arc", "monument", "road", "street" ]
        }, {
            title: "fa-solid fa-arrow-alt-circle-down",
            searchTerms: [ "arrow-circle-o-down", "download" ]
        }, {
            title: "fa-regular fa-arrow-alt-circle-down",
            searchTerms: [ "arrow-circle-o-down", "download" ]
        }, {
            title: "fa-solid fa-arrow-alt-circle-left",
            searchTerms: [ "arrow-circle-o-left", "back", "previous" ]
        }, {
            title: "fa-regular fa-arrow-alt-circle-left",
            searchTerms: [ "arrow-circle-o-left", "back", "previous" ]
        }, {
            title: "fa-solid fa-arrow-alt-circle-right",
            searchTerms: [ "arrow-circle-o-right", "forward", "next" ]
        }, {
            title: "fa-regular fa-arrow-alt-circle-right",
            searchTerms: [ "arrow-circle-o-right", "forward", "next" ]
        }, {
            title: "fa-solid fa-arrow-alt-circle-up",
            searchTerms: [ "arrow-circle-o-up" ]
        }, {
            title: "fa-regular fa-arrow-alt-circle-up",
            searchTerms: [ "arrow-circle-o-up" ]
        }, {
            title: "fa-solid fa-arrow-circle-down",
            searchTerms: [ "download" ]
        }, {
            title: "fa-solid fa-arrow-circle-left",
            searchTerms: [ "back", "previous" ]
        }, {
            title: "fa-solid fa-arrow-circle-right",
            searchTerms: [ "forward", "next" ]
        }, {
            title: "fa-solid fa-arrow-circle-up",
            searchTerms: []
        }, {
            title: "fa-solid fa-arrow-down",
            searchTerms: [ "download" ]
        }, {
            title: "fa-solid fa-arrow-left",
            searchTerms: [ "back", "previous" ]
        }, {
            title: "fa-solid fa-arrow-right",
            searchTerms: [ "forward", "next" ]
        }, {
            title: "fa-solid fa-arrow-up",
            searchTerms: []
        }, {
            title: "fa-solid fa-arrows-alt",
            searchTerms: [ "arrow", "arrows", "bigger", "enlarge", "expand", "fullscreen", "move", "position", "reorder", "resize" ]
        }, {
            title: "fa-solid fa-arrows-alt-h",
            searchTerms: [ "arrows-h", "resize" ]
        }, {
            title: "fa-solid fa-arrows-alt-v",
            searchTerms: [ "arrows-v", "resize" ]
        }, {
            title: "fa-solid fa-assistive-listening-systems",
            searchTerms: []
        }, {
            title: "fa-solid fa-asterisk",
            searchTerms: [ "details" ]
        }, {
            title: "fa-brands fa-asymmetrik",
            searchTerms: []
        }, {
            title: "fa-solid fa-at",
            searchTerms: [ "e-mail", "email" ]
        }, {
            title: "fa-solid fa-atlas",
            searchTerms: [ "book", "directions", "geography", "map", "wayfinding" ]
        }, {
            title: "fa-solid fa-atom",
            searchTerms: [ "atheism", "chemistry", "science" ]
        }, {
            title: "fa-brands fa-audible",
            searchTerms: []
        }, {
            title: "fa-solid fa-audio-description",
            searchTerms: []
        }, {
            title: "fa-brands fa-autoprefixer",
            searchTerms: []
        }, {
            title: "fa-brands fa-avianex",
            searchTerms: []
        }, {
            title: "fa-brands fa-aviato",
            searchTerms: []
        }, {
            title: "fa-solid fa-award",
            searchTerms: [ "honor", "praise", "prize", "recognition", "ribbon" ]
        }, {
            title: "fa-brands fa-aws",
            searchTerms: []
        }, {
            title: "fa-solid fa-backspace",
            searchTerms: [ "command", "delete", "keyboard", "undo" ]
        }, {
            title: "fa-solid fa-backward",
            searchTerms: [ "previous", "rewind" ]
        }, {
            title: "fa-solid fa-balance-scale",
            searchTerms: [ "balanced", "justice", "legal", "measure", "weight" ]
        }, {
            title: "fa-solid fa-ban",
            searchTerms: [ "abort", "ban", "block", "cancel", "delete", "hide", "prohibit", "remove", "stop", "trash" ]
        }, {
            title: "fa-solid fa-band-aid",
            searchTerms: [ "bandage", "boo boo", "ouch" ]
        }, {
            title: "fa-brands fa-bandcamp",
            searchTerms: []
        }, {
            title: "fa-solid fa-barcode",
            searchTerms: [ "scan" ]
        }, {
            title: "fa-solid fa-bars",
            searchTerms: [ "checklist", "drag", "hamburger", "list", "menu", "nav", "navigation", "ol", "reorder", "settings", "todo", "ul" ]
        }, {
            title: "fa-solid fa-baseball-ball",
            searchTerms: []
        }, {
            title: "fa-solid fa-basketball-ball",
            searchTerms: []
        }, {
            title: "fa-solid fa-bath",
            searchTerms: []
        }, {
            title: "fa-solid fa-battery-empty",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-solid fa-battery-full",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-solid fa-battery-half",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-solid fa-battery-quarter",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-solid fa-battery-three-quarters",
            searchTerms: [ "power", "status" ]
        }, {
            title: "fa-solid fa-bed",
            searchTerms: [ "lodging", "sleep", "travel" ]
        }, {
            title: "fa-solid fa-beer",
            searchTerms: [ "alcohol", "bar", "beverage", "drink", "liquor", "mug", "stein" ]
        }, {
            title: "fa-brands fa-behance",
            searchTerms: []
        }, {
            title: "fa-brands fa-behance-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-bell",
            searchTerms: [ "alert", "notification", "reminder" ]
        }, {
            title: "fa-regular fa-bell",
            searchTerms: [ "alert", "notification", "reminder" ]
        }, {
            title: "fa-solid fa-bell-slash",
            searchTerms: []
        }, {
            title: "fa-regular fa-bell-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-bezier-curve",
            searchTerms: [ "curves", "illustrator", "lines", "path", "vector" ]
        }, {
            title: "fa-solid fa-bible",
            searchTerms: [ "book", "catholicism", "christianity" ]
        }, {
            title: "fa-solid fa-bicycle",
            searchTerms: [ "bike", "gears", "transportation", "vehicle" ]
        }, {
            title: "fa-brands fa-bimobject",
            searchTerms: []
        }, {
            title: "fa-solid fa-binoculars",
            searchTerms: []
        }, {
            title: "fa-solid fa-birthday-cake",
            searchTerms: []
        }, {
            title: "fa-brands fa-bitbucket",
            searchTerms: [ "bitbucket-square", "git" ]
        }, {
            title: "fa-brands fa-bitcoin",
            searchTerms: []
        }, {
            title: "fa-brands fa-bity",
            searchTerms: []
        }, {
            title: "fa-brands fa-black-tie",
            searchTerms: []
        }, {
            title: "fa-brands fa-blackberry",
            searchTerms: []
        }, {
            title: "fa-solid fa-blender",
            searchTerms: []
        }, {
            title: "fa-solid fa-blender-phone",
            searchTerms: [ "appliance", "fantasy", "silly" ]
        }, {
            title: "fa-solid fa-blind",
            searchTerms: []
        }, {
            title: "fa-brands fa-blogger",
            searchTerms: []
        }, {
            title: "fa-brands fa-blogger-b",
            searchTerms: []
        }, {
            title: "fa-brands fa-bluetooth",
            searchTerms: []
        }, {
            title: "fa-brands fa-bluetooth-b",
            searchTerms: []
        }, {
            title: "fa-solid fa-bold",
            searchTerms: []
        }, {
            title: "fa-solid fa-bolt",
            searchTerms: [ "electricity", "lightning", "weather", "zap" ]
        }, {
            title: "fa-solid fa-bomb",
            searchTerms: []
        }, {
            title: "fa-solid fa-bone",
            searchTerms: []
        }, {
            title: "fa-solid fa-bong",
            searchTerms: [ "aparatus", "cannabis", "marijuana", "pipe", "smoke", "smoking" ]
        }, {
            title: "fa-solid fa-book",
            searchTerms: [ "documentation", "read" ]
        }, {
            title: "fa-solid fa-book-dead",
            searchTerms: [ "Dungeons & Dragons", "crossbones", "d&d", "dark arts", "death", "dnd", "documentation", "evil", "fantasy", "halloween", "holiday", "read", "skull", "spell" ]
        }, {
            title: "fa-solid fa-book-open",
            searchTerms: [ "flyer", "notebook", "open book", "pamphlet", "reading" ]
        }, {
            title: "fa-solid fa-book-reader",
            searchTerms: [ "library" ]
        }, {
            title: "fa-solid fa-bookmark",
            searchTerms: [ "save" ]
        }, {
            title: "fa-regular fa-bookmark",
            searchTerms: [ "save" ]
        }, {
            title: "fa-solid fa-bowling-ball",
            searchTerms: []
        }, {
            title: "fa-solid fa-box",
            searchTerms: [ "package" ]
        }, {
            title: "fa-solid fa-box-open",
            searchTerms: []
        }, {
            title: "fa-solid fa-boxes",
            searchTerms: []
        }, {
            title: "fa-solid fa-braille",
            searchTerms: []
        }, {
            title: "fa-solid fa-brain",
            searchTerms: [ "cerebellum", "gray matter", "intellect", "medulla oblongata", "mind", "noodle", "wit" ]
        }, {
            title: "fa-solid fa-briefcase",
            searchTerms: [ "bag", "business", "luggage", "office", "work" ]
        }, {
            title: "fa-solid fa-briefcase-medical",
            searchTerms: [ "health briefcase" ]
        }, {
            title: "fa-solid fa-broadcast-tower",
            searchTerms: [ "airwaves", "radio", "waves" ]
        }, {
            title: "fa-solid fa-broom",
            searchTerms: [ "clean", "firebolt", "fly", "halloween", "holiday", "nimbus 2000", "quidditch", "sweep", "witch" ]
        }, {
            title: "fa-solid fa-brush",
            searchTerms: [ "bristles", "color", "handle", "painting" ]
        }, {
            title: "fa-brands fa-btc",
            searchTerms: []
        }, {
            title: "fa-solid fa-bug",
            searchTerms: [ "insect", "report" ]
        }, {
            title: "fa-solid fa-building",
            searchTerms: [ "apartment", "business", "company", "office", "work" ]
        }, {
            title: "fa-regular fa-building",
            searchTerms: [ "apartment", "business", "company", "office", "work" ]
        }, {
            title: "fa-solid fa-bullhorn",
            searchTerms: [ "announcement", "broadcast", "louder", "megaphone", "share" ]
        }, {
            title: "fa-solid fa-bullseye",
            searchTerms: [ "target" ]
        }, {
            title: "fa-solid fa-burn",
            searchTerms: [ "energy" ]
        }, {
            title: "fa-brands fa-buromobelexperte",
            searchTerms: []
        }, {
            title: "fa-solid fa-bus",
            searchTerms: [ "machine", "public transportation", "transportation", "vehicle" ]
        }, {
            title: "fa-solid fa-bus-alt",
            searchTerms: [ "machine", "public transportation", "transportation", "vehicle" ]
        }, {
            title: "fa-solid fa-business-time",
            searchTerms: [ "briefcase", "business socks", "clock", "flight of the conchords", "wednesday" ]
        }, {
            title: "fa-brands fa-buysellads",
            searchTerms: []
        }, {
            title: "fa-solid fa-calculator",
            searchTerms: []
        }, {
            title: "fa-solid fa-calendar",
            searchTerms: [ "calendar-o", "date", "event", "schedule", "time", "when" ]
        }, {
            title: "fa-regular fa-calendar",
            searchTerms: [ "calendar-o", "date", "event", "schedule", "time", "when" ]
        }, {
            title: "fa-solid fa-calendar-alt",
            searchTerms: [ "calendar", "date", "event", "schedule", "time", "when" ]
        }, {
            title: "fa-regular fa-calendar-alt",
            searchTerms: [ "calendar", "date", "event", "schedule", "time", "when" ]
        }, {
            title: "fa-solid fa-calendar-check",
            searchTerms: [ "accept", "agree", "appointment", "confirm", "correct", "done", "ok", "select", "success", "todo" ]
        }, {
            title: "fa-regular fa-calendar-check",
            searchTerms: [ "accept", "agree", "appointment", "confirm", "correct", "done", "ok", "select", "success", "todo" ]
        }, {
            title: "fa-solid fa-calendar-minus",
            searchTerms: [ "delete", "negative", "remove" ]
        }, {
            title: "fa-regular fa-calendar-minus",
            searchTerms: [ "delete", "negative", "remove" ]
        }, {
            title: "fa-solid fa-calendar-plus",
            searchTerms: [ "add", "create", "new", "positive" ]
        }, {
            title: "fa-regular fa-calendar-plus",
            searchTerms: [ "add", "create", "new", "positive" ]
        }, {
            title: "fa-solid fa-calendar-times",
            searchTerms: [ "archive", "delete", "remove", "x" ]
        }, {
            title: "fa-regular fa-calendar-times",
            searchTerms: [ "archive", "delete", "remove", "x" ]
        }, {
            title: "fa-solid fa-camera",
            searchTerms: [ "photo", "picture", "record" ]
        }, {
            title: "fa-solid fa-camera-retro",
            searchTerms: [ "photo", "picture", "record" ]
        }, {
            title: "fa-solid fa-campground",
            searchTerms: [ "camping", "fall", "outdoors", "seasonal", "tent" ]
        }, {
            title: "fa-solid fa-cannabis",
            searchTerms: [ "bud", "chronic", "drugs", "endica", "endo", "ganja", "marijuana", "mary jane", "pot", "reefer", "sativa", "spliff", "weed", "whacky-tabacky" ]
        }, {
            title: "fa-solid fa-capsules",
            searchTerms: [ "drugs", "medicine" ]
        }, {
            title: "fa-solid fa-car",
            searchTerms: [ "machine", "transportation", "vehicle" ]
        }, {
            title: "fa-solid fa-car-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-car-battery",
            searchTerms: []
        }, {
            title: "fa-solid fa-car-crash",
            searchTerms: []
        }, {
            title: "fa-solid fa-car-side",
            searchTerms: []
        }, {
            title: "fa-solid fa-caret-down",
            searchTerms: [ "arrow", "dropdown", "menu", "more", "triangle down" ]
        }, {
            title: "fa-solid fa-caret-left",
            searchTerms: [ "arrow", "back", "previous", "triangle left" ]
        }, {
            title: "fa-solid fa-caret-right",
            searchTerms: [ "arrow", "forward", "next", "triangle right" ]
        }, {
            title: "fa-solid fa-caret-square-down",
            searchTerms: [ "caret-square-o-down", "dropdown", "menu", "more" ]
        }, {
            title: "fa-regular fa-caret-square-down",
            searchTerms: [ "caret-square-o-down", "dropdown", "menu", "more" ]
        }, {
            title: "fa-solid fa-caret-square-left",
            searchTerms: [ "back", "caret-square-o-left", "previous" ]
        }, {
            title: "fa-regular fa-caret-square-left",
            searchTerms: [ "back", "caret-square-o-left", "previous" ]
        }, {
            title: "fa-solid fa-caret-square-right",
            searchTerms: [ "caret-square-o-right", "forward", "next" ]
        }, {
            title: "fa-regular fa-caret-square-right",
            searchTerms: [ "caret-square-o-right", "forward", "next" ]
        }, {
            title: "fa-solid fa-caret-square-up",
            searchTerms: [ "caret-square-o-up" ]
        }, {
            title: "fa-regular fa-caret-square-up",
            searchTerms: [ "caret-square-o-up" ]
        }, {
            title: "fa-solid fa-caret-up",
            searchTerms: [ "arrow", "triangle up" ]
        }, {
            title: "fa-solid fa-cart-arrow-down",
            searchTerms: [ "shopping" ]
        }, {
            title: "fa-solid fa-cart-plus",
            searchTerms: [ "add", "create", "new", "positive", "shopping" ]
        }, {
            title: "fa-solid fa-cat",
            searchTerms: [ "feline", "halloween", "holiday", "kitten", "kitty", "meow", "pet" ]
        }, {
            title: "fa-brands fa-cc-amazon-pay",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-amex",
            searchTerms: [ "amex" ]
        }, {
            title: "fa-brands fa-cc-apple-pay",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-diners-club",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-discover",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-jcb",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-mastercard",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-paypal",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-stripe",
            searchTerms: []
        }, {
            title: "fa-brands fa-cc-visa",
            searchTerms: []
        }, {
            title: "fa-brands fa-centercode",
            searchTerms: []
        }, {
            title: "fa-solid fa-certificate",
            searchTerms: [ "badge", "star" ]
        }, {
            title: "fa-solid fa-chair",
            searchTerms: [ "furniture", "seat" ]
        }, {
            title: "fa-solid fa-chalkboard",
            searchTerms: [ "blackboard", "learning", "school", "teaching", "whiteboard", "writing" ]
        }, {
            title: "fa-solid fa-chalkboard-teacher",
            searchTerms: [ "blackboard", "instructor", "learning", "professor", "school", "whiteboard", "writing" ]
        }, {
            title: "fa-solid fa-charging-station",
            searchTerms: []
        }, {
            title: "fa-solid fa-chart-area",
            searchTerms: [ "analytics", "area-chart", "graph" ]
        }, {
            title: "fa-solid fa-chart-bar",
            searchTerms: [ "analytics", "bar-chart", "graph" ]
        }, {
            title: "fa-regular fa-chart-bar",
            searchTerms: [ "analytics", "bar-chart", "graph" ]
        }, {
            title: "fa-solid fa-chart-line",
            searchTerms: [ "activity", "analytics", "dashboard", "graph", "line-chart" ]
        }, {
            title: "fa-solid fa-chart-pie",
            searchTerms: [ "analytics", "graph", "pie-chart" ]
        }, {
            title: "fa-solid fa-check",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "notice", "notification", "notify", "ok", "select", "success", "tick", "todo", "yes" ]
        }, {
            title: "fa-solid fa-check-circle",
            searchTerms: [ "accept", "agree", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-regular fa-check-circle",
            searchTerms: [ "accept", "agree", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-solid fa-check-double",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "notice", "notification", "notify", "ok", "select", "success", "tick", "todo" ]
        }, {
            title: "fa-solid fa-check-square",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-regular fa-check-square",
            searchTerms: [ "accept", "agree", "checkmark", "confirm", "correct", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-solid fa-chess",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-bishop",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-board",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-king",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-knight",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-pawn",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-queen",
            searchTerms: []
        }, {
            title: "fa-solid fa-chess-rook",
            searchTerms: []
        }, {
            title: "fa-solid fa-chevron-circle-down",
            searchTerms: [ "arrow", "dropdown", "menu", "more" ]
        }, {
            title: "fa-solid fa-chevron-circle-left",
            searchTerms: [ "arrow", "back", "previous" ]
        }, {
            title: "fa-solid fa-chevron-circle-right",
            searchTerms: [ "arrow", "forward", "next" ]
        }, {
            title: "fa-solid fa-chevron-circle-up",
            searchTerms: [ "arrow" ]
        }, {
            title: "fa-solid fa-chevron-down",
            searchTerms: []
        }, {
            title: "fa-solid fa-chevron-left",
            searchTerms: [ "back", "bracket", "previous" ]
        }, {
            title: "fa-solid fa-chevron-right",
            searchTerms: [ "bracket", "forward", "next" ]
        }, {
            title: "fa-solid fa-chevron-up",
            searchTerms: []
        }, {
            title: "fa-solid fa-child",
            searchTerms: []
        }, {
            title: "fa-brands fa-chrome",
            searchTerms: [ "browser" ]
        }, {
            title: "fa-solid fa-church",
            searchTerms: [ "building", "community", "religion" ]
        }, {
            title: "fa-solid fa-circle",
            searchTerms: [ "circle-thin", "dot", "notification" ]
        }, {
            title: "fa-regular fa-circle",
            searchTerms: [ "circle-thin", "dot", "notification" ]
        }, {
            title: "fa-solid fa-circle-notch",
            searchTerms: [ "circle-o-notch" ]
        }, {
            title: "fa-solid fa-city",
            searchTerms: [ "buildings", "busy", "skyscrapers", "urban", "windows" ]
        }, {
            title: "fa-solid fa-clipboard",
            searchTerms: [ "paste" ]
        }, {
            title: "fa-regular fa-clipboard",
            searchTerms: [ "paste" ]
        }, {
            title: "fa-solid fa-clipboard-check",
            searchTerms: [ "accept", "agree", "confirm", "done", "ok", "select", "success", "todo", "yes" ]
        }, {
            title: "fa-solid fa-clipboard-list",
            searchTerms: [ "checklist", "completed", "done", "finished", "intinerary", "ol", "schedule", "todo", "ul" ]
        }, {
            title: "fa-solid fa-clock",
            searchTerms: [ "date", "late", "schedule", "timer", "timestamp", "watch" ]
        }, {
            title: "fa-regular fa-clock",
            searchTerms: [ "date", "late", "schedule", "timer", "timestamp", "watch" ]
        }, {
            title: "fa-solid fa-clone",
            searchTerms: [ "copy", "duplicate" ]
        }, {
            title: "fa-regular fa-clone",
            searchTerms: [ "copy", "duplicate" ]
        }, {
            title: "fa-solid fa-closed-captioning",
            searchTerms: [ "cc" ]
        }, {
            title: "fa-regular fa-closed-captioning",
            searchTerms: [ "cc" ]
        }, {
            title: "fa-solid fa-cloud",
            searchTerms: [ "save" ]
        }, {
            title: "fa-solid fa-cloud-download-alt",
            searchTerms: [ "import" ]
        }, {
            title: "fa-solid fa-cloud-meatball",
            searchTerms: []
        }, {
            title: "fa-solid fa-cloud-moon",
            searchTerms: [ "crescent", "evening", "halloween", "holiday", "lunar", "night", "sky" ]
        }, {
            title: "fa-solid fa-cloud-moon-rain",
            searchTerms: []
        }, {
            title: "fa-solid fa-cloud-rain",
            searchTerms: [ "precipitation" ]
        }, {
            title: "fa-solid fa-cloud-showers-heavy",
            searchTerms: [ "precipitation", "rain", "storm" ]
        }, {
            title: "fa-solid fa-cloud-sun",
            searchTerms: [ "day", "daytime", "fall", "outdoors", "seasonal" ]
        }, {
            title: "fa-solid fa-cloud-sun-rain",
            searchTerms: []
        }, {
            title: "fa-solid fa-cloud-upload-alt",
            searchTerms: [ "cloud-upload" ]
        }, {
            title: "fa-brands fa-cloudscale",
            searchTerms: []
        }, {
            title: "fa-brands fa-cloudsmith",
            searchTerms: []
        }, {
            title: "fa-brands fa-cloudversify",
            searchTerms: []
        }, {
            title: "fa-solid fa-cocktail",
            searchTerms: [ "alcohol", "beverage", "drink" ]
        }, {
            title: "fa-solid fa-code",
            searchTerms: [ "brackets", "html" ]
        }, {
            title: "fa-solid fa-code-branch",
            searchTerms: [ "branch", "code-fork", "fork", "git", "github", "rebase", "svn", "vcs", "version" ]
        }, {
            title: "fa-brands fa-codepen",
            searchTerms: []
        }, {
            title: "fa-brands fa-codiepie",
            searchTerms: []
        }, {
            title: "fa-solid fa-coffee",
            searchTerms: [ "beverage", "breakfa-solidt", "cafe", "drink", "fall", "morning", "mug", "seasonal", "tea" ]
        }, {
            title: "fa-solid fa-cog",
            searchTerms: [ "settings" ]
        }, {
            title: "fa-solid fa-cogs",
            searchTerms: [ "gears", "settings" ]
        }, {
            title: "fa-solid fa-coins",
            searchTerms: []
        }, {
            title: "fa-solid fa-columns",
            searchTerms: [ "dashboard", "panes", "split" ]
        }, {
            title: "fa-solid fa-comment",
            searchTerms: [ "bubble", "chat", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-regular fa-comment",
            searchTerms: [ "bubble", "chat", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-solid fa-comment-alt",
            searchTerms: [ "bubble", "chat", "commenting", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-regular fa-comment-alt",
            searchTerms: [ "bubble", "chat", "commenting", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-solid fa-comment-dollar",
            searchTerms: []
        }, {
            title: "fa-solid fa-comment-dots",
            searchTerms: []
        }, {
            title: "fa-regular fa-comment-dots",
            searchTerms: []
        }, {
            title: "fa-solid fa-comment-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-comments",
            searchTerms: [ "bubble", "chat", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-regular fa-comments",
            searchTerms: [ "bubble", "chat", "conversation", "feedback", "message", "note", "notification", "sms", "speech", "texting" ]
        }, {
            title: "fa-solid fa-comments-dollar",
            searchTerms: []
        }, {
            title: "fa-solid fa-compact-disc",
            searchTerms: [ "bluray", "cd", "disc", "media" ]
        }, {
            title: "fa-solid fa-compass",
            searchTerms: [ "directory", "location", "menu", "safa-regulari" ]
        }, {
            title: "fa-regular fa-compass",
            searchTerms: [ "directory", "location", "menu", "safa-regulari" ]
        }, {
            title: "fa-solid fa-compress",
            searchTerms: [ "collapse", "combine", "contract", "merge", "smaller" ]
        }, {
            title: "fa-solid fa-concierge-bell",
            searchTerms: [ "attention", "hotel", "service", "support" ]
        }, {
            title: "fa-brands fa-connectdevelop",
            searchTerms: []
        }, {
            title: "fa-brands fa-contao",
            searchTerms: []
        }, {
            title: "fa-solid fa-cookie",
            searchTerms: [ "baked good", "chips", "food", "snack", "sweet", "treat" ]
        }, {
            title: "fa-solid fa-cookie-bite",
            searchTerms: [ "baked good", "bitten", "chips", "eating", "food", "snack", "sweet", "treat" ]
        }, {
            title: "fa-solid fa-copy",
            searchTerms: [ "clone", "duplicate", "file", "files-o" ]
        }, {
            title: "fa-regular fa-copy",
            searchTerms: [ "clone", "duplicate", "file", "files-o" ]
        }, {
            title: "fa-solid fa-copyright",
            searchTerms: []
        }, {
            title: "fa-regular fa-copyright",
            searchTerms: []
        }, {
            title: "fa-solid fa-couch",
            searchTerms: [ "furniture", "sofa" ]
        }, {
            title: "fa-brands fa-cpanel",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-by",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-nc",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-nc-eu",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-nc-jp",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-nd",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-pd",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-pd-alt",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-remix",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-sa",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-sampling",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-sampling-plus",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-share",
            searchTerms: []
        }, {
            title: "fa-brands fa-creative-commons-zero",
            searchTerms: []
        }, {
            title: "fa-solid fa-credit-card",
            searchTerms: [ "buy", "checkout", "credit-card-alt", "debit", "money", "payment", "purchase" ]
        }, {
            title: "fa-regular fa-credit-card",
            searchTerms: [ "buy", "checkout", "credit-card-alt", "debit", "money", "payment", "purchase" ]
        }, {
            title: "fa-brands fa-critical-role",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, {
            title: "fa-solid fa-crop",
            searchTerms: [ "design" ]
        }, {
            title: "fa-solid fa-crop-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-cross",
            searchTerms: [ "catholicism", "christianity" ]
        }, {
            title: "fa-solid fa-crosshairs",
            searchTerms: [ "gpd", "picker", "position" ]
        }, {
            title: "fa-solid fa-crow",
            searchTerms: [ "bird", "bullfrog", "fauna", "halloween", "holiday", "toad" ]
        }, {
            title: "fa-solid fa-crown",
            searchTerms: []
        }, {
            title: "fa-brands fa-css3",
            searchTerms: [ "code" ]
        }, {
            title: "fa-brands fa-css3-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-cube",
            searchTerms: [ "package" ]
        }, {
            title: "fa-solid fa-cubes",
            searchTerms: [ "packages" ]
        }, {
            title: "fa-solid fa-cut",
            searchTerms: [ "scissors" ]
        }, {
            title: "fa-brands fa-cuttlefish",
            searchTerms: []
        }, {
            title: "fa-brands fa-d-and-d",
            searchTerms: []
        }, {
            title: "fa-brands fa-d-and-d-beyond",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "gaming", "tabletop" ]
        }, {
            title: "fa-brands fa-dashcube",
            searchTerms: []
        }, {
            title: "fa-solid fa-database",
            searchTerms: []
        }, {
            title: "fa-solid fa-deaf",
            searchTerms: []
        }, {
            title: "fa-brands fa-delicious",
            searchTerms: []
        }, {
            title: "fa-solid fa-democrat",
            searchTerms: [ "american", "democratic party", "donkey", "election", "left", "left-wing", "liberal", "politics", "usa" ]
        }, {
            title: "fa-brands fa-deploydog",
            searchTerms: []
        }, {
            title: "fa-brands fa-deskpro",
            searchTerms: []
        }, {
            title: "fa-solid fa-desktop",
            searchTerms: [ "computer", "cpu", "demo", "desktop", "device", "machine", "monitor", "pc", "screen" ]
        }, {
            title: "fa-brands fa-dev",
            searchTerms: []
        }, {
            title: "fa-brands fa-deviantart",
            searchTerms: []
        }, {
            title: "fa-solid fa-dharmachakra",
            searchTerms: [ "buddhism", "buddhist", "wheel of dharma" ]
        }, {
            title: "fa-solid fa-diagnoses",
            searchTerms: []
        }, {
            title: "fa-solid fa-dice",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-d20",
            searchTerms: [ "Dungeons & Dragons", "chance", "d&d", "dnd", "fantasy", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-d6",
            searchTerms: [ "Dungeons & Dragons", "chance", "d&d", "dnd", "fantasy", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-five",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-four",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-one",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-six",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-three",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-solid fa-dice-two",
            searchTerms: [ "chance", "gambling", "game", "roll" ]
        }, {
            title: "fa-brands fa-digg",
            searchTerms: []
        }, {
            title: "fa-brands fa-digital-ocean",
            searchTerms: []
        }, {
            title: "fa-solid fa-digital-tachograph",
            searchTerms: []
        }, {
            title: "fa-solid fa-directions",
            searchTerms: []
        }, {
            title: "fa-brands fa-discord",
            searchTerms: []
        }, {
            title: "fa-brands fa-discourse",
            searchTerms: []
        }, {
            title: "fa-solid fa-divide",
            searchTerms: []
        }, {
            title: "fa-solid fa-dizzy",
            searchTerms: [ "dazed", "disapprove", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-dizzy",
            searchTerms: [ "dazed", "disapprove", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-dna",
            searchTerms: [ "double helix", "helix" ]
        }, {
            title: "fa-brands fa-dochub",
            searchTerms: []
        }, {
            title: "fa-brands fa-docker",
            searchTerms: []
        }, {
            title: "fa-solid fa-dog",
            searchTerms: [ "canine", "fauna", "mammmal", "pet", "pooch", "puppy", "woof" ]
        }, {
            title: "fa-solid fa-dollar-sign",
            searchTerms: [ "$", "dollar-sign", "money", "price", "usd" ]
        }, {
            title: "fa-solid fa-dolly",
            searchTerms: []
        }, {
            title: "fa-solid fa-dolly-flatbed",
            searchTerms: []
        }, {
            title: "fa-solid fa-donate",
            searchTerms: [ "generosity", "give" ]
        }, {
            title: "fa-solid fa-door-closed",
            searchTerms: []
        }, {
            title: "fa-solid fa-door-open",
            searchTerms: []
        }, {
            title: "fa-solid fa-dot-circle",
            searchTerms: [ "bullseye", "notification", "target" ]
        }, {
            title: "fa-regular fa-dot-circle",
            searchTerms: [ "bullseye", "notification", "target" ]
        }, {
            title: "fa-solid fa-dove",
            searchTerms: [ "bird", "fauna", "flying", "peace" ]
        }, {
            title: "fa-solid fa-download",
            searchTerms: [ "import" ]
        }, {
            title: "fa-brands fa-draft2digital",
            searchTerms: []
        }, {
            title: "fa-solid fa-drafting-compass",
            searchTerms: [ "mechanical drawing", "plot", "plotting" ]
        }, {
            title: "fa-solid fa-dragon",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy" ]
        }, {
            title: "fa-solid fa-draw-polygon",
            searchTerms: []
        }, {
            title: "fa-brands fa-dribbble",
            searchTerms: []
        }, {
            title: "fa-brands fa-dribbble-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-dropbox",
            searchTerms: []
        }, {
            title: "fa-solid fa-drum",
            searchTerms: [ "instrument", "music", "percussion", "snare", "sound" ]
        }, {
            title: "fa-solid fa-drum-steelpan",
            searchTerms: [ "calypso", "instrument", "music", "percussion", "reggae", "snare", "sound", "steel", "tropical" ]
        }, {
            title: "fa-solid fa-drumstick-bite",
            searchTerms: []
        }, {
            title: "fa-brands fa-drupal",
            searchTerms: []
        }, {
            title: "fa-solid fa-dumbbell",
            searchTerms: [ "exercise", "gym", "strength", "weight", "weight-lifting" ]
        }, {
            title: "fa-solid fa-dungeon",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "door", "entrance", "fantasy", "gate" ]
        }, {
            title: "fa-brands fa-dyalog",
            searchTerms: []
        }, {
            title: "fa-brands fa-earlybirds",
            searchTerms: []
        }, {
            title: "fa-brands fa-ebay",
            searchTerms: []
        }, {
            title: "fa-brands fa-edge",
            searchTerms: [ "browser", "ie" ]
        }, {
            title: "fa-solid fa-edit",
            searchTerms: [ "edit", "pen", "pencil", "update", "write" ]
        }, {
            title: "fa-regular fa-edit",
            searchTerms: [ "edit", "pen", "pencil", "update", "write" ]
        }, {
            title: "fa-solid fa-eject",
            searchTerms: []
        }, {
            title: "fa-brands fa-elementor",
            searchTerms: []
        }, {
            title: "fa-solid fa-ellipsis-h",
            searchTerms: [ "dots", "drag", "kebab", "list", "menu", "nav", "navigation", "ol", "reorder", "settings", "ul" ]
        }, {
            title: "fa-solid fa-ellipsis-v",
            searchTerms: [ "dots", "drag", "kebab", "list", "menu", "nav", "navigation", "ol", "reorder", "settings", "ul" ]
        }, {
            title: "fa-brands fa-ello",
            searchTerms: []
        }, {
            title: "fa-brands fa-ember",
            searchTerms: []
        }, {
            title: "fa-brands fa-empire",
            searchTerms: []
        }, {
            title: "fa-solid fa-envelope",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-regular fa-envelope",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-solid fa-envelope-open",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-regular fa-envelope-open",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-solid fa-envelope-open-text",
            searchTerms: []
        }, {
            title: "fa-solid fa-envelope-square",
            searchTerms: [ "e-mail", "email", "letter", "mail", "message", "notification", "support" ]
        }, {
            title: "fa-brands fa-envira",
            searchTerms: [ "leaf" ]
        }, {
            title: "fa-solid fa-equals",
            searchTerms: []
        }, {
            title: "fa-solid fa-eraser",
            searchTerms: [ "delete", "remove" ]
        }, {
            title: "fa-brands fa-erlang",
            searchTerms: []
        }, {
            title: "fa-brands fa-ethereum",
            searchTerms: []
        }, {
            title: "fa-brands fa-etsy",
            searchTerms: []
        }, {
            title: "fa-solid fa-euro-sign",
            searchTerms: [ "eur" ]
        }, {
            title: "fa-solid fa-exchange-alt",
            searchTerms: [ "arrow", "arrows", "exchange", "reciprocate", "return", "swap", "transfer" ]
        }, {
            title: "fa-solid fa-exclamation",
            searchTerms: [ "alert", "danger", "error", "important", "notice", "notification", "notify", "problem", "warning" ]
        }, {
            title: "fa-solid fa-exclamation-circle",
            searchTerms: [ "alert", "danger", "error", "important", "notice", "notification", "notify", "problem", "warning" ]
        }, {
            title: "fa-solid fa-exclamation-triangle",
            searchTerms: [ "alert", "danger", "error", "important", "notice", "notification", "notify", "problem", "warning" ]
        }, {
            title: "fa-solid fa-expand",
            searchTerms: [ "bigger", "enlarge", "resize" ]
        }, {
            title: "fa-solid fa-expand-arrows-alt",
            searchTerms: [ "arrows-alt", "bigger", "enlarge", "move", "resize" ]
        }, {
            title: "fa-brands fa-expeditedssl",
            searchTerms: []
        }, {
            title: "fa-solid fa-external-link-alt",
            searchTerms: [ "external-link", "new", "open" ]
        }, {
            title: "fa-solid fa-external-link-square-alt",
            searchTerms: [ "external-link-square", "new", "open" ]
        }, {
            title: "fa-solid fa-eye",
            searchTerms: [ "optic", "see", "seen", "show", "sight", "views", "visible" ]
        }, {
            title: "fa-regular fa-eye",
            searchTerms: [ "optic", "see", "seen", "show", "sight", "views", "visible" ]
        }, {
            title: "fa-solid fa-eye-dropper",
            searchTerms: [ "eyedropper" ]
        }, {
            title: "fa-solid fa-eye-slash",
            searchTerms: [ "blind", "hide", "show", "toggle", "unseen", "views", "visible", "visiblity" ]
        }, {
            title: "fa-regular fa-eye-slash",
            searchTerms: [ "blind", "hide", "show", "toggle", "unseen", "views", "visible", "visiblity" ]
        }, {
            title: "fa-brands fa-facebook",
            searchTerms: [ "facebook-official", "social network" ]
        }, {
            title: "fa-brands fa-facebook-f",
            searchTerms: [ "facebook" ]
        }, {
            title: "fa-brands fa-facebook-messenger",
            searchTerms: []
        }, {
            title: "fa-brands fa-facebook-square",
            searchTerms: [ "social network" ]
        }, {
            title: "fa-brands fa-fantasy-flight-games",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, {
            title: "fa-solid fa-fa-solidt-backward",
            searchTerms: [ "beginning", "first", "previous", "rewind", "start" ]
        }, {
            title: "fa-solid fa-fa-solidt-forward",
            searchTerms: [ "end", "last", "next" ]
        }, {
            title: "fa-solid fa-fax",
            searchTerms: []
        }, {
            title: "fa-solid fa-feather",
            searchTerms: [ "bird", "light", "plucked", "quill" ]
        }, {
            title: "fa-solid fa-feather-alt",
            searchTerms: [ "bird", "light", "plucked", "quill" ]
        }, {
            title: "fa-solid fa-female",
            searchTerms: [ "human", "person", "profile", "user", "woman" ]
        }, {
            title: "fa-solid fa-fighter-jet",
            searchTerms: [ "airplane", "fa-solidt", "fly", "goose", "maverick", "plane", "quick", "top gun", "transportation", "travel" ]
        }, {
            title: "fa-solid fa-file",
            searchTerms: [ "document", "new", "page", "pdf", "resume" ]
        }, {
            title: "fa-regular fa-file",
            searchTerms: [ "document", "new", "page", "pdf", "resume" ]
        }, {
            title: "fa-solid fa-file-alt",
            searchTerms: [ "document", "file-text", "invoice", "new", "page", "pdf" ]
        }, {
            title: "fa-regular fa-file-alt",
            searchTerms: [ "document", "file-text", "invoice", "new", "page", "pdf" ]
        }, {
            title: "fa-solid fa-file-archive",
            searchTerms: [ ".zip", "bundle", "compress", "compression", "download", "zip" ]
        }, {
            title: "fa-regular fa-file-archive",
            searchTerms: [ ".zip", "bundle", "compress", "compression", "download", "zip" ]
        }, {
            title: "fa-solid fa-file-audio",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-audio",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-code",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-code",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-contract",
            searchTerms: [ "agreement", "binding", "document", "legal", "signature" ]
        }, {
            title: "fa-solid fa-file-csv",
            searchTerms: [ "spreadsheets" ]
        }, {
            title: "fa-solid fa-file-download",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-excel",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-excel",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-export",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-image",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-image",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-import",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-invoice",
            searchTerms: [ "bill", "document", "receipt" ]
        }, {
            title: "fa-solid fa-file-invoice-dollar",
            searchTerms: [ "$", "bill", "document", "dollar-sign", "money", "receipt", "usd" ]
        }, {
            title: "fa-solid fa-file-medical",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-medical-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-pdf",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-pdf",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-powerpoint",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-powerpoint",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-prescription",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-solid fa-file-signature",
            searchTerms: [ "John Hancock", "contract", "document", "name" ]
        }, {
            title: "fa-solid fa-file-upload",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-video",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-video",
            searchTerms: []
        }, {
            title: "fa-solid fa-file-word",
            searchTerms: []
        }, {
            title: "fa-regular fa-file-word",
            searchTerms: []
        }, {
            title: "fa-solid fa-fill",
            searchTerms: [ "bucket", "color", "paint", "paint bucket" ]
        }, {
            title: "fa-solid fa-fill-drip",
            searchTerms: [ "bucket", "color", "drop", "paint", "paint bucket", "spill" ]
        }, {
            title: "fa-solid fa-film",
            searchTerms: [ "movie" ]
        }, {
            title: "fa-solid fa-filter",
            searchTerms: [ "funnel", "options" ]
        }, {
            title: "fa-solid fa-fingerprint",
            searchTerms: [ "human", "id", "identification", "lock", "smudge", "touch", "unique", "unlock" ]
        }, {
            title: "fa-solid fa-fire",
            searchTerms: [ "caliente", "flame", "heat", "hot", "popular" ]
        }, {
            title: "fa-solid fa-fire-extinguisher",
            searchTerms: []
        }, {
            title: "fa-brands fa-firefox",
            searchTerms: [ "browser" ]
        }, {
            title: "fa-solid fa-first-aid",
            searchTerms: []
        }, {
            title: "fa-brands fa-first-order",
            searchTerms: []
        }, {
            title: "fa-brands fa-first-order-alt",
            searchTerms: []
        }, {
            title: "fa-brands fa-firstdraft",
            searchTerms: []
        }, {
            title: "fa-solid fa-fish",
            searchTerms: [ "fauna", "gold", "swimming" ]
        }, {
            title: "fa-solid fa-fist-raised",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "hand", "ki", "monk", "resist", "strength", "unarmed combat" ]
        }, {
            title: "fa-solid fa-flag",
            searchTerms: [ "country", "notice", "notification", "notify", "pole", "report", "symbol" ]
        }, {
            title: "fa-regular fa-flag",
            searchTerms: [ "country", "notice", "notification", "notify", "pole", "report", "symbol" ]
        }, {
            title: "fa-solid fa-flag-checkered",
            searchTerms: [ "notice", "notification", "notify", "pole", "racing", "report", "symbol" ]
        }, {
            title: "fa-solid fa-flag-usa",
            searchTerms: [ "betsy ross", "country", "old glory", "stars", "stripes", "symbol" ]
        }, {
            title: "fa-solid fa-flask",
            searchTerms: [ "beaker", "experimental", "labs", "science" ]
        }, {
            title: "fa-brands fa-flickr",
            searchTerms: []
        }, {
            title: "fa-brands fa-flipboard",
            searchTerms: []
        }, {
            title: "fa-solid fa-flushed",
            searchTerms: [ "embarrassed", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-flushed",
            searchTerms: [ "embarrassed", "emoticon", "face" ]
        }, {
            title: "fa-brands fa-fly",
            searchTerms: []
        }, {
            title: "fa-solid fa-folder",
            searchTerms: []
        }, {
            title: "fa-regular fa-folder",
            searchTerms: []
        }, {
            title: "fa-solid fa-folder-minus",
            searchTerms: [ "archive", "delete", "negative", "remove" ]
        }, {
            title: "fa-solid fa-folder-open",
            searchTerms: []
        }, {
            title: "fa-regular fa-folder-open",
            searchTerms: []
        }, {
            title: "fa-solid fa-folder-plus",
            searchTerms: [ "add", "create", "new", "positive" ]
        }, {
            title: "fa-solid fa-font",
            searchTerms: [ "text" ]
        }, {
            title: "fa-brands fa-font-awesome",
            searchTerms: [ "meanpath" ]
        }, {
            title: "fa-brands fa-font-awesome-alt",
            searchTerms: []
        }, {
            title: "fa-brands fa-font-awesome-flag",
            searchTerms: []
        }, {
            title: "fa-regular fa-font-awesome-logo-full",
            searchTerms: []
        }, {
            title: "fa-solid fa-font-awesome-logo-full",
            searchTerms: []
        }, {
            title: "fa-brands fa-font-awesome-logo-full",
            searchTerms: []
        }, {
            title: "fa-brands fa-fonticons",
            searchTerms: []
        }, {
            title: "fa-brands fa-fonticons-fi",
            searchTerms: []
        }, {
            title: "fa-solid fa-football-ball",
            searchTerms: [ "fall", "pigskin", "seasonal" ]
        }, {
            title: "fa-brands fa-fort-awesome",
            searchTerms: [ "castle" ]
        }, {
            title: "fa-brands fa-fort-awesome-alt",
            searchTerms: [ "castle" ]
        }, {
            title: "fa-brands fa-forumbee",
            searchTerms: []
        }, {
            title: "fa-solid fa-forward",
            searchTerms: [ "forward", "next" ]
        }, {
            title: "fa-brands fa-foursquare",
            searchTerms: []
        }, {
            title: "fa-brands fa-free-code-camp",
            searchTerms: []
        }, {
            title: "fa-brands fa-freebsd",
            searchTerms: []
        }, {
            title: "fa-solid fa-frog",
            searchTerms: [ "amphibian", "bullfrog", "fauna", "hop", "kermit", "kiss", "prince", "ribbit", "toad", "wart" ]
        }, {
            title: "fa-solid fa-frown",
            searchTerms: [ "disapprove", "emoticon", "face", "rating", "sad" ]
        }, {
            title: "fa-regular fa-frown",
            searchTerms: [ "disapprove", "emoticon", "face", "rating", "sad" ]
        }, {
            title: "fa-solid fa-frown-open",
            searchTerms: [ "disapprove", "emoticon", "face", "rating", "sad" ]
        }, {
            title: "fa-regular fa-frown-open",
            searchTerms: [ "disapprove", "emoticon", "face", "rating", "sad" ]
        }, {
            title: "fa-brands fa-fulcrum",
            searchTerms: []
        }, {
            title: "fa-solid fa-funnel-dollar",
            searchTerms: []
        }, {
            title: "fa-solid fa-futbol",
            searchTerms: [ "ball", "football", "soccer" ]
        }, {
            title: "fa-regular fa-futbol",
            searchTerms: [ "ball", "football", "soccer" ]
        }, {
            title: "fa-brands fa-galactic-republic",
            searchTerms: [ "politics", "star wars" ]
        }, {
            title: "fa-brands fa-galactic-senate",
            searchTerms: [ "star wars" ]
        }, {
            title: "fa-solid fa-gamepad",
            searchTerms: [ "controller" ]
        }, {
            title: "fa-solid fa-gas-pump",
            searchTerms: []
        }, {
            title: "fa-solid fa-gavel",
            searchTerms: [ "hammer", "judge", "lawyer", "opinion" ]
        }, {
            title: "fa-solid fa-gem",
            searchTerms: [ "diamond" ]
        }, {
            title: "fa-regular fa-gem",
            searchTerms: [ "diamond" ]
        }, {
            title: "fa-solid fa-genderless",
            searchTerms: []
        }, {
            title: "fa-brands fa-get-pocket",
            searchTerms: []
        }, {
            title: "fa-brands fa-gg",
            searchTerms: []
        }, {
            title: "fa-brands fa-gg-circle",
            searchTerms: []
        }, {
            title: "fa-solid fa-ghost",
            searchTerms: [ "apparition", "blinky", "clyde", "floating", "halloween", "holiday", "inky", "pinky", "spirit" ]
        }, {
            title: "fa-solid fa-gift",
            searchTerms: [ "generosity", "giving", "party", "present", "wrapped" ]
        }, {
            title: "fa-brands fa-git",
            searchTerms: []
        }, {
            title: "fa-brands fa-git-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-github",
            searchTerms: [ "octocat" ]
        }, {
            title: "fa-brands fa-github-alt",
            searchTerms: [ "octocat" ]
        }, {
            title: "fa-brands fa-github-square",
            searchTerms: [ "octocat" ]
        }, {
            title: "fa-brands fa-gitkraken",
            searchTerms: []
        }, {
            title: "fa-brands fa-gitlab",
            searchTerms: [ "Axosoft" ]
        }, {
            title: "fa-brands fa-gitter",
            searchTerms: []
        }, {
            title: "fa-solid fa-glass-martini",
            searchTerms: [ "alcohol", "bar", "beverage", "drink", "glass", "liquor", "martini" ]
        }, {
            title: "fa-solid fa-glass-martini-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-glasses",
            searchTerms: [ "foureyes", "hipster", "nerd", "reading", "sight", "spectacles" ]
        }, {
            title: "fa-brands fa-glide",
            searchTerms: []
        }, {
            title: "fa-brands fa-glide-g",
            searchTerms: []
        }, {
            title: "fa-solid fa-globe",
            searchTerms: [ "all", "coordinates", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-solid fa-globe-africa",
            searchTerms: [ "all", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-solid fa-globe-americas",
            searchTerms: [ "all", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-solid fa-globe-asia",
            searchTerms: [ "all", "country", "earth", "global", "gps", "language", "localize", "location", "map", "online", "place", "planet", "translate", "travel", "world" ]
        }, {
            title: "fa-brands fa-gofore",
            searchTerms: []
        }, {
            title: "fa-solid fa-golf-ball",
            searchTerms: []
        }, {
            title: "fa-brands fa-goodreads",
            searchTerms: []
        }, {
            title: "fa-brands fa-goodreads-g",
            searchTerms: []
        }, {
            title: "fa-brands fa-google",
            searchTerms: []
        }, {
            title: "fa-brands fa-google-drive",
            searchTerms: []
        }, {
            title: "fa-brands fa-google-play",
            searchTerms: []
        }, {
            title: "fa-brands fa-google-plus",
            searchTerms: [ "google-plus-circle", "google-plus-official" ]
        }, {
            title: "fa-brands fa-google-plus-g",
            searchTerms: [ "google-plus", "social network" ]
        }, {
            title: "fa-brands fa-google-plus-square",
            searchTerms: [ "social network" ]
        }, {
            title: "fa-brands fa-google-wallet",
            searchTerms: []
        }, {
            title: "fa-solid fa-gopuram",
            searchTerms: [ "building", "entrance", "hinduism", "temple", "tower" ]
        }, {
            title: "fa-solid fa-graduation-cap",
            searchTerms: [ "learning", "school", "student" ]
        }, {
            title: "fa-brands fa-gratipay",
            searchTerms: [ "favorite", "heart", "like", "love" ]
        }, {
            title: "fa-brands fa-grav",
            searchTerms: []
        }, {
            title: "fa-solid fa-greater-than",
            searchTerms: []
        }, {
            title: "fa-solid fa-greater-than-equal",
            searchTerms: []
        }, {
            title: "fa-solid fa-grimace",
            searchTerms: [ "cringe", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-grimace",
            searchTerms: [ "cringe", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-grin",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-regular fa-grin",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-solid fa-grin-alt",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-regular fa-grin-alt",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-solid fa-grin-beam",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-regular fa-grin-beam",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-solid fa-grin-beam-sweat",
            searchTerms: [ "emoticon", "face", "smile" ]
        }, {
            title: "fa-regular fa-grin-beam-sweat",
            searchTerms: [ "emoticon", "face", "smile" ]
        }, {
            title: "fa-solid fa-grin-hearts",
            searchTerms: [ "emoticon", "face", "love", "smile" ]
        }, {
            title: "fa-regular fa-grin-hearts",
            searchTerms: [ "emoticon", "face", "love", "smile" ]
        }, {
            title: "fa-solid fa-grin-squint",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-regular fa-grin-squint",
            searchTerms: [ "emoticon", "face", "laugh", "smile" ]
        }, {
            title: "fa-solid fa-grin-squint-tears",
            searchTerms: [ "emoticon", "face", "happy", "smile" ]
        }, {
            title: "fa-regular fa-grin-squint-tears",
            searchTerms: [ "emoticon", "face", "happy", "smile" ]
        }, {
            title: "fa-solid fa-grin-stars",
            searchTerms: [ "emoticon", "face", "star-struck" ]
        }, {
            title: "fa-regular fa-grin-stars",
            searchTerms: [ "emoticon", "face", "star-struck" ]
        }, {
            title: "fa-solid fa-grin-tears",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-grin-tears",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-grin-tongue",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-grin-tongue",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-grin-tongue-squint",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-grin-tongue-squint",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-grin-tongue-wink",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-grin-tongue-wink",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-grin-wink",
            searchTerms: [ "emoticon", "face", "flirt", "laugh", "smile" ]
        }, {
            title: "fa-regular fa-grin-wink",
            searchTerms: [ "emoticon", "face", "flirt", "laugh", "smile" ]
        }, {
            title: "fa-solid fa-grip-horizontal",
            searchTerms: [ "affordance", "drag", "drop", "grab", "handle" ]
        }, {
            title: "fa-solid fa-grip-vertical",
            searchTerms: [ "affordance", "drag", "drop", "grab", "handle" ]
        }, {
            title: "fa-brands fa-gripfire",
            searchTerms: []
        }, {
            title: "fa-brands fa-grunt",
            searchTerms: []
        }, {
            title: "fa-brands fa-gulp",
            searchTerms: []
        }, {
            title: "fa-solid fa-h-square",
            searchTerms: [ "hospital", "hotel" ]
        }, {
            title: "fa-brands fa-hacker-news",
            searchTerms: []
        }, {
            title: "fa-brands fa-hacker-news-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-hackerrank",
            searchTerms: []
        }, {
            title: "fa-solid fa-hammer",
            searchTerms: [ "admin", "fix", "repair", "settings", "tool" ]
        }, {
            title: "fa-solid fa-hamsa",
            searchTerms: [ "amulet", "christianity", "islam", "jewish", "judaism", "muslim", "protection" ]
        }, {
            title: "fa-solid fa-hand-holding",
            searchTerms: []
        }, {
            title: "fa-solid fa-hand-holding-heart",
            searchTerms: []
        }, {
            title: "fa-solid fa-hand-holding-usd",
            searchTerms: [ "$", "dollar sign", "donation", "giving", "money", "price" ]
        }, {
            title: "fa-solid fa-hand-lizard",
            searchTerms: []
        }, {
            title: "fa-regular fa-hand-lizard",
            searchTerms: []
        }, {
            title: "fa-solid fa-hand-paper",
            searchTerms: [ "stop" ]
        }, {
            title: "fa-regular fa-hand-paper",
            searchTerms: [ "stop" ]
        }, {
            title: "fa-solid fa-hand-peace",
            searchTerms: []
        }, {
            title: "fa-regular fa-hand-peace",
            searchTerms: []
        }, {
            title: "fa-solid fa-hand-point-down",
            searchTerms: [ "finger", "hand-o-down", "point" ]
        }, {
            title: "fa-regular fa-hand-point-down",
            searchTerms: [ "finger", "hand-o-down", "point" ]
        }, {
            title: "fa-solid fa-hand-point-left",
            searchTerms: [ "back", "finger", "hand-o-left", "left", "point", "previous" ]
        }, {
            title: "fa-regular fa-hand-point-left",
            searchTerms: [ "back", "finger", "hand-o-left", "left", "point", "previous" ]
        }, {
            title: "fa-solid fa-hand-point-right",
            searchTerms: [ "finger", "forward", "hand-o-right", "next", "point", "right" ]
        }, {
            title: "fa-regular fa-hand-point-right",
            searchTerms: [ "finger", "forward", "hand-o-right", "next", "point", "right" ]
        }, {
            title: "fa-solid fa-hand-point-up",
            searchTerms: [ "finger", "hand-o-up", "point" ]
        }, {
            title: "fa-regular fa-hand-point-up",
            searchTerms: [ "finger", "hand-o-up", "point" ]
        }, {
            title: "fa-solid fa-hand-pointer",
            searchTerms: [ "select" ]
        }, {
            title: "fa-regular fa-hand-pointer",
            searchTerms: [ "select" ]
        }, {
            title: "fa-solid fa-hand-rock",
            searchTerms: []
        }, {
            title: "fa-regular fa-hand-rock",
            searchTerms: []
        }, {
            title: "fa-solid fa-hand-scissors",
            searchTerms: []
        }, {
            title: "fa-regular fa-hand-scissors",
            searchTerms: []
        }, {
            title: "fa-solid fa-hand-spock",
            searchTerms: []
        }, {
            title: "fa-regular fa-hand-spock",
            searchTerms: []
        }, {
            title: "fa-solid fa-hands",
            searchTerms: []
        }, {
            title: "fa-solid fa-hands-helping",
            searchTerms: [ "aid", "assistance", "partnership", "volunteering" ]
        }, {
            title: "fa-solid fa-handshake",
            searchTerms: [ "greeting", "partnership" ]
        }, {
            title: "fa-regular fa-handshake",
            searchTerms: [ "greeting", "partnership" ]
        }, {
            title: "fa-solid fa-hanukiah",
            searchTerms: [ "candle", "hanukkah", "jewish", "judaism", "light" ]
        }, {
            title: "fa-solid fa-hashtag",
            searchTerms: []
        }, {
            title: "fa-solid fa-hat-wizard",
            searchTerms: [ "Dungeons & Dragons", "buckle", "cloth", "clothing", "d&d", "dnd", "fantasy", "halloween", "holiday", "mage", "magic", "pointy", "witch" ]
        }, {
            title: "fa-solid fa-haykal",
            searchTerms: [ "bahai", "bahá'í", "star" ]
        }, {
            title: "fa-solid fa-hdd",
            searchTerms: [ "cpu", "hard drive", "harddrive", "machine", "save", "storage" ]
        }, {
            title: "fa-regular fa-hdd",
            searchTerms: [ "cpu", "hard drive", "harddrive", "machine", "save", "storage" ]
        }, {
            title: "fa-solid fa-heading",
            searchTerms: [ "header" ]
        }, {
            title: "fa-solid fa-headphones",
            searchTerms: [ "audio", "listen", "music", "sound", "speaker" ]
        }, {
            title: "fa-solid fa-headphones-alt",
            searchTerms: [ "audio", "listen", "music", "sound", "speaker" ]
        }, {
            title: "fa-solid fa-headset",
            searchTerms: [ "audio", "gamer", "gaming", "listen", "live chat", "microphone", "shot caller", "sound", "support", "telemarketer" ]
        }, {
            title: "fa-solid fa-heart",
            searchTerms: [ "favorite", "like", "love" ]
        }, {
            title: "fa-regular fa-heart",
            searchTerms: [ "favorite", "like", "love" ]
        }, {
            title: "fa-solid fa-heartbeat",
            searchTerms: [ "ekg", "lifeline", "vital signs" ]
        }, {
            title: "fa-solid fa-helicopter",
            searchTerms: [ "airwolf", "apache", "chopper", "flight", "fly" ]
        }, {
            title: "fa-solid fa-highlighter",
            searchTerms: [ "edit", "marker", "sharpie", "update", "write" ]
        }, {
            title: "fa-solid fa-hiking",
            searchTerms: [ "activity", "backpack", "fall", "fitness", "outdoors", "seasonal", "walking" ]
        }, {
            title: "fa-solid fa-hippo",
            searchTerms: [ "fauna", "hungry", "mammmal" ]
        }, {
            title: "fa-brands fa-hips",
            searchTerms: []
        }, {
            title: "fa-brands fa-hire-a-helper",
            searchTerms: []
        }, {
            title: "fa-solid fa-history",
            searchTerms: []
        }, {
            title: "fa-solid fa-hockey-puck",
            searchTerms: []
        }, {
            title: "fa-solid fa-home",
            searchTerms: [ "house", "main" ]
        }, {
            title: "fa-brands fa-hooli",
            searchTerms: []
        }, {
            title: "fa-brands fa-hornbill",
            searchTerms: []
        }, {
            title: "fa-solid fa-horse",
            searchTerms: [ "equus", "fauna", "mammmal", "neigh" ]
        }, {
            title: "fa-solid fa-hospital",
            searchTerms: [ "building", "emergency room", "medical center" ]
        }, {
            title: "fa-regular fa-hospital",
            searchTerms: [ "building", "emergency room", "medical center" ]
        }, {
            title: "fa-solid fa-hospital-alt",
            searchTerms: [ "building", "emergency room", "medical center" ]
        }, {
            title: "fa-solid fa-hospital-symbol",
            searchTerms: []
        }, {
            title: "fa-solid fa-hot-tub",
            searchTerms: []
        }, {
            title: "fa-solid fa-hotel",
            searchTerms: [ "building", "lodging" ]
        }, {
            title: "fa-brands fa-hotjar",
            searchTerms: []
        }, {
            title: "fa-solid fa-hourglass",
            searchTerms: []
        }, {
            title: "fa-regular fa-hourglass",
            searchTerms: []
        }, {
            title: "fa-solid fa-hourglass-end",
            searchTerms: []
        }, {
            title: "fa-solid fa-hourglass-half",
            searchTerms: []
        }, {
            title: "fa-solid fa-hourglass-start",
            searchTerms: []
        }, {
            title: "fa-solid fa-house-damage",
            searchTerms: [ "devastation", "home" ]
        }, {
            title: "fa-brands fa-houzz",
            searchTerms: []
        }, {
            title: "fa-solid fa-hryvnia",
            searchTerms: [ "money" ]
        }, {
            title: "fa-brands fa-html5",
            searchTerms: []
        }, {
            title: "fa-brands fa-hubspot",
            searchTerms: []
        }, {
            title: "fa-solid fa-i-cursor",
            searchTerms: []
        }, {
            title: "fa-solid fa-id-badge",
            searchTerms: []
        }, {
            title: "fa-regular fa-id-badge",
            searchTerms: []
        }, {
            title: "fa-solid fa-id-card",
            searchTerms: [ "document", "identification", "issued" ]
        }, {
            title: "fa-regular fa-id-card",
            searchTerms: [ "document", "identification", "issued" ]
        }, {
            title: "fa-solid fa-id-card-alt",
            searchTerms: [ "demographics" ]
        }, {
            title: "fa-solid fa-image",
            searchTerms: [ "album", "photo", "picture" ]
        }, {
            title: "fa-regular fa-image",
            searchTerms: [ "album", "photo", "picture" ]
        }, {
            title: "fa-solid fa-images",
            searchTerms: [ "album", "photo", "picture" ]
        }, {
            title: "fa-regular fa-images",
            searchTerms: [ "album", "photo", "picture" ]
        }, {
            title: "fa-brands fa-imdb",
            searchTerms: []
        }, {
            title: "fa-solid fa-inbox",
            searchTerms: []
        }, {
            title: "fa-solid fa-indent",
            searchTerms: []
        }, {
            title: "fa-solid fa-industry",
            searchTerms: [ "factory", "manufacturing" ]
        }, {
            title: "fa-solid fa-infinity",
            searchTerms: []
        }, {
            title: "fa-solid fa-info",
            searchTerms: [ "details", "help", "information", "more" ]
        }, {
            title: "fa-solid fa-info-circle",
            searchTerms: [ "details", "help", "information", "more" ]
        }, {
            title: "fa-brands fa-instagram",
            searchTerms: []
        }, {
            title: "fa-brands fa-internet-explorer",
            searchTerms: [ "browser", "ie" ]
        }, {
            title: "fa-brands fa-ioxhost",
            searchTerms: []
        }, {
            title: "fa-solid fa-italic",
            searchTerms: [ "italics" ]
        }, {
            title: "fa-brands fa-itunes",
            searchTerms: []
        }, {
            title: "fa-brands fa-itunes-note",
            searchTerms: []
        }, {
            title: "fa-brands fa-java",
            searchTerms: []
        }, {
            title: "fa-solid fa-jedi",
            searchTerms: [ "star wars" ]
        }, {
            title: "fa-brands fa-jedi-order",
            searchTerms: [ "star wars" ]
        }, {
            title: "fa-brands fa-jenkins",
            searchTerms: []
        }, {
            title: "fa-brands fa-joget",
            searchTerms: []
        }, {
            title: "fa-solid fa-joint",
            searchTerms: [ "blunt", "cannabis", "doobie", "drugs", "marijuana", "roach", "smoke", "smoking", "spliff" ]
        }, {
            title: "fa-brands fa-joomla",
            searchTerms: []
        }, {
            title: "fa-solid fa-journal-whills",
            searchTerms: [ "book", "jedi", "star wars", "the force" ]
        }, {
            title: "fa-brands fa-js",
            searchTerms: []
        }, {
            title: "fa-brands fa-js-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-jsfiddle",
            searchTerms: []
        }, {
            title: "fa-solid fa-kaaba",
            searchTerms: [ "building", "cube", "islam", "muslim" ]
        }, {
            title: "fa-brands fa-kaggle",
            searchTerms: []
        }, {
            title: "fa-solid fa-key",
            searchTerms: [ "password", "unlock" ]
        }, {
            title: "fa-brands fa-keybase",
            searchTerms: []
        }, {
            title: "fa-solid fa-keyboard",
            searchTerms: [ "input", "type" ]
        }, {
            title: "fa-regular fa-keyboard",
            searchTerms: [ "input", "type" ]
        }, {
            title: "fa-brands fa-keycdn",
            searchTerms: []
        }, {
            title: "fa-solid fa-khanda",
            searchTerms: [ "chakkar", "sikh", "sikhism", "sword" ]
        }, {
            title: "fa-brands fa-kickstarter",
            searchTerms: []
        }, {
            title: "fa-brands fa-kickstarter-k",
            searchTerms: []
        }, {
            title: "fa-solid fa-kiss",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-regular fa-kiss",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-solid fa-kiss-beam",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-regular fa-kiss-beam",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-solid fa-kiss-wink-heart",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-regular fa-kiss-wink-heart",
            searchTerms: [ "beso", "emoticon", "face", "love", "smooch" ]
        }, {
            title: "fa-solid fa-kiwi-bird",
            searchTerms: [ "bird", "fauna" ]
        }, {
            title: "fa-brands fa-korvue",
            searchTerms: []
        }, {
            title: "fa-solid fa-landmark",
            searchTerms: [ "building", "historic", "memoroable", "politics" ]
        }, {
            title: "fa-solid fa-language",
            searchTerms: [ "dialect", "idiom", "localize", "speech", "translate", "vernacular" ]
        }, {
            title: "fa-solid fa-laptop",
            searchTerms: [ "computer", "cpu", "dell", "demo", "device", "dude you're getting", "mac", "macbook", "machine", "pc" ]
        }, {
            title: "fa-solid fa-laptop-code",
            searchTerms: []
        }, {
            title: "fa-brands fa-laravel",
            searchTerms: []
        }, {
            title: "fa-brands fa-lastfm",
            searchTerms: []
        }, {
            title: "fa-brands fa-lastfm-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-laugh",
            searchTerms: [ "LOL", "emoticon", "face", "laugh" ]
        }, {
            title: "fa-regular fa-laugh",
            searchTerms: [ "LOL", "emoticon", "face", "laugh" ]
        }, {
            title: "fa-solid fa-laugh-beam",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-laugh-beam",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-laugh-squint",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-laugh-squint",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-laugh-wink",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-regular fa-laugh-wink",
            searchTerms: [ "LOL", "emoticon", "face" ]
        }, {
            title: "fa-solid fa-layer-group",
            searchTerms: [ "layers" ]
        }, {
            title: "fa-solid fa-leaf",
            searchTerms: [ "eco", "flora", "nature", "plant" ]
        }, {
            title: "fa-brands fa-leanpub",
            searchTerms: []
        }, {
            title: "fa-solid fa-lemon",
            searchTerms: [ "food" ]
        }, {
            title: "fa-regular fa-lemon",
            searchTerms: [ "food" ]
        }, {
            title: "fa-brands fa-less",
            searchTerms: []
        }, {
            title: "fa-solid fa-less-than",
            searchTerms: []
        }, {
            title: "fa-solid fa-less-than-equal",
            searchTerms: []
        }, {
            title: "fa-solid fa-level-down-alt",
            searchTerms: [ "level-down" ]
        }, {
            title: "fa-solid fa-level-up-alt",
            searchTerms: [ "level-up" ]
        }, {
            title: "fa-solid fa-life-ring",
            searchTerms: [ "support" ]
        }, {
            title: "fa-regular fa-life-ring",
            searchTerms: [ "support" ]
        }, {
            title: "fa-solid fa-lightbulb",
            searchTerms: [ "idea", "inspiration" ]
        }, {
            title: "fa-regular fa-lightbulb",
            searchTerms: [ "idea", "inspiration" ]
        }, {
            title: "fa-brands fa-line",
            searchTerms: []
        }, {
            title: "fa-solid fa-link",
            searchTerms: [ "chain" ]
        }, {
            title: "fa-brands fa-linkedin",
            searchTerms: [ "linkedin-square" ]
        }, {
            title: "fa-brands fa-linkedin-in",
            searchTerms: [ "linkedin" ]
        }, {
            title: "fa-brands fa-linode",
            searchTerms: []
        }, {
            title: "fa-brands fa-linux",
            searchTerms: [ "tux" ]
        }, {
            title: "fa-solid fa-lira-sign",
            searchTerms: [ "try", "turkish" ]
        }, {
            title: "fa-solid fa-list",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, {
            title: "fa-solid fa-list-alt",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, {
            title: "fa-regular fa-list-alt",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, {
            title: "fa-solid fa-list-ol",
            searchTerms: [ "checklist", "list", "numbers", "ol", "todo", "ul" ]
        }, {
            title: "fa-solid fa-list-ul",
            searchTerms: [ "checklist", "list", "ol", "todo", "ul" ]
        }, {
            title: "fa-solid fa-location-arrow",
            searchTerms: [ "address", "coordinates", "gps", "location", "map", "place", "where" ]
        }, {
            title: "fa-solid fa-lock",
            searchTerms: [ "admin", "protect", "security" ]
        }, {
            title: "fa-solid fa-lock-open",
            searchTerms: [ "admin", "lock", "open", "password", "protect" ]
        }, {
            title: "fa-solid fa-long-arrow-alt-down",
            searchTerms: [ "long-arrow-down" ]
        }, {
            title: "fa-solid fa-long-arrow-alt-left",
            searchTerms: [ "back", "long-arrow-left", "previous" ]
        }, {
            title: "fa-solid fa-long-arrow-alt-right",
            searchTerms: [ "long-arrow-right" ]
        }, {
            title: "fa-solid fa-long-arrow-alt-up",
            searchTerms: [ "long-arrow-up" ]
        }, {
            title: "fa-solid fa-low-vision",
            searchTerms: []
        }, {
            title: "fa-solid fa-luggage-cart",
            searchTerms: []
        }, {
            title: "fa-brands fa-lyft",
            searchTerms: []
        }, {
            title: "fa-brands fa-magento",
            searchTerms: []
        }, {
            title: "fa-solid fa-magic",
            searchTerms: [ "autocomplete", "automatic", "mage", "magic", "spell", "witch", "wizard" ]
        }, {
            title: "fa-solid fa-magnet",
            searchTerms: []
        }, {
            title: "fa-solid fa-mail-bulk",
            searchTerms: []
        }, {
            title: "fa-brands fa-mailchimp",
            searchTerms: []
        }, {
            title: "fa-solid fa-male",
            searchTerms: [ "human", "man", "person", "profile", "user" ]
        }, {
            title: "fa-brands fa-mandalorian",
            searchTerms: []
        }, {
            title: "fa-solid fa-map",
            searchTerms: [ "coordinates", "location", "paper", "place", "travel" ]
        }, {
            title: "fa-regular fa-map",
            searchTerms: [ "coordinates", "location", "paper", "place", "travel" ]
        }, {
            title: "fa-solid fa-map-marked",
            searchTerms: [ "address", "coordinates", "destination", "gps", "localize", "location", "map", "paper", "pin", "place", "point of interest", "position", "route", "travel", "where" ]
        }, {
            title: "fa-solid fa-map-marked-alt",
            searchTerms: [ "address", "coordinates", "destination", "gps", "localize", "location", "map", "paper", "pin", "place", "point of interest", "position", "route", "travel", "where" ]
        }, {
            title: "fa-solid fa-map-marker",
            searchTerms: [ "address", "coordinates", "gps", "localize", "location", "map", "pin", "place", "position", "travel", "where" ]
        }, {
            title: "fa-solid fa-map-marker-alt",
            searchTerms: [ "address", "coordinates", "gps", "localize", "location", "map", "pin", "place", "position", "travel", "where" ]
        }, {
            title: "fa-solid fa-map-pin",
            searchTerms: [ "address", "coordinates", "gps", "localize", "location", "map", "marker", "place", "position", "travel", "where" ]
        }, {
            title: "fa-solid fa-map-signs",
            searchTerms: []
        }, {
            title: "fa-brands fa-markdown",
            searchTerms: []
        }, {
            title: "fa-solid fa-marker",
            searchTerms: [ "edit", "sharpie", "update", "write" ]
        }, {
            title: "fa-solid fa-mars",
            searchTerms: [ "male" ]
        }, {
            title: "fa-solid fa-mars-double",
            searchTerms: []
        }, {
            title: "fa-solid fa-mars-stroke",
            searchTerms: []
        }, {
            title: "fa-solid fa-mars-stroke-h",
            searchTerms: []
        }, {
            title: "fa-solid fa-mars-stroke-v",
            searchTerms: []
        }, {
            title: "fa-solid fa-mask",
            searchTerms: [ "costume", "disguise", "halloween", "holiday", "secret", "super hero" ]
        }, {
            title: "fa-brands fa-mastodon",
            searchTerms: []
        }, {
            title: "fa-brands fa-maxcdn",
            searchTerms: []
        }, {
            title: "fa-solid fa-medal",
            searchTerms: []
        }, {
            title: "fa-brands fa-medapps",
            searchTerms: []
        }, {
            title: "fa-brands fa-medium",
            searchTerms: []
        }, {
            title: "fa-brands fa-medium-m",
            searchTerms: []
        }, {
            title: "fa-solid fa-medkit",
            searchTerms: [ "first aid", "firstaid", "health", "help", "support" ]
        }, {
            title: "fa-brands fa-medrt",
            searchTerms: []
        }, {
            title: "fa-brands fa-meetup",
            searchTerms: []
        }, {
            title: "fa-brands fa-megaport",
            searchTerms: []
        }, {
            title: "fa-solid fa-meh",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-regular fa-meh",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-solid fa-meh-blank",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-regular fa-meh-blank",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-solid fa-meh-rolling-eyes",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-regular fa-meh-rolling-eyes",
            searchTerms: [ "emoticon", "face", "neutral", "rating" ]
        }, {
            title: "fa-solid fa-memory",
            searchTerms: [ "DIMM", "RAM" ]
        }, {
            title: "fa-solid fa-menorah",
            searchTerms: [ "candle", "hanukkah", "jewish", "judaism", "light" ]
        }, {
            title: "fa-solid fa-mercury",
            searchTerms: [ "transgender" ]
        }, {
            title: "fa-solid fa-meteor",
            searchTerms: []
        }, {
            title: "fa-solid fa-microchip",
            searchTerms: [ "cpu", "processor" ]
        }, {
            title: "fa-solid fa-microphone",
            searchTerms: [ "record", "sound", "voice" ]
        }, {
            title: "fa-solid fa-microphone-alt",
            searchTerms: [ "record", "sound", "voice" ]
        }, {
            title: "fa-solid fa-microphone-alt-slash",
            searchTerms: [ "disable", "mute", "record", "sound", "voice" ]
        }, {
            title: "fa-solid fa-microphone-slash",
            searchTerms: [ "disable", "mute", "record", "sound", "voice" ]
        }, {
            title: "fa-solid fa-microscope",
            searchTerms: []
        }, {
            title: "fa-brands fa-microsoft",
            searchTerms: []
        }, {
            title: "fa-solid fa-minus",
            searchTerms: [ "collapse", "delete", "hide", "minify", "negative", "remove", "trash" ]
        }, {
            title: "fa-solid fa-minus-circle",
            searchTerms: [ "delete", "hide", "negative", "remove", "trash" ]
        }, {
            title: "fa-solid fa-minus-square",
            searchTerms: [ "collapse", "delete", "hide", "minify", "negative", "remove", "trash" ]
        }, {
            title: "fa-regular fa-minus-square",
            searchTerms: [ "collapse", "delete", "hide", "minify", "negative", "remove", "trash" ]
        }, {
            title: "fa-brands fa-mix",
            searchTerms: []
        }, {
            title: "fa-brands fa-mixcloud",
            searchTerms: []
        }, {
            title: "fa-brands fa-mizuni",
            searchTerms: []
        }, {
            title: "fa-solid fa-mobile",
            searchTerms: [ "apple", "call", "cell phone", "cellphone", "device", "iphone", "number", "screen", "telephone", "text" ]
        }, {
            title: "fa-solid fa-mobile-alt",
            searchTerms: [ "apple", "call", "cell phone", "cellphone", "device", "iphone", "number", "screen", "telephone", "text" ]
        }, {
            title: "fa-brands fa-modx",
            searchTerms: []
        }, {
            title: "fa-brands fa-monero",
            searchTerms: []
        }, {
            title: "fa-solid fa-money-bill",
            searchTerms: [ "buy", "cash", "checkout", "money", "payment", "price", "purchase" ]
        }, {
            title: "fa-solid fa-money-bill-alt",
            searchTerms: [ "buy", "cash", "checkout", "money", "payment", "price", "purchase" ]
        }, {
            title: "fa-regular fa-money-bill-alt",
            searchTerms: [ "buy", "cash", "checkout", "money", "payment", "price", "purchase" ]
        }, {
            title: "fa-solid fa-money-bill-wave",
            searchTerms: []
        }, {
            title: "fa-solid fa-money-bill-wave-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-money-check",
            searchTerms: [ "bank check", "cheque" ]
        }, {
            title: "fa-solid fa-money-check-alt",
            searchTerms: [ "bank check", "cheque" ]
        }, {
            title: "fa-solid fa-monument",
            searchTerms: [ "building", "historic", "memoroable" ]
        }, {
            title: "fa-solid fa-moon",
            searchTerms: [ "contrast", "crescent", "darker", "lunar", "night" ]
        }, {
            title: "fa-regular fa-moon",
            searchTerms: [ "contrast", "crescent", "darker", "lunar", "night" ]
        }, {
            title: "fa-solid fa-mortar-pestle",
            searchTerms: [ "crush", "culinary", "grind", "medical", "mix", "spices" ]
        }, {
            title: "fa-solid fa-mosque",
            searchTerms: [ "building", "islam", "muslim" ]
        }, {
            title: "fa-solid fa-motorcycle",
            searchTerms: [ "bike", "machine", "transportation", "vehicle" ]
        }, {
            title: "fa-solid fa-mountain",
            searchTerms: []
        }, {
            title: "fa-solid fa-mouse-pointer",
            searchTerms: [ "select" ]
        }, {
            title: "fa-solid fa-music",
            searchTerms: [ "note", "sound" ]
        }, {
            title: "fa-brands fa-napster",
            searchTerms: []
        }, {
            title: "fa-brands fa-neos",
            searchTerms: []
        }, {
            title: "fa-solid fa-network-wired",
            searchTerms: []
        }, {
            title: "fa-solid fa-neuter",
            searchTerms: []
        }, {
            title: "fa-solid fa-newspaper",
            searchTerms: [ "article", "press" ]
        }, {
            title: "fa-regular fa-newspaper",
            searchTerms: [ "article", "press" ]
        }, {
            title: "fa-brands fa-nimblr",
            searchTerms: []
        }, {
            title: "fa-brands fa-nintendo-switch",
            searchTerms: []
        }, {
            title: "fa-brands fa-node",
            searchTerms: []
        }, {
            title: "fa-brands fa-node-js",
            searchTerms: []
        }, {
            title: "fa-solid fa-not-equal",
            searchTerms: []
        }, {
            title: "fa-solid fa-notes-medical",
            searchTerms: []
        }, {
            title: "fa-brands fa-npm",
            searchTerms: []
        }, {
            title: "fa-brands fa-ns8",
            searchTerms: []
        }, {
            title: "fa-brands fa-nutritionix",
            searchTerms: []
        }, {
            title: "fa-solid fa-object-group",
            searchTerms: [ "design" ]
        }, {
            title: "fa-regular fa-object-group",
            searchTerms: [ "design" ]
        }, {
            title: "fa-solid fa-object-ungroup",
            searchTerms: [ "design" ]
        }, {
            title: "fa-regular fa-object-ungroup",
            searchTerms: [ "design" ]
        }, {
            title: "fa-brands fa-odnoklassniki",
            searchTerms: []
        }, {
            title: "fa-brands fa-odnoklassniki-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-oil-can",
            searchTerms: []
        }, {
            title: "fa-brands fa-old-republic",
            searchTerms: [ "politics", "star wars" ]
        }, {
            title: "fa-solid fa-om",
            searchTerms: [ "buddhism", "hinduism", "jainism", "mantra" ]
        }, {
            title: "fa-brands fa-opencart",
            searchTerms: []
        }, {
            title: "fa-brands fa-openid",
            searchTerms: []
        }, {
            title: "fa-brands fa-opera",
            searchTerms: []
        }, {
            title: "fa-brands fa-optin-monster",
            searchTerms: []
        }, {
            title: "fa-brands fa-osi",
            searchTerms: []
        }, {
            title: "fa-solid fa-otter",
            searchTerms: [ "fauna", "mammmal" ]
        }, {
            title: "fa-solid fa-outdent",
            searchTerms: []
        }, {
            title: "fa-brands fa-page4",
            searchTerms: []
        }, {
            title: "fa-brands fa-pagelines",
            searchTerms: [ "eco", "flora", "leaf", "leaves", "nature", "plant", "tree" ]
        }, {
            title: "fa-solid fa-paint-brush",
            searchTerms: []
        }, {
            title: "fa-solid fa-paint-roller",
            searchTerms: [ "brush", "painting", "tool" ]
        }, {
            title: "fa-solid fa-palette",
            searchTerms: [ "colors", "painting" ]
        }, {
            title: "fa-brands fa-palfed",
            searchTerms: []
        }, {
            title: "fa-solid fa-pallet",
            searchTerms: []
        }, {
            title: "fa-solid fa-paper-plane",
            searchTerms: []
        }, {
            title: "fa-regular fa-paper-plane",
            searchTerms: []
        }, {
            title: "fa-solid fa-paperclip",
            searchTerms: [ "attachment" ]
        }, {
            title: "fa-solid fa-parachute-box",
            searchTerms: [ "aid", "assistance", "rescue", "supplies" ]
        }, {
            title: "fa-solid fa-paragraph",
            searchTerms: []
        }, {
            title: "fa-solid fa-parking",
            searchTerms: []
        }, {
            title: "fa-solid fa-passport",
            searchTerms: [ "document", "identification", "issued" ]
        }, {
            title: "fa-solid fa-pastafa-regularianism",
            searchTerms: [ "agnosticism", "atheism", "flying spaghetti monster", "fsm" ]
        }, {
            title: "fa-solid fa-paste",
            searchTerms: [ "clipboard", "copy" ]
        }, {
            title: "fa-brands fa-patreon",
            searchTerms: []
        }, {
            title: "fa-solid fa-pause",
            searchTerms: [ "wait" ]
        }, {
            title: "fa-solid fa-pause-circle",
            searchTerms: []
        }, {
            title: "fa-regular fa-pause-circle",
            searchTerms: []
        }, {
            title: "fa-solid fa-paw",
            searchTerms: [ "animal", "pet" ]
        }, {
            title: "fa-brands fa-paypal",
            searchTerms: []
        }, {
            title: "fa-solid fa-peace",
            searchTerms: []
        }, {
            title: "fa-solid fa-pen",
            searchTerms: [ "design", "edit", "update", "write" ]
        }, {
            title: "fa-solid fa-pen-alt",
            searchTerms: [ "design", "edit", "update", "write" ]
        }, {
            title: "fa-solid fa-pen-fancy",
            searchTerms: [ "design", "edit", "fountain pen", "update", "write" ]
        }, {
            title: "fa-solid fa-pen-nib",
            searchTerms: [ "design", "edit", "fountain pen", "update", "write" ]
        }, {
            title: "fa-solid fa-pen-square",
            searchTerms: [ "edit", "pencil-square", "update", "write" ]
        }, {
            title: "fa-solid fa-pencil-alt",
            searchTerms: [ "design", "edit", "pencil", "update", "write" ]
        }, {
            title: "fa-solid fa-pencil-ruler",
            searchTerms: []
        }, {
            title: "fa-brands fa-penny-arcade",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "pax", "tabletop" ]
        }, {
            title: "fa-solid fa-people-carry",
            searchTerms: [ "movers" ]
        }, {
            title: "fa-solid fa-percent",
            searchTerms: []
        }, {
            title: "fa-solid fa-percentage",
            searchTerms: []
        }, {
            title: "fa-brands fa-periscope",
            searchTerms: []
        }, {
            title: "fa-solid fa-person-booth",
            searchTerms: [ "changing", "changing room", "election", "human", "person", "vote", "voting" ]
        }, {
            title: "fa-brands fa-phabricator",
            searchTerms: []
        }, {
            title: "fa-brands fa-phoenix-framework",
            searchTerms: []
        }, {
            title: "fa-brands fa-phoenix-squadron",
            searchTerms: []
        }, {
            title: "fa-solid fa-phone",
            searchTerms: [ "call", "earphone", "number", "support", "telephone", "voice" ]
        }, {
            title: "fa-solid fa-phone-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-phone-square",
            searchTerms: [ "call", "number", "support", "telephone", "voice" ]
        }, {
            title: "fa-solid fa-phone-volume",
            searchTerms: [ "telephone", "volume-control-phone" ]
        }, {
            title: "fa-brands fa-php",
            searchTerms: []
        }, {
            title: "fa-brands fa-pied-piper",
            searchTerms: []
        }, {
            title: "fa-brands fa-pied-piper-alt",
            searchTerms: []
        }, {
            title: "fa-brands fa-pied-piper-hat",
            searchTerms: [ "clothing" ]
        }, {
            title: "fa-brands fa-pied-piper-pp",
            searchTerms: []
        }, {
            title: "fa-solid fa-piggy-bank",
            searchTerms: [ "save", "savings" ]
        }, {
            title: "fa-solid fa-pills",
            searchTerms: [ "drugs", "medicine" ]
        }, {
            title: "fa-brands fa-pinterest",
            searchTerms: []
        }, {
            title: "fa-brands fa-pinterest-p",
            searchTerms: []
        }, {
            title: "fa-brands fa-pinterest-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-place-of-worship",
            searchTerms: []
        }, {
            title: "fa-solid fa-plane",
            searchTerms: [ "airplane", "destination", "fly", "location", "mode", "travel", "trip" ]
        }, {
            title: "fa-solid fa-plane-arrival",
            searchTerms: [ "airplane", "arriving", "destination", "fly", "land", "landing", "location", "mode", "travel", "trip" ]
        }, {
            title: "fa-solid fa-plane-departure",
            searchTerms: [ "airplane", "departing", "destination", "fly", "location", "mode", "take off", "taking off", "travel", "trip" ]
        }, {
            title: "fa-solid fa-play",
            searchTerms: [ "music", "playing", "sound", "start" ]
        }, {
            title: "fa-solid fa-play-circle",
            searchTerms: [ "playing", "start" ]
        }, {
            title: "fa-regular fa-play-circle",
            searchTerms: [ "playing", "start" ]
        }, {
            title: "fa-brands fa-playstation",
            searchTerms: []
        }, {
            title: "fa-solid fa-plug",
            searchTerms: [ "connect", "online", "power" ]
        }, {
            title: "fa-solid fa-plus",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-solid fa-plus-circle",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-solid fa-plus-square",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-regular fa-plus-square",
            searchTerms: [ "add", "create", "expand", "new", "positive" ]
        }, {
            title: "fa-solid fa-podcast",
            searchTerms: []
        }, {
            title: "fa-solid fa-poll",
            searchTerms: [ "results", "survey", "vote", "voting" ]
        }, {
            title: "fa-solid fa-poll-h",
            searchTerms: [ "results", "survey", "vote", "voting" ]
        }, {
            title: "fa-solid fa-poo",
            searchTerms: []
        }, {
            title: "fa-solid fa-poo-storm",
            searchTerms: [ "mess", "poop", "shit" ]
        }, {
            title: "fa-solid fa-poop",
            searchTerms: []
        }, {
            title: "fa-solid fa-portrait",
            searchTerms: []
        }, {
            title: "fa-solid fa-pound-sign",
            searchTerms: [ "gbp" ]
        }, {
            title: "fa-solid fa-power-off",
            searchTerms: [ "on", "reboot", "restart" ]
        }, {
            title: "fa-solid fa-pray",
            searchTerms: []
        }, {
            title: "fa-solid fa-praying-hands",
            searchTerms: []
        }, {
            title: "fa-solid fa-prescription",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-solid fa-prescription-bottle",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-solid fa-prescription-bottle-alt",
            searchTerms: [ "drugs", "medical", "medicine", "rx" ]
        }, {
            title: "fa-solid fa-print",
            searchTerms: []
        }, {
            title: "fa-solid fa-procedures",
            searchTerms: []
        }, {
            title: "fa-brands fa-product-hunt",
            searchTerms: []
        }, {
            title: "fa-solid fa-project-diagram",
            searchTerms: []
        }, {
            title: "fa-brands fa-pushed",
            searchTerms: []
        }, {
            title: "fa-solid fa-puzzle-piece",
            searchTerms: [ "add-on", "addon", "section" ]
        }, {
            title: "fa-brands fa-python",
            searchTerms: []
        }, {
            title: "fa-brands fa-qq",
            searchTerms: []
        }, {
            title: "fa-solid fa-qrcode",
            searchTerms: [ "scan" ]
        }, {
            title: "fa-solid fa-question",
            searchTerms: [ "help", "information", "support", "unknown" ]
        }, {
            title: "fa-solid fa-question-circle",
            searchTerms: [ "help", "information", "support", "unknown" ]
        }, {
            title: "fa-regular fa-question-circle",
            searchTerms: [ "help", "information", "support", "unknown" ]
        }, {
            title: "fa-solid fa-quidditch",
            searchTerms: []
        }, {
            title: "fa-brands fa-quinscape",
            searchTerms: []
        }, {
            title: "fa-brands fa-quora",
            searchTerms: []
        }, {
            title: "fa-solid fa-quote-left",
            searchTerms: []
        }, {
            title: "fa-solid fa-quote-right",
            searchTerms: []
        }, {
            title: "fa-solid fa-quran",
            searchTerms: [ "book", "islam", "muslim" ]
        }, {
            title: "fa-brands fa-r-project",
            searchTerms: []
        }, {
            title: "fa-solid fa-rainbow",
            searchTerms: []
        }, {
            title: "fa-solid fa-random",
            searchTerms: [ "shuffle", "sort" ]
        }, {
            title: "fa-brands fa-ravelry",
            searchTerms: []
        }, {
            title: "fa-brands fa-react",
            searchTerms: []
        }, {
            title: "fa-brands fa-reacteurope",
            searchTerms: []
        }, {
            title: "fa-brands fa-readme",
            searchTerms: []
        }, {
            title: "fa-brands fa-rebel",
            searchTerms: []
        }, {
            title: "fa-solid fa-receipt",
            searchTerms: [ "check", "invoice", "table" ]
        }, {
            title: "fa-solid fa-recycle",
            searchTerms: []
        }, {
            title: "fa-brands fa-red-river",
            searchTerms: []
        }, {
            title: "fa-brands fa-reddit",
            searchTerms: []
        }, {
            title: "fa-brands fa-reddit-alien",
            searchTerms: []
        }, {
            title: "fa-brands fa-reddit-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-redo",
            searchTerms: [ "forward", "refresh", "reload", "repeat" ]
        }, {
            title: "fa-solid fa-redo-alt",
            searchTerms: [ "forward", "refresh", "reload", "repeat" ]
        }, {
            title: "fa-solid fa-registered",
            searchTerms: []
        }, {
            title: "fa-regular fa-registered",
            searchTerms: []
        }, {
            title: "fa-brands fa-renren",
            searchTerms: []
        }, {
            title: "fa-solid fa-reply",
            searchTerms: []
        }, {
            title: "fa-solid fa-reply-all",
            searchTerms: []
        }, {
            title: "fa-brands fa-replyd",
            searchTerms: []
        }, {
            title: "fa-solid fa-republican",
            searchTerms: [ "american", "conservative", "election", "elephant", "politics", "republican party", "right", "right-wing", "usa" ]
        }, {
            title: "fa-brands fa-researchgate",
            searchTerms: []
        }, {
            title: "fa-brands fa-resolving",
            searchTerms: []
        }, {
            title: "fa-solid fa-retweet",
            searchTerms: [ "refresh", "reload", "share", "swap" ]
        }, {
            title: "fa-brands fa-rev",
            searchTerms: []
        }, {
            title: "fa-solid fa-ribbon",
            searchTerms: [ "badge", "cause", "lapel", "pin" ]
        }, {
            title: "fa-solid fa-ring",
            searchTerms: [ "Dungeons & Dragons", "Gollum", "band", "binding", "d&d", "dnd", "fantasy", "jewelry", "precious" ]
        }, {
            title: "fa-solid fa-road",
            searchTerms: [ "street" ]
        }, {
            title: "fa-solid fa-robot",
            searchTerms: []
        }, {
            title: "fa-solid fa-rocket",
            searchTerms: [ "app" ]
        }, {
            title: "fa-brands fa-rocketchat",
            searchTerms: []
        }, {
            title: "fa-brands fa-rockrms",
            searchTerms: []
        }, {
            title: "fa-solid fa-route",
            searchTerms: []
        }, {
            title: "fa-solid fa-rss",
            searchTerms: [ "blog" ]
        }, {
            title: "fa-solid fa-rss-square",
            searchTerms: [ "blog", "feed" ]
        }, {
            title: "fa-solid fa-ruble-sign",
            searchTerms: [ "rub" ]
        }, {
            title: "fa-solid fa-ruler",
            searchTerms: []
        }, {
            title: "fa-solid fa-ruler-combined",
            searchTerms: []
        }, {
            title: "fa-solid fa-ruler-horizontal",
            searchTerms: []
        }, {
            title: "fa-solid fa-ruler-vertical",
            searchTerms: []
        }, {
            title: "fa-solid fa-running",
            searchTerms: [ "jog", "sprint" ]
        }, {
            title: "fa-solid fa-rupee-sign",
            searchTerms: [ "indian", "inr" ]
        }, {
            title: "fa-solid fa-sad-cry",
            searchTerms: [ "emoticon", "face", "tear", "tears" ]
        }, {
            title: "fa-regular fa-sad-cry",
            searchTerms: [ "emoticon", "face", "tear", "tears" ]
        }, {
            title: "fa-solid fa-sad-tear",
            searchTerms: [ "emoticon", "face", "tear", "tears" ]
        }, {
            title: "fa-regular fa-sad-tear",
            searchTerms: [ "emoticon", "face", "tear", "tears" ]
        }, {
            title: "fa-brands fa-safa-regulari",
            searchTerms: [ "browser" ]
        }, {
            title: "fa-brands fa-sass",
            searchTerms: []
        }, {
            title: "fa-solid fa-save",
            searchTerms: [ "floppy", "floppy-o" ]
        }, {
            title: "fa-regular fa-save",
            searchTerms: [ "floppy", "floppy-o" ]
        }, {
            title: "fa-brands fa-schlix",
            searchTerms: []
        }, {
            title: "fa-solid fa-school",
            searchTerms: []
        }, {
            title: "fa-solid fa-screwdriver",
            searchTerms: [ "admin", "fix", "repair", "settings", "tool" ]
        }, {
            title: "fa-brands fa-scribd",
            searchTerms: []
        }, {
            title: "fa-solid fa-scroll",
            searchTerms: [ "Dungeons & Dragons", "announcement", "d&d", "dnd", "fantasy", "paper" ]
        }, {
            title: "fa-solid fa-search",
            searchTerms: [ "bigger", "enlarge", "magnify", "preview", "zoom" ]
        }, {
            title: "fa-solid fa-search-dollar",
            searchTerms: []
        }, {
            title: "fa-solid fa-search-location",
            searchTerms: []
        }, {
            title: "fa-solid fa-search-minus",
            searchTerms: [ "minify", "negative", "smaller", "zoom", "zoom out" ]
        }, {
            title: "fa-solid fa-search-plus",
            searchTerms: [ "bigger", "enlarge", "magnify", "positive", "zoom", "zoom in" ]
        }, {
            title: "fa-brands fa-searchengin",
            searchTerms: []
        }, {
            title: "fa-solid fa-seedling",
            searchTerms: []
        }, {
            title: "fa-brands fa-sellcast",
            searchTerms: [ "eercast" ]
        }, {
            title: "fa-brands fa-sellsy",
            searchTerms: []
        }, {
            title: "fa-solid fa-server",
            searchTerms: [ "cpu" ]
        }, {
            title: "fa-brands fa-servicestack",
            searchTerms: []
        }, {
            title: "fa-solid fa-shapes",
            searchTerms: [ "circle", "square", "triangle" ]
        }, {
            title: "fa-solid fa-share",
            searchTerms: []
        }, {
            title: "fa-solid fa-share-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-share-alt-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-share-square",
            searchTerms: [ "send", "social" ]
        }, {
            title: "fa-regular fa-share-square",
            searchTerms: [ "send", "social" ]
        }, {
            title: "fa-solid fa-shekel-sign",
            searchTerms: [ "ils" ]
        }, {
            title: "fa-solid fa-shield-alt",
            searchTerms: [ "achievement", "award", "block", "defend", "security", "winner" ]
        }, {
            title: "fa-solid fa-ship",
            searchTerms: [ "boat", "sea" ]
        }, {
            title: "fa-solid fa-shipping-fa-solidt",
            searchTerms: []
        }, {
            title: "fa-brands fa-shirtsinbulk",
            searchTerms: []
        }, {
            title: "fa-solid fa-shoe-prints",
            searchTerms: [ "feet", "footprints", "steps" ]
        }, {
            title: "fa-solid fa-shopping-bag",
            searchTerms: []
        }, {
            title: "fa-solid fa-shopping-basket",
            searchTerms: []
        }, {
            title: "fa-solid fa-shopping-cart",
            searchTerms: [ "buy", "checkout", "payment", "purchase" ]
        }, {
            title: "fa-brands fa-shopware",
            searchTerms: []
        }, {
            title: "fa-solid fa-shower",
            searchTerms: []
        }, {
            title: "fa-solid fa-shuttle-van",
            searchTerms: [ "machine", "public-transportation", "transportation", "vehicle" ]
        }, {
            title: "fa-solid fa-sign",
            searchTerms: []
        }, {
            title: "fa-solid fa-sign-in-alt",
            searchTerms: [ "arrow", "enter", "join", "log in", "login", "sign in", "sign up", "sign-in", "signin", "signup" ]
        }, {
            title: "fa-solid fa-sign-language",
            searchTerms: []
        }, {
            title: "fa-solid fa-sign-out-alt",
            searchTerms: [ "arrow", "exit", "leave", "log out", "logout", "sign-out" ]
        }, {
            title: "fa-solid fa-signal",
            searchTerms: [ "bars", "graph", "online", "status" ]
        }, {
            title: "fa-solid fa-signature",
            searchTerms: [ "John Hancock", "cursive", "name", "writing" ]
        }, {
            title: "fa-brands fa-simplybuilt",
            searchTerms: []
        }, {
            title: "fa-brands fa-sistrix",
            searchTerms: []
        }, {
            title: "fa-solid fa-sitemap",
            searchTerms: [ "directory", "hierarchy", "ia", "information architecture", "organization" ]
        }, {
            title: "fa-brands fa-sith",
            searchTerms: []
        }, {
            title: "fa-solid fa-skull",
            searchTerms: [ "bones", "skeleton", "yorick" ]
        }, {
            title: "fa-solid fa-skull-crossbones",
            searchTerms: [ "Dungeons & Dragons", "alert", "bones", "d&d", "danger", "dead", "deadly", "death", "dnd", "fantasy", "halloween", "holiday", "jolly-roger", "pirate", "poison", "skeleton", "warning" ]
        }, {
            title: "fa-brands fa-skyatlas",
            searchTerms: []
        }, {
            title: "fa-brands fa-skype",
            searchTerms: []
        }, {
            title: "fa-brands fa-slack",
            searchTerms: [ "anchor", "hash", "hashtag" ]
        }, {
            title: "fa-brands fa-slack-hash",
            searchTerms: [ "anchor", "hash", "hashtag" ]
        }, {
            title: "fa-solid fa-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-sliders-h",
            searchTerms: [ "settings", "sliders" ]
        }, {
            title: "fa-brands fa-slideshare",
            searchTerms: []
        }, {
            title: "fa-solid fa-smile",
            searchTerms: [ "approve", "emoticon", "face", "happy", "rating", "satisfied" ]
        }, {
            title: "fa-regular fa-smile",
            searchTerms: [ "approve", "emoticon", "face", "happy", "rating", "satisfied" ]
        }, {
            title: "fa-solid fa-smile-beam",
            searchTerms: [ "emoticon", "face", "happy", "positive" ]
        }, {
            title: "fa-regular fa-smile-beam",
            searchTerms: [ "emoticon", "face", "happy", "positive" ]
        }, {
            title: "fa-solid fa-smile-wink",
            searchTerms: [ "emoticon", "face", "happy" ]
        }, {
            title: "fa-regular fa-smile-wink",
            searchTerms: [ "emoticon", "face", "happy" ]
        }, {
            title: "fa-solid fa-smog",
            searchTerms: [ "dragon" ]
        }, {
            title: "fa-solid fa-smoking",
            searchTerms: [ "cigarette", "nicotine", "smoking status" ]
        }, {
            title: "fa-solid fa-smoking-ban",
            searchTerms: [ "no smoking", "non-smoking" ]
        }, {
            title: "fa-brands fa-snapchat",
            searchTerms: []
        }, {
            title: "fa-brands fa-snapchat-ghost",
            searchTerms: []
        }, {
            title: "fa-brands fa-snapchat-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-snowflake",
            searchTerms: [ "precipitation", "seasonal", "winter" ]
        }, {
            title: "fa-regular fa-snowflake",
            searchTerms: [ "precipitation", "seasonal", "winter" ]
        }, {
            title: "fa-solid fa-socks",
            searchTerms: [ "business socks", "business time", "flight of the conchords", "wednesday" ]
        }, {
            title: "fa-solid fa-solar-panel",
            searchTerms: [ "clean", "eco-friendly", "energy", "green", "sun" ]
        }, {
            title: "fa-solid fa-sort",
            searchTerms: [ "order" ]
        }, {
            title: "fa-solid fa-sort-alpha-down",
            searchTerms: [ "sort-alpha-asc" ]
        }, {
            title: "fa-solid fa-sort-alpha-up",
            searchTerms: [ "sort-alpha-desc" ]
        }, {
            title: "fa-solid fa-sort-amount-down",
            searchTerms: [ "sort-amount-asc" ]
        }, {
            title: "fa-solid fa-sort-amount-up",
            searchTerms: [ "sort-amount-desc" ]
        }, {
            title: "fa-solid fa-sort-down",
            searchTerms: [ "arrow", "descending", "sort-desc" ]
        }, {
            title: "fa-solid fa-sort-numeric-down",
            searchTerms: [ "numbers", "sort-numeric-asc" ]
        }, {
            title: "fa-solid fa-sort-numeric-up",
            searchTerms: [ "numbers", "sort-numeric-desc" ]
        }, {
            title: "fa-solid fa-sort-up",
            searchTerms: [ "arrow", "ascending", "sort-asc" ]
        }, {
            title: "fa-brands fa-soundcloud",
            searchTerms: []
        }, {
            title: "fa-solid fa-spa",
            searchTerms: [ "flora", "mindfullness", "plant", "wellness" ]
        }, {
            title: "fa-solid fa-space-shuttle",
            searchTerms: [ "astronaut", "machine", "nasa", "rocket", "transportation" ]
        }, {
            title: "fa-brands fa-speakap",
            searchTerms: []
        }, {
            title: "fa-solid fa-spider",
            searchTerms: [ "arachnid", "bug", "charlotte", "crawl", "eight", "halloween", "holiday" ]
        }, {
            title: "fa-solid fa-spinner",
            searchTerms: [ "loading", "progress" ]
        }, {
            title: "fa-solid fa-splotch",
            searchTerms: []
        }, {
            title: "fa-brands fa-spotify",
            searchTerms: []
        }, {
            title: "fa-solid fa-spray-can",
            searchTerms: []
        }, {
            title: "fa-solid fa-square",
            searchTerms: [ "block", "box" ]
        }, {
            title: "fa-regular fa-square",
            searchTerms: [ "block", "box" ]
        }, {
            title: "fa-solid fa-square-full",
            searchTerms: []
        }, {
            title: "fa-solid fa-square-root-alt",
            searchTerms: []
        }, {
            title: "fa-brands fa-squarespace",
            searchTerms: []
        }, {
            title: "fa-brands fa-stack-exchange",
            searchTerms: []
        }, {
            title: "fa-brands fa-stack-overflow",
            searchTerms: []
        }, {
            title: "fa-solid fa-stamp",
            searchTerms: []
        }, {
            title: "fa-solid fa-star",
            searchTerms: [ "achievement", "award", "favorite", "important", "night", "rating", "score" ]
        }, {
            title: "fa-regular fa-star",
            searchTerms: [ "achievement", "award", "favorite", "important", "night", "rating", "score" ]
        }, {
            title: "fa-solid fa-star-and-crescent",
            searchTerms: [ "islam", "muslim" ]
        }, {
            title: "fa-solid fa-star-half",
            searchTerms: [ "achievement", "award", "rating", "score", "star-half-empty", "star-half-full" ]
        }, {
            title: "fa-regular fa-star-half",
            searchTerms: [ "achievement", "award", "rating", "score", "star-half-empty", "star-half-full" ]
        }, {
            title: "fa-solid fa-star-half-alt",
            searchTerms: [ "achievement", "award", "rating", "score", "star-half-empty", "star-half-full" ]
        }, {
            title: "fa-solid fa-star-of-david",
            searchTerms: [ "jewish", "judaism" ]
        }, {
            title: "fa-solid fa-star-of-life",
            searchTerms: []
        }, {
            title: "fa-brands fa-staylinked",
            searchTerms: []
        }, {
            title: "fa-brands fa-steam",
            searchTerms: []
        }, {
            title: "fa-brands fa-steam-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-steam-symbol",
            searchTerms: []
        }, {
            title: "fa-solid fa-step-backward",
            searchTerms: [ "beginning", "first", "previous", "rewind", "start" ]
        }, {
            title: "fa-solid fa-step-forward",
            searchTerms: [ "end", "last", "next" ]
        }, {
            title: "fa-solid fa-stethoscope",
            searchTerms: []
        }, {
            title: "fa-brands fa-sticker-mule",
            searchTerms: []
        }, {
            title: "fa-solid fa-sticky-note",
            searchTerms: []
        }, {
            title: "fa-regular fa-sticky-note",
            searchTerms: []
        }, {
            title: "fa-solid fa-stop",
            searchTerms: [ "block", "box", "square" ]
        }, {
            title: "fa-solid fa-stop-circle",
            searchTerms: []
        }, {
            title: "fa-regular fa-stop-circle",
            searchTerms: []
        }, {
            title: "fa-solid fa-stopwatch",
            searchTerms: [ "time" ]
        }, {
            title: "fa-solid fa-store",
            searchTerms: []
        }, {
            title: "fa-solid fa-store-alt",
            searchTerms: []
        }, {
            title: "fa-brands fa-strava",
            searchTerms: []
        }, {
            title: "fa-solid fa-stream",
            searchTerms: []
        }, {
            title: "fa-solid fa-street-view",
            searchTerms: [ "map" ]
        }, {
            title: "fa-solid fa-strikethrough",
            searchTerms: []
        }, {
            title: "fa-brands fa-stripe",
            searchTerms: []
        }, {
            title: "fa-brands fa-stripe-s",
            searchTerms: []
        }, {
            title: "fa-solid fa-stroopwafel",
            searchTerms: [ "dessert", "food", "sweets", "waffle" ]
        }, {
            title: "fa-brands fa-studiovinari",
            searchTerms: []
        }, {
            title: "fa-brands fa-stumbleupon",
            searchTerms: []
        }, {
            title: "fa-brands fa-stumbleupon-circle",
            searchTerms: []
        }, {
            title: "fa-solid fa-subscript",
            searchTerms: []
        }, {
            title: "fa-solid fa-subway",
            searchTerms: [ "machine", "railway", "train", "transportation", "vehicle" ]
        }, {
            title: "fa-solid fa-suitcase",
            searchTerms: [ "baggage", "luggage", "move", "suitcase", "travel", "trip" ]
        }, {
            title: "fa-solid fa-suitcase-rolling",
            searchTerms: []
        }, {
            title: "fa-solid fa-sun",
            searchTerms: [ "brighten", "contrast", "day", "lighter", "sol", "solar", "star", "weather" ]
        }, {
            title: "fa-regular fa-sun",
            searchTerms: [ "brighten", "contrast", "day", "lighter", "sol", "solar", "star", "weather" ]
        }, {
            title: "fa-brands fa-superpowers",
            searchTerms: []
        }, {
            title: "fa-solid fa-superscript",
            searchTerms: [ "exponential" ]
        }, {
            title: "fa-brands fa-supple",
            searchTerms: []
        }, {
            title: "fa-solid fa-surprise",
            searchTerms: [ "emoticon", "face", "shocked" ]
        }, {
            title: "fa-regular fa-surprise",
            searchTerms: [ "emoticon", "face", "shocked" ]
        }, {
            title: "fa-solid fa-swatchbook",
            searchTerms: []
        }, {
            title: "fa-solid fa-swimmer",
            searchTerms: [ "athlete", "head", "man", "person", "water" ]
        }, {
            title: "fa-solid fa-swimming-pool",
            searchTerms: [ "ladder", "recreation", "water" ]
        }, {
            title: "fa-solid fa-synagogue",
            searchTerms: [ "building", "jewish", "judaism", "star of david", "temple" ]
        }, {
            title: "fa-solid fa-sync",
            searchTerms: [ "exchange", "refresh", "reload", "rotate", "swap" ]
        }, {
            title: "fa-solid fa-sync-alt",
            searchTerms: [ "refresh", "reload", "rotate" ]
        }, {
            title: "fa-solid fa-syringe",
            searchTerms: [ "immunizations", "needle" ]
        }, {
            title: "fa-solid fa-table",
            searchTerms: [ "data", "excel", "spreadsheet" ]
        }, {
            title: "fa-solid fa-table-tennis",
            searchTerms: []
        }, {
            title: "fa-solid fa-tablet",
            searchTerms: [ "apple", "device", "ipad", "kindle", "screen" ]
        }, {
            title: "fa-solid fa-tablet-alt",
            searchTerms: [ "apple", "device", "ipad", "kindle", "screen" ]
        }, {
            title: "fa-solid fa-tablets",
            searchTerms: [ "drugs", "medicine" ]
        }, {
            title: "fa-solid fa-tachometer-alt",
            searchTerms: [ "dashboard", "tachometer" ]
        }, {
            title: "fa-solid fa-tag",
            searchTerms: [ "label" ]
        }, {
            title: "fa-solid fa-tags",
            searchTerms: [ "labels" ]
        }, {
            title: "fa-solid fa-tape",
            searchTerms: []
        }, {
            title: "fa-solid fa-tasks",
            searchTerms: [ "downloading", "downloads", "loading", "progress", "settings" ]
        }, {
            title: "fa-solid fa-taxi",
            searchTerms: [ "cab", "cabbie", "car", "car service", "lyft", "machine", "transportation", "uber", "vehicle" ]
        }, {
            title: "fa-brands fa-teamspeak",
            searchTerms: []
        }, {
            title: "fa-solid fa-teeth",
            searchTerms: []
        }, {
            title: "fa-solid fa-teeth-open",
            searchTerms: []
        }, {
            title: "fa-brands fa-telegram",
            searchTerms: []
        }, {
            title: "fa-brands fa-telegram-plane",
            searchTerms: []
        }, {
            title: "fa-solid fa-temperature-high",
            searchTerms: [ "mercury", "thermometer", "warm" ]
        }, {
            title: "fa-solid fa-temperature-low",
            searchTerms: [ "cool", "mercury", "thermometer" ]
        }, {
            title: "fa-brands fa-tencent-weibo",
            searchTerms: []
        }, {
            title: "fa-solid fa-terminal",
            searchTerms: [ "code", "command", "console", "prompt" ]
        }, {
            title: "fa-solid fa-text-height",
            searchTerms: []
        }, {
            title: "fa-solid fa-text-width",
            searchTerms: []
        }, {
            title: "fa-solid fa-th",
            searchTerms: [ "blocks", "boxes", "grid", "squares" ]
        }, {
            title: "fa-solid fa-th-large",
            searchTerms: [ "blocks", "boxes", "grid", "squares" ]
        }, {
            title: "fa-solid fa-th-list",
            searchTerms: [ "checklist", "completed", "done", "finished", "ol", "todo", "ul" ]
        }, {
            title: "fa-brands fa-the-red-yeti",
            searchTerms: []
        }, {
            title: "fa-solid fa-theater-masks",
            searchTerms: []
        }, {
            title: "fa-brands fa-themeco",
            searchTerms: []
        }, {
            title: "fa-brands fa-themeisle",
            searchTerms: []
        }, {
            title: "fa-solid fa-thermometer",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-solid fa-thermometer-empty",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-solid fa-thermometer-full",
            searchTerms: [ "fever", "mercury", "status", "temperature" ]
        }, {
            title: "fa-solid fa-thermometer-half",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-solid fa-thermometer-quarter",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-solid fa-thermometer-three-quarters",
            searchTerms: [ "mercury", "status", "temperature" ]
        }, {
            title: "fa-brands fa-think-peaks",
            searchTerms: []
        }, {
            title: "fa-solid fa-thumbs-down",
            searchTerms: [ "disagree", "disapprove", "dislike", "hand", "thumbs-o-down" ]
        }, {
            title: "fa-regular fa-thumbs-down",
            searchTerms: [ "disagree", "disapprove", "dislike", "hand", "thumbs-o-down" ]
        }, {
            title: "fa-solid fa-thumbs-up",
            searchTerms: [ "agree", "approve", "favorite", "hand", "like", "ok", "okay", "success", "thumbs-o-up", "yes", "you got it dude" ]
        }, {
            title: "fa-regular fa-thumbs-up",
            searchTerms: [ "agree", "approve", "favorite", "hand", "like", "ok", "okay", "success", "thumbs-o-up", "yes", "you got it dude" ]
        }, {
            title: "fa-solid fa-thumbtack",
            searchTerms: [ "coordinates", "location", "marker", "pin", "thumb-tack" ]
        }, {
            title: "fa-solid fa-ticket-alt",
            searchTerms: [ "ticket" ]
        }, {
            title: "fa-solid fa-times",
            searchTerms: [ "close", "cross", "error", "exit", "incorrect", "notice", "notification", "notify", "problem", "wrong", "x" ]
        }, {
            title: "fa-solid fa-times-circle",
            searchTerms: [ "close", "cross", "exit", "incorrect", "notice", "notification", "notify", "problem", "wrong", "x" ]
        }, {
            title: "fa-regular fa-times-circle",
            searchTerms: [ "close", "cross", "exit", "incorrect", "notice", "notification", "notify", "problem", "wrong", "x" ]
        }, {
            title: "fa-solid fa-tint",
            searchTerms: [ "drop", "droplet", "raindrop", "waterdrop" ]
        }, {
            title: "fa-solid fa-tint-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-tired",
            searchTerms: [ "emoticon", "face", "grumpy" ]
        }, {
            title: "fa-regular fa-tired",
            searchTerms: [ "emoticon", "face", "grumpy" ]
        }, {
            title: "fa-solid fa-toggle-off",
            searchTerms: [ "switch" ]
        }, {
            title: "fa-solid fa-toggle-on",
            searchTerms: [ "switch" ]
        }, {
            title: "fa-solid fa-toilet-paper",
            searchTerms: [ "bathroom", "halloween", "holiday", "lavatory", "prank", "restroom", "roll" ]
        }, {
            title: "fa-solid fa-toolbox",
            searchTerms: [ "admin", "container", "fix", "repair", "settings", "tools" ]
        }, {
            title: "fa-solid fa-tooth",
            searchTerms: [ "bicuspid", "dental", "molar", "mouth", "teeth" ]
        }, {
            title: "fa-solid fa-torah",
            searchTerms: [ "book", "jewish", "judaism" ]
        }, {
            title: "fa-solid fa-torii-gate",
            searchTerms: [ "building", "shintoism" ]
        }, {
            title: "fa-solid fa-tractor",
            searchTerms: []
        }, {
            title: "fa-brands fa-trade-federation",
            searchTerms: []
        }, {
            title: "fa-solid fa-trademark",
            searchTerms: []
        }, {
            title: "fa-solid fa-traffic-light",
            searchTerms: []
        }, {
            title: "fa-solid fa-train",
            searchTerms: [ "bullet", "locomotive", "railway" ]
        }, {
            title: "fa-solid fa-transgender",
            searchTerms: [ "intersex" ]
        }, {
            title: "fa-solid fa-transgender-alt",
            searchTerms: []
        }, {
            title: "fa-solid fa-trash",
            searchTerms: [ "delete", "garbage", "hide", "remove" ]
        }, {
            title: "fa-solid fa-trash-alt",
            searchTerms: [ "delete", "garbage", "hide", "remove", "trash", "trash-o" ]
        }, {
            title: "fa-regular fa-trash-alt",
            searchTerms: [ "delete", "garbage", "hide", "remove", "trash", "trash-o" ]
        }, {
            title: "fa-solid fa-tree",
            searchTerms: [ "bark", "fall", "flora", "forest", "nature", "plant", "seasonal" ]
        }, {
            title: "fa-brands fa-trello",
            searchTerms: []
        }, {
            title: "fa-brands fa-tripadvisor",
            searchTerms: []
        }, {
            title: "fa-solid fa-trophy",
            searchTerms: [ "achievement", "award", "cup", "game", "winner" ]
        }, {
            title: "fa-solid fa-truck",
            searchTerms: [ "delivery", "shipping" ]
        }, {
            title: "fa-solid fa-truck-loading",
            searchTerms: []
        }, {
            title: "fa-solid fa-truck-monster",
            searchTerms: []
        }, {
            title: "fa-solid fa-truck-moving",
            searchTerms: []
        }, {
            title: "fa-solid fa-truck-pickup",
            searchTerms: []
        }, {
            title: "fa-solid fa-tshirt",
            searchTerms: [ "cloth", "clothing" ]
        }, {
            title: "fa-solid fa-tty",
            searchTerms: []
        }, {
            title: "fa-brands fa-tumblr",
            searchTerms: []
        }, {
            title: "fa-brands fa-tumblr-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-tv",
            searchTerms: [ "computer", "display", "monitor", "television" ]
        }, {
            title: "fa-brands fa-twitch",
            searchTerms: []
        }, {
            title: "fa-brands fa-twitter",
            searchTerms: [ "social network", "tweet" ]
        }, {
            title: "fa-brands fa-twitter-square",
            searchTerms: [ "social network", "tweet" ]
        }, {
            title: "fa-brands fa-typo3",
            searchTerms: []
        }, {
            title: "fa-brands fa-uber",
            searchTerms: []
        }, {
            title: "fa-brands fa-uikit",
            searchTerms: []
        }, {
            title: "fa-solid fa-umbrella",
            searchTerms: [ "protection", "rain" ]
        }, {
            title: "fa-solid fa-umbrella-beach",
            searchTerms: [ "protection", "recreation", "sun" ]
        }, {
            title: "fa-solid fa-underline",
            searchTerms: []
        }, {
            title: "fa-solid fa-undo",
            searchTerms: [ "back", "control z", "exchange", "oops", "return", "rotate", "swap" ]
        }, {
            title: "fa-solid fa-undo-alt",
            searchTerms: [ "back", "control z", "exchange", "oops", "return", "swap" ]
        }, {
            title: "fa-brands fa-uniregistry",
            searchTerms: []
        }, {
            title: "fa-solid fa-universal-access",
            searchTerms: []
        }, {
            title: "fa-solid fa-university",
            searchTerms: [ "bank", "institution" ]
        }, {
            title: "fa-solid fa-unlink",
            searchTerms: [ "chain", "chain-broken", "remove" ]
        }, {
            title: "fa-solid fa-unlock",
            searchTerms: [ "admin", "lock", "password", "protect" ]
        }, {
            title: "fa-solid fa-unlock-alt",
            searchTerms: [ "admin", "lock", "password", "protect" ]
        }, {
            title: "fa-brands fa-untappd",
            searchTerms: []
        }, {
            title: "fa-solid fa-upload",
            searchTerms: [ "export", "publish" ]
        }, {
            title: "fa-brands fa-usb",
            searchTerms: []
        }, {
            title: "fa-solid fa-user",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-regular fa-user",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-solid fa-user-alt",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-solid fa-user-alt-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-astronaut",
            searchTerms: [ "avatar", "clothing", "cosmonaut", "space", "suit" ]
        }, {
            title: "fa-solid fa-user-check",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-circle",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-regular fa-user-circle",
            searchTerms: [ "account", "avatar", "head", "human", "man", "person", "profile" ]
        }, {
            title: "fa-solid fa-user-clock",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-cog",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-edit",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-friends",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-graduate",
            searchTerms: [ "cap", "clothing", "commencement", "gown", "graduation", "student" ]
        }, {
            title: "fa-solid fa-user-injured",
            searchTerms: [ "cast", "ouch", "sling" ]
        }, {
            title: "fa-solid fa-user-lock",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-md",
            searchTerms: [ "doctor", "job", "medical", "nurse", "occupation", "profile" ]
        }, {
            title: "fa-solid fa-user-minus",
            searchTerms: [ "delete", "negative", "remove" ]
        }, {
            title: "fa-solid fa-user-ninja",
            searchTerms: [ "assassin", "avatar", "dangerous", "deadly", "sneaky" ]
        }, {
            title: "fa-solid fa-user-plus",
            searchTerms: [ "positive", "sign up", "signup" ]
        }, {
            title: "fa-solid fa-user-secret",
            searchTerms: [ "clothing", "coat", "hat", "incognito", "privacy", "spy", "whisper" ]
        }, {
            title: "fa-solid fa-user-shield",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-slash",
            searchTerms: [ "ban", "remove" ]
        }, {
            title: "fa-solid fa-user-tag",
            searchTerms: []
        }, {
            title: "fa-solid fa-user-tie",
            searchTerms: [ "avatar", "business", "clothing", "formal" ]
        }, {
            title: "fa-solid fa-user-times",
            searchTerms: [ "archive", "delete", "remove", "x" ]
        }, {
            title: "fa-solid fa-users",
            searchTerms: [ "people", "persons", "profiles" ]
        }, {
            title: "fa-solid fa-users-cog",
            searchTerms: []
        }, {
            title: "fa-brands fa-ussunnah",
            searchTerms: []
        }, {
            title: "fa-solid fa-utensil-spoon",
            searchTerms: [ "spoon" ]
        }, {
            title: "fa-solid fa-utensils",
            searchTerms: [ "cutlery", "dinner", "eat", "food", "knife", "restaurant", "spoon" ]
        }, {
            title: "fa-brands fa-vaadin",
            searchTerms: []
        }, {
            title: "fa-solid fa-vector-square",
            searchTerms: [ "anchors", "lines", "object" ]
        }, {
            title: "fa-solid fa-venus",
            searchTerms: [ "female" ]
        }, {
            title: "fa-solid fa-venus-double",
            searchTerms: []
        }, {
            title: "fa-solid fa-venus-mars",
            searchTerms: []
        }, {
            title: "fa-brands fa-viacoin",
            searchTerms: []
        }, {
            title: "fa-brands fa-viadeo",
            searchTerms: []
        }, {
            title: "fa-brands fa-viadeo-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-vial",
            searchTerms: [ "test tube" ]
        }, {
            title: "fa-solid fa-vials",
            searchTerms: [ "lab results", "test tubes" ]
        }, {
            title: "fa-brands fa-viber",
            searchTerms: []
        }, {
            title: "fa-solid fa-video",
            searchTerms: [ "camera", "film", "movie", "record", "video-camera" ]
        }, {
            title: "fa-solid fa-video-slash",
            searchTerms: []
        }, {
            title: "fa-solid fa-vihara",
            searchTerms: [ "buddhism", "buddhist", "building", "monastery" ]
        }, {
            title: "fa-brands fa-vimeo",
            searchTerms: []
        }, {
            title: "fa-brands fa-vimeo-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-vimeo-v",
            searchTerms: [ "vimeo" ]
        }, {
            title: "fa-brands fa-vine",
            searchTerms: []
        }, {
            title: "fa-brands fa-vk",
            searchTerms: []
        }, {
            title: "fa-brands fa-vnv",
            searchTerms: []
        }, {
            title: "fa-solid fa-volleyball-ball",
            searchTerms: []
        }, {
            title: "fa-solid fa-volume-down",
            searchTerms: [ "audio", "lower", "music", "quieter", "sound", "speaker" ]
        }, {
            title: "fa-solid fa-volume-mute",
            searchTerms: []
        }, {
            title: "fa-solid fa-volume-off",
            searchTerms: [ "audio", "music", "mute", "sound" ]
        }, {
            title: "fa-solid fa-volume-up",
            searchTerms: [ "audio", "higher", "louder", "music", "sound", "speaker" ]
        }, {
            title: "fa-solid fa-vote-yea",
            searchTerms: [ "accept", "cast", "election", "politics", "positive", "yes" ]
        }, {
            title: "fa-solid fa-vr-cardboard",
            searchTerms: [ "google", "reality", "virtual" ]
        }, {
            title: "fa-brands fa-vuejs",
            searchTerms: []
        }, {
            title: "fa-solid fa-walking",
            searchTerms: []
        }, {
            title: "fa-solid fa-wallet",
            searchTerms: []
        }, {
            title: "fa-solid fa-warehouse",
            searchTerms: []
        }, {
            title: "fa-solid fa-water",
            searchTerms: []
        }, {
            title: "fa-brands fa-weebly",
            searchTerms: []
        }, {
            title: "fa-brands fa-weibo",
            searchTerms: []
        }, {
            title: "fa-solid fa-weight",
            searchTerms: [ "measurement", "scale", "weight" ]
        }, {
            title: "fa-solid fa-weight-hanging",
            searchTerms: [ "anvil", "heavy", "measurement" ]
        }, {
            title: "fa-brands fa-weixin",
            searchTerms: []
        }, {
            title: "fa-brands fa-whatsapp",
            searchTerms: []
        }, {
            title: "fa-brands fa-whatsapp-square",
            searchTerms: []
        }, {
            title: "fa-solid fa-wheelchair",
            searchTerms: [ "handicap", "person" ]
        }, {
            title: "fa-brands fa-whmcs",
            searchTerms: []
        }, {
            title: "fa-solid fa-wifi",
            searchTerms: []
        }, {
            title: "fa-brands fa-wikipedia-w",
            searchTerms: []
        }, {
            title: "fa-solid fa-wind",
            searchTerms: [ "air", "blow", "breeze", "fall", "seasonal" ]
        }, {
            title: "fa-solid fa-window-close",
            searchTerms: []
        }, {
            title: "fa-regular fa-window-close",
            searchTerms: []
        }, {
            title: "fa-solid fa-window-maximize",
            searchTerms: []
        }, {
            title: "fa-regular fa-window-maximize",
            searchTerms: []
        }, {
            title: "fa-solid fa-window-minimize",
            searchTerms: []
        }, {
            title: "fa-regular fa-window-minimize",
            searchTerms: []
        }, {
            title: "fa-solid fa-window-restore",
            searchTerms: []
        }, {
            title: "fa-regular fa-window-restore",
            searchTerms: []
        }, {
            title: "fa-brands fa-windows",
            searchTerms: [ "microsoft" ]
        }, {
            title: "fa-solid fa-wine-bottle",
            searchTerms: [ "alcohol", "beverage", "drink", "glass", "grapes" ]
        }, {
            title: "fa-solid fa-wine-glass",
            searchTerms: [ "alcohol", "beverage", "drink", "grapes" ]
        }, {
            title: "fa-solid fa-wine-glass-alt",
            searchTerms: [ "alcohol", "beverage", "drink", "grapes" ]
        }, {
            title: "fa-brands fa-wix",
            searchTerms: []
        }, {
            title: "fa-brands fa-wizards-of-the-coast",
            searchTerms: [ "Dungeons & Dragons", "d&d", "dnd", "fantasy", "game", "gaming", "tabletop" ]
        }, {
            title: "fa-brands fa-wolf-pack-battalion",
            searchTerms: []
        }, {
            title: "fa-solid fa-won-sign",
            searchTerms: [ "krw" ]
        }, {
            title: "fa-brands fa-wordpress",
            searchTerms: []
        }, {
            title: "fa-brands fa-wordpress-simple",
            searchTerms: []
        }, {
            title: "fa-brands fa-wpbeginner",
            searchTerms: []
        }, {
            title: "fa-brands fa-wpexplorer",
            searchTerms: []
        }, {
            title: "fa-brands fa-wpforms",
            searchTerms: []
        }, {
            title: "fa-brands fa-wpressr",
            searchTerms: [ "rendact" ]
        }, {
            title: "fa-solid fa-wrench",
            searchTerms: [ "fix", "settings", "spanner", "tool", "update" ]
        }, {
            title: "fa-solid fa-x-ray",
            searchTerms: [ "radiological images", "radiology" ]
        }, {
            title: "fa-brands fa-xbox",
            searchTerms: []
        }, {
            title: "fa-brands fa-xing",
            searchTerms: []
        }, {
            title: "fa-brands fa-xing-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-y-combinator",
            searchTerms: []
        }, {
            title: "fa-brands fa-yahoo",
            searchTerms: []
        }, {
            title: "fa-brands fa-yandex",
            searchTerms: []
        }, {
            title: "fa-brands fa-yandex-international",
            searchTerms: []
        }, {
            title: "fa-brands fa-yelp",
            searchTerms: []
        }, {
            title: "fa-solid fa-yen-sign",
            searchTerms: [ "jpy", "money" ]
        }, {
            title: "fa-solid fa-yin-yang",
            searchTerms: [ "daoism", "opposites", "taoism" ]
        }, {
            title: "fa-brands fa-yoast",
            searchTerms: []
        }, {
            title: "fa-brands fa-youtube",
            searchTerms: [ "film", "video", "youtube-play", "youtube-square" ]
        }, {
            title: "fa-brands fa-youtube-square",
            searchTerms: []
        }, {
            title: "fa-brands fa-zhihu",
            searchTerms: []
        } ,


        // Bootstrap icon
        { title: "bi bi-123", searchTerms: [] },
        { title: "bi bi-alarm-fill", searchTerms: [] },
        { title: "bi bi-alarm", searchTerms: [] },
        { title: "bi bi-align-bottom", searchTerms: [] },
        { title: "bi bi-align-center", searchTerms: [] },
        { title: "bi bi-align-end", searchTerms: [] },
        { title: "bi bi-align-middle", searchTerms: [] },
        { title: "bi bi-align-start", searchTerms: [] },
        { title: "bi bi-align-top", searchTerms: [] },
        { title: "bi bi-alt", searchTerms: [] },
        { title: "bi bi-app-indicator", searchTerms: [] },
        { title: "bi bi-app", searchTerms: [] },
        { title: "bi bi-archive-fill", searchTerms: [] },
        { title: "bi bi-archive", searchTerms: [] },
        { title: "bi bi-arrow-90deg-down", searchTerms: [] },
        { title: "bi bi-arrow-90deg-left", searchTerms: [] },
        { title: "bi bi-arrow-90deg-right", searchTerms: [] },
        { title: "bi bi-arrow-90deg-up", searchTerms: [] },
        { title: "bi bi-arrow-bar-down", searchTerms: [] },
        { title: "bi bi-arrow-bar-left", searchTerms: [] },
        { title: "bi bi-arrow-bar-right", searchTerms: [] },
        { title: "bi bi-arrow-bar-up", searchTerms: [] },
        { title: "bi bi-arrow-clockwise", searchTerms: [] },
        { title: "bi bi-arrow-counterclockwise", searchTerms: [] },
        { title: "bi bi-arrow-down-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-down-circle", searchTerms: [] },
        { title: "bi bi-arrow-down-left-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-down-left-circle", searchTerms: [] },
        { title: "bi bi-arrow-down-left-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-down-left-square", searchTerms: [] },
        { title: "bi bi-arrow-down-left", searchTerms: [] },
        { title: "bi bi-arrow-down-right-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-down-right-circle", searchTerms: [] },
        { title: "bi bi-arrow-down-right-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-down-right-square", searchTerms: [] },
        { title: "bi bi-arrow-down-right", searchTerms: [] },
        { title: "bi bi-arrow-down-short", searchTerms: [] },
        { title: "bi bi-arrow-down-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-down-square", searchTerms: [] },
        { title: "bi bi-arrow-down-up", searchTerms: [] },
        { title: "bi bi-arrow-down", searchTerms: [] },
        { title: "bi bi-arrow-left-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-left-circle", searchTerms: [] },
        { title: "bi bi-arrow-left-right", searchTerms: [] },
        { title: "bi bi-arrow-left-short", searchTerms: [] },
        { title: "bi bi-arrow-left-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-left-square", searchTerms: [] },
        { title: "bi bi-arrow-left", searchTerms: [] },
        { title: "bi bi-arrow-repeat", searchTerms: [] },
        { title: "bi bi-arrow-return-left", searchTerms: [] },
        { title: "bi bi-arrow-return-right", searchTerms: [] },
        { title: "bi bi-arrow-right-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-right-circle", searchTerms: [] },
        { title: "bi bi-arrow-right-short", searchTerms: [] },
        { title: "bi bi-arrow-right-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-right-square", searchTerms: [] },
        { title: "bi bi-arrow-right", searchTerms: [] },
        { title: "bi bi-arrow-up-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-up-circle", searchTerms: [] },
        { title: "bi bi-arrow-up-left-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-up-left-circle", searchTerms: [] },
        { title: "bi bi-arrow-up-left-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-up-left-square", searchTerms: [] },
        { title: "bi bi-arrow-up-left", searchTerms: [] },
        { title: "bi bi-arrow-up-right-circle-fill", searchTerms: [] },
        { title: "bi bi-arrow-up-right-circle", searchTerms: [] },
        { title: "bi bi-arrow-up-right-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-up-right-square", searchTerms: [] },
        { title: "bi bi-arrow-up-right", searchTerms: [] },
        { title: "bi bi-arrow-up-short", searchTerms: [] },
        { title: "bi bi-arrow-up-square-fill", searchTerms: [] },
        { title: "bi bi-arrow-up-square", searchTerms: [] },
        { title: "bi bi-arrow-up", searchTerms: [] },
        { title: "bi bi-arrows-angle-contract", searchTerms: [] },
        { title: "bi bi-arrows-angle-expand", searchTerms: [] },
        { title: "bi bi-arrows-collapse", searchTerms: [] },
        { title: "bi bi-arrows-expand", searchTerms: [] },
        { title: "bi bi-arrows-fullscreen", searchTerms: [] },
        { title: "bi bi-arrows-move", searchTerms: [] },
        { title: "bi bi-aspect-ratio-fill", searchTerms: [] },
        { title: "bi bi-aspect-ratio", searchTerms: [] },
        { title: "bi bi-asterisk", searchTerms: [] },
        { title: "bi bi-at", searchTerms: [] },
        { title: "bi bi-award-fill", searchTerms: [] },
        { title: "bi bi-award", searchTerms: [] },
        { title: "bi bi-back", searchTerms: [] },
        { title: "bi bi-backspace-fill", searchTerms: [] },
        { title: "bi bi-backspace-reverse-fill", searchTerms: [] },
        { title: "bi bi-backspace-reverse", searchTerms: [] },
        { title: "bi bi-backspace", searchTerms: [] },
        { title: "bi bi-badge-3d-fill", searchTerms: [] },
        { title: "bi bi-badge-3d", searchTerms: [] },
        { title: "bi bi-badge-4k-fill", searchTerms: [] },
        { title: "bi bi-badge-4k", searchTerms: [] },
        { title: "bi bi-badge-8k-fill", searchTerms: [] },
        { title: "bi bi-badge-8k", searchTerms: [] },
        { title: "bi bi-badge-ad-fill", searchTerms: [] },
        { title: "bi bi-badge-ad", searchTerms: [] },
        { title: "bi bi-badge-ar-fill", searchTerms: [] },
        { title: "bi bi-badge-ar", searchTerms: [] },
        { title: "bi bi-badge-cc-fill", searchTerms: [] },
        { title: "bi bi-badge-cc", searchTerms: [] },
        { title: "bi bi-badge-hd-fill", searchTerms: [] },
        { title: "bi bi-badge-hd", searchTerms: [] },
        { title: "bi bi-badge-tm-fill", searchTerms: [] },
        { title: "bi bi-badge-tm", searchTerms: [] },
        { title: "bi bi-badge-vo-fill", searchTerms: [] },
        { title: "bi bi-badge-vo", searchTerms: [] },
        { title: "bi bi-badge-vr-fill", searchTerms: [] },
        { title: "bi bi-badge-vr", searchTerms: [] },
        { title: "bi bi-badge-wc-fill", searchTerms: [] },
        { title: "bi bi-badge-wc", searchTerms: [] },
        { title: "bi bi-bag-check-fill", searchTerms: [] },
        { title: "bi bi-bag-check", searchTerms: [] },
        { title: "bi bi-bag-dash-fill", searchTerms: [] },
        { title: "bi bi-bag-dash", searchTerms: [] },
        { title: "bi bi-bag-fill", searchTerms: [] },
        { title: "bi bi-bag-plus-fill", searchTerms: [] },
        { title: "bi bi-bag-plus", searchTerms: [] },
        { title: "bi bi-bag-x-fill", searchTerms: [] },
        { title: "bi bi-bag-x", searchTerms: [] },
        { title: "bi bi-bag", searchTerms: [] },
        { title: "bi bi-bar-chart-fill", searchTerms: [] },
        { title: "bi bi-bar-chart-line-fill", searchTerms: [] },
        { title: "bi bi-bar-chart-line", searchTerms: [] },
        { title: "bi bi-bar-chart-steps", searchTerms: [] },
        { title: "bi bi-bar-chart", searchTerms: [] },
        { title: "bi bi-basket-fill", searchTerms: [] },
        { title: "bi bi-basket", searchTerms: [] },
        { title: "bi bi-basket2-fill", searchTerms: [] },
        { title: "bi bi-basket2", searchTerms: [] },
        { title: "bi bi-basket3-fill", searchTerms: [] },
        { title: "bi bi-basket3", searchTerms: [] },
        { title: "bi bi-battery-charging", searchTerms: [] },
        { title: "bi bi-battery-full", searchTerms: [] },
        { title: "bi bi-battery-half", searchTerms: [] },
        { title: "bi bi-battery", searchTerms: [] },
        { title: "bi bi-bell-fill", searchTerms: [] },
        { title: "bi bi-bell", searchTerms: [] },
        { title: "bi bi-bezier", searchTerms: [] },
        { title: "bi bi-bezier2", searchTerms: [] },
        { title: "bi bi-bicycle", searchTerms: [] },
        { title: "bi bi-binoculars-fill", searchTerms: [] },
        { title: "bi bi-binoculars", searchTerms: [] },
        { title: "bi bi-blockquote-left", searchTerms: [] },
        { title: "bi bi-blockquote-right", searchTerms: [] },
        { title: "bi bi-book-fill", searchTerms: [] },
        { title: "bi bi-book-half", searchTerms: [] },
        { title: "bi bi-book", searchTerms: [] },
        { title: "bi bi-bookmark-check-fill", searchTerms: [] },
        { title: "bi bi-bookmark-check", searchTerms: [] },
        { title: "bi bi-bookmark-dash-fill", searchTerms: [] },
        { title: "bi bi-bookmark-dash", searchTerms: [] },
        { title: "bi bi-bookmark-fill", searchTerms: [] },
        { title: "bi bi-bookmark-heart-fill", searchTerms: [] },
        { title: "bi bi-bookmark-heart", searchTerms: [] },
        { title: "bi bi-bookmark-plus-fill", searchTerms: [] },
        { title: "bi bi-bookmark-plus", searchTerms: [] },
        { title: "bi bi-bookmark-star-fill", searchTerms: [] },
        { title: "bi bi-bookmark-star", searchTerms: [] },
        { title: "bi bi-bookmark-x-fill", searchTerms: [] },
        { title: "bi bi-bookmark-x", searchTerms: [] },
        { title: "bi bi-bookmark", searchTerms: [] },
        { title: "bi bi-bookmarks-fill", searchTerms: [] },
        { title: "bi bi-bookmarks", searchTerms: [] },
        { title: "bi bi-bookshelf", searchTerms: [] },
        { title: "bi bi-bootstrap-fill", searchTerms: [] },
        { title: "bi bi-bootstrap-reboot", searchTerms: [] },
        { title: "bi bi-bootstrap", searchTerms: [] },
        { title: "bi bi-border-all", searchTerms: [] },
        { title: "bi bi-border-bottom", searchTerms: [] },
        { title: "bi bi-border-center", searchTerms: [] },
        { title: "bi bi-border-inner", searchTerms: [] },
        { title: "bi bi-border-left", searchTerms: [] },
        { title: "bi bi-border-middle", searchTerms: [] },
        { title: "bi bi-border-outer", searchTerms: [] },
        { title: "bi bi-border-right", searchTerms: [] },
        { title: "bi bi-border-style", searchTerms: [] },
        { title: "bi bi-border-top", searchTerms: [] },
        { title: "bi bi-border-width", searchTerms: [] },
        { title: "bi bi-border", searchTerms: [] },
        { title: "bi bi-bounding-box-circles", searchTerms: [] },
        { title: "bi bi-bounding-box", searchTerms: [] },
        { title: "bi bi-box-arrow-down-left", searchTerms: [] },
        { title: "bi bi-box-arrow-down-right", searchTerms: [] },
        { title: "bi bi-box-arrow-down", searchTerms: [] },
        { title: "bi bi-box-arrow-in-down-left", searchTerms: [] },
        { title: "bi bi-box-arrow-in-down-right", searchTerms: [] },
        { title: "bi bi-box-arrow-in-down", searchTerms: [] },
        { title: "bi bi-box-arrow-in-left", searchTerms: [] },
        { title: "bi bi-box-arrow-in-right", searchTerms: [] },
        { title: "bi bi-box-arrow-in-up-left", searchTerms: [] },
        { title: "bi bi-box-arrow-in-up-right", searchTerms: [] },
        { title: "bi bi-box-arrow-in-up", searchTerms: [] },
        { title: "bi bi-box-arrow-left", searchTerms: [] },
        { title: "bi bi-box-arrow-right", searchTerms: [] },
        { title: "bi bi-box-arrow-up-left", searchTerms: [] },
        { title: "bi bi-box-arrow-up-right", searchTerms: [] },
        { title: "bi bi-box-arrow-up", searchTerms: [] },
        { title: "bi bi-box-seam", searchTerms: [] },
        { title: "bi bi-box", searchTerms: [] },
        { title: "bi bi-braces", searchTerms: [] },
        { title: "bi bi-bricks", searchTerms: [] },
        { title: "bi bi-briefcase-fill", searchTerms: [] },
        { title: "bi bi-briefcase", searchTerms: [] },
        { title: "bi bi-brightness-alt-high-fill", searchTerms: [] },
        { title: "bi bi-brightness-alt-high", searchTerms: [] },
        { title: "bi bi-brightness-alt-low-fill", searchTerms: [] },
        { title: "bi bi-brightness-alt-low", searchTerms: [] },
        { title: "bi bi-brightness-high-fill", searchTerms: [] },
        { title: "bi bi-brightness-high", searchTerms: [] },
        { title: "bi bi-brightness-low-fill", searchTerms: [] },
        { title: "bi bi-brightness-low", searchTerms: [] },
        { title: "bi bi-broadcast-pin", searchTerms: [] },
        { title: "bi bi-broadcast", searchTerms: [] },
        { title: "bi bi-brush-fill", searchTerms: [] },
        { title: "bi bi-brush", searchTerms: [] },
        { title: "bi bi-bucket-fill", searchTerms: [] },
        { title: "bi bi-bucket", searchTerms: [] },
        { title: "bi bi-bug-fill", searchTerms: [] },
        { title: "bi bi-bug", searchTerms: [] },
        { title: "bi bi-building", searchTerms: [] },
        { title: "bi bi-bullseye", searchTerms: [] },
        { title: "bi bi-calculator-fill", searchTerms: [] },
        { title: "bi bi-calculator", searchTerms: [] },
        { title: "bi bi-calendar-check-fill", searchTerms: [] },
        { title: "bi bi-calendar-check", searchTerms: [] },
        { title: "bi bi-calendar-date-fill", searchTerms: [] },
        { title: "bi bi-calendar-date", searchTerms: [] },
        { title: "bi bi-calendar-day-fill", searchTerms: [] },
        { title: "bi bi-calendar-day", searchTerms: [] },
        { title: "bi bi-calendar-event-fill", searchTerms: [] },
        { title: "bi bi-calendar-event", searchTerms: [] },
        { title: "bi bi-calendar-fill", searchTerms: [] },
        { title: "bi bi-calendar-minus-fill", searchTerms: [] },
        { title: "bi bi-calendar-minus", searchTerms: [] },
        { title: "bi bi-calendar-month-fill", searchTerms: [] },
        { title: "bi bi-calendar-month", searchTerms: [] },
        { title: "bi bi-calendar-plus-fill", searchTerms: [] },
        { title: "bi bi-calendar-plus", searchTerms: [] },
        { title: "bi bi-calendar-range-fill", searchTerms: [] },
        { title: "bi bi-calendar-range", searchTerms: [] },
        { title: "bi bi-calendar-week-fill", searchTerms: [] },
        { title: "bi bi-calendar-week", searchTerms: [] },
        { title: "bi bi-calendar-x-fill", searchTerms: [] },
        { title: "bi bi-calendar-x", searchTerms: [] },
        { title: "bi bi-calendar", searchTerms: [] },
        { title: "bi bi-calendar2-check-fill", searchTerms: [] },
        { title: "bi bi-calendar2-check", searchTerms: [] },
        { title: "bi bi-calendar2-date-fill", searchTerms: [] },
        { title: "bi bi-calendar2-date", searchTerms: [] },
        { title: "bi bi-calendar2-day-fill", searchTerms: [] },
        { title: "bi bi-calendar2-day", searchTerms: [] },
        { title: "bi bi-calendar2-event-fill", searchTerms: [] },
        { title: "bi bi-calendar2-event", searchTerms: [] },
        { title: "bi bi-calendar2-fill", searchTerms: [] },
        { title: "bi bi-calendar2-minus-fill", searchTerms: [] },
        { title: "bi bi-calendar2-minus", searchTerms: [] },
        { title: "bi bi-calendar2-month-fill", searchTerms: [] },
        { title: "bi bi-calendar2-month", searchTerms: [] },
        { title: "bi bi-calendar2-plus-fill", searchTerms: [] },
        { title: "bi bi-calendar2-plus", searchTerms: [] },
        { title: "bi bi-calendar2-range-fill", searchTerms: [] },
        { title: "bi bi-calendar2-range", searchTerms: [] },
        { title: "bi bi-calendar2-week-fill", searchTerms: [] },
        { title: "bi bi-calendar2-week", searchTerms: [] },
        { title: "bi bi-calendar2-x-fill", searchTerms: [] },
        { title: "bi bi-calendar2-x", searchTerms: [] },
        { title: "bi bi-calendar2", searchTerms: [] },
        { title: "bi bi-calendar3-event-fill", searchTerms: [] },
        { title: "bi bi-calendar3-event", searchTerms: [] },
        { title: "bi bi-calendar3-fill", searchTerms: [] },
        { title: "bi bi-calendar3-range-fill", searchTerms: [] },
        { title: "bi bi-calendar3-range", searchTerms: [] },
        { title: "bi bi-calendar3-week-fill", searchTerms: [] },
        { title: "bi bi-calendar3-week", searchTerms: [] },
        { title: "bi bi-calendar3", searchTerms: [] },
        { title: "bi bi-calendar4-event", searchTerms: [] },
        { title: "bi bi-calendar4-range", searchTerms: [] },
        { title: "bi bi-calendar4-week", searchTerms: [] },
        { title: "bi bi-calendar4", searchTerms: [] },
        { title: "bi bi-camera-fill", searchTerms: [] },
        { title: "bi bi-camera-reels-fill", searchTerms: [] },
        { title: "bi bi-camera-reels", searchTerms: [] },
        { title: "bi bi-camera-video-fill", searchTerms: [] },
        { title: "bi bi-camera-video-off-fill", searchTerms: [] },
        { title: "bi bi-camera-video-off", searchTerms: [] },
        { title: "bi bi-camera-video", searchTerms: [] },
        { title: "bi bi-camera", searchTerms: [] },
        { title: "bi bi-camera2", searchTerms: [] },
        { title: "bi bi-capslock-fill", searchTerms: [] },
        { title: "bi bi-capslock", searchTerms: [] },
        { title: "bi bi-card-checklist", searchTerms: [] },
        { title: "bi bi-card-heading", searchTerms: [] },
        { title: "bi bi-card-image", searchTerms: [] },
        { title: "bi bi-card-list", searchTerms: [] },
        { title: "bi bi-card-text", searchTerms: [] },
        { title: "bi bi-caret-down-fill", searchTerms: [] },
        { title: "bi bi-caret-down-square-fill", searchTerms: [] },
        { title: "bi bi-caret-down-square", searchTerms: [] },
        { title: "bi bi-caret-down", searchTerms: [] },
        { title: "bi bi-caret-left-fill", searchTerms: [] },
        { title: "bi bi-caret-left-square-fill", searchTerms: [] },
        { title: "bi bi-caret-left-square", searchTerms: [] },
        { title: "bi bi-caret-left", searchTerms: [] },
        { title: "bi bi-caret-right-fill", searchTerms: [] },
        { title: "bi bi-caret-right-square-fill", searchTerms: [] },
        { title: "bi bi-caret-right-square", searchTerms: [] },
        { title: "bi bi-caret-right", searchTerms: [] },
        { title: "bi bi-caret-up-fill", searchTerms: [] },
        { title: "bi bi-caret-up-square-fill", searchTerms: [] },
        { title: "bi bi-caret-up-square", searchTerms: [] },
        { title: "bi bi-caret-up", searchTerms: [] },
        { title: "bi bi-cart-check-fill", searchTerms: [] },
        { title: "bi bi-cart-check", searchTerms: [] },
        { title: "bi bi-cart-dash-fill", searchTerms: [] },
        { title: "bi bi-cart-dash", searchTerms: [] },
        { title: "bi bi-cart-fill", searchTerms: [] },
        { title: "bi bi-cart-plus-fill", searchTerms: [] },
        { title: "bi bi-cart-plus", searchTerms: [] },
        { title: "bi bi-cart-x-fill", searchTerms: [] },
        { title: "bi bi-cart-x", searchTerms: [] },
        { title: "bi bi-cart", searchTerms: [] },
        { title: "bi bi-cart2", searchTerms: [] },
        { title: "bi bi-cart3", searchTerms: [] },
        { title: "bi bi-cart4", searchTerms: [] },
        { title: "bi bi-cash-stack", searchTerms: [] },
        { title: "bi bi-cash", searchTerms: [] },
        { title: "bi bi-cast", searchTerms: [] },
        { title: "bi bi-chat-dots-fill", searchTerms: [] },
        { title: "bi bi-chat-dots", searchTerms: [] },
        { title: "bi bi-chat-fill", searchTerms: [] },
        { title: "bi bi-chat-left-dots-fill", searchTerms: [] },
        { title: "bi bi-chat-left-dots", searchTerms: [] },
        { title: "bi bi-chat-left-fill", searchTerms: [] },
        { title: "bi bi-chat-left-quote-fill", searchTerms: [] },
        { title: "bi bi-chat-left-quote", searchTerms: [] },
        { title: "bi bi-chat-left-text-fill", searchTerms: [] },
        { title: "bi bi-chat-left-text", searchTerms: [] },
        { title: "bi bi-chat-left", searchTerms: [] },
        { title: "bi bi-chat-quote-fill", searchTerms: [] },
        { title: "bi bi-chat-quote", searchTerms: [] },
        { title: "bi bi-chat-right-dots-fill", searchTerms: [] },
        { title: "bi bi-chat-right-dots", searchTerms: [] },
        { title: "bi bi-chat-right-fill", searchTerms: [] },
        { title: "bi bi-chat-right-quote-fill", searchTerms: [] },
        { title: "bi bi-chat-right-quote", searchTerms: [] },
        { title: "bi bi-chat-right-text-fill", searchTerms: [] },
        { title: "bi bi-chat-right-text", searchTerms: [] },
        { title: "bi bi-chat-right", searchTerms: [] },
        { title: "bi bi-chat-square-dots-fill", searchTerms: [] },
        { title: "bi bi-chat-square-dots", searchTerms: [] },
        { title: "bi bi-chat-square-fill", searchTerms: [] },
        { title: "bi bi-chat-square-quote-fill", searchTerms: [] },
        { title: "bi bi-chat-square-quote", searchTerms: [] },
        { title: "bi bi-chat-square-text-fill", searchTerms: [] },
        { title: "bi bi-chat-square-text", searchTerms: [] },
        { title: "bi bi-chat-square", searchTerms: [] },
        { title: "bi bi-chat-text-fill", searchTerms: [] },
        { title: "bi bi-chat-text", searchTerms: [] },
        { title: "bi bi-chat", searchTerms: [] },
        { title: "bi bi-check-all", searchTerms: [] },
        { title: "bi bi-check-circle-fill", searchTerms: [] },
        { title: "bi bi-check-circle", searchTerms: [] },
        { title: "bi bi-check-square-fill", searchTerms: [] },
        { title: "bi bi-check-square", searchTerms: [] },
        { title: "bi bi-check", searchTerms: [] },
        { title: "bi bi-check2-all", searchTerms: [] },
        { title: "bi bi-check2-circle", searchTerms: [] },
        { title: "bi bi-check2-square", searchTerms: [] },
        { title: "bi bi-check2", searchTerms: [] },
        { title: "bi bi-chevron-bar-contract", searchTerms: [] },
        { title: "bi bi-chevron-bar-down", searchTerms: [] },
        { title: "bi bi-chevron-bar-expand", searchTerms: [] },
        { title: "bi bi-chevron-bar-left", searchTerms: [] },
        { title: "bi bi-chevron-bar-right", searchTerms: [] },
        { title: "bi bi-chevron-bar-up", searchTerms: [] },
        { title: "bi bi-chevron-compact-down", searchTerms: [] },
        { title: "bi bi-chevron-compact-left", searchTerms: [] },
        { title: "bi bi-chevron-compact-right", searchTerms: [] },
        { title: "bi bi-chevron-compact-up", searchTerms: [] },
        { title: "bi bi-chevron-contract", searchTerms: [] },
        { title: "bi bi-chevron-double-down", searchTerms: [] },
        { title: "bi bi-chevron-double-left", searchTerms: [] },
        { title: "bi bi-chevron-double-right", searchTerms: [] },
        { title: "bi bi-chevron-double-up", searchTerms: [] },
        { title: "bi bi-chevron-down", searchTerms: [] },
        { title: "bi bi-chevron-expand", searchTerms: [] },
        { title: "bi bi-chevron-left", searchTerms: [] },
        { title: "bi bi-chevron-right", searchTerms: [] },
        { title: "bi bi-chevron-up", searchTerms: [] },
        { title: "bi bi-circle-fill", searchTerms: [] },
        { title: "bi bi-circle-half", searchTerms: [] },
        { title: "bi bi-circle-square", searchTerms: [] },
        { title: "bi bi-circle", searchTerms: [] },
        { title: "bi bi-clipboard-check", searchTerms: [] },
        { title: "bi bi-clipboard-data", searchTerms: [] },
        { title: "bi bi-clipboard-minus", searchTerms: [] },
        { title: "bi bi-clipboard-plus", searchTerms: [] },
        { title: "bi bi-clipboard-x", searchTerms: [] },
        { title: "bi bi-clipboard", searchTerms: [] },
        { title: "bi bi-clock-fill", searchTerms: [] },
        { title: "bi bi-clock-history", searchTerms: [] },
        { title: "bi bi-clock", searchTerms: [] },
        { title: "bi bi-cloud-arrow-down-fill", searchTerms: [] },
        { title: "bi bi-cloud-arrow-down", searchTerms: [] },
        { title: "bi bi-cloud-arrow-up-fill", searchTerms: [] },
        { title: "bi bi-cloud-arrow-up", searchTerms: [] },
        { title: "bi bi-cloud-check-fill", searchTerms: [] },
        { title: "bi bi-cloud-check", searchTerms: [] },
        { title: "bi bi-cloud-download-fill", searchTerms: [] },
        { title: "bi bi-cloud-download", searchTerms: [] },
        { title: "bi bi-cloud-drizzle-fill", searchTerms: [] },
        { title: "bi bi-cloud-drizzle", searchTerms: [] },
        { title: "bi bi-cloud-fill", searchTerms: [] },
        { title: "bi bi-cloud-fog-fill", searchTerms: [] },
        { title: "bi bi-cloud-fog", searchTerms: [] },
        { title: "bi bi-cloud-fog2-fill", searchTerms: [] },
        { title: "bi bi-cloud-fog2", searchTerms: [] },
        { title: "bi bi-cloud-hail-fill", searchTerms: [] },
        { title: "bi bi-cloud-hail", searchTerms: [] },
        { title: "bi bi-cloud-haze-fill", searchTerms: [] },
        { title: "bi bi-cloud-haze", searchTerms: [] },
        { title: "bi bi-cloud-haze2-fill", searchTerms: [] },
        { title: "bi bi-cloud-lightning-fill", searchTerms: [] },
        { title: "bi bi-cloud-lightning-rain-fill", searchTerms: [] },
        { title: "bi bi-cloud-lightning-rain", searchTerms: [] },
        { title: "bi bi-cloud-lightning", searchTerms: [] },
        { title: "bi bi-cloud-minus-fill", searchTerms: [] },
        { title: "bi bi-cloud-minus", searchTerms: [] },
        { title: "bi bi-cloud-moon-fill", searchTerms: [] },
        { title: "bi bi-cloud-moon", searchTerms: [] },
        { title: "bi bi-cloud-plus-fill", searchTerms: [] },
        { title: "bi bi-cloud-plus", searchTerms: [] },
        { title: "bi bi-cloud-rain-fill", searchTerms: [] },
        { title: "bi bi-cloud-rain-heavy-fill", searchTerms: [] },
        { title: "bi bi-cloud-rain-heavy", searchTerms: [] },
        { title: "bi bi-cloud-rain", searchTerms: [] },
        { title: "bi bi-cloud-slash-fill", searchTerms: [] },
        { title: "bi bi-cloud-slash", searchTerms: [] },
        { title: "bi bi-cloud-sleet-fill", searchTerms: [] },
        { title: "bi bi-cloud-sleet", searchTerms: [] },
        { title: "bi bi-cloud-snow-fill", searchTerms: [] },
        { title: "bi bi-cloud-snow", searchTerms: [] },
        { title: "bi bi-cloud-sun-fill", searchTerms: [] },
        { title: "bi bi-cloud-sun", searchTerms: [] },
        { title: "bi bi-cloud-upload-fill", searchTerms: [] },
        { title: "bi bi-cloud-upload", searchTerms: [] },
        { title: "bi bi-cloud", searchTerms: [] },
        { title: "bi bi-clouds-fill", searchTerms: [] },
        { title: "bi bi-clouds", searchTerms: [] },
        { title: "bi bi-cloudy-fill", searchTerms: [] },
        { title: "bi bi-cloudy", searchTerms: [] },
        { title: "bi bi-code-slash", searchTerms: [] },
        { title: "bi bi-code-square", searchTerms: [] },
        { title: "bi bi-code", searchTerms: [] },
        { title: "bi bi-collection-fill", searchTerms: [] },
        { title: "bi bi-collection-play-fill", searchTerms: [] },
        { title: "bi bi-collection-play", searchTerms: [] },
        { title: "bi bi-collection", searchTerms: [] },
        { title: "bi bi-columns-gap", searchTerms: [] },
        { title: "bi bi-columns", searchTerms: [] },
        { title: "bi bi-command", searchTerms: [] },
        { title: "bi bi-compass-fill", searchTerms: [] },
        { title: "bi bi-compass", searchTerms: [] },
        { title: "bi bi-cone-striped", searchTerms: [] },
        { title: "bi bi-cone", searchTerms: [] },
        { title: "bi bi-controller", searchTerms: [] },
        { title: "bi bi-cpu-fill", searchTerms: [] },
        { title: "bi bi-cpu", searchTerms: [] },
        { title: "bi bi-credit-card-2-back-fill", searchTerms: [] },
        { title: "bi bi-credit-card-2-back", searchTerms: [] },
        { title: "bi bi-credit-card-2-front-fill", searchTerms: [] },
        { title: "bi bi-credit-card-2-front", searchTerms: [] },
        { title: "bi bi-credit-card-fill", searchTerms: [] },
        { title: "bi bi-credit-card", searchTerms: [] },
        { title: "bi bi-crop", searchTerms: [] },
        { title: "bi bi-cup-fill", searchTerms: [] },
        { title: "bi bi-cup-straw", searchTerms: [] },
        { title: "bi bi-cup", searchTerms: [] },
        { title: "bi bi-cursor-fill", searchTerms: [] },
        { title: "bi bi-cursor-text", searchTerms: [] },
        { title: "bi bi-cursor", searchTerms: [] },
        { title: "bi bi-dash-circle-dotted", searchTerms: [] },
        { title: "bi bi-dash-circle-fill", searchTerms: [] },
        { title: "bi bi-dash-circle", searchTerms: [] },
        { title: "bi bi-dash-square-dotted", searchTerms: [] },
        { title: "bi bi-dash-square-fill", searchTerms: [] },
        { title: "bi bi-dash-square", searchTerms: [] },
        { title: "bi bi-dash", searchTerms: [] },
        { title: "bi bi-diagram-2-fill", searchTerms: [] },
        { title: "bi bi-diagram-2", searchTerms: [] },
        { title: "bi bi-diagram-3-fill", searchTerms: [] },
        { title: "bi bi-diagram-3", searchTerms: [] },
        { title: "bi bi-diamond-fill", searchTerms: [] },
        { title: "bi bi-diamond-half", searchTerms: [] },
        { title: "bi bi-diamond", searchTerms: [] },
        { title: "bi bi-dice-1-fill", searchTerms: [] },
        { title: "bi bi-dice-1", searchTerms: [] },
        { title: "bi bi-dice-2-fill", searchTerms: [] },
        { title: "bi bi-dice-2", searchTerms: [] },
        { title: "bi bi-dice-3-fill", searchTerms: [] },
        { title: "bi bi-dice-3", searchTerms: [] },
        { title: "bi bi-dice-4-fill", searchTerms: [] },
        { title: "bi bi-dice-4", searchTerms: [] },
        { title: "bi bi-dice-5-fill", searchTerms: [] },
        { title: "bi bi-dice-5", searchTerms: [] },
        { title: "bi bi-dice-6-fill", searchTerms: [] },
        { title: "bi bi-dice-6", searchTerms: [] },
        { title: "bi bi-disc-fill", searchTerms: [] },
        { title: "bi bi-disc", searchTerms: [] },
        { title: "bi bi-discord", searchTerms: [] },
        { title: "bi bi-display-fill", searchTerms: [] },
        { title: "bi bi-display", searchTerms: [] },
        { title: "bi bi-distribute-horizontal", searchTerms: [] },
        { title: "bi bi-distribute-vertical", searchTerms: [] },
        { title: "bi bi-door-closed-fill", searchTerms: [] },
        { title: "bi bi-door-closed", searchTerms: [] },
        { title: "bi bi-door-open-fill", searchTerms: [] },
        { title: "bi bi-door-open", searchTerms: [] },
        { title: "bi bi-dot", searchTerms: [] },
        { title: "bi bi-download", searchTerms: [] },
        { title: "bi bi-droplet-fill", searchTerms: [] },
        { title: "bi bi-droplet-half", searchTerms: [] },
        { title: "bi bi-droplet", searchTerms: [] },
        { title: "bi bi-earbuds", searchTerms: [] },
        { title: "bi bi-easel-fill", searchTerms: [] },
        { title: "bi bi-easel", searchTerms: [] },
        { title: "bi bi-egg-fill", searchTerms: [] },
        { title: "bi bi-egg-fried", searchTerms: [] },
        { title: "bi bi-egg", searchTerms: [] },
        { title: "bi bi-eject-fill", searchTerms: [] },
        { title: "bi bi-eject", searchTerms: [] },
        { title: "bi bi-emoji-angry-fill", searchTerms: [] },
        { title: "bi bi-emoji-angry", searchTerms: [] },
        { title: "bi bi-emoji-dizzy-fill", searchTerms: [] },
        { title: "bi bi-emoji-dizzy", searchTerms: [] },
        { title: "bi bi-emoji-expressionless-fill", searchTerms: [] },
        { title: "bi bi-emoji-expressionless", searchTerms: [] },
        { title: "bi bi-emoji-frown-fill", searchTerms: [] },
        { title: "bi bi-emoji-frown", searchTerms: [] },
        { title: "bi bi-emoji-heart-eyes-fill", searchTerms: [] },
        { title: "bi bi-emoji-heart-eyes", searchTerms: [] },
        { title: "bi bi-emoji-laughing-fill", searchTerms: [] },
        { title: "bi bi-emoji-laughing", searchTerms: [] },
        { title: "bi bi-emoji-neutral-fill", searchTerms: [] },
        { title: "bi bi-emoji-neutral", searchTerms: [] },
        { title: "bi bi-emoji-smile-fill", searchTerms: [] },
        { title: "bi bi-emoji-smile-upside-down-fill", searchTerms: [] },
        { title: "bi bi-emoji-smile-upside-down", searchTerms: [] },
        { title: "bi bi-emoji-smile", searchTerms: [] },
        { title: "bi bi-emoji-sunglasses-fill", searchTerms: [] },
        { title: "bi bi-emoji-sunglasses", searchTerms: [] },
        { title: "bi bi-emoji-wink-fill", searchTerms: [] },
        { title: "bi bi-emoji-wink", searchTerms: [] },
        { title: "bi bi-envelope-fill", searchTerms: [] },
        { title: "bi bi-envelope-open-fill", searchTerms: [] },
        { title: "bi bi-envelope-open", searchTerms: [] },
        { title: "bi bi-envelope", searchTerms: [] },
        { title: "bi bi-eraser-fill", searchTerms: [] },
        { title: "bi bi-eraser", searchTerms: [] },
        { title: "bi bi-exclamation-circle-fill", searchTerms: [] },
        { title: "bi bi-exclamation-circle", searchTerms: [] },
        { title: "bi bi-exclamation-diamond-fill", searchTerms: [] },
        { title: "bi bi-exclamation-diamond", searchTerms: [] },
        { title: "bi bi-exclamation-octagon-fill", searchTerms: [] },
        { title: "bi bi-exclamation-octagon", searchTerms: [] },
        { title: "bi bi-exclamation-square-fill", searchTerms: [] },
        { title: "bi bi-exclamation-square", searchTerms: [] },
        { title: "bi bi-exclamation-triangle-fill", searchTerms: [] },
        { title: "bi bi-exclamation-triangle", searchTerms: [] },
        { title: "bi bi-exclamation", searchTerms: [] },
        { title: "bi bi-exclude", searchTerms: [] },
        { title: "bi bi-eye-fill", searchTerms: [] },
        { title: "bi bi-eye-slash-fill", searchTerms: [] },
        { title: "bi bi-eye-slash", searchTerms: [] },
        { title: "bi bi-eye", searchTerms: [] },
        { title: "bi bi-eyedropper", searchTerms: [] },
        { title: "bi bi-eyeglasses", searchTerms: [] },
        { title: "bi bi-facebook", searchTerms: [] },
        { title: "bi bi-file-arrow-down-fill", searchTerms: [] },
        { title: "bi bi-file-arrow-down", searchTerms: [] },
        { title: "bi bi-file-arrow-up-fill", searchTerms: [] },
        { title: "bi bi-file-arrow-up", searchTerms: [] },
        { title: "bi bi-file-bar-graph-fill", searchTerms: [] },
        { title: "bi bi-file-bar-graph", searchTerms: [] },
        { title: "bi bi-file-binary-fill", searchTerms: [] },
        { title: "bi bi-file-binary", searchTerms: [] },
        { title: "bi bi-file-break-fill", searchTerms: [] },
        { title: "bi bi-file-break", searchTerms: [] },
        { title: "bi bi-file-check-fill", searchTerms: [] },
        { title: "bi bi-file-check", searchTerms: [] },
        { title: "bi bi-file-code-fill", searchTerms: [] },
        { title: "bi bi-file-code", searchTerms: [] },
        { title: "bi bi-file-diff-fill", searchTerms: [] },
        { title: "bi bi-file-diff", searchTerms: [] },
        { title: "bi bi-file-earmark-arrow-down-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-arrow-down", searchTerms: [] },
        { title: "bi bi-file-earmark-arrow-up-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-arrow-up", searchTerms: [] },
        { title: "bi bi-file-earmark-bar-graph-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-bar-graph", searchTerms: [] },
        { title: "bi bi-file-earmark-binary-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-binary", searchTerms: [] },
        { title: "bi bi-file-earmark-break-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-break", searchTerms: [] },
        { title: "bi bi-file-earmark-check-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-check", searchTerms: [] },
        { title: "bi bi-file-earmark-code-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-code", searchTerms: [] },
        { title: "bi bi-file-earmark-diff-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-diff", searchTerms: [] },
        { title: "bi bi-file-earmark-easel-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-easel", searchTerms: [] },
        { title: "bi bi-file-earmark-excel-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-excel", searchTerms: [] },
        { title: "bi bi-file-earmark-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-font-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-font", searchTerms: [] },
        { title: "bi bi-file-earmark-image-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-image", searchTerms: [] },
        { title: "bi bi-file-earmark-lock-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-lock", searchTerms: [] },
        { title: "bi bi-file-earmark-lock2-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-lock2", searchTerms: [] },
        { title: "bi bi-file-earmark-medical-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-medical", searchTerms: [] },
        { title: "bi bi-file-earmark-minus-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-minus", searchTerms: [] },
        { title: "bi bi-file-earmark-music-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-music", searchTerms: [] },
        { title: "bi bi-file-earmark-person-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-person", searchTerms: [] },
        { title: "bi bi-file-earmark-play-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-play", searchTerms: [] },
        { title: "bi bi-file-earmark-plus-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-plus", searchTerms: [] },
        { title: "bi bi-file-earmark-post-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-post", searchTerms: [] },
        { title: "bi bi-file-earmark-ppt-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-ppt", searchTerms: [] },
        { title: "bi bi-file-earmark-richtext-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-richtext", searchTerms: [] },
        { title: "bi bi-file-earmark-ruled-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-ruled", searchTerms: [] },
        { title: "bi bi-file-earmark-slides-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-slides", searchTerms: [] },
        { title: "bi bi-file-earmark-spreadsheet-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-spreadsheet", searchTerms: [] },
        { title: "bi bi-file-earmark-text-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-text", searchTerms: [] },
        { title: "bi bi-file-earmark-word-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-word", searchTerms: [] },
        { title: "bi bi-file-earmark-x-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-x", searchTerms: [] },
        { title: "bi bi-file-earmark-zip-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-zip", searchTerms: [] },
        { title: "bi bi-file-earmark", searchTerms: [] },
        { title: "bi bi-file-easel-fill", searchTerms: [] },
        { title: "bi bi-file-easel", searchTerms: [] },
        { title: "bi bi-file-excel-fill", searchTerms: [] },
        { title: "bi bi-file-excel", searchTerms: [] },
        { title: "bi bi-file-fill", searchTerms: [] },
        { title: "bi bi-file-font-fill", searchTerms: [] },
        { title: "bi bi-file-font", searchTerms: [] },
        { title: "bi bi-file-image-fill", searchTerms: [] },
        { title: "bi bi-file-image", searchTerms: [] },
        { title: "bi bi-file-lock-fill", searchTerms: [] },
        { title: "bi bi-file-lock", searchTerms: [] },
        { title: "bi bi-file-lock2-fill", searchTerms: [] },
        { title: "bi bi-file-lock2", searchTerms: [] },
        { title: "bi bi-file-medical-fill", searchTerms: [] },
        { title: "bi bi-file-medical", searchTerms: [] },
        { title: "bi bi-file-minus-fill", searchTerms: [] },
        { title: "bi bi-file-minus", searchTerms: [] },
        { title: "bi bi-file-music-fill", searchTerms: [] },
        { title: "bi bi-file-music", searchTerms: [] },
        { title: "bi bi-file-person-fill", searchTerms: [] },
        { title: "bi bi-file-person", searchTerms: [] },
        { title: "bi bi-file-play-fill", searchTerms: [] },
        { title: "bi bi-file-play", searchTerms: [] },
        { title: "bi bi-file-plus-fill", searchTerms: [] },
        { title: "bi bi-file-plus", searchTerms: [] },
        { title: "bi bi-file-post-fill", searchTerms: [] },
        { title: "bi bi-file-post", searchTerms: [] },
        { title: "bi bi-file-ppt-fill", searchTerms: [] },
        { title: "bi bi-file-ppt", searchTerms: [] },
        { title: "bi bi-file-richtext-fill", searchTerms: [] },
        { title: "bi bi-file-richtext", searchTerms: [] },
        { title: "bi bi-file-ruled-fill", searchTerms: [] },
        { title: "bi bi-file-ruled", searchTerms: [] },
        { title: "bi bi-file-slides-fill", searchTerms: [] },
        { title: "bi bi-file-slides", searchTerms: [] },
        { title: "bi bi-file-spreadsheet-fill", searchTerms: [] },
        { title: "bi bi-file-spreadsheet", searchTerms: [] },
        { title: "bi bi-file-text-fill", searchTerms: [] },
        { title: "bi bi-file-text", searchTerms: [] },
        { title: "bi bi-file-word-fill", searchTerms: [] },
        { title: "bi bi-file-word", searchTerms: [] },
        { title: "bi bi-file-x-fill", searchTerms: [] },
        { title: "bi bi-file-x", searchTerms: [] },
        { title: "bi bi-file-zip-fill", searchTerms: [] },
        { title: "bi bi-file-zip", searchTerms: [] },
        { title: "bi bi-file", searchTerms: [] },
        { title: "bi bi-files-alt", searchTerms: [] },
        { title: "bi bi-files", searchTerms: [] },
        { title: "bi bi-film", searchTerms: [] },
        { title: "bi bi-filter-circle-fill", searchTerms: [] },
        { title: "bi bi-filter-circle", searchTerms: [] },
        { title: "bi bi-filter-left", searchTerms: [] },
        { title: "bi bi-filter-right", searchTerms: [] },
        { title: "bi bi-filter-square-fill", searchTerms: [] },
        { title: "bi bi-filter-square", searchTerms: [] },
        { title: "bi bi-filter", searchTerms: [] },
        { title: "bi bi-flag-fill", searchTerms: [] },
        { title: "bi bi-flag", searchTerms: [] },
        { title: "bi bi-flower1", searchTerms: [] },
        { title: "bi bi-flower2", searchTerms: [] },
        { title: "bi bi-flower3", searchTerms: [] },
        { title: "bi bi-folder-check", searchTerms: [] },
        { title: "bi bi-folder-fill", searchTerms: [] },
        { title: "bi bi-folder-minus", searchTerms: [] },
        { title: "bi bi-folder-plus", searchTerms: [] },
        { title: "bi bi-folder-symlink-fill", searchTerms: [] },
        { title: "bi bi-folder-symlink", searchTerms: [] },
        { title: "bi bi-folder-x", searchTerms: [] },
        { title: "bi bi-folder", searchTerms: [] },
        { title: "bi bi-folder2-open", searchTerms: [] },
        { title: "bi bi-folder2", searchTerms: [] },
        { title: "bi bi-fonts", searchTerms: [] },
        { title: "bi bi-forward-fill", searchTerms: [] },
        { title: "bi bi-forward", searchTerms: [] },
        { title: "bi bi-front", searchTerms: [] },
        { title: "bi bi-fullscreen-exit", searchTerms: [] },
        { title: "bi bi-fullscreen", searchTerms: [] },
        { title: "bi bi-funnel-fill", searchTerms: [] },
        { title: "bi bi-funnel", searchTerms: [] },
        { title: "bi bi-gear-fill", searchTerms: [] },
        { title: "bi bi-gear-wide-connected", searchTerms: [] },
        { title: "bi bi-gear-wide", searchTerms: [] },
        { title: "bi bi-gear", searchTerms: [] },
        { title: "bi bi-gem", searchTerms: [] },
        { title: "bi bi-geo-alt-fill", searchTerms: [] },
        { title: "bi bi-geo-alt", searchTerms: [] },
        { title: "bi bi-geo-fill", searchTerms: [] },
        { title: "bi bi-geo", searchTerms: [] },
        { title: "bi bi-gift-fill", searchTerms: [] },
        { title: "bi bi-gift", searchTerms: [] },
        { title: "bi bi-github", searchTerms: [] },
        { title: "bi bi-globe", searchTerms: [] },
        { title: "bi bi-globe2", searchTerms: [] },
        { title: "bi bi-google", searchTerms: [] },
        { title: "bi bi-graph-down", searchTerms: [] },
        { title: "bi bi-graph-up", searchTerms: [] },
        { title: "bi bi-grid-1x2-fill", searchTerms: [] },
        { title: "bi bi-grid-1x2", searchTerms: [] },
        { title: "bi bi-grid-3x2-gap-fill", searchTerms: [] },
        { title: "bi bi-grid-3x2-gap", searchTerms: [] },
        { title: "bi bi-grid-3x2", searchTerms: [] },
        { title: "bi bi-grid-3x3-gap-fill", searchTerms: [] },
        { title: "bi bi-grid-3x3-gap", searchTerms: [] },
        { title: "bi bi-grid-3x3", searchTerms: [] },
        { title: "bi bi-grid-fill", searchTerms: [] },
        { title: "bi bi-grid", searchTerms: [] },
        { title: "bi bi-grip-horizontal", searchTerms: [] },
        { title: "bi bi-grip-vertical", searchTerms: [] },
        { title: "bi bi-hammer", searchTerms: [] },
        { title: "bi bi-hand-index-fill", searchTerms: [] },
        { title: "bi bi-hand-index-thumb-fill", searchTerms: [] },
        { title: "bi bi-hand-index-thumb", searchTerms: [] },
        { title: "bi bi-hand-index", searchTerms: [] },
        { title: "bi bi-hand-thumbs-down-fill", searchTerms: [] },
        { title: "bi bi-hand-thumbs-down", searchTerms: [] },
        { title: "bi bi-hand-thumbs-up-fill", searchTerms: [] },
        { title: "bi bi-hand-thumbs-up", searchTerms: [] },
        { title: "bi bi-handbag-fill", searchTerms: [] },
        { title: "bi bi-handbag", searchTerms: [] },
        { title: "bi bi-hash", searchTerms: [] },
        { title: "bi bi-hdd-fill", searchTerms: [] },
        { title: "bi bi-hdd-network-fill", searchTerms: [] },
        { title: "bi bi-hdd-network", searchTerms: [] },
        { title: "bi bi-hdd-rack-fill", searchTerms: [] },
        { title: "bi bi-hdd-rack", searchTerms: [] },
        { title: "bi bi-hdd-stack-fill", searchTerms: [] },
        { title: "bi bi-hdd-stack", searchTerms: [] },
        { title: "bi bi-hdd", searchTerms: [] },
        { title: "bi bi-headphones", searchTerms: [] },
        { title: "bi bi-headset", searchTerms: [] },
        { title: "bi bi-heart-fill", searchTerms: [] },
        { title: "bi bi-heart-half", searchTerms: [] },
        { title: "bi bi-heart", searchTerms: [] },
        { title: "bi bi-heptagon-fill", searchTerms: [] },
        { title: "bi bi-heptagon-half", searchTerms: [] },
        { title: "bi bi-heptagon", searchTerms: [] },
        { title: "bi bi-hexagon-fill", searchTerms: [] },
        { title: "bi bi-hexagon-half", searchTerms: [] },
        { title: "bi bi-hexagon", searchTerms: [] },
        { title: "bi bi-hourglass-bottom", searchTerms: [] },
        { title: "bi bi-hourglass-split", searchTerms: [] },
        { title: "bi bi-hourglass-top", searchTerms: [] },
        { title: "bi bi-hourglass", searchTerms: [] },
        { title: "bi bi-house-door-fill", searchTerms: [] },
        { title: "bi bi-house-door", searchTerms: [] },
        { title: "bi bi-house-fill", searchTerms: [] },
        { title: "bi bi-house", searchTerms: [] },
        { title: "bi bi-hr", searchTerms: [] },
        { title: "bi bi-hurricane", searchTerms: [] },
        { title: "bi bi-image-alt", searchTerms: [] },
        { title: "bi bi-image-fill", searchTerms: [] },
        { title: "bi bi-image", searchTerms: [] },
        { title: "bi bi-images", searchTerms: [] },
        { title: "bi bi-inbox-fill", searchTerms: [] },
        { title: "bi bi-inbox", searchTerms: [] },
        { title: "bi bi-inboxes-fill", searchTerms: [] },
        { title: "bi bi-inboxes", searchTerms: [] },
        { title: "bi bi-info-circle-fill", searchTerms: [] },
        { title: "bi bi-info-circle", searchTerms: [] },
        { title: "bi bi-info-square-fill", searchTerms: [] },
        { title: "bi bi-info-square", searchTerms: [] },
        { title: "bi bi-info", searchTerms: [] },
        { title: "bi bi-input-cursor-text", searchTerms: [] },
        { title: "bi bi-input-cursor", searchTerms: [] },
        { title: "bi bi-instagram", searchTerms: [] },
        { title: "bi bi-intersect", searchTerms: [] },
        { title: "bi bi-journal-album", searchTerms: [] },
        { title: "bi bi-journal-arrow-down", searchTerms: [] },
        { title: "bi bi-journal-arrow-up", searchTerms: [] },
        { title: "bi bi-journal-bookmark-fill", searchTerms: [] },
        { title: "bi bi-journal-bookmark", searchTerms: [] },
        { title: "bi bi-journal-check", searchTerms: [] },
        { title: "bi bi-journal-code", searchTerms: [] },
        { title: "bi bi-journal-medical", searchTerms: [] },
        { title: "bi bi-journal-minus", searchTerms: [] },
        { title: "bi bi-journal-plus", searchTerms: [] },
        { title: "bi bi-journal-richtext", searchTerms: [] },
        { title: "bi bi-journal-text", searchTerms: [] },
        { title: "bi bi-journal-x", searchTerms: [] },
        { title: "bi bi-journal", searchTerms: [] },
        { title: "bi bi-journals", searchTerms: [] },
        { title: "bi bi-joystick", searchTerms: [] },
        { title: "bi bi-justify-left", searchTerms: [] },
        { title: "bi bi-justify-right", searchTerms: [] },
        { title: "bi bi-justify", searchTerms: [] },
        { title: "bi bi-kanban-fill", searchTerms: [] },
        { title: "bi bi-kanban", searchTerms: [] },
        { title: "bi bi-key-fill", searchTerms: [] },
        { title: "bi bi-key", searchTerms: [] },
        { title: "bi bi-keyboard-fill", searchTerms: [] },
        { title: "bi bi-keyboard", searchTerms: [] },
        { title: "bi bi-ladder", searchTerms: [] },
        { title: "bi bi-lamp-fill", searchTerms: [] },
        { title: "bi bi-lamp", searchTerms: [] },
        { title: "bi bi-laptop-fill", searchTerms: [] },
        { title: "bi bi-laptop", searchTerms: [] },
        { title: "bi bi-layer-backward", searchTerms: [] },
        { title: "bi bi-layer-forward", searchTerms: [] },
        { title: "bi bi-layers-fill", searchTerms: [] },
        { title: "bi bi-layers-half", searchTerms: [] },
        { title: "bi bi-layers", searchTerms: [] },
        { title: "bi bi-layout-sidebar-inset-reverse", searchTerms: [] },
        { title: "bi bi-layout-sidebar-inset", searchTerms: [] },
        { title: "bi bi-layout-sidebar-reverse", searchTerms: [] },
        { title: "bi bi-layout-sidebar", searchTerms: [] },
        { title: "bi bi-layout-split", searchTerms: [] },
        { title: "bi bi-layout-text-sidebar-reverse", searchTerms: [] },
        { title: "bi bi-layout-text-sidebar", searchTerms: [] },
        { title: "bi bi-layout-text-window-reverse", searchTerms: [] },
        { title: "bi bi-layout-text-window", searchTerms: [] },
        { title: "bi bi-layout-three-columns", searchTerms: [] },
        { title: "bi bi-layout-wtf", searchTerms: [] },
        { title: "bi bi-life-preserver", searchTerms: [] },
        { title: "bi bi-lightbulb-fill", searchTerms: [] },
        { title: "bi bi-lightbulb-off-fill", searchTerms: [] },
        { title: "bi bi-lightbulb-off", searchTerms: [] },
        { title: "bi bi-lightbulb", searchTerms: [] },
        { title: "bi bi-lightning-charge-fill", searchTerms: [] },
        { title: "bi bi-lightning-charge", searchTerms: [] },
        { title: "bi bi-lightning-fill", searchTerms: [] },
        { title: "bi bi-lightning", searchTerms: [] },
        { title: "bi bi-link-45deg", searchTerms: [] },
        { title: "bi bi-link", searchTerms: [] },
        { title: "bi bi-linkedin", searchTerms: [] },
        { title: "bi bi-list-check", searchTerms: [] },
        { title: "bi bi-list-nested", searchTerms: [] },
        { title: "bi bi-list-ol", searchTerms: [] },
        { title: "bi bi-list-stars", searchTerms: [] },
        { title: "bi bi-list-task", searchTerms: [] },
        { title: "bi bi-list-ul", searchTerms: [] },
        { title: "bi bi-list", searchTerms: [] },
        { title: "bi bi-lock-fill", searchTerms: [] },
        { title: "bi bi-lock", searchTerms: [] },
        { title: "bi bi-mailbox", searchTerms: [] },
        { title: "bi bi-mailbox2", searchTerms: [] },
        { title: "bi bi-map-fill", searchTerms: [] },
        { title: "bi bi-map", searchTerms: [] },
        { title: "bi bi-markdown-fill", searchTerms: [] },
        { title: "bi bi-markdown", searchTerms: [] },
        { title: "bi bi-mask", searchTerms: [] },
        { title: "bi bi-megaphone-fill", searchTerms: [] },
        { title: "bi bi-megaphone", searchTerms: [] },
        { title: "bi bi-menu-app-fill", searchTerms: [] },
        { title: "bi bi-menu-app", searchTerms: [] },
        { title: "bi bi-menu-button-fill", searchTerms: [] },
        { title: "bi bi-menu-button-wide-fill", searchTerms: [] },
        { title: "bi bi-menu-button-wide", searchTerms: [] },
        { title: "bi bi-menu-button", searchTerms: [] },
        { title: "bi bi-menu-down", searchTerms: [] },
        { title: "bi bi-menu-up", searchTerms: [] },
        { title: "bi bi-mic-fill", searchTerms: [] },
        { title: "bi bi-mic-mute-fill", searchTerms: [] },
        { title: "bi bi-mic-mute", searchTerms: [] },
        { title: "bi bi-mic", searchTerms: [] },
        { title: "bi bi-minecart-loaded", searchTerms: [] },
        { title: "bi bi-minecart", searchTerms: [] },
        { title: "bi bi-moisture", searchTerms: [] },
        { title: "bi bi-moon-fill", searchTerms: [] },
        { title: "bi bi-moon-stars-fill", searchTerms: [] },
        { title: "bi bi-moon-stars", searchTerms: [] },
        { title: "bi bi-moon", searchTerms: [] },
        { title: "bi bi-mouse-fill", searchTerms: [] },
        { title: "bi bi-mouse", searchTerms: [] },
        { title: "bi bi-mouse2-fill", searchTerms: [] },
        { title: "bi bi-mouse2", searchTerms: [] },
        { title: "bi bi-mouse3-fill", searchTerms: [] },
        { title: "bi bi-mouse3", searchTerms: [] },
        { title: "bi bi-music-note-beamed", searchTerms: [] },
        { title: "bi bi-music-note-list", searchTerms: [] },
        { title: "bi bi-music-note", searchTerms: [] },
        { title: "bi bi-music-player-fill", searchTerms: [] },
        { title: "bi bi-music-player", searchTerms: [] },
        { title: "bi bi-newspaper", searchTerms: [] },
        { title: "bi bi-node-minus-fill", searchTerms: [] },
        { title: "bi bi-node-minus", searchTerms: [] },
        { title: "bi bi-node-plus-fill", searchTerms: [] },
        { title: "bi bi-node-plus", searchTerms: [] },
        { title: "bi bi-nut-fill", searchTerms: [] },
        { title: "bi bi-nut", searchTerms: [] },
        { title: "bi bi-octagon-fill", searchTerms: [] },
        { title: "bi bi-octagon-half", searchTerms: [] },
        { title: "bi bi-octagon", searchTerms: [] },
        { title: "bi bi-option", searchTerms: [] },
        { title: "bi bi-outlet", searchTerms: [] },
        { title: "bi bi-paint-bucket", searchTerms: [] },
        { title: "bi bi-palette-fill", searchTerms: [] },
        { title: "bi bi-palette", searchTerms: [] },
        { title: "bi bi-palette2", searchTerms: [] },
        { title: "bi bi-paperclip", searchTerms: [] },
        { title: "bi bi-paragraph", searchTerms: [] },
        { title: "bi bi-patch-check-fill", searchTerms: [] },
        { title: "bi bi-patch-check", searchTerms: [] },
        { title: "bi bi-patch-exclamation-fill", searchTerms: [] },
        { title: "bi bi-patch-exclamation", searchTerms: [] },
        { title: "bi bi-patch-minus-fill", searchTerms: [] },
        { title: "bi bi-patch-minus", searchTerms: [] },
        { title: "bi bi-patch-plus-fill", searchTerms: [] },
        { title: "bi bi-patch-plus", searchTerms: [] },
        { title: "bi bi-patch-question-fill", searchTerms: [] },
        { title: "bi bi-patch-question", searchTerms: [] },
        { title: "bi bi-pause-btn-fill", searchTerms: [] },
        { title: "bi bi-pause-btn", searchTerms: [] },
        { title: "bi bi-pause-circle-fill", searchTerms: [] },
        { title: "bi bi-pause-circle", searchTerms: [] },
        { title: "bi bi-pause-fill", searchTerms: [] },
        { title: "bi bi-pause", searchTerms: [] },
        { title: "bi bi-peace-fill", searchTerms: [] },
        { title: "bi bi-peace", searchTerms: [] },
        { title: "bi bi-pen-fill", searchTerms: [] },
        { title: "bi bi-pen", searchTerms: [] },
        { title: "bi bi-pencil-fill", searchTerms: [] },
        { title: "bi bi-pencil-square", searchTerms: [] },
        { title: "bi bi-pencil", searchTerms: [] },
        { title: "bi bi-pentagon-fill", searchTerms: [] },
        { title: "bi bi-pentagon-half", searchTerms: [] },
        { title: "bi bi-pentagon", searchTerms: [] },
        { title: "bi bi-people-fill", searchTerms: [] },
        { title: "bi bi-people", searchTerms: [] },
        { title: "bi bi-percent", searchTerms: [] },
        { title: "bi bi-person-badge-fill", searchTerms: [] },
        { title: "bi bi-person-badge", searchTerms: [] },
        { title: "bi bi-person-bounding-box", searchTerms: [] },
        { title: "bi bi-person-check-fill", searchTerms: [] },
        { title: "bi bi-person-check", searchTerms: [] },
        { title: "bi bi-person-circle", searchTerms: [] },
        { title: "bi bi-person-dash-fill", searchTerms: [] },
        { title: "bi bi-person-dash", searchTerms: [] },
        { title: "bi bi-person-fill", searchTerms: [] },
        { title: "bi bi-person-lines-fill", searchTerms: [] },
        { title: "bi bi-person-plus-fill", searchTerms: [] },
        { title: "bi bi-person-plus", searchTerms: [] },
        { title: "bi bi-person-square", searchTerms: [] },
        { title: "bi bi-person-x-fill", searchTerms: [] },
        { title: "bi bi-person-x", searchTerms: [] },
        { title: "bi bi-person", searchTerms: [] },
        { title: "bi bi-phone-fill", searchTerms: [] },
        { title: "bi bi-phone-landscape-fill", searchTerms: [] },
        { title: "bi bi-phone-landscape", searchTerms: [] },
        { title: "bi bi-phone-vibrate-fill", searchTerms: [] },
        { title: "bi bi-phone-vibrate", searchTerms: [] },
        { title: "bi bi-phone", searchTerms: [] },
        { title: "bi bi-pie-chart-fill", searchTerms: [] },
        { title: "bi bi-pie-chart", searchTerms: [] },
        { title: "bi bi-pin-angle-fill", searchTerms: [] },
        { title: "bi bi-pin-angle", searchTerms: [] },
        { title: "bi bi-pin-fill", searchTerms: [] },
        { title: "bi bi-pin", searchTerms: [] },
        { title: "bi bi-pip-fill", searchTerms: [] },
        { title: "bi bi-pip", searchTerms: [] },
        { title: "bi bi-play-btn-fill", searchTerms: [] },
        { title: "bi bi-play-btn", searchTerms: [] },
        { title: "bi bi-play-circle-fill", searchTerms: [] },
        { title: "bi bi-play-circle", searchTerms: [] },
        { title: "bi bi-play-fill", searchTerms: [] },
        { title: "bi bi-play", searchTerms: [] },
        { title: "bi bi-plug-fill", searchTerms: [] },
        { title: "bi bi-plug", searchTerms: [] },
        { title: "bi bi-plus-circle-dotted", searchTerms: [] },
        { title: "bi bi-plus-circle-fill", searchTerms: [] },
        { title: "bi bi-plus-circle", searchTerms: [] },
        { title: "bi bi-plus-square-dotted", searchTerms: [] },
        { title: "bi bi-plus-square-fill", searchTerms: [] },
        { title: "bi bi-plus-square", searchTerms: [] },
        { title: "bi bi-plus", searchTerms: [] },
        { title: "bi bi-power", searchTerms: [] },
        { title: "bi bi-printer-fill", searchTerms: [] },
        { title: "bi bi-printer", searchTerms: [] },
        { title: "bi bi-puzzle-fill", searchTerms: [] },
        { title: "bi bi-puzzle", searchTerms: [] },
        { title: "bi bi-question-circle-fill", searchTerms: [] },
        { title: "bi bi-question-circle", searchTerms: [] },
        { title: "bi bi-question-diamond-fill", searchTerms: [] },
        { title: "bi bi-question-diamond", searchTerms: [] },
        { title: "bi bi-question-octagon-fill", searchTerms: [] },
        { title: "bi bi-question-octagon", searchTerms: [] },
        { title: "bi bi-question-square-fill", searchTerms: [] },
        { title: "bi bi-question-square", searchTerms: [] },
        { title: "bi bi-question", searchTerms: [] },
        { title: "bi bi-rainbow", searchTerms: [] },
        { title: "bi bi-receipt-cutoff", searchTerms: [] },
        { title: "bi bi-receipt", searchTerms: [] },
        { title: "bi bi-reception-0", searchTerms: [] },
        { title: "bi bi-reception-1", searchTerms: [] },
        { title: "bi bi-reception-2", searchTerms: [] },
        { title: "bi bi-reception-3", searchTerms: [] },
        { title: "bi bi-reception-4", searchTerms: [] },
        { title: "bi bi-record-btn-fill", searchTerms: [] },
        { title: "bi bi-record-btn", searchTerms: [] },
        { title: "bi bi-record-circle-fill", searchTerms: [] },
        { title: "bi bi-record-circle", searchTerms: [] },
        { title: "bi bi-record-fill", searchTerms: [] },
        { title: "bi bi-record", searchTerms: [] },
        { title: "bi bi-record2-fill", searchTerms: [] },
        { title: "bi bi-record2", searchTerms: [] },
        { title: "bi bi-reply-all-fill", searchTerms: [] },
        { title: "bi bi-reply-all", searchTerms: [] },
        { title: "bi bi-reply-fill", searchTerms: [] },
        { title: "bi bi-reply", searchTerms: [] },
        { title: "bi bi-rss-fill", searchTerms: [] },
        { title: "bi bi-rss", searchTerms: [] },
        { title: "bi bi-rulers", searchTerms: [] },
        { title: "bi bi-save-fill", searchTerms: [] },
        { title: "bi bi-save", searchTerms: [] },
        { title: "bi bi-save2-fill", searchTerms: [] },
        { title: "bi bi-save2", searchTerms: [] },
        { title: "bi bi-scissors", searchTerms: [] },
        { title: "bi bi-screwdriver", searchTerms: [] },
        { title: "bi bi-search", searchTerms: [] },
        { title: "bi bi-segmented-nav", searchTerms: [] },
        { title: "bi bi-server", searchTerms: [] },
        { title: "bi bi-share-fill", searchTerms: [] },
        { title: "bi bi-share", searchTerms: [] },
        { title: "bi bi-shield-check", searchTerms: [] },
        { title: "bi bi-shield-exclamation", searchTerms: [] },
        { title: "bi bi-shield-fill-check", searchTerms: [] },
        { title: "bi bi-shield-fill-exclamation", searchTerms: [] },
        { title: "bi bi-shield-fill-minus", searchTerms: [] },
        { title: "bi bi-shield-fill-plus", searchTerms: [] },
        { title: "bi bi-shield-fill-x", searchTerms: [] },
        { title: "bi bi-shield-fill", searchTerms: [] },
        { title: "bi bi-shield-lock-fill", searchTerms: [] },
        { title: "bi bi-shield-lock", searchTerms: [] },
        { title: "bi bi-shield-minus", searchTerms: [] },
        { title: "bi bi-shield-plus", searchTerms: [] },
        { title: "bi bi-shield-shaded", searchTerms: [] },
        { title: "bi bi-shield-slash-fill", searchTerms: [] },
        { title: "bi bi-shield-slash", searchTerms: [] },
        { title: "bi bi-shield-x", searchTerms: [] },
        { title: "bi bi-shield", searchTerms: [] },
        { title: "bi bi-shift-fill", searchTerms: [] },
        { title: "bi bi-shift", searchTerms: [] },
        { title: "bi bi-shop-window", searchTerms: [] },
        { title: "bi bi-shop", searchTerms: [] },
        { title: "bi bi-shuffle", searchTerms: [] },
        { title: "bi bi-signpost-2-fill", searchTerms: [] },
        { title: "bi bi-signpost-2", searchTerms: [] },
        { title: "bi bi-signpost-fill", searchTerms: [] },
        { title: "bi bi-signpost-split-fill", searchTerms: [] },
        { title: "bi bi-signpost-split", searchTerms: [] },
        { title: "bi bi-signpost", searchTerms: [] },
        { title: "bi bi-sim-fill", searchTerms: [] },
        { title: "bi bi-sim", searchTerms: [] },
        { title: "bi bi-skip-backward-btn-fill", searchTerms: [] },
        { title: "bi bi-skip-backward-btn", searchTerms: [] },
        { title: "bi bi-skip-backward-circle-fill", searchTerms: [] },
        { title: "bi bi-skip-backward-circle", searchTerms: [] },
        { title: "bi bi-skip-backward-fill", searchTerms: [] },
        { title: "bi bi-skip-backward", searchTerms: [] },
        { title: "bi bi-skip-end-btn-fill", searchTerms: [] },
        { title: "bi bi-skip-end-btn", searchTerms: [] },
        { title: "bi bi-skip-end-circle-fill", searchTerms: [] },
        { title: "bi bi-skip-end-circle", searchTerms: [] },
        { title: "bi bi-skip-end-fill", searchTerms: [] },
        { title: "bi bi-skip-end", searchTerms: [] },
        { title: "bi bi-skip-forward-btn-fill", searchTerms: [] },
        { title: "bi bi-skip-forward-btn", searchTerms: [] },
        { title: "bi bi-skip-forward-circle-fill", searchTerms: [] },
        { title: "bi bi-skip-forward-circle", searchTerms: [] },
        { title: "bi bi-skip-forward-fill", searchTerms: [] },
        { title: "bi bi-skip-forward", searchTerms: [] },
        { title: "bi bi-skip-start-btn-fill", searchTerms: [] },
        { title: "bi bi-skip-start-btn", searchTerms: [] },
        { title: "bi bi-skip-start-circle-fill", searchTerms: [] },
        { title: "bi bi-skip-start-circle", searchTerms: [] },
        { title: "bi bi-skip-start-fill", searchTerms: [] },
        { title: "bi bi-skip-start", searchTerms: [] },
        { title: "bi bi-slack", searchTerms: [] },
        { title: "bi bi-slash-circle-fill", searchTerms: [] },
        { title: "bi bi-slash-circle", searchTerms: [] },
        { title: "bi bi-slash-square-fill", searchTerms: [] },
        { title: "bi bi-slash-square", searchTerms: [] },
        { title: "bi bi-slash", searchTerms: [] },
        { title: "bi bi-sliders", searchTerms: [] },
        { title: "bi bi-smartwatch", searchTerms: [] },
        { title: "bi bi-snow", searchTerms: [] },
        { title: "bi bi-snow2", searchTerms: [] },
        { title: "bi bi-snow3", searchTerms: [] },
        { title: "bi bi-sort-alpha-down-alt", searchTerms: [] },
        { title: "bi bi-sort-alpha-down", searchTerms: [] },
        { title: "bi bi-sort-alpha-up-alt", searchTerms: [] },
        { title: "bi bi-sort-alpha-up", searchTerms: [] },
        { title: "bi bi-sort-down-alt", searchTerms: [] },
        { title: "bi bi-sort-down", searchTerms: [] },
        { title: "bi bi-sort-numeric-down-alt", searchTerms: [] },
        { title: "bi bi-sort-numeric-down", searchTerms: [] },
        { title: "bi bi-sort-numeric-up-alt", searchTerms: [] },
        { title: "bi bi-sort-numeric-up", searchTerms: [] },
        { title: "bi bi-sort-up-alt", searchTerms: [] },
        { title: "bi bi-sort-up", searchTerms: [] },
        { title: "bi bi-soundwave", searchTerms: [] },
        { title: "bi bi-speaker-fill", searchTerms: [] },
        { title: "bi bi-speaker", searchTerms: [] },
        { title: "bi bi-speedometer", searchTerms: [] },
        { title: "bi bi-speedometer2", searchTerms: [] },
        { title: "bi bi-spellcheck", searchTerms: [] },
        { title: "bi bi-square-fill", searchTerms: [] },
        { title: "bi bi-square-half", searchTerms: [] },
        { title: "bi bi-square", searchTerms: [] },
        { title: "bi bi-stack", searchTerms: [] },
        { title: "bi bi-star-fill", searchTerms: [] },
        { title: "bi bi-star-half", searchTerms: [] },
        { title: "bi bi-star", searchTerms: [] },
        { title: "bi bi-stars", searchTerms: [] },
        { title: "bi bi-stickies-fill", searchTerms: [] },
        { title: "bi bi-stickies", searchTerms: [] },
        { title: "bi bi-sticky-fill", searchTerms: [] },
        { title: "bi bi-sticky", searchTerms: [] },
        { title: "bi bi-stop-btn-fill", searchTerms: [] },
        { title: "bi bi-stop-btn", searchTerms: [] },
        { title: "bi bi-stop-circle-fill", searchTerms: [] },
        { title: "bi bi-stop-circle", searchTerms: [] },
        { title: "bi bi-stop-fill", searchTerms: [] },
        { title: "bi bi-stop", searchTerms: [] },
        { title: "bi bi-stoplights-fill", searchTerms: [] },
        { title: "bi bi-stoplights", searchTerms: [] },
        { title: "bi bi-stopwatch-fill", searchTerms: [] },
        { title: "bi bi-stopwatch", searchTerms: [] },
        { title: "bi bi-subtract", searchTerms: [] },
        { title: "bi bi-suit-club-fill", searchTerms: [] },
        { title: "bi bi-suit-club", searchTerms: [] },
        { title: "bi bi-suit-diamond-fill", searchTerms: [] },
        { title: "bi bi-suit-diamond", searchTerms: [] },
        { title: "bi bi-suit-heart-fill", searchTerms: [] },
        { title: "bi bi-suit-heart", searchTerms: [] },
        { title: "bi bi-suit-spade-fill", searchTerms: [] },
        { title: "bi bi-suit-spade", searchTerms: [] },
        { title: "bi bi-sun-fill", searchTerms: [] },
        { title: "bi bi-sun", searchTerms: [] },
        { title: "bi bi-sunglasses", searchTerms: [] },
        { title: "bi bi-sunrise-fill", searchTerms: [] },
        { title: "bi bi-sunrise", searchTerms: [] },
        { title: "bi bi-sunset-fill", searchTerms: [] },
        { title: "bi bi-sunset", searchTerms: [] },
        { title: "bi bi-symmetry-horizontal", searchTerms: [] },
        { title: "bi bi-symmetry-vertical", searchTerms: [] },
        { title: "bi bi-table", searchTerms: [] },
        { title: "bi bi-tablet-fill", searchTerms: [] },
        { title: "bi bi-tablet-landscape-fill", searchTerms: [] },
        { title: "bi bi-tablet-landscape", searchTerms: [] },
        { title: "bi bi-tablet", searchTerms: [] },
        { title: "bi bi-tag-fill", searchTerms: [] },
        { title: "bi bi-tag", searchTerms: [] },
        { title: "bi bi-tags-fill", searchTerms: [] },
        { title: "bi bi-tags", searchTerms: [] },
        { title: "bi bi-telegram", searchTerms: [] },
        { title: "bi bi-telephone-fill", searchTerms: [] },
        { title: "bi bi-telephone-forward-fill", searchTerms: [] },
        { title: "bi bi-telephone-forward", searchTerms: [] },
        { title: "bi bi-telephone-inbound-fill", searchTerms: [] },
        { title: "bi bi-telephone-inbound", searchTerms: [] },
        { title: "bi bi-telephone-minus-fill", searchTerms: [] },
        { title: "bi bi-telephone-minus", searchTerms: [] },
        { title: "bi bi-telephone-outbound-fill", searchTerms: [] },
        { title: "bi bi-telephone-outbound", searchTerms: [] },
        { title: "bi bi-telephone-plus-fill", searchTerms: [] },
        { title: "bi bi-telephone-plus", searchTerms: [] },
        { title: "bi bi-telephone-x-fill", searchTerms: [] },
        { title: "bi bi-telephone-x", searchTerms: [] },
        { title: "bi bi-telephone", searchTerms: [] },
        { title: "bi bi-terminal-fill", searchTerms: [] },
        { title: "bi bi-terminal", searchTerms: [] },
        { title: "bi bi-text-center", searchTerms: [] },
        { title: "bi bi-text-indent-left", searchTerms: [] },
        { title: "bi bi-text-indent-right", searchTerms: [] },
        { title: "bi bi-text-left", searchTerms: [] },
        { title: "bi bi-text-paragraph", searchTerms: [] },
        { title: "bi bi-text-right", searchTerms: [] },
        { title: "bi bi-textarea-resize", searchTerms: [] },
        { title: "bi bi-textarea-t", searchTerms: [] },
        { title: "bi bi-textarea", searchTerms: [] },
        { title: "bi bi-thermometer-half", searchTerms: [] },
        { title: "bi bi-thermometer-high", searchTerms: [] },
        { title: "bi bi-thermometer-low", searchTerms: [] },
        { title: "bi bi-thermometer-snow", searchTerms: [] },
        { title: "bi bi-thermometer-sun", searchTerms: [] },
        { title: "bi bi-thermometer", searchTerms: [] },
        { title: "bi bi-three-dots-vertical", searchTerms: [] },
        { title: "bi bi-three-dots", searchTerms: [] },
        { title: "bi bi-toggle-off", searchTerms: [] },
        { title: "bi bi-toggle-on", searchTerms: [] },
        { title: "bi bi-toggle2-off", searchTerms: [] },
        { title: "bi bi-toggle2-on", searchTerms: [] },
        { title: "bi bi-toggles", searchTerms: [] },
        { title: "bi bi-toggles2", searchTerms: [] },
        { title: "bi bi-tools", searchTerms: [] },
        { title: "bi bi-tornado", searchTerms: [] },
        { title: "bi bi-trash-fill", searchTerms: [] },
        { title: "bi bi-trash", searchTerms: [] },
        { title: "bi bi-trash2-fill", searchTerms: [] },
        { title: "bi bi-trash2", searchTerms: [] },
        { title: "bi bi-tree-fill", searchTerms: [] },
        { title: "bi bi-tree", searchTerms: [] },
        { title: "bi bi-triangle-fill", searchTerms: [] },
        { title: "bi bi-triangle-half", searchTerms: [] },
        { title: "bi bi-triangle", searchTerms: [] },
        { title: "bi bi-trophy-fill", searchTerms: [] },
        { title: "bi bi-trophy", searchTerms: [] },
        { title: "bi bi-tropical-storm", searchTerms: [] },
        { title: "bi bi-truck-flatbed", searchTerms: [] },
        { title: "bi bi-truck", searchTerms: [] },
        { title: "bi bi-tsunami", searchTerms: [] },
        { title: "bi bi-tv-fill", searchTerms: [] },
        { title: "bi bi-tv", searchTerms: [] },
        { title: "bi bi-twitch", searchTerms: [] },
        { title: "bi bi-twitter", searchTerms: [] },
        { title: "bi bi-type-bold", searchTerms: [] },
        { title: "bi bi-type-h1", searchTerms: [] },
        { title: "bi bi-type-h2", searchTerms: [] },
        { title: "bi bi-type-h3", searchTerms: [] },
        { title: "bi bi-type-italic", searchTerms: [] },
        { title: "bi bi-type-strikethrough", searchTerms: [] },
        { title: "bi bi-type-underline", searchTerms: [] },
        { title: "bi bi-type", searchTerms: [] },
        { title: "bi bi-ui-checks-grid", searchTerms: [] },
        { title: "bi bi-ui-checks", searchTerms: [] },
        { title: "bi bi-ui-radios-grid", searchTerms: [] },
        { title: "bi bi-ui-radios", searchTerms: [] },
        { title: "bi bi-umbrella-fill", searchTerms: [] },
        { title: "bi bi-umbrella", searchTerms: [] },
        { title: "bi bi-union", searchTerms: [] },
        { title: "bi bi-unlock-fill", searchTerms: [] },
        { title: "bi bi-unlock", searchTerms: [] },
        { title: "bi bi-upc-scan", searchTerms: [] },
        { title: "bi bi-upc", searchTerms: [] },
        { title: "bi bi-upload", searchTerms: [] },
        { title: "bi bi-vector-pen", searchTerms: [] },
        { title: "bi bi-view-list", searchTerms: [] },
        { title: "bi bi-view-stacked", searchTerms: [] },
        { title: "bi bi-vinyl-fill", searchTerms: [] },
        { title: "bi bi-vinyl", searchTerms: [] },
        { title: "bi bi-voicemail", searchTerms: [] },
        { title: "bi bi-volume-down-fill", searchTerms: [] },
        { title: "bi bi-volume-down", searchTerms: [] },
        { title: "bi bi-volume-mute-fill", searchTerms: [] },
        { title: "bi bi-volume-mute", searchTerms: [] },
        { title: "bi bi-volume-off-fill", searchTerms: [] },
        { title: "bi bi-volume-off", searchTerms: [] },
        { title: "bi bi-volume-up-fill", searchTerms: [] },
        { title: "bi bi-volume-up", searchTerms: [] },
        { title: "bi bi-vr", searchTerms: [] },
        { title: "bi bi-wallet-fill", searchTerms: [] },
        { title: "bi bi-wallet", searchTerms: [] },
        { title: "bi bi-wallet2", searchTerms: [] },
        { title: "bi bi-watch", searchTerms: [] },
        { title: "bi bi-water", searchTerms: [] },
        { title: "bi bi-whatsapp", searchTerms: [] },
        { title: "bi bi-wifi-1", searchTerms: [] },
        { title: "bi bi-wifi-2", searchTerms: [] },
        { title: "bi bi-wifi-off", searchTerms: [] },
        { title: "bi bi-wifi", searchTerms: [] },
        { title: "bi bi-wind", searchTerms: [] },
        { title: "bi bi-window-dock", searchTerms: [] },
        { title: "bi bi-window-sidebar", searchTerms: [] },
        { title: "bi bi-window", searchTerms: [] },
        { title: "bi bi-wrench", searchTerms: [] },
        { title: "bi bi-x-circle-fill", searchTerms: [] },
        { title: "bi bi-x-circle", searchTerms: [] },
        { title: "bi bi-x-diamond-fill", searchTerms: [] },
        { title: "bi bi-x-diamond", searchTerms: [] },
        { title: "bi bi-x-octagon-fill", searchTerms: [] },
        { title: "bi bi-x-octagon", searchTerms: [] },
        { title: "bi bi-x-square-fill", searchTerms: [] },
        { title: "bi bi-x-square", searchTerms: [] },
        { title: "bi bi-x", searchTerms: [] },
        { title: "bi bi-youtube", searchTerms: [] },
        { title: "bi bi-zoom-in", searchTerms: [] },
        { title: "bi bi-zoom-out", searchTerms: [] },
        { title: "bi bi-bank", searchTerms: [] },
        { title: "bi bi-bank2", searchTerms: [] },
        { title: "bi bi-bell-slash-fill", searchTerms: [] },
        { title: "bi bi-bell-slash", searchTerms: [] },
        { title: "bi bi-cash-coin", searchTerms: [] },
        { title: "bi bi-check-lg", searchTerms: [] },
        { title: "bi bi-coin", searchTerms: [] },
        { title: "bi bi-currency-bitcoin", searchTerms: [] },
        { title: "bi bi-currency-dollar", searchTerms: [] },
        { title: "bi bi-currency-euro", searchTerms: [] },
        { title: "bi bi-currency-exchange", searchTerms: [] },
        { title: "bi bi-currency-pound", searchTerms: [] },
        { title: "bi bi-currency-yen", searchTerms: [] },
        { title: "bi bi-dash-lg", searchTerms: [] },
        { title: "bi bi-exclamation-lg", searchTerms: [] },
        { title: "bi bi-file-earmark-pdf-fill", searchTerms: [] },
        { title: "bi bi-file-earmark-pdf", searchTerms: [] },
        { title: "bi bi-file-pdf-fill", searchTerms: [] },
        { title: "bi bi-file-pdf", searchTerms: [] },
        { title: "bi bi-gender-ambiguous", searchTerms: [] },
        { title: "bi bi-gender-female", searchTerms: [] },
        { title: "bi bi-gender-male", searchTerms: [] },
        { title: "bi bi-gender-trans", searchTerms: [] },
        { title: "bi bi-headset-vr", searchTerms: [] },
        { title: "bi bi-info-lg", searchTerms: [] },
        { title: "bi bi-mastodon", searchTerms: [] },
        { title: "bi bi-messenger", searchTerms: [] },
        { title: "bi bi-piggy-bank-fill", searchTerms: [] },
        { title: "bi bi-piggy-bank", searchTerms: [] },
        { title: "bi bi-pin-map-fill", searchTerms: [] },
        { title: "bi bi-pin-map", searchTerms: [] },
        { title: "bi bi-plus-lg", searchTerms: [] },
        { title: "bi bi-question-lg", searchTerms: [] },
        { title: "bi bi-recycle", searchTerms: [] },
        { title: "bi bi-reddit", searchTerms: [] },
        { title: "bi bi-safe-fill", searchTerms: [] },
        { title: "bi bi-safe2-fill", searchTerms: [] },
        { title: "bi bi-safe2", searchTerms: [] },
        { title: "bi bi-sd-card-fill", searchTerms: [] },
        { title: "bi bi-sd-card", searchTerms: [] },
        { title: "bi bi-skype", searchTerms: [] },
        { title: "bi bi-slash-lg", searchTerms: [] },
        { title: "bi bi-translate", searchTerms: [] },
        { title: "bi bi-x-lg", searchTerms: [] },
        { title: "bi bi-safe", searchTerms: [] },
        { title: "bi bi-apple", searchTerms: [] },
        { title: "bi bi-microsoft", searchTerms: [] },
        { title: "bi bi-windows", searchTerms: [] },
        { title: "bi bi-behance", searchTerms: [] },
        { title: "bi bi-dribbble", searchTerms: [] },
        { title: "bi bi-line", searchTerms: [] },
        { title: "bi bi-medium", searchTerms: [] },
        { title: "bi bi-paypal", searchTerms: [] },
        { title: "bi bi-pinterest", searchTerms: [] },
        { title: "bi bi-signal", searchTerms: [] },
        { title: "bi bi-snapchat", searchTerms: [] },
        { title: "bi bi-spotify", searchTerms: [] },
        { title: "bi bi-stack-overflow", searchTerms: [] },
        { title: "bi bi-strava", searchTerms: [] },
        { title: "bi bi-wordpress", searchTerms: [] },
        { title: "bi bi-vimeo", searchTerms: [] },
        { title: "bi bi-activity", searchTerms: [] },
        { title: "bi bi-easel2-fill", searchTerms: [] },
        { title: "bi bi-easel2", searchTerms: [] },
        { title: "bi bi-easel3-fill", searchTerms: [] },
        { title: "bi bi-easel3", searchTerms: [] },
        { title: "bi bi-fan", searchTerms: [] },
        { title: "bi bi-fingerprint", searchTerms: [] },
        { title: "bi bi-graph-down-arrow", searchTerms: [] },
        { title: "bi bi-graph-up-arrow", searchTerms: [] },
        { title: "bi bi-hypnotize", searchTerms: [] },
        { title: "bi bi-magic", searchTerms: [] },
        { title: "bi bi-person-rolodex", searchTerms: [] },
        { title: "bi bi-person-video", searchTerms: [] },
        { title: "bi bi-person-video2", searchTerms: [] },
        { title: "bi bi-person-video3", searchTerms: [] },
        { title: "bi bi-person-workspace", searchTerms: [] },
        { title: "bi bi-radioactive", searchTerms: [] },
        { title: "bi bi-webcam-fill", searchTerms: [] },
        { title: "bi bi-webcam", searchTerms: [] },
        { title: "bi bi-yin-yang", searchTerms: [] },
        { title: "bi bi-bandaid-fill", searchTerms: [] },
        { title: "bi bi-bandaid", searchTerms: [] },
        { title: "bi bi-bluetooth", searchTerms: [] },
        { title: "bi bi-body-text", searchTerms: [] },
        { title: "bi bi-boombox", searchTerms: [] },
        { title: "bi bi-boxes", searchTerms: [] },
        { title: "bi bi-dpad-fill", searchTerms: [] },
        { title: "bi bi-dpad", searchTerms: [] },
        { title: "bi bi-ear-fill", searchTerms: [] },
        { title: "bi bi-ear", searchTerms: [] },
        { title: "bi bi-envelope-check-fill", searchTerms: [] },
        { title: "bi bi-envelope-check", searchTerms: [] },
        { title: "bi bi-envelope-dash-fill", searchTerms: [] },
        { title: "bi bi-envelope-dash", searchTerms: [] },
        { title: "bi bi-envelope-exclamation-fill", searchTerms: [] },
        { title: "bi bi-envelope-exclamation", searchTerms: [] },
        { title: "bi bi-envelope-plus-fill", searchTerms: [] },
        { title: "bi bi-envelope-plus", searchTerms: [] },
        { title: "bi bi-envelope-slash-fill", searchTerms: [] },
        { title: "bi bi-envelope-slash", searchTerms: [] },
        { title: "bi bi-envelope-x-fill", searchTerms: [] },
        { title: "bi bi-envelope-x", searchTerms: [] },
        { title: "bi bi-explicit-fill", searchTerms: [] },
        { title: "bi bi-explicit", searchTerms: [] },
        { title: "bi bi-git", searchTerms: [] },
        { title: "bi bi-infinity", searchTerms: [] },
        { title: "bi bi-list-columns-reverse", searchTerms: [] },
        { title: "bi bi-list-columns", searchTerms: [] },
        { title: "bi bi-meta", searchTerms: [] },
        { title: "bi bi-nintendo-switch", searchTerms: [] },
        { title: "bi bi-pc-display-horizontal", searchTerms: [] },
        { title: "bi bi-pc-display", searchTerms: [] },
        { title: "bi bi-pc-horizontal", searchTerms: [] },
        { title: "bi bi-pc", searchTerms: [] },
        { title: "bi bi-playstation", searchTerms: [] },
        { title: "bi bi-plus-slash-minus", searchTerms: [] },
        { title: "bi bi-projector-fill", searchTerms: [] },
        { title: "bi bi-projector", searchTerms: [] },
        { title: "bi bi-qr-code-scan", searchTerms: [] },
        { title: "bi bi-qr-code", searchTerms: [] },
        { title: "bi bi-quora", searchTerms: [] },
        { title: "bi bi-quote", searchTerms: [] },
        { title: "bi bi-robot", searchTerms: [] },
        { title: "bi bi-send-check-fill", searchTerms: [] },
        { title: "bi bi-send-check", searchTerms: [] },
        { title: "bi bi-send-dash-fill", searchTerms: [] },
        { title: "bi bi-send-dash", searchTerms: [] },
        { title: "bi bi-send-exclamation-fill", searchTerms: [] },
        { title: "bi bi-send-exclamation", searchTerms: [] },
        { title: "bi bi-send-fill", searchTerms: [] },
        { title: "bi bi-send-plus-fill", searchTerms: [] },
        { title: "bi bi-send-plus", searchTerms: [] },
        { title: "bi bi-send-slash-fill", searchTerms: [] },
        { title: "bi bi-send-slash", searchTerms: [] },
        { title: "bi bi-send-x-fill", searchTerms: [] },
        { title: "bi bi-send-x", searchTerms: [] },
        { title: "bi bi-send", searchTerms: [] },
        { title: "bi bi-steam", searchTerms: [] },
        { title: "bi bi-terminal-dash", searchTerms: [] },
        { title: "bi bi-terminal-plus", searchTerms: [] },
        { title: "bi bi-terminal-split", searchTerms: [] },
        { title: "bi bi-ticket-detailed-fill", searchTerms: [] },
        { title: "bi bi-ticket-detailed", searchTerms: [] },
        { title: "bi bi-ticket-fill", searchTerms: [] },
        { title: "bi bi-ticket-perforated-fill", searchTerms: [] },
        { title: "bi bi-ticket-perforated", searchTerms: [] },
        { title: "bi bi-ticket", searchTerms: [] },
        { title: "bi bi-tiktok", searchTerms: [] },
        { title: "bi bi-window-dash", searchTerms: [] },
        { title: "bi bi-window-desktop", searchTerms: [] },
        { title: "bi bi-window-fullscreen", searchTerms: [] },
        { title: "bi bi-window-plus", searchTerms: [] },
        { title: "bi bi-window-split", searchTerms: [] },
        { title: "bi bi-window-stack", searchTerms: [] },
        { title: "bi bi-window-x", searchTerms: [] },
        { title: "bi bi-xbox", searchTerms: [] },
        { title: "bi bi-ethernet", searchTerms: [] },
        { title: "bi bi-hdmi-fill", searchTerms: [] },
        { title: "bi bi-hdmi", searchTerms: [] },
        { title: "bi bi-usb-c-fill", searchTerms: [] },
        { title: "bi bi-usb-c", searchTerms: [] },
        { title: "bi bi-usb-fill", searchTerms: [] },
        { title: "bi bi-usb-plug-fill", searchTerms: [] },
        { title: "bi bi-usb-plug", searchTerms: [] },
        { title: "bi bi-usb-symbol", searchTerms: [] },
        { title: "bi bi-usb", searchTerms: [] },
        { title: "bi bi-boombox-fill", searchTerms: [] },
        { title: "bi bi-displayport", searchTerms: [] },
        { title: "bi bi-gpu-card", searchTerms: [] },
        { title: "bi bi-memory", searchTerms: [] },
        { title: "bi bi-modem-fill", searchTerms: [] },
        { title: "bi bi-modem", searchTerms: [] },
        { title: "bi bi-motherboard-fill", searchTerms: [] },
        { title: "bi bi-motherboard", searchTerms: [] },
        { title: "bi bi-optical-audio-fill", searchTerms: [] },
        { title: "bi bi-optical-audio", searchTerms: [] },
        { title: "bi bi-pci-card", searchTerms: [] },
        { title: "bi bi-router-fill", searchTerms: [] },
        { title: "bi bi-router", searchTerms: [] },
        { title: "bi bi-thunderbolt-fill", searchTerms: [] },
        { title: "bi bi-thunderbolt", searchTerms: [] },
        { title: "bi bi-usb-drive-fill", searchTerms: [] },
        { title: "bi bi-usb-drive", searchTerms: [] },
        { title: "bi bi-usb-micro-fill", searchTerms: [] },
        { title: "bi bi-usb-micro", searchTerms: [] },
        { title: "bi bi-usb-mini-fill", searchTerms: [] },
        { title: "bi bi-usb-mini", searchTerms: [] },
        { title: "bi bi-cloud-haze2", searchTerms: [] },
        { title: "bi bi-device-hdd-fill", searchTerms: [] },
        { title: "bi bi-device-hdd", searchTerms: [] },
        { title: "bi bi-device-ssd-fill", searchTerms: [] },
        { title: "bi bi-device-ssd", searchTerms: [] },
        { title: "bi bi-displayport-fill", searchTerms: [] },
        { title: "bi bi-mortarboard-fill", searchTerms: [] },
        { title: "bi bi-mortarboard", searchTerms: [] },
        { title: "bi bi-terminal-x", searchTerms: [] },
        { title: "bi bi-arrow-through-heart-fill", searchTerms: [] },
        { title: "bi bi-arrow-through-heart", searchTerms: [] },
        { title: "bi bi-badge-sd-fill", searchTerms: [] },
        { title: "bi bi-badge-sd", searchTerms: [] },
        { title: "bi bi-bag-heart-fill", searchTerms: [] },
        { title: "bi bi-bag-heart", searchTerms: [] },
        { title: "bi bi-balloon-fill", searchTerms: [] },
        { title: "bi bi-balloon-heart-fill", searchTerms: [] },
        { title: "bi bi-balloon-heart", searchTerms: [] },
        { title: "bi bi-balloon", searchTerms: [] },
        { title: "bi bi-box2-fill", searchTerms: [] },
        { title: "bi bi-box2-heart-fill", searchTerms: [] },
        { title: "bi bi-box2-heart", searchTerms: [] },
        { title: "bi bi-box2", searchTerms: [] },
        { title: "bi bi-braces-asterisk", searchTerms: [] },
        { title: "bi bi-calendar-heart-fill", searchTerms: [] },
        { title: "bi bi-calendar-heart", searchTerms: [] },
        { title: "bi bi-calendar2-heart-fill", searchTerms: [] },
        { title: "bi bi-calendar2-heart", searchTerms: [] },
        { title: "bi bi-chat-heart-fill", searchTerms: [] },
        { title: "bi bi-chat-heart", searchTerms: [] },
        { title: "bi bi-chat-left-heart-fill", searchTerms: [] },
        { title: "bi bi-chat-left-heart", searchTerms: [] },
        { title: "bi bi-chat-right-heart-fill", searchTerms: [] },
        { title: "bi bi-chat-right-heart", searchTerms: [] },
        { title: "bi bi-chat-square-heart-fill", searchTerms: [] },
        { title: "bi bi-chat-square-heart", searchTerms: [] },
        { title: "bi bi-clipboard-check-fill", searchTerms: [] },
        { title: "bi bi-clipboard-data-fill", searchTerms: [] },
        { title: "bi bi-clipboard-fill", searchTerms: [] },
        { title: "bi bi-clipboard-heart-fill", searchTerms: [] },
        { title: "bi bi-clipboard-heart", searchTerms: [] },
        { title: "bi bi-clipboard-minus-fill", searchTerms: [] },
        { title: "bi bi-clipboard-plus-fill", searchTerms: [] },
        { title: "bi bi-clipboard-pulse", searchTerms: [] },
        { title: "bi bi-clipboard-x-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-check-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-check", searchTerms: [] },
        { title: "bi bi-clipboard2-data-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-data", searchTerms: [] },
        { title: "bi bi-clipboard2-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-heart-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-heart", searchTerms: [] },
        { title: "bi bi-clipboard2-minus-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-minus", searchTerms: [] },
        { title: "bi bi-clipboard2-plus-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-plus", searchTerms: [] },
        { title: "bi bi-clipboard2-pulse-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-pulse", searchTerms: [] },
        { title: "bi bi-clipboard2-x-fill", searchTerms: [] },
        { title: "bi bi-clipboard2-x", searchTerms: [] },
        { title: "bi bi-clipboard2", searchTerms: [] },
        { title: "bi bi-emoji-kiss-fill", searchTerms: [] },
        { title: "bi bi-emoji-kiss", searchTerms: [] },
        { title: "bi bi-envelope-heart-fill", searchTerms: [] },
        { title: "bi bi-envelope-heart", searchTerms: [] },
        { title: "bi bi-envelope-open-heart-fill", searchTerms: [] },
        { title: "bi bi-envelope-open-heart", searchTerms: [] },
        { title: "bi bi-envelope-paper-fill", searchTerms: [] },
        { title: "bi bi-envelope-paper-heart-fill", searchTerms: [] },
        { title: "bi bi-envelope-paper-heart", searchTerms: [] },
        { title: "bi bi-envelope-paper", searchTerms: [] },
        { title: "bi bi-filetype-aac", searchTerms: [] },
        { title: "bi bi-filetype-ai", searchTerms: [] },
        { title: "bi bi-filetype-bmp", searchTerms: [] },
        { title: "bi bi-filetype-cs", searchTerms: [] },
        { title: "bi bi-filetype-css", searchTerms: [] },
        { title: "bi bi-filetype-csv", searchTerms: [] },
        { title: "bi bi-filetype-doc", searchTerms: [] },
        { title: "bi bi-filetype-docx", searchTerms: [] },
        { title: "bi bi-filetype-exe", searchTerms: [] },
        { title: "bi bi-filetype-gif", searchTerms: [] },
        { title: "bi bi-filetype-heic", searchTerms: [] },
        { title: "bi bi-filetype-html", searchTerms: [] },
        { title: "bi bi-filetype-java", searchTerms: [] },
        { title: "bi bi-filetype-jpg", searchTerms: [] },
        { title: "bi bi-filetype-js", searchTerms: [] },
        { title: "bi bi-filetype-jsx", searchTerms: [] },
        { title: "bi bi-filetype-key", searchTerms: [] },
        { title: "bi bi-filetype-m4p", searchTerms: [] },
        { title: "bi bi-filetype-md", searchTerms: [] },
        { title: "bi bi-filetype-mdx", searchTerms: [] },
        { title: "bi bi-filetype-mov", searchTerms: [] },
        { title: "bi bi-filetype-mp3", searchTerms: [] },
        { title: "bi bi-filetype-mp4", searchTerms: [] },
        { title: "bi bi-filetype-otf", searchTerms: [] },
        { title: "bi bi-filetype-pdf", searchTerms: [] },
        { title: "bi bi-filetype-php", searchTerms: [] },
        { title: "bi bi-filetype-png", searchTerms: [] },
        { title: "bi bi-filetype-ppt", searchTerms: [] },
        { title: "bi bi-filetype-psd", searchTerms: [] },
        { title: "bi bi-filetype-py", searchTerms: [] },
        { title: "bi bi-filetype-raw", searchTerms: [] },
        { title: "bi bi-filetype-rb", searchTerms: [] },
        { title: "bi bi-filetype-sass", searchTerms: [] },
        { title: "bi bi-filetype-scss", searchTerms: [] },
        { title: "bi bi-filetype-sh", searchTerms: [] },
        { title: "bi bi-filetype-svg", searchTerms: [] },
        { title: "bi bi-filetype-tiff", searchTerms: [] },
        { title: "bi bi-filetype-tsx", searchTerms: [] },
        { title: "bi bi-filetype-ttf", searchTerms: [] },
        { title: "bi bi-filetype-txt", searchTerms: [] },
        { title: "bi bi-filetype-wav", searchTerms: [] },
        { title: "bi bi-filetype-woff", searchTerms: [] },
        { title: "bi bi-filetype-xls", searchTerms: [] },
        { title: "bi bi-filetype-xml", searchTerms: [] },
        { title: "bi bi-filetype-yml", searchTerms: [] },
        { title: "bi bi-heart-arrow", searchTerms: [] },
        { title: "bi bi-heart-pulse-fill", searchTerms: [] },
        { title: "bi bi-heart-pulse", searchTerms: [] },
        { title: "bi bi-heartbreak-fill", searchTerms: [] },
        { title: "bi bi-heartbreak", searchTerms: [] },
        { title: "bi bi-hearts", searchTerms: [] },
        { title: "bi bi-hospital-fill", searchTerms: [] },
        { title: "bi bi-hospital", searchTerms: [] },
        { title: "bi bi-house-heart-fill", searchTerms: [] },
        { title: "bi bi-house-heart", searchTerms: [] },
        { title: "bi bi-incognito", searchTerms: [] },
        { title: "bi bi-magnet-fill", searchTerms: [] },
        { title: "bi bi-magnet", searchTerms: [] },
        { title: "bi bi-person-heart", searchTerms: [] },
        { title: "bi bi-person-hearts", searchTerms: [] },
        { title: "bi bi-phone-flip", searchTerms: [] },
        { title: "bi bi-plugin", searchTerms: [] },
        { title: "bi bi-postage-fill", searchTerms: [] },
        { title: "bi bi-postage-heart-fill", searchTerms: [] },
        { title: "bi bi-postage-heart", searchTerms: [] },
        { title: "bi bi-postage", searchTerms: [] },
        { title: "bi bi-postcard-fill", searchTerms: [] },
        { title: "bi bi-postcard-heart-fill", searchTerms: [] },
        { title: "bi bi-postcard-heart", searchTerms: [] },
        { title: "bi bi-postcard", searchTerms: [] },
        { title: "bi bi-search-heart-fill", searchTerms: [] },
        { title: "bi bi-search-heart", searchTerms: [] },
        { title: "bi bi-sliders2-vertical", searchTerms: [] },
        { title: "bi bi-sliders2", searchTerms: [] },
        { title: "bi bi-trash3-fill", searchTerms: [] },
        { title: "bi bi-trash3", searchTerms: [] },
        { title: "bi bi-valentine", searchTerms: [] },
        { title: "bi bi-valentine2", searchTerms: [] },
        { title: "bi bi-wrench-adjustable-circle-fill", searchTerms: [] },
        { title: "bi bi-wrench-adjustable-circle", searchTerms: [] },
        { title: "bi bi-wrench-adjustable", searchTerms: [] },
        { title: "bi bi-filetype-json", searchTerms: [] },
        { title: "bi bi-filetype-pptx", searchTerms: [] },
        { title: "bi bi-filetype-xlsx", searchTerms: [] },
        { title: "bi bi-1-circle-fill", searchTerms: [] },
        { title: "bi bi-1-circle", searchTerms: [] },
        { title: "bi bi-1-square-fill", searchTerms: [] },
        { title: "bi bi-1-square", searchTerms: [] },
        { title: "bi bi-2-circle-fill", searchTerms: [] },
        { title: "bi bi-2-circle", searchTerms: [] },
        { title: "bi bi-2-square-fill", searchTerms: [] },
        { title: "bi bi-2-square", searchTerms: [] },
        { title: "bi bi-3-circle-fill", searchTerms: [] },
        { title: "bi bi-3-circle", searchTerms: [] },
        { title: "bi bi-3-square-fill", searchTerms: [] },
        { title: "bi bi-3-square", searchTerms: [] },
        { title: "bi bi-4-circle-fill", searchTerms: [] },
        { title: "bi bi-4-circle", searchTerms: [] },
        { title: "bi bi-4-square-fill", searchTerms: [] },
        { title: "bi bi-4-square", searchTerms: [] },
        { title: "bi bi-5-circle-fill", searchTerms: [] },
        { title: "bi bi-5-circle", searchTerms: [] },
        { title: "bi bi-5-square-fill", searchTerms: [] },
        { title: "bi bi-5-square", searchTerms: [] },
        { title: "bi bi-6-circle-fill", searchTerms: [] },
        { title: "bi bi-6-circle", searchTerms: [] },
        { title: "bi bi-6-square-fill", searchTerms: [] },
        { title: "bi bi-6-square", searchTerms: [] },
        { title: "bi bi-7-circle-fill", searchTerms: [] },
        { title: "bi bi-7-circle", searchTerms: [] },
        { title: "bi bi-7-square-fill", searchTerms: [] },
        { title: "bi bi-7-square", searchTerms: [] },
        { title: "bi bi-8-circle-fill", searchTerms: [] },
        { title: "bi bi-8-circle", searchTerms: [] },
        { title: "bi bi-8-square-fill", searchTerms: [] },
        { title: "bi bi-8-square", searchTerms: [] },
        { title: "bi bi-9-circle-fill", searchTerms: [] },
        { title: "bi bi-9-circle", searchTerms: [] },
        { title: "bi bi-9-square-fill", searchTerms: [] },
        { title: "bi bi-9-square", searchTerms: [] },
        { title: "bi bi-airplane-engines-fill", searchTerms: [] },
        { title: "bi bi-airplane-engines", searchTerms: [] },
        { title: "bi bi-airplane-fill", searchTerms: [] },
        { title: "bi bi-airplane", searchTerms: [] },
        { title: "bi bi-alexa", searchTerms: [] },
        { title: "bi bi-alipay", searchTerms: [] },
        { title: "bi bi-android", searchTerms: [] },
        { title: "bi bi-android2", searchTerms: [] },
        { title: "bi bi-box-fill", searchTerms: [] },
        { title: "bi bi-box-seam-fill", searchTerms: [] },
        { title: "bi bi-browser-chrome", searchTerms: [] },
        { title: "bi bi-browser-edge", searchTerms: [] },
        { title: "bi bi-browser-firefox", searchTerms: [] },
        { title: "bi bi-browser-safari", searchTerms: [] },
        { title: "bi bi-c-circle-fill", searchTerms: [] },
        { title: "bi bi-c-circle", searchTerms: [] },
        { title: "bi bi-c-square-fill", searchTerms: [] },
        { title: "bi bi-c-square", searchTerms: [] },
        { title: "bi bi-capsule-pill", searchTerms: [] },
        { title: "bi bi-capsule", searchTerms: [] },
        { title: "bi bi-car-front-fill", searchTerms: [] },
        { title: "bi bi-car-front", searchTerms: [] },
        { title: "bi bi-cassette-fill", searchTerms: [] },
        { title: "bi bi-cassette", searchTerms: [] },
        { title: "bi bi-cc-circle-fill", searchTerms: [] },
        { title: "bi bi-cc-circle", searchTerms: [] },
        { title: "bi bi-cc-square-fill", searchTerms: [] },
        { title: "bi bi-cc-square", searchTerms: [] },
        { title: "bi bi-cup-hot-fill", searchTerms: [] },
        { title: "bi bi-cup-hot", searchTerms: [] },
        { title: "bi bi-currency-rupee", searchTerms: [] },
        { title: "bi bi-dropbox", searchTerms: [] },
        { title: "bi bi-escape", searchTerms: [] },
        { title: "bi bi-fast-forward-btn-fill", searchTerms: [] },
        { title: "bi bi-fast-forward-btn", searchTerms: [] },
        { title: "bi bi-fast-forward-circle-fill", searchTerms: [] },
        { title: "bi bi-fast-forward-circle", searchTerms: [] },
        { title: "bi bi-fast-forward-fill", searchTerms: [] },
        { title: "bi bi-fast-forward", searchTerms: [] },
        { title: "bi bi-filetype-sql", searchTerms: [] },
        { title: "bi bi-fire", searchTerms: [] },
        { title: "bi bi-google-play", searchTerms: [] },
        { title: "bi bi-h-circle-fill", searchTerms: [] },
        { title: "bi bi-h-circle", searchTerms: [] },
        { title: "bi bi-h-square-fill", searchTerms: [] },
        { title: "bi bi-h-square", searchTerms: [] },
        { title: "bi bi-indent", searchTerms: [] },
        { title: "bi bi-lungs-fill", searchTerms: [] },
        { title: "bi bi-lungs", searchTerms: [] },
        { title: "bi bi-microsoft-teams", searchTerms: [] },
        { title: "bi bi-p-circle-fill", searchTerms: [] },
        { title: "bi bi-p-circle", searchTerms: [] },
        { title: "bi bi-p-square-fill", searchTerms: [] },
        { title: "bi bi-p-square", searchTerms: [] },
        { title: "bi bi-pass-fill", searchTerms: [] },
        { title: "bi bi-pass", searchTerms: [] },
        { title: "bi bi-prescription", searchTerms: [] },
        { title: "bi bi-prescription2", searchTerms: [] },
        { title: "bi bi-r-circle-fill", searchTerms: [] },
        { title: "bi bi-r-circle", searchTerms: [] },
        { title: "bi bi-r-square-fill", searchTerms: [] },
        { title: "bi bi-r-square", searchTerms: [] },
        { title: "bi bi-repeat-1", searchTerms: [] },
        { title: "bi bi-repeat", searchTerms: [] },
        { title: "bi bi-rewind-btn-fill", searchTerms: [] },
        { title: "bi bi-rewind-btn", searchTerms: [] },
        { title: "bi bi-rewind-circle-fill", searchTerms: [] },
        { title: "bi bi-rewind-circle", searchTerms: [] },
        { title: "bi bi-rewind-fill", searchTerms: [] },
        { title: "bi bi-rewind", searchTerms: [] },
        { title: "bi bi-train-freight-front-fill", searchTerms: [] },
        { title: "bi bi-train-freight-front", searchTerms: [] },
        { title: "bi bi-train-front-fill", searchTerms: [] },
        { title: "bi bi-train-front", searchTerms: [] },
        { title: "bi bi-train-lightrail-front-fill", searchTerms: [] },
        { title: "bi bi-train-lightrail-front", searchTerms: [] },
        { title: "bi bi-truck-front-fill", searchTerms: [] },
        { title: "bi bi-truck-front", searchTerms: [] },
        { title: "bi bi-ubuntu", searchTerms: [] },
        { title: "bi bi-unindent", searchTerms: [] },
        { title: "bi bi-unity", searchTerms: [] },
        { title: "bi bi-universal-access-circle", searchTerms: [] },
        { title: "bi bi-universal-access", searchTerms: [] },
        { title: "bi bi-virus", searchTerms: [] },
        { title: "bi bi-virus2", searchTerms: [] },
        { title: "bi bi-wechat", searchTerms: [] },
        { title: "bi bi-yelp", searchTerms: [] },
        { title: "bi bi-sign-stop-fill", searchTerms: [] },
        { title: "bi bi-sign-stop-lights-fill", searchTerms: [] },
        { title: "bi bi-sign-stop-lights", searchTerms: [] },
        { title: "bi bi-sign-stop", searchTerms: [] },
        { title: "bi bi-sign-turn-left-fill", searchTerms: [] },
        { title: "bi bi-sign-turn-left", searchTerms: [] },
        { title: "bi bi-sign-turn-right-fill", searchTerms: [] },
        { title: "bi bi-sign-turn-right", searchTerms: [] },
        { title: "bi bi-sign-turn-slight-left-fill", searchTerms: [] },
        { title: "bi bi-sign-turn-slight-left", searchTerms: [] },
        { title: "bi bi-sign-turn-slight-right-fill", searchTerms: [] },
        { title: "bi bi-sign-turn-slight-right", searchTerms: [] },
        { title: "bi bi-sign-yield-fill", searchTerms: [] },
        { title: "bi bi-sign-yield", searchTerms: [] },
        { title: "bi bi-ev-station-fill", searchTerms: [] },
        { title: "bi bi-ev-station", searchTerms: [] },
        { title: "bi bi-fuel-pump-diesel-fill", searchTerms: [] },
        { title: "bi bi-fuel-pump-diesel", searchTerms: [] },
        { title: "bi bi-fuel-pump-fill", searchTerms: [] },
        { title: "bi bi-fuel-pump", searchTerms: [] },
        { title: "bi bi-0-circle-fill", searchTerms: [] },
        { title: "bi bi-0-circle", searchTerms: [] },
        { title: "bi bi-0-square-fill", searchTerms: [] },
        { title: "bi bi-0-square", searchTerms: [] },
        { title: "bi bi-rocket-fill", searchTerms: [] },
        { title: "bi bi-rocket-takeoff-fill", searchTerms: [] },
        { title: "bi bi-rocket-takeoff", searchTerms: [] },
        { title: "bi bi-rocket", searchTerms: [] },
        { title: "bi bi-stripe", searchTerms: [] },
        { title: "bi bi-subscript", searchTerms: [] },
        { title: "bi bi-superscript", searchTerms: [] },
        { title: "bi bi-trello", searchTerms: [] },
        { title: "bi bi-envelope-at-fill", searchTerms: [] },
        { title: "bi bi-envelope-at", searchTerms: [] },
        { title: "bi bi-regex", searchTerms: [] },
        { title: "bi bi-text-wrap", searchTerms: [] },
        { title: "bi bi-sign-dead-end-fill", searchTerms: [] },
        { title: "bi bi-sign-dead-end", searchTerms: [] },
        { title: "bi bi-sign-do-not-enter-fill", searchTerms: [] },
        { title: "bi bi-sign-do-not-enter", searchTerms: [] },
        { title: "bi bi-sign-intersection-fill", searchTerms: [] },
        { title: "bi bi-sign-intersection-side-fill", searchTerms: [] },
        { title: "bi bi-sign-intersection-side", searchTerms: [] },
        { title: "bi bi-sign-intersection-t-fill", searchTerms: [] },
        { title: "bi bi-sign-intersection-t", searchTerms: [] },
        { title: "bi bi-sign-intersection-y-fill", searchTerms: [] },
        { title: "bi bi-sign-intersection-y", searchTerms: [] },
        { title: "bi bi-sign-intersection", searchTerms: [] },
        { title: "bi bi-sign-merge-left-fill", searchTerms: [] },
        { title: "bi bi-sign-merge-left", searchTerms: [] },
        { title: "bi bi-sign-merge-right-fill", searchTerms: [] },
        { title: "bi bi-sign-merge-right", searchTerms: [] },
        { title: "bi bi-sign-no-left-turn-fill", searchTerms: [] },
        { title: "bi bi-sign-no-left-turn", searchTerms: [] },
        { title: "bi bi-sign-no-parking-fill", searchTerms: [] },
        { title: "bi bi-sign-no-parking", searchTerms: [] },
        { title: "bi bi-sign-no-right-turn-fill", searchTerms: [] },
        { title: "bi bi-sign-no-right-turn", searchTerms: [] },
        { title: "bi bi-sign-railroad-fill", searchTerms: [] },
        { title: "bi bi-sign-railroad", searchTerms: [] },
        { title: "bi bi-building-add", searchTerms: [] },
        { title: "bi bi-building-check", searchTerms: [] },
        { title: "bi bi-building-dash", searchTerms: [] },
        { title: "bi bi-building-down", searchTerms: [] },
        { title: "bi bi-building-exclamation", searchTerms: [] },
        { title: "bi bi-building-fill-add", searchTerms: [] },
        { title: "bi bi-building-fill-check", searchTerms: [] },
        { title: "bi bi-building-fill-dash", searchTerms: [] },
        { title: "bi bi-building-fill-down", searchTerms: [] },
        { title: "bi bi-building-fill-exclamation", searchTerms: [] },
        { title: "bi bi-building-fill-gear", searchTerms: [] },
        { title: "bi bi-building-fill-lock", searchTerms: [] },
        { title: "bi bi-building-fill-slash", searchTerms: [] },
        { title: "bi bi-building-fill-up", searchTerms: [] },
        { title: "bi bi-building-fill-x", searchTerms: [] },
        { title: "bi bi-building-fill", searchTerms: [] },
        { title: "bi bi-building-gear", searchTerms: [] },
        { title: "bi bi-building-lock", searchTerms: [] },
        { title: "bi bi-building-slash", searchTerms: [] },
        { title: "bi bi-building-up", searchTerms: [] },
        { title: "bi bi-building-x", searchTerms: [] },
        { title: "bi bi-buildings-fill", searchTerms: [] },
        { title: "bi bi-buildings", searchTerms: [] },
        { title: "bi bi-bus-front-fill", searchTerms: [] },
        { title: "bi bi-bus-front", searchTerms: [] },
        { title: "bi bi-ev-front-fill", searchTerms: [] },
        { title: "bi bi-ev-front", searchTerms: [] },
        { title: "bi bi-globe-americas", searchTerms: [] },
        { title: "bi bi-globe-asia-australia", searchTerms: [] },
        { title: "bi bi-globe-central-south-asia", searchTerms: [] },
        { title: "bi bi-globe-europe-africa", searchTerms: [] },
        { title: "bi bi-house-add-fill", searchTerms: [] },
        { title: "bi bi-house-add", searchTerms: [] },
        { title: "bi bi-house-check-fill", searchTerms: [] },
        { title: "bi bi-house-check", searchTerms: [] },
        { title: "bi bi-house-dash-fill", searchTerms: [] },
        { title: "bi bi-house-dash", searchTerms: [] },
        { title: "bi bi-house-down-fill", searchTerms: [] },
        { title: "bi bi-house-down", searchTerms: [] },
        { title: "bi bi-house-exclamation-fill", searchTerms: [] },
        { title: "bi bi-house-exclamation", searchTerms: [] },
        { title: "bi bi-house-gear-fill", searchTerms: [] },
        { title: "bi bi-house-gear", searchTerms: [] },
        { title: "bi bi-house-lock-fill", searchTerms: [] },
        { title: "bi bi-house-lock", searchTerms: [] },
        { title: "bi bi-house-slash-fill", searchTerms: [] },
        { title: "bi bi-house-slash", searchTerms: [] },
        { title: "bi bi-house-up-fill", searchTerms: [] },
        { title: "bi bi-house-up", searchTerms: [] },
        { title: "bi bi-house-x-fill", searchTerms: [] },
        { title: "bi bi-house-x", searchTerms: [] },
        { title: "bi bi-person-add", searchTerms: [] },
        { title: "bi bi-person-down", searchTerms: [] },
        { title: "bi bi-person-exclamation", searchTerms: [] },
        { title: "bi bi-person-fill-add", searchTerms: [] },
        { title: "bi bi-person-fill-check", searchTerms: [] },
        { title: "bi bi-person-fill-dash", searchTerms: [] },
        { title: "bi bi-person-fill-down", searchTerms: [] },
        { title: "bi bi-person-fill-exclamation", searchTerms: [] },
        { title: "bi bi-person-fill-gear", searchTerms: [] },
        { title: "bi bi-person-fill-lock", searchTerms: [] },
        { title: "bi bi-person-fill-slash", searchTerms: [] },
        { title: "bi bi-person-fill-up", searchTerms: [] },
        { title: "bi bi-person-fill-x", searchTerms: [] },
        { title: "bi bi-person-gear", searchTerms: [] },
        { title: "bi bi-person-lock", searchTerms: [] },
        { title: "bi bi-person-slash", searchTerms: [] },
        { title: "bi bi-person-up", searchTerms: [] },
        { title: "bi bi-scooter", searchTerms: [] },
        { title: "bi bi-taxi-front-fill", searchTerms: [] },
        { title: "bi bi-taxi-front", searchTerms: [] },
        { title: "bi bi-amd", searchTerms: [] },
        { title: "bi bi-database-add", searchTerms: [] },
        { title: "bi bi-database-check", searchTerms: [] },
        { title: "bi bi-database-dash", searchTerms: [] },
        { title: "bi bi-database-down", searchTerms: [] },
        { title: "bi bi-database-exclamation", searchTerms: [] },
        { title: "bi bi-database-fill-add", searchTerms: [] },
        { title: "bi bi-database-fill-check", searchTerms: [] },
        { title: "bi bi-database-fill-dash", searchTerms: [] },
        { title: "bi bi-database-fill-down", searchTerms: [] },
        { title: "bi bi-database-fill-exclamation", searchTerms: [] },
        { title: "bi bi-database-fill-gear", searchTerms: [] },
        { title: "bi bi-database-fill-lock", searchTerms: [] },
        { title: "bi bi-database-fill-slash", searchTerms: [] },
        { title: "bi bi-database-fill-up", searchTerms: [] },
        { title: "bi bi-database-fill-x", searchTerms: [] },
        { title: "bi bi-database-fill", searchTerms: [] },
        { title: "bi bi-database-gear", searchTerms: [] },
        { title: "bi bi-database-lock", searchTerms: [] },
        { title: "bi bi-database-slash", searchTerms: [] },
        { title: "bi bi-database-up", searchTerms: [] },
        { title: "bi bi-database-x", searchTerms: [] },
        { title: "bi bi-database", searchTerms: [] },
        { title: "bi bi-houses-fill", searchTerms: [] },
        { title: "bi bi-houses", searchTerms: [] },
        { title: "bi bi-nvidia", searchTerms: [] },
        { title: "bi bi-person-vcard-fill", searchTerms: [] },
        { title: "bi bi-person-vcard", searchTerms: [] },
        { title: "bi bi-sina-weibo", searchTerms: [] },
        { title: "bi bi-tencent-qq", searchTerms: [] },
        { title: "bi bi-wikipedia", searchTerms: [] },
        { title: "bi bi-alphabet-uppercase", searchTerms: [] },
        { title: "bi bi-alphabet", searchTerms: [] },
        { title: "bi bi-amazon", searchTerms: [] },
        { title: "bi bi-arrows-collapse-vertical", searchTerms: [] },
        { title: "bi bi-arrows-expand-vertical", searchTerms: [] },
        { title: "bi bi-arrows-vertical", searchTerms: [] },
        { title: "bi bi-arrows", searchTerms: [] },
        { title: "bi bi-ban-fill", searchTerms: [] },
        { title: "bi bi-ban", searchTerms: [] },
        { title: "bi bi-bing", searchTerms: [] },
        { title: "bi bi-cake", searchTerms: [] },
        { title: "bi bi-cake2", searchTerms: [] },
        { title: "bi bi-cookie", searchTerms: [] },
        { title: "bi bi-copy", searchTerms: [] },
        { title: "bi bi-crosshair", searchTerms: [] },
        { title: "bi bi-crosshair2", searchTerms: [] },
        { title: "bi bi-emoji-astonished-fill", searchTerms: [] },
        { title: "bi bi-emoji-astonished", searchTerms: [] },
        { title: "bi bi-emoji-grimace-fill", searchTerms: [] },
        { title: "bi bi-emoji-grimace", searchTerms: [] },
        { title: "bi bi-emoji-grin-fill", searchTerms: [] },
        { title: "bi bi-emoji-grin", searchTerms: [] },
        { title: "bi bi-emoji-surprise-fill", searchTerms: [] },
        { title: "bi bi-emoji-surprise", searchTerms: [] },
        { title: "bi bi-emoji-tear-fill", searchTerms: [] },
        { title: "bi bi-emoji-tear", searchTerms: [] },
        { title: "bi bi-envelope-arrow-down-fill", searchTerms: [] },
        { title: "bi bi-envelope-arrow-down", searchTerms: [] },
        { title: "bi bi-envelope-arrow-up-fill", searchTerms: [] },
        { title: "bi bi-envelope-arrow-up", searchTerms: [] },
        { title: "bi bi-feather", searchTerms: [] },
        { title: "bi bi-feather2", searchTerms: [] },
        { title: "bi bi-floppy-fill", searchTerms: [] },
        { title: "bi bi-floppy", searchTerms: [] },
        { title: "bi bi-floppy2-fill", searchTerms: [] },
        { title: "bi bi-floppy2", searchTerms: [] },
        { title: "bi bi-gitlab", searchTerms: [] },
        { title: "bi bi-highlighter", searchTerms: [] },
        { title: "bi bi-marker-tip", searchTerms: [] },
        { title: "bi bi-nvme-fill", searchTerms: [] },
        { title: "bi bi-nvme", searchTerms: [] },
        { title: "bi bi-opencollective", searchTerms: [] },
        { title: "bi bi-pci-card-network", searchTerms: [] },
        { title: "bi bi-pci-card-sound", searchTerms: [] },
        { title: "bi bi-radar", searchTerms: [] },
        { title: "bi bi-send-arrow-down-fill", searchTerms: [] },
        { title: "bi bi-send-arrow-down", searchTerms: [] },
        { title: "bi bi-send-arrow-up-fill", searchTerms: [] },
        { title: "bi bi-send-arrow-up", searchTerms: [] },
        { title: "bi bi-sim-slash-fill", searchTerms: [] },
        { title: "bi bi-sim-slash", searchTerms: [] },
        { title: "bi bi-sourceforge", searchTerms: [] },
        { title: "bi bi-substack", searchTerms: [] },
        { title: "bi bi-threads-fill", searchTerms: [] },
        { title: "bi bi-threads", searchTerms: [] },
        { title: "bi bi-transparency", searchTerms: [] },
        { title: "bi bi-twitter-x", searchTerms: [] },
        { title: "bi bi-type-h4", searchTerms: [] },
        { title: "bi bi-type-h5", searchTerms: [] },
        { title: "bi bi-type-h6", searchTerms: [] },
        { title: "bi bi-backpack-fill", searchTerms: [] },
        { title: "bi bi-backpack", searchTerms: [] },
        { title: "bi bi-backpack2-fill", searchTerms: [] },
        { title: "bi bi-backpack2", searchTerms: [] },
        { title: "bi bi-backpack3-fill", searchTerms: [] },
        { title: "bi bi-backpack3", searchTerms: [] },
        { title: "bi bi-backpack4-fill", searchTerms: [] },
        { title: "bi bi-backpack4", searchTerms: [] },
        { title: "bi bi-brilliance", searchTerms: [] },
        { title: "bi bi-cake-fill", searchTerms: [] },
        { title: "bi bi-cake2-fill", searchTerms: [] },
        { title: "bi bi-duffle-fill", searchTerms: [] },
        { title: "bi bi-duffle", searchTerms: [] },
        { title: "bi bi-exposure", searchTerms: [] },
        { title: "bi bi-gender-neuter", searchTerms: [] },
        { title: "bi bi-highlights", searchTerms: [] },
        { title: "bi bi-luggage-fill", searchTerms: [] },
        { title: "bi bi-luggage", searchTerms: [] },
        { title: "bi bi-mailbox-flag", searchTerms: [] },
        { title: "bi bi-mailbox2-flag", searchTerms: [] },
        { title: "bi bi-noise-reduction", searchTerms: [] },
        { title: "bi bi-passport-fill", searchTerms: [] },
        { title: "bi bi-passport", searchTerms: [] },
        { title: "bi bi-person-arms-up", searchTerms: [] },
        { title: "bi bi-person-raised-hand", searchTerms: [] },
        { title: "bi bi-person-standing-dress", searchTerms: [] },
        { title: "bi bi-person-standing", searchTerms: [] },
        { title: "bi bi-person-walking", searchTerms: [] },
        { title: "bi bi-person-wheelchair", searchTerms: [] },
        { title: "bi bi-shadows", searchTerms: [] },
        { title: "bi bi-suitcase-fill", searchTerms: [] },
        { title: "bi bi-suitcase-lg-fill", searchTerms: [] },
        { title: "bi bi-suitcase-lg", searchTerms: [] },
        { title: "bi bi-suitcase", searchTerms: [] },
        { title: "bi bi-suitcase2-fill", searchTerms: [] },
        { title: "bi bi-suitcase2", searchTerms: [] },
        { title: "bi bi-vignette", searchTerms: [] },
    ]
    });
});