async function fetchOpenAIResponse(apiKey, prompt, responseElementId) {
    if (!prompt.trim()) {
        alert("Please enter a prompt!");
        return;
    }

    const responseElement = document.getElementById(responseElementId);
    responseElement.value = "";

    try {
        const response = await fetch("https://api.openai.com/v1/chat/completions", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "Authorization": `Bearer ${apiKey}`
            },
            body: JSON.stringify({
                model: "gpt-4",
                messages: [{ role: "user", content: prompt }],
                max_tokens: 200,
                temperature: 0.7,
                stream: true // Enable streaming
            })
        });

        if (!response.ok) {
            throw new Error("Failed to fetch OpenAI API response");
        }

        const reader = response.body.getReader();
        const decoder = new TextDecoder("utf-8");

        while (true) {
            const { done, value } = await reader.read();
            if (done) break;

            const chunk = decoder.decode(value, { stream: true });
            const lines = chunk.split("\n").filter(line => line.trim() !== "");

            lines.forEach(line => {
                if (line.startsWith("data: ")) {
                    const json = line.slice(6);
                    if (json === "[DONE]") return;

                    try {
                        const data = JSON.parse(json);

                        if (data.choices && data.choices[0].delta && data.choices[0].delta.content) {

                            const content = data.choices[0].delta.content;

                            if (responseElement.classList.contains('summernote')) {
                                // Initialize NicEdit if not already initialized
                                if (!window.nicEditors.findEditor(responseElementId)) {
                                    new nicEditor().panelInstance(responseElementId);
                                }

                                // Find the NicEdit editor and append content
                                const nicEditorInstance = nicEditors.findEditor(responseElementId);
                                const currentContent = nicEditorInstance.getContent();
                                nicEditorInstance.setContent(currentContent + content);
                            } else {
                                // Update regular input or textarea
                                responseElement.value += content;
                            }


                        }
                    } catch (error) {
                        console.error("Error parsing line:", line, error);
                    }
                }
            });
        }
    } catch (error) {
        console.error("Error:", error);
        responseElement.value = "Error occurred while streaming response.";
    }
}
