(function ($) {
  'use strict';

  // preloader
  $(".it-preloader-holder").delay(300).animate({
    "opacity": "0"
  }, 300, function () {
    $(".it-preloader-holder").css("display", "none");
  });

  // CURSOR
  var cursor = $(".cursor"),
    follower = $(".cursor-follower");

  var posX = 0,
    posY = 0;

  var mouseX = 0,
    mouseY = 0;

  TweenMax.to({}, 0.016, {
    repeat: -1,
    onRepeat: function () {
      posX += (mouseX - posX) / 9;
      posY += (mouseY - posY) / 9;

      TweenMax.set(follower, {
        css: {
          left: posX - 12,
          top: posY - 12
        }
      });

      TweenMax.set(cursor, {
        css: {
          left: mouseX,
          top: mouseY
        }
      });
    }
  });

  $(document).on("mousemove", function (e) {
    mouseX = e.clientX;
    mouseY = e.clientY;
  });
  // yellow circle
  $("a, button").on("mouseenter", function () {
    cursor.addClass("active");
    follower.addClass("active");
  });
  $("a, button").on("mouseleave", function () {
    cursor.removeClass("active");
    follower.removeClass("active");
  });


  // mobile submenu collapsible js
  $(".sidebar-menu .dropdown > a, .candidate-d-menu .menu-dropdown > a, .candidate-dashboard-sidebar .dropdown > a").on("click", function () {
    var item = $(this).parent(".dropdown");
    item.siblings(".dropdown").children(".sidebar-submenu").slideUp();

    item.siblings(".dropdown").removeClass("dropdown-open");

    item.siblings(".dropdown").removeClass("open");

    item.children(".sidebar-submenu").slideToggle();

    item.toggleClass("dropdown-open");
  });

  $(".it-header-open-btn").on("click", function () {
    $(".it-header-nav-wrapper").addClass("active");
  });

  $(".it-header-close-btn").on("click", function () {
    $(".it-header-nav-wrapper").removeClass("active");
  });

  // user sidebar open js
  $(".user-sidebar-open-btn").on("click", function () {
    $(".user-sidebar").addClass("sidebar-open");
  });

  // user sidebar close js
  $(".user-sidebar-close").on("click", function () {
    $(".user-sidebar").removeClass("sidebar-open");
  });

  // mobile bottom bar scroll appear
  $(window).on('scroll', function () {
    var scroll = $(window).scrollTop();
    if (scroll >= 50) {
      $(".jt-mobile-bar").addClass("animated fadeInDown bottom-fixed");
    } else {
      $(".jt-mobile-bar").removeClass("animated fadeInDown bottom-fixed");
    }
  });

  //to keep the current page active
  $(function () {
    for (
      var nk = window.location,
      o = $("ul.activation-menu a")
        .filter(function () {
          return this.href == nk;
        })
        .addClass("active-page") // anchor
        .parent()
        .addClass("active-page");
      ;

    ) {
      // li
      if (!o.is("li")) break;
      o = o.parent().addClass("show").parent().addClass("open");
    }
  });

  // Bootstrap tooltip js 
  const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
  const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))

  // Responsive table js 
  $('.responsive-table').basictable({
    breakpoint: 991,
  });

  $(".candidate-dashboard-sidebar-open").on("click", function () {
    $(".candidate-dashboard-sidebar").toggleClass("active");
  });

  $(".candidate-dashboard-sidebar-close").on("click", function () {
    $(".candidate-dashboard-sidebar").removeClass("active");
  });

  // referral tree js
  $(".expand-btn").each(function () {
    $(this).on("click", function () {
      $(this).toggleClass("active");
      let subReferralTree = $(this).parent(".single-referral").siblings(".sub-referral-tree");
      subReferralTree.slideToggle();
    });
  });

  // input value copy js
  $('.copy-btn').on("click", function () {
    // Find the input element within the same input-group
    var input = $(this).siblings('.form-control');

    // Select the input value
    input.select();

    // Copy the input value to the clipboard
    document.execCommand('copy');

    // Optionally, you can display a message or change the button text
    $(this).text('Copied!');

    // Reset the button text after a short delay
    setTimeout(() => {
      $(this).text('Copy');
    }, 2000);
  });

  // input value copy js
  $('.copy-btn').on("click", function () {
    // Find the input element within the same input-group
    var input = $('.url-field');

    // Select the input value
    input.select();

    // Copy the input value to the clipboard
    document.execCommand('copy');

    // Optionally, you can display a message or change the button text
    $(this).text('Copied!');

    // Reset the button text after a short delay
    setTimeout(() => {
      $(this).text('Copy');
    }, 2000);
  });

  $('.password-field-btn').click(function () {
    $(this).toggleClass("active");
    var passField = $(this).siblings(".form-control");

    if (passField.attr('type') === 'password') {
      passField.attr('type', 'text');
    } else {
      passField.attr('type', 'password');
    }
  });

  // Show or hide the sticky footer button
  $(window).on("scroll", function () {
    if ($(this).scrollTop() > 200) {
      $(".top-action-btn").fadeIn(200);
    } else {
      $(".top-action-btn").fadeOut(200);
    }
  });

  // scroll animation init (wow js plugin)
  new WOW().init();

  // Animate the scroll to top
  $(".top-action-btn").on("click", function (event) {
    event.preventDefault();
    $("html, body").animate({ scrollTop: 0 }, 300);
  });

  $('.video-popup').magnificPopup({
    type: 'iframe'
  });

  $(".mobile-menu-open").on("click", function () {
    $(".mobile-menu").addClass("active");
  });

  $(".mobile-menu-close").on("click", function () {
    $(".mobile-menu").removeClass("active");
  });

  $(".bookmark-btn").on("click", function () {
    $(this).toggleClass("bookmarked");
  });

  $('.image-popup').magnificPopup({
    type: 'image',
    gallery: {
      // options for gallery
      enabled: true
    },
  });

})(jQuery);