<?php

namespace App\Constant;

class Constant
{
    const ASSETS_FROM_BACKEND = 'backend';

    const ASSETS_FROM_COMMON = 'common';

    const ASSETS_FROM_FRONTEND = 'frontend';


    const ASSETS_FROM_INSTALLER = 'installer';

    const IMAGE_UPLOAD_ROOT_PATH = 'files/image/';
    const ROOT_CSS_ASSETS_PATH = 'files/css/';
    const ROOT_JS_ASSETS_PATH = 'files/js/';

    const CMS_SKELETON_PATH = 'views/backend/sections/skeleton/';
    const CMS_SECTION_PATH = 'views/backend/sections/';

    const LANGUAGE_BACKEND = 'backend';
    const LANGUAGE_FRONTEND = 'frontend';
    const LANGUAGE_NOTIFICATION = 'notification';

    const FIAT = 'fiat';
    const CRYPTO = 'crypto';

    const ACTIVE = 1;
    const INACTIVE = 0;
    const PENDING = 2;
    const REJECTED = 3;
    const ACCEPTED = 4;

    const WITHDRAW_AUCTION = 3;
    const COMPLETED_AUCTION = 2;
    const RUNNING_AUCTION = 1;

    const COMPLETED_STAGE = 2;

    const WITH_BALANCE = 'balance';
    const WITH_GATEWAY = 'gateway';

    const CONTENT = 'content';
    const ELEMENT = 'element';

    const EMAIL_VERIFIED = 1;
    const EMAIL_UNVERIFIED = 0;

    const SMS_VERIFIED = 1;
    const SMS_UNVERIFIED = 0;

    const KYC_VERIFIED = 1;
    const KYC_UNVERIFIED = 0;


    const DEPOSIT = 'deposit';
    const PAYMENT = 'payment';
    const REFERRAL = 'referral';

    const PERCENTAGE = 0;
    const FIXED = 1;

    const ONLINE_GATEWAY = 1;
    const OFFLINE_GATEWAY = 2;

    const HEADER_MENU = 1;
    const FOOTER_MENU = 2;

    const SUPPORT_CLOSED = 2;
    const SUPPORT_OPEN = 0;
    const SUPPORT_ANSWERED = 1;

    public $inputTypes = ['text' => 'Input Text', 'textarea' => 'Textarea', 'file' => 'File Upload'];

    public $validations = ['required' => 'Required', 'optional' => 'Optional'];

    const OFFLINE_GATEWAY_TYPE = ['crypto' => 'Crypto Gateway', 'bank' => 'Banking Payment'];

    const ICONS = [
        'others' => "iconoir:hand-cash"
    ];

    const ROUTE_WITHOUT_BREADCRUMB = [];
}
