<?php
namespace App\Constant;

use App\Traits\Payment\PaymentSuccess;

class GatewayRedirect
{
    use PaymentSuccess;

    public static function canceled($type)
    {
        $routes = [
            'deposit' => 'deposit'
        ];

        return ['status' => true,'message'=>strtoupper($type).' Cancled Succcesfully', 'route' => $routes[$type] ?? null];
    }

    public static function paymentFailed($type){
        $routes = [
            'deposit' => 'deposit'
        ];

        return ['status' => false,'message'=>strtoupper($type).' failed', 'route' => $routes[$type] ?? null];
    }

    public static function success($type){

        $routes = [
            'deposit' => 'deposit-final',
            'payment' => 'payment-final'
        ];

        $response = self::completedTransaction(session('transaction'), $type);

       return ['status' => $response['status'],'message'=> $response['message'], 'route' => $routes[$type] ?? null];
    }
}
