<?php

namespace App\Constant;


class MailTemplate
{
    const GENERAL_MAIL = 'general_mail';
    const EMAIL_VERIFY = 'email_verify';
    const PASSWORD_RESET = 'password_rest';
    const ADD_BALANCE = 'add_balance';
    const SUB_BALANCE = 'sub_balance';
    const WITHDRAW_CREATED = 'withdraw_created';
    const WITHDRAW_ACCEPTED = 'withdraw_accepted';
    const WITHDRAW_REJECTED = 'withdraw_rejected';
    const DEPOSIT_REQUEST = 'deposit_request';
    const DEPOSIT_ACCEPTED = 'deposit_accepted';
    const DEPOSIT_REJECTED = 'deposit_rejected';
    const DEPOSIT_SUCCESSFUL = 'deposit_successful';
    const REFERRAL_COMMISSION = 'referral_commission';
    const REFERRAL_INVITATION = 'referral_invitation';
    const KYC_VERIFICATION_REQUEST = 'kyc_verification_request';
    const ACCEPT_KYC = 'accept_kyc';
    const REJECT_KYC = 'reject_kyc';
    const SUPPORT_CREATED = 'support_created';
    const SUPPORT_REPLY = 'support_reply';
    const SUPPORT_CLOSED = 'support_closed';

    const PURCHASE_TOKEN = 'purchase_token';
    const PURCHASE_TOKEN_CREATED = 'purchase_token_create';
    const OFFLINE_PURCHASE_REQUEST = "offline_purchase_request";
    const OFLINE_PURCHASE_ACCEPT = "offline_purchase_accepted";
    const ONLINE_PURCHASE_TOKEN = "online_purchase_token";
    const OFFLINE_PURCHASE_REJECTED = "offline_purchase_rejected";

    const AUCTION_BUY_TOKEN = 'auction_buy_token';
    const AUCTION_SELL_TOKEN = 'auction_sell_token';
    const AUCTION_WITHDRAW = 'auction_withdraw';




    protected $key;

    function __construct($key = null)
    {
        $this->key = $key;
    }

    private function templates()
    {
        return [
            SELF::GENERAL_MAIL => [
                "codes" => [
                    "message" => "Message body"
                ],
                "relatable_table" => [],
                "display" => [
                    "icon" => "teenyicons:otp-outline",
                    "color" => "bg-primary"
                ],
                "formattable_column" => [],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "user",
                    "route" => $this->getRouteForTemplate(SELF::GENERAL_MAIL),
                    "response_type" => "success",
                    "form_mail" => true,
                    "email" => true,
                    "push" => false,
                    "notification" => false
                ]
            ],
            SELF::EMAIL_VERIFY => [
                "codes" => [
                    "verification_code" => "Otp for Email Verification"
                ],
                "relatable_table" => [],
                "display" => [
                    "icon" => "teenyicons:otp-outline",
                    "color" => "bg-primary"
                ],
                "formattable_column" => [],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "user",
                    "route" => $this->getRouteForTemplate(SELF::EMAIL_VERIFY),
                    "response_type" => "success",
                    "email" => true,
                    "push" => false,
                    "notification" => false
                ]
            ],
            SELF::PASSWORD_RESET => [
                "codes" => [
                    "token" => "Otp for Verification"
                ],
                "relatable_table" => [],
                "display" => [
                    "icon" => "teenyicons:otp-outline",
                    "color" => "bg-info"
                ],
                "formattable_column" => [],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "user",
                    "route" => $this->getRouteForTemplate(SELF::PASSWORD_RESET),
                    "response_type" => "success",
                    "email" => true,
                    "push" => false,
                    "notification" => false
                ]
            ],
            SELF::ADD_BALANCE => [
                "codes" => [
                    "reason" => "Add Balance Reason",
                    "amount" => "Add Balance Amount"
                ],
                "relatable_table" => [],
                "display" => [
                    "icon" => "ic:baseline-account-balance-wallet",
                    "color" => "bg-primary"
                ],
                "formattable_column" => ["amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "add_balance",
                    "route" => $this->getRouteForTemplate(SELF::ADD_BALANCE),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::SUB_BALANCE => [
                "codes" => [
                    "reason" => "Sub Balance Reason",
                    "amount" => "Sub Balance Amount"
                ],
                "relatable_table" => [],
                "display" => [
                    "icon" => "ic:baseline-account-balance-wallet",
                    "color" => "bg-warning"
                ],
                "formattable_column" => ["amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "sub_balance",
                    "route" => $this->getRouteForTemplate(SELF::SUB_BALANCE),
                    "response_type" => "error",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::WITHDRAW_CREATED => [
                "codes" => [
                    "withdraw_amount" => "Total Withdraw Amount",
                    "charge" => "Withdraw Charge",
                    "getable_amount" => "Total received amount",
                    "trx" => "Withdraw Transaction",
                    "time" => "Withdraw Time",
                    "method" => "Withdraw Method",
                    "status" => "Withdraw Status",
                    "note" => "Withdraw Note"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "akar-icons:percentage",
                    "color" => "bg-primary"
                ],
                "formattable_column" => ["withdraw_amount", "charge", "getable_amount"],
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::WITHDRAW_CREATED),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::WITHDRAW_ACCEPTED => [
                "codes" => [
                    "withdraw_amount" => "Total Withdraw Amount",
                    "charge" => "Withdraw Charge",
                    "getable_amount" => "Total received amount",
                    "trx" => "Withdraw Transaction",
                    "time" => "Withdraw Time",
                    "method" => "Withdraw Method",
                    "status" => "Withdraw Status",
                    "note" => "Withdraw Note"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "akar-icons:percentage",
                    "color" => "bg-primary"
                ],
                "formattable_column" => ["withdraw_amount", "charge", "getable_amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "withdraw",
                    "route" => $this->getRouteForTemplate(SELF::WITHDRAW_ACCEPTED),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::WITHDRAW_REJECTED => [
                "codes" => [
                    "withdraw_amount" => "Total Withdraw Amount",
                    "charge" => "Withdraw Charge",
                    "getable_amount" => "Total received amount",
                    "trx" => "Withdraw Transaction",
                    "time" => "Withdraw Time",
                    "method" => "Withdraw Method",
                    "status" => "Withdraw Status",
                    "note" => "Withdraw Note"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "akar-icons:percentage",
                    "color" => "bg-primary"
                ],
                "formattable_column" => ["withdraw_amount", "charge", "getable_amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "withdraw",
                    "route" => $this->getRouteForTemplate(SELF::WITHDRAW_REJECTED),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::DEPOSIT_REQUEST => [
                "codes" => [
                    "total_amount" => "Total Deposit Amount",
                    "charge" => "Deposit Charge",
                    "trx" => "Deposit Transaction",
                    "time" => "Deposit Time",
                    "method" => "Deposit Method",
                    "status" => "Deposit Status"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "akar-icons:percentage",
                    "color" => "bg-primary"
                ],
                "formattable_column" => ["total_amount", "charge"],
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::DEPOSIT_REQUEST),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::DEPOSIT_ACCEPTED => [
                "codes" => [
                    "total_amount" => "Total Deposit Amount",
                    "charge" => "Deposit Charge",
                    "trx" => "Deposit Transaction",
                    "time" => "Deposit Time",
                    "method" => "Deposit Method",
                    "status" => "Deposit Status"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "akar-icons:percentage",
                    "color" => "bg-primary"
                ],
                "formattable_column" => ["total_amount", "charge"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "deposit",
                    "route" => $this->getRouteForTemplate(SELF::DEPOSIT_ACCEPTED),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::DEPOSIT_REJECTED => [
                "codes" => [
                    "total_amount" => "Total Deposit Amount",
                    "charge" => "Deposit Charge",
                    "trx" => "Deposit Transaction",
                    "time" => "Deposit Time",
                    "method" => "Deposit Method",
                    "status" => "Deposit Status",
                    "reason" => "Deposit Reject Reason"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "ph:hand-deposit",
                    "color" => "bg-success"
                ],
                "formattable_column" => ["total_amount", "charge"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "deposit",
                    "route" => $this->getRouteForTemplate(SELF::DEPOSIT_REJECTED),
                    "response_type" => "error",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::DEPOSIT_SUCCESSFUL => [
                "codes" => [
                    "amount" => "Total Deposit Amount",
                    "charge" => "Deposit Charge",
                    "trx" => "Deposit Transaction",
                    "time" => "Deposit Time",
                    "method" => "Deposit Method",
                    "status" => "Deposit Status"
                ],
                "relatable_table" => [
                    "method" => "name"
                ],
                "display" => [
                    "icon" => "ph:hand-deposit-duotone",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount", "charge"],
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::DEPOSIT_SUCCESSFUL),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::REFERRAL_COMMISSION => [
                "codes" => [
                    "amount" => "Total Commission Amount",
                    "commissionFrom" => "Commission from which user",
                    "trx" => "Transaction Number",
                    "time" => "Commission Time"
                ],
                "relatable_table" => [
                    "commissionFrom" => "full_name"
                ],
                "display" => [
                    "icon" => "healthicons:referral-outline",
                    "color" => "bg-danger"
                ],
                "formattable_column" => ["amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "referral",
                    "route" => $this->getRouteForTemplate(SELF::REFERRAL_COMMISSION),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::REFERRAL_INVITATION => [
                "codes" => [
                    "link" => "Referral Invitation link"
                ],
                "relatable_table" => null,
                "display" => [
                    "icon" => "healthicons:referral-outline",
                    "color" => "bg-info"
                ],
                "formattable_column" => null,
                "configuration" => null
            ],
            SELF::KYC_VERIFICATION_REQUEST => [
                "codes" => [
                    "message" => "Kyc Verification"
                ],
                "relatable_table" => null,
                "display" => [
                    "icon" => "arcticons:laokyc",
                    "color" => "bg-primary"
                ],
                "formattable_column" => null,
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::KYC_VERIFICATION_REQUEST),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::ACCEPT_KYC => [
                "codes" => [
                    "message" => "Accept Kyc Verification"
                ],
                "relatable_table" => null,
                "display" => [
                    "icon" => "arcticons:laokyc",
                    "color" => "bg-primary"
                ],
                "formattable_column" => null,
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "kyc",
                    "route" => $this->getRouteForTemplate(SELF::ACCEPT_KYC),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::REJECT_KYC => [
                "codes" => [
                    "reason" => "Reject Kyc Verification"
                ],
                "relatable_table" => null,
                "display" => [
                    "icon" => "arcticons:laokyc",
                    "color" => "bg-primary"
                ],
                "formattable_column" => null,
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "kyc",
                    "route" => $this->getRouteForTemplate(SELF::REJECT_KYC),
                    "response_type" => "error",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::SUPPORT_CREATED => [
                "codes" => [
                    "message" => "Message"
                ],
                "relatable_table" => null,
                "display" => null,
                "formattable_column" => null,
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::SUPPORT_CREATED),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::SUPPORT_REPLY => [
                "codes" => [
                    "message" => "Message"
                ],
                "relatable_table" => null,
                "display" => null,
                "formattable_column" => null,
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::SUPPORT_REPLY),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::SUPPORT_CLOSED => [
                "codes" => [
                    "message" => "Message"
                ],
                "relatable_table" => null,
                "display" => null,
                "formattable_column" => null,
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "support",
                    "route" => $this->getRouteForTemplate(SELF::SUPPORT_CLOSED),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::PURCHASE_TOKEN => [
                "codes" => [
                    "trx" => "Transaction Number",
                    "total_amount" => "Total Price",
                    "token" => "Purchase Token",
                    "bonus_token" => "Bonus Token",
                    "stage" => "Stage Title"
                ],
                "relatable_table" => ["stage" => "title"],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "stage",
                    "route" => $this->getRouteForTemplate(SELF::PURCHASE_TOKEN),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::PURCHASE_TOKEN_CREATED => [
                "codes" => [],
                "relatable_table" => [],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount"],
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "stage",
                    "route" => $this->getRouteForTemplate(SELF::PURCHASE_TOKEN_CREATED),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::OFFLINE_PURCHASE_REQUEST => [
                "codes" => [
                    "trx" => "Transaction Number",
                    "total_amount" => "Total Price",
                    "token" => "Purchase Token",
                    "bonus_token" => "Bonus Token",
                    "stage" => "Stage Title",
                    "user" => "User name"
                ],
                "relatable_table" => ["stage" => "title", "user" => "username"],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount"],
                "configuration" => [
                    "notification_receiver" => "admin-notification",
                    "notification_type" => "stage",
                    "route" => $this->getRouteForTemplate(SELF::OFFLINE_PURCHASE_REQUEST),
                    "response_type" => "success",
                    "email" => false,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::OFLINE_PURCHASE_ACCEPT => [
                "codes" => [
                    "trx" => "Transaction Number",
                    "total_amount" => "Total Price",
                    "token" => "Purchase Token",
                    "bonus_token" => "Bonus Token",
                    "stage" => "Stage Title"
                ],
                "relatable_table" => ["stage" => "title"],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "stage",
                    "route" => $this->getRouteForTemplate(SELF::OFLINE_PURCHASE_ACCEPT),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::ONLINE_PURCHASE_TOKEN => [
                "codes" => [
                    "trx" => "Transaction Number",
                    "total_amount" => "Total Price",
                    "token" => "Purchase Token",
                    "bonus_token" => "Bonus Token",
                    "stage" => "Stage Title",
                    "method" => "Purchase Method"
                ],
                "relatable_table" => ["stage" => "title", "method" => "name"],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "stage",
                    "route" => $this->getRouteForTemplate(SELF::ONLINE_PURCHASE_TOKEN),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::OFFLINE_PURCHASE_REJECTED => [
                "codes" => [
                    "trx" => "Transaction Number",
                    "total_amount" => "Total Price",
                    "token" => "Purchase Token",
                    "bonus_token" => "Bonus Token",
                    "note" => "Rejection note",
                    "stage" => "Stage Title"
                ],
                "relatable_table" => ["stage" => "title"],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ["total_amount"],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "stage",
                    "route" => $this->getRouteForTemplate(SELF::OFFLINE_PURCHASE_REJECTED),
                    "response_type" => "error",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::AUCTION_BUY_TOKEN => [
                "codes" => [
                    'trx' => "Transaction Number",
                    'total_price' => "Total Price",
                    'tokens' => 'Purchase Token',
                    'seller' => 'Seller Name',
                    'auction' => 'Auction Trx'
                ],
                "relatable_table" => [
                    'seller' => 'fullname',
                    'auction' => 'trx'
                ],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => [
                    'total_price'
                ],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::AUCTION_BUY_TOKEN),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::AUCTION_SELL_TOKEN => [
                "codes" => [
                    'trx' => "Transaction Number",
                    'total_price' => "Total Price",
                    'tokens' => 'Purchase Token',
                    'buyer' => 'Buyer Name',
                    'auction' => 'Auction Trx'
                ],
                "relatable_table" => [
                    'buyer' => 'fullname',
                    'auction' => 'trx'
                ],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => [
                    'total_price'
                ],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::AUCTION_SELL_TOKEN),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ],
            SELF::AUCTION_WITHDRAW => [
                "codes" => [
                    'trx' => "Transaction Number",
                    'refund_token' => "Refund Token",
                    'withdraw_fine' => 'withdraw_fine',
                    'auction' => 'Auction Trx'
                ],
                "relatable_table" => [
                    'auction' => 'trx'
                ],
                "display" => [
                    "icon" => "ic:baseline-token",
                    "color" => "bg-info"
                ],
                "formattable_column" => ['withdraw_fine'],
                "configuration" => [
                    "notification_receiver" => "user-notification",
                    "notification_type" => "others",
                    "route" => $this->getRouteForTemplate(SELF::AUCTION_WITHDRAW),
                    "response_type" => "success",
                    "email" => true,
                    "push" => true,
                    "notification" => true
                ]
            ]



        ];
    }


    function getTemplate()
    {
        if (!$this->key) {
            return $this->templates();
        }

        return $this->templates()[$this->key] ?? null;
    }


    private function getRouteForTemplate($template)
    {
        return match ($template) {
            self::WITHDRAW_CREATED => route('panel.withdraw-request'),
            self::DEPOSIT_REQUEST => route('panel.offline-deposit-details', ":id"),
            self::DEPOSIT_SUCCESSFUL => route('panel.online-deposits'),
            self::KYC_VERIFICATION_REQUEST => route('panel.kyc-verification-details', ":id"),
            self::SUPPORT_CREATED => route('panel.support-details', ":id"),
            self::SUPPORT_REPLY => route('panel.support-details', ":id"),
            self::OFFLINE_PURCHASE_REQUEST => route('panel.offline-pending-purchase'),
            self::PURCHASE_TOKEN_CREATED => route('panel.stage.purchases'),
            default => "",
        };
    }
}
