<?php

namespace App\Cron;

use App\Contracts\Cron;
use App\Models\Auction;
use Illuminate\Support\Facades\DB;

class AuctionCron implements Cron
{

    public static function execute()
    {
        $auctions = Auction::active()
            ->where('end_date', '>', now())
            ->orWhereColumn('tokens', '<=', 'sell_token')
            ->get();
      
        foreach ($auctions as $auction) {
            DB::beginTransaction();
            $remain_token = $auction->availableToken();
            $auction->status = cons()::COMPLETED_AUCTION;
            $auction->save();
            
            if($auction->tokens > $auction->sell_token){
                    $user = $auction->user;
                    $user->token += $remain_token;
                    $user->save();
            }
        

            DB::commit();
        }
    }
}
