<?php

namespace App\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class NotificationEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public $collection;
    public $user;
    public $message;
    public $action;

    public function __construct(Model $collection, $user, $message, $action)
    {
        $this->collection = $collection;
        $this->user = $user;
        $this->message = $message;
        $this->action = $action;
    }
}
