<?php
namespace App\Factory;

use App\Contracts\PaymentGatewayInterface;
use App\Gateways\Flutterwave;
use App\Gateways\NowPayments;
use App\Gateways\Paypal;
use App\Gateways\Paystack;
use App\Gateways\Paytm;
use App\Gateways\PerfectMoney;
use App\Gateways\SSLCommerz;
use App\Gateways\Stripe;
use InvalidArgumentException;

class PaymentGatewayFactory
{
    public static function create(string $gateway) : PaymentGatewayInterface
    {

        $moduleName = ucwords($gateway);

        $moduleGatewayClass = "Modules\\{$moduleName}\\App\\Gateways\\{$moduleName}";


        if (class_exists($moduleGatewayClass)) {
            return new $moduleGatewayClass();
        }



        return match ($gateway) {
            'stripe' => new Stripe(),
            'paytm' => new Paytm(),
            'flutterwave' => new Flutterwave(),
            'nowpayments' => new NowPayments(),
            'paystack' => new Paystack(),
            'paypal' => new Paypal(),
            'perfectmoney' => new PerfectMoney(),
            'sslcommerz' => new SSLCommerz(),
            default => throw new InvalidArgumentException("Unsupported gateway: {$gateway}"),
        };
    }
}
