<?php 

namespace App\Filters;

class BulkEmailFilter{
    public function handle($query, $next)
    {

        if(in_array('active', request()->types)){
            $query->whereHas('ability', function ($item) {
                $item->where('status', cons()::ACTIVE);
            });
        }elseif(in_array('inactive', request()->types)){

            $query->whereHas('ability', function ($item) {
                $item->where('status', cons()::INACTIVE);
            });

        }elseif(in_array('email_verified', request()->types)){

            $query->whereHas('ability', function ($item) {
                $item->where('email_verified', cons()::EMAIL_VERIFIED);
            });

        }elseif(in_array('email_unverified', request()->types)){

            $query->whereHas('ability', function ($item) {
                $item->where('email_verified', cons()::EMAIL_UNVERIFIED);
            });

        }elseif(in_array('sms_unverified', request()->types)){

            $query->whereHas('ability', function ($item) {
                $item->where('sms_verified', cons()::SMS_UNVERIFIED);
            });

        }elseif(in_array('sms_verified', request()->types)){

            $query->whereHas('ability', function ($item) {
                $item->where('sms_verified', cons()::SMS_VERIFIED);
            });

        }elseif(in_array('kyc_verified', request()->types)){

            $query->whereHas('ability', function ($item) {
                $item->where('kyc_verified', cons()::KYC_VERIFIED);
            });

        }elseif(in_array('kyc_unverified', request()->types)){
            $query->whereHas('ability', function ($item) {
                $item->where('kyc_verified', cons()::KYC_UNVERIFIED);
            });
        }

        return $next($query);
    }
}