<?php

namespace App\Filters;

use Carbon\Carbon;

class DateFilter{

    public function handle($query, $next)
    {
    
        if (isset(request()->from) && isset(request()->to)) {
            $fromDate = Carbon::parse(request()->from)->startOfDay();
            $toDate = Carbon::parse(request()->to)->endOfDay();
            $query->whereBetween('created_at', [$fromDate, $toDate]);
        }elseif(isset(request()->from)){
            $fromDate = Carbon::parse(request()->from)->startOfDay();
            $query->whereBetween('created_at', [$fromDate, now()->endOfDay()]);
        }elseif(isset(request()->to)){
            $toDate = Carbon::parse(request()->to)->endOfDay();
            $query->where('created_at','<', $toDate);
        }

        return $next($query);
    }
}
