<?php 

namespace App\Filters;

use Illuminate\Support\Facades\DB;

class LoginFilter{
    public function handle($query, $next)
    {
        if (isset(request()->name)) {
            $query->whereHas('user', function ($q){
                $q->where('username', request()->name)
                ->where('f_name', 'LIKE', "%".request()->name."%")
                ->orWhere('l_name', 'LIKE', "%".request()->name."%")
                ->orWhere('email', request()->name)
                ->orWhere(DB::raw("CONCAT(f_name, ' ', l_name)"), 'LIKE', "%".request()->name."%");
            });
        }

        return $next($query);
    }
}