<?php

namespace App\Filters;

use Carbon\Carbon;

class ReturnFilter{

    public function handle($query, $next)
    {
    
        if (isset(request()->from) && isset(request()->to)) {
            $fromDate = Carbon::parse(request()->from)->startOfDay();
            $toDate = Carbon::parse(request()->to)->endOfDay();
            $query->whereBetween('return_date', [$fromDate, $toDate]);
        }elseif(isset(request()->from)){
            $fromDate = Carbon::parse(request()->from)->startOfDay();
            $query->whereBetween('return_date', [$fromDate, now()->endOfDay()]);
        }elseif(isset(request()->to)){
            $toDate = Carbon::parse(request()->to)->endOfDay();
            $query->where('return_date','<', $toDate);
        }

        return $next($query);
    }
}
