<?php

namespace App\Filters;

class SellerFilter
{
    public function handle($query, $next)
    {

        if (isset(request()->seller)) {
            $seller = request()->seller;

            $query->whereHas('user', function ($q) use ($seller) {
                $q->where('username', 'LIKE', $seller . '%')
                    ->orWhere('f_name', 'LIKE', $seller . '%')
                    ->orWhere('l_name', 'LIKE', $seller . '%');
            });
        }

        return $next($query);
    }
}
