<?php

namespace App\Filters;

class SortFilter
{
    public function handle($query, $next)
    {
        if (isset(request()->sort) && request()->sort != 'all') {
            if (request()->sort == 'active') {
                $query->whereHas('ability', function ($item) {
                    $item->where('status', cons()::ACTIVE);
                });
            } elseif (request()->sort == 'email_unverified') {
                $query->whereHas('ability', function ($item) {
                    $item->where('email_verified', cons()::EMAIL_UNVERIFIED);
                });
            } elseif (request()->sort == 'sms_unverified') {
                $query->whereHas('ability', function ($item) {
                    $item->where('sms_verified', cons()::SMS_UNVERIFIED);
                });
            } elseif (request()->sort == 'kyc_unverified') {
                $query->whereHas('ability', function ($item) {
                    $item->where('kyc_verified', cons()::KYC_UNVERIFIED);
                });
            } elseif (request()->sort == 'deactive') {
                $query->whereHas('ability', function ($item) {
                    $item->where('status', cons()::INACTIVE);
                });
            }elseif(request()->sort == 'open'){
                $query->where('status', cons()::SUPPORT_OPEN);
            }elseif(request()->sort == 'answered'){
                $query->where('status', cons()::SUPPORT_ANSWERED);
            }elseif(request()->sort == 'closed'){
                $query->where('status', cons()::SUPPORT_CLOSED);
            }elseif(request()->sort == 'pending'){
                $query->where('status', cons()::PENDING);
            }elseif(request()->sort == 'accepted'){
                $query->where('status', cons()::ACCEPTED);
            }elseif(request()->sort == 'rejected'){
                $query->where('status', cons()::REJECTED);
            }elseif(request()->sort == 'accept_kyc'){
                $query->where('status',cons()::ACCEPTED);
            }elseif(request()->sort == 'reject_kyc'){
                $query->where('status',cons()::REJECTED);
            }
            elseif(request()->sort == 'pending_kyc'){
                $query->where('status',cons()::PENDING);
            }
        }

        return $next($query);
    }
}
