<?php

namespace App\Filters;

use Illuminate\Support\Facades\DB;

class UserFilter
{
    public function handle($query, $next)
    {
        if (isset(request()->name)) {
            $query->where(function ($q){
                $q->where('f_name', 'LIKE', "%".request()->name."%")
                  ->orWhere('l_name', 'LIKE', "%".request()->name."%")
                  ->orWhere(DB::raw("CONCAT(f_name, ' ', l_name)"), 'LIKE', "%".request()->name."%");
            })->OrWhere('email', request()->name);
        }

        return $next($query);
    }
}
