<?php

namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Models\Gateway;
use Illuminate\Validation\ValidationException;

class Flutterwave implements PaymentGatewayInterface
{
    function initPayment($method, $data)
    {
        if(!$method->parameters){
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }
        
        return ['type' => 'route', 'redirect' => route('payment-view',$method->name)];
    }

    function paymentCheck($request)
    {

        $method = Gateway::where('name', $request['method'])->first();
        
        $curl = curl_init();
        $tnx_id = $request['tnx_id'];
        $url = "https://api.flutterwave.com/v3/transactions/$tnx_id/verify";
        $token = $method->parameters->secret_key;
        curl_setopt_array($curl, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => ['Content-Type: application/json', "Authorization: Bearer $token"],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);

        $response = json_decode($response);

        return $response;
    }

    function paymentCallback($request,$data, $module)
    {
        return GatewayRedirect::success($module);
    }

    public function paymentSuccess($method, $module){}
    public function paymentCancel($module){
        return GatewayRedirect::canceled($module);
    }
    public function cryptoPaymentStatus($id){}

}
