<?php

namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Models\Gateway;
use App\Models\GatewayPayment;
use BaconQrCode\Renderer\GDLibRenderer;
use BaconQrCode\Writer;
use Illuminate\Support\Facades\URL;
use Illuminate\Validation\ValidationException;

class NowPayments implements PaymentGatewayInterface
{
    function initPayment($method, $data)
    {
        if (!$method->parameters) {
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        $params['price_amount'] = $data['amount'];
        $params['price_currency'] = tc()->get('currency');
        $params['pay_currency'] = strtoupper($method->currency);
        $params['ipn_callback_url'] = route('payment-callback', $method->name);
        $params['order_id'] = $data['trx'];
        $params['order_description'] = $data['module'];

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.nowpayments.io/v1/payment',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($params),
            CURLOPT_HTTPHEADER => ['x-api-key:' . $method->parameters->api_key, 'Content-Type: application/json'],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);

        $payment = json_decode($response, true);

        if (isset($payment['status']) && !$payment['status']) {
            throw ValidationException::withMessages([
                'error' => $payment['message'],
            ]);
        }

        $renderer = new GDLibRenderer(200);
        $writer = new Writer($renderer);
        $qrCodePng = $writer->writeString($payment['pay_address'] . '?amount=' . $payment['pay_amount']);

        $cryptoPayment = GatewayPayment::create([
            'user_id' => user()->id,
            'method_id' => $method->id,
            'payment_id' => $payment['payment_id'],
            'amount_received' => $payment['pay_amount'],
            'expiration_estimate_date' => $payment['expiration_estimate_date'],
            'pay_address' => $payment['pay_address'],
            'payment_status' => $payment['payment_status'],
            'qrcode' => base64_encode($qrCodePng),
            'currency' => $payment['pay_currency'],
            'trx' => $data['trx'],
        ]);

        $expireLink = URL::temporarySignedRoute(
            'crypto-payment-view', 
            now()->addMinutes(15), 
            ['trx' => $cryptoPayment->trx]
        );

        return ['type' => 'route', 'redirect' => $expireLink];
    }

    function paymentCallback($request, $data, $module)
    {
        $method = Gateway::find($data['gateway_id']);

        $payment = GatewayPayment::where('trx', $data['trx'])->first();

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://api.nowpayments.io/v1/payment/' . $payment->payment_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => ['x-api-key:' . $method->parameters->api_key],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);

        $res = json_decode($response, true);

        if ($res['payment_status'] == 'finished') {
            return GatewayRedirect::success($module);
        } else {
            return ['status' => false, 'message' => tt_trans('Please complete your payment first', cons()::LANGUAGE_NOTIFICATION),'type' => $data['type']];
        }
    }

    public function paymentSuccess($method, $module)
    {
    }
    public function paymentCancel($module)
    {
    }
    public function paymentCheck($request)
    {
    }
    public function cryptoPaymentStatus($id)
    {
    }
}
