<?php

namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Models\Gateway;
use Illuminate\Validation\ValidationException;
use Srmklive\PayPal\Services\PayPal as PayPalClient;

class Paypal implements PaymentGatewayInterface
{

    function initPayment($method, $data)
    {

        if(!$method->parameters){
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        config([
            'paypal.mode' => $method->parameters->mode,
            'paypal.sandbox.client_id' => $method->parameters->client_id,
            'paypal.sandbox.client_secret' => $method->parameters->client_secret,
            'paypal.sandbox.app_id' => 'APP-80W284485P519543T',
            'paypal.payment_action' => 'Sale',
            'paypal.currency' => $method->currency,
            'paypal.notify_url' => route('payment-callback', $method->name),
            'paypal.locale' => 'en_US',
            'paypal.validate_ssl' => true,
        ]);

        $provider = new PayPalClient();

        $paypalToken = $provider->getAccessToken();

        $response = $provider->createOrder([
            'intent' => 'CAPTURE',
            'application_context' => [
                'return_url' => route('payment-callback', $method->name),
                'cancel_url' => route('payment-cancel', $method->name),
            ],
            'purchase_units' => [
                0 => [
                    'amount' => [
                        'currency_code' => $method->currency,
                        'value' => $data['amount_in_gateway_currency'],
                    ],
                ],
            ],
        ]);

        if (isset($response['id']) && $response['id'] != null) {
            foreach ($response['links'] as $links) {
                if ($links['rel'] == 'approve') {
                    return ['type' => 'url', 'redirect' => $links['href']];
                }
            }
        }

        return ['status' => false, 'message' => tt_trans('Invalid Request', cons()::LANGUAGE_NOTIFICATION)];
    }

    function paymentCallback($request, $data, $module)
    {

        $method = Gateway::find($data['method_id']);

        $payloads['user'] = user();

        config([
            'paypal.mode' => $method->parameters->mode,
            'paypal.sandbox.client_id' => $method->parameters->client_id,
            'paypal.sandbox.client_secret' => $method->parameters->client_secret,
            'paypal.sandbox.app_id' => 'APP-80W284485P519543T',
            'paypal.payment_action' => 'Sale',
            'paypal.currency' => $method->currency,
            'paypal.notify_url' => route('payment-callback',$method->name),
            'paypal.locale' => 'en_US',
            'paypal.validate_ssl' => true,
        ]);


        $provider = new PayPalClient();
        $provider->setApiCredentials(config('paypal'));
        $provider->getAccessToken();

        $response = $provider->capturePaymentOrder($request->token);

        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
            return GatewayRedirect::success($module);
        } else {
            return ['status' => false, 'message' => tt_trans('Something went wrong', cons()::LANGUAGE_NOTIFICATION)];
            
        }
    }

    public function paymentSuccess($method, $module){}
    public function paymentCancel($module){}
    public function paymentCheck($request){}
    public function cryptoPaymentStatus($id){}
}
