<?php
namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Models\Gateway;
use Illuminate\Validation\ValidationException;

class Paystack implements PaymentGatewayInterface
{

    function initPayment($method, $data)
    {
       
        if(!$method->parameters){
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        return ['type' => 'route', 'redirect' => route('payment-view', $method->name)];
    }

    function paymentCheck($request)
    {
        $method = Gateway::where('name', $request['method'])->first();

        $secret_key = $method->parameters->secret_key;

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => "https://api.paystack.co/transaction/verify/".$request['reference'],
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_SSL_VERIFYHOST => 0,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => ["Authorization: Bearer $secret_key", 'Cache-Control: no-cache'],
        ]);
        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);

        $final_data = json_decode($response);

        return $final_data;
    }

    function paymentCallback($request,$data, $module)
    {
        return GatewayRedirect::success($module);
    }

    public function paymentSuccess($method, $module){}
    public function paymentCancel($module){
        return GatewayRedirect::canceled($module);
    }
    public function cryptoPaymentStatus($id){}
}
