<?php
namespace App\Gateways;

use Anand\LaravelPaytmWallet\Facades\PaytmWallet;
use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Models\Gateway;
use Illuminate\Validation\ValidationException;

class Paytm implements PaymentGatewayInterface
{
    function initPayment($method, $data)
    {
        if (!$method->parameters) {
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        $user = user();

        config([
            'services.paytm-wallet.env' => $method->parameters->mode == 'live' ? 'production' : 'local',
            'services.paytm-wallet.merchant_id' => $method->parameters->merchant_id,
            'services.paytm-wallet.merchant_key' => $method->parameters->merchant_key,
            'services.paytm-wallet.merchant_website' => 'WEBSTAGING',
            'services.paytm-wallet.channel' => 'WEB',
            'services.paytm-wallet.industry_type' => 'Retail',
        ]);

        $payment = PaytmWallet::with('receive');

        $payment->prepare([
            'order' => $data['trx'],
            'user' => $user->username,
            'mobile_number' => $user->mobile ?? '123456',
            'email' => $user->email,
            'amount' => $data['amount_in_gateway_currency'],
            'callback_url' => route('payment-callback', $method->name),
        ]);

        return ['type' => 'response', 'redirect' => $payment->receive()];
    }

    function paymentCallback($request, $data, $module)
    {

        $method = Gateway::find($data['method_id']);

        config([
            'services.paytm-wallet.env' => $method->parameters->mode == 'live' ? 'production' : 'local',
            'services.paytm-wallet.merchant_id' => $method->parameters->merchant_id,
            'services.paytm-wallet.merchant_key' => $method->parameters->merchant_key,
            'services.paytm-wallet.merchant_website' => 'WEBSTAGING',
            'services.paytm-wallet.channel' => 'WEB',
            'services.paytm-wallet.industry_type' => 'Retail',
        ]);

        $transaction = PaytmWallet::with('receive');

        try {
            $response = $transaction->response();
        } catch (\Exception $e) {
            return GatewayRedirect::paymentFailed($module);
        }


        if ($transaction->isSuccessful()) {
            return GatewayRedirect::success($module);

        } elseif ($transaction->isFailed()) {
            return GatewayRedirect::canceled($module);
        }
    }


    public function paymentSuccess($method, $module){}
    public function paymentCancel($module){
        return GatewayRedirect::canceled($module);
    }
    public function paymentCheck($request){}
    public function cryptoPaymentStatus($id){}

}
