<?php

namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Models\Gateway;
use Illuminate\Validation\ValidationException;

class PerfectMoney implements PaymentGatewayInterface
{

    function initPayment($method, $data)
    {

        if(!$method->parameters){
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        return ['type' => 'route', 'redirect' => route('payment-view', $method->name)];
    }

    function paymentCallback($request,$data, $module)
    {

        $method = Gateway::find($data['method_id']);

        $request = json_decode(json_encode($request->all()));

        $passphrase = strtoupper(md5($method->parameters->passphrase));

        define('ALTERNATE_PHRASE_HASH', $passphrase);
        define('PATH_TO_LOG', '/asset/');
        $string = $request->PAYMENT_ID . ':' . $request->PAYEE_ACCOUNT . ':' . $request->PAYMENT_AMOUNT . ':' . $request->PAYMENT_UNITS . ':' . $request->PAYMENT_BATCH_NUM . ':' . $request->PAYER_ACCOUNT . ':' . ALTERNATE_PHRASE_HASH . ':' . $request->TIMESTAMPGMT;

        $hash = strtoupper(md5($string));
        $hash2 = $request->V2_HASH;

        $amount = $request->PAYMENT_AMOUNT;
        $unit = $request->PAYMENT_UNITS;
        $transaction = $request->PAYMENT_ID;
        if ($request->PAYEE_ACCOUNT == $method->parameters->account_id && $unit == $method->currency && $amount == $data['amount_in_gateway_currency']) {
           return GatewayRedirect::success($module);
        } else {
            return GatewayRedirect::canceled($module);
        }
    }

    function paymentError($deposit, $method, $request){

        session()->forget('deposit');

        return ['status' => false, 'message' => tt_trans('Payment not completed', cons()::LANGUAGE_NOTIFICATION)];

    }

    public function paymentSuccess($method, $module){}
    public function paymentCancel($module){}
    public function paymentCheck($request){}
    public function cryptoPaymentStatus($id){}
}
