<?php

namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use App\Gateways\Lib\SslCommerz\SslCommerzNotification;
use Illuminate\Validation\ValidationException;

class SSLCommerz implements PaymentGatewayInterface
{
    
    function initPayment($method, $data)
    {
        $user = user();

        $post_data = [];
        $post_data['total_amount'] = $data['amount_in_gateway_currency']; # You cant not pay less than 10
        $post_data['currency'] = $method->currency;
        $post_data['tran_id'] = $data['trx']; // tran_id must be unique

        # CUSTOMER INFORMATION
        $post_data['cus_name'] = $user->full_name;
        $post_data['cus_email'] = $user->email;
        $post_data['cus_add1'] = $user->address->address;
        $post_data['cus_add2'] = '';
        $post_data['cus_city'] = $user->address->city;
        $post_data['cus_state'] = $user->address->state;
        $post_data['cus_postcode'] = $user->address->zip;
        $post_data['cus_country'] = $user->address->country;
        $post_data['cus_phone'] = $user->mobile;
        $post_data['cus_fax'] = '';

        # SHIPMENT INFORMATION
        $post_data['ship_name'] = tc()->get('sitename');
        $post_data['ship_add1'] = 'Dhaka';
        $post_data['ship_add2'] = 'Dhaka';
        $post_data['ship_city'] = 'Dhaka';
        $post_data['ship_state'] = 'Dhaka';
        $post_data['ship_postcode'] = '';
        $post_data['ship_phone'] = '';
        $post_data['ship_country'] = 'Bangladesh';

        $post_data['shipping_method'] = 'NO';
        $post_data['product_name'] = 'Deposit';
        $post_data['product_category'] = 'Deposit';
        $post_data['product_profile'] = 'add Balance';

        $post_data['value_a'] = $data['module'];


        if(!$method->parameters){
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        config([
            'sslcommerz.mode' => $method->parameters->mode == 'sandbox' ? 'sandbox' : 'live',
            'sslcommerz.apiCredentials.store_id' => $method->parameters->store_id,
            'sslcommerz.apiCredentials.store_password' => $method->parameters->store_password,
            'sslcommerz.apiDomain' => $method->parameters->mode == 'sandbox' ? 'https://sandbox.sslcommerz.com' : 'https://securepay.sslcommerz.com',
            'sslcommerz.connect_from_localhost' => $method->parameters->mode == 'sandbox' ? true : false,
            'sslcommerz.success_url' => route('payment-callback', $method->name),
            'sslcommerz.failed_url' => route('payment-cancel', $method->name),
            'sslcommerz.cancel_url' => route('payment-cancel', $method->name),
            'sslcommerz.ipn_url' => route('payment-callback', $method->name),
        ]);

        $sslc = new SslCommerzNotification();

        $payment_options = $sslc->makePayment($post_data, 'hosted');

        throw ValidationException::withMessages([
            'error' => $payment_options,
        ]);

    }

    function paymentCallback($request, $data, $module)
    {
        return GatewayRedirect::success($module);
    }

    public function paymentSuccess($method, $module){}
    public function paymentCancel($module){
        return GatewayRedirect::canceled($module);
    }
    public function paymentCheck($request){}
    public function cryptoPaymentStatus($id){}
}
