<?php

namespace App\Gateways;

use App\Constant\GatewayRedirect;
use App\Contracts\PaymentGatewayInterface;
use Illuminate\Validation\ValidationException;
use Stripe\Stripe as StripePayment;

class Stripe implements PaymentGatewayInterface
{
    function initPayment($method, $data)
    {
        if(!$method->parameters){
            throw ValidationException::withMessages([
                'error' => 'No Api key Found',
            ]);
        }

        StripePayment::setApiKey($method->parameters->secret_key);


        $amount = number_format((float)$data['amount_in_gateway_currency'], 2, '.', '')  * 100;


        $session = \Stripe\Checkout\Session::create([
            'payment_method_types' => ['card'],
            'line_items' => [
                [
                    'price_data' => [
                        'currency' => $method->currency,
                        'product_data' => [
                            'name' => "Payment"
                        ],
                        'unit_amount' => $amount,
                    ],
                    'quantity' => 1,
                ]
            ],
            'mode' => 'payment',
            'success_url' => route('payment-success', $method->name),
            'cancel_url' => route('payment-cancel',$method->name),
        ]);

        return ['type' =>'url','redirect' => $session->url];
    }

    public function paymentCallback($method, $data, $module){

    }
    public function paymentSuccess($method, $module){
        return GatewayRedirect::success($module);
        
    }
    public function paymentCancel($module){
        return GatewayRedirect::canceled($module);
    }
    public function paymentCheck($request){

    }
    public function cryptoPaymentStatus($id){

    }
}
