<?php

use App\Constant\Constant;
use App\Constant\Theme as ConstantTheme;
use App\Events\NotificationEvent;
use App\Gateways\Flutterwave;
use App\Gateways\NowPayments;
use App\Gateways\Paypal;
use App\Gateways\Paystack;
use App\Gateways\Paytm;
use App\Gateways\PerfectMoney;
use App\Gateways\SSLCommerz;
use App\Gateways\Stripe;
use App\Mail\SendMarkdownMail;
use App\Models\Admin;
use App\Models\Content;
use App\Models\Currency;
use App\Models\Deposit;
use App\Models\IcoSetting;
use App\Constant\MailTemplate;
use App\Models\Language;
use App\Models\Menu;
use App\Models\Page;
use App\Models\ReferralCommission;
use App\Models\ReferralSetting;
use App\Models\Stage;
use App\Models\StagePurchase;
use App\Models\Template;
use App\Models\Theme;
use App\Models\Transaction;
use App\Models\UserEarnings;
use App\Models\UserLogin;
use App\Notifications\AdminNotification;
use App\Notifications\UserNotification;
use App\Services\Backend\Settings\CacheSettingService;
use App\Utils\FormBuilder;
use App\Utils\Placeholder;
use Carbon\Carbon;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\File;
use Jackiedo\DotenvEditor\Facades\DotenvEditor;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Password;
use Jenssegers\Agent\Agent;
use Pusher\Pusher;
use Stevebauman\Location\Facades\Location;
use Nwidart\Modules\Facades\Module;

if (!function_exists('version')) {
    function version()
    {
        return tc()->get('current_version');
    }
}

if (!function_exists('css')) {
    function css($path, $loadfrom = 'common')
    {
        $module = config('app.theme_type');
        $addon = config('app.active_theme');

        if ($module == 'module' && $loadfrom == 'module') {
            $file = "project/Modules/{$addon}/resources/assets/css/{$path}";
            return asset($file);
        }

        if ($loadfrom == cons()::ASSETS_FROM_BACKEND) {
            return asset('files/css/backend/' . $path);
        } elseif ($loadfrom == cons()::ASSETS_FROM_FRONTEND) {
            return asset('files/css/frontend/' . currentActiveTemplate() . '/' . $path);
        } elseif ($loadfrom == cons()::ASSETS_FROM_INSTALLER) {
            return asset('files/css/installer/' . $path);
        } else {
            return asset('files/css/common/' . $path);
        }
    }
}

if (!function_exists('js')) {
    function js($path, $loadfrom = 'common')
    {
        $module = config('app.theme_type');
        $addon = config('app.active_theme');

        if ($module == 'module' && $loadfrom == 'module') {
            $file = "project/Modules/{$addon}/resources/assets/js/{$path}";

            return asset($file);
        }

        if ($loadfrom == cons()::ASSETS_FROM_BACKEND) {
            return asset('files/js/backend/' . $path);
        } elseif ($loadfrom == cons()::ASSETS_FROM_FRONTEND) {
            return asset('files/js/frontend/' . currentActiveTemplate() . '/' . $path);
        } elseif ($loadfrom == cons()::ASSETS_FROM_INSTALLER) {
            return asset('files/js/installer/' . $path);
        } else {
            return asset('files/js/common/' . $path);
        }
    }
}
if (!function_exists('currentActiveTemplate')) {
    function currentActiveTemplate()
    {
        $theme = Theme::where('is_active', 1)->first();

        return  $theme ? $theme->title : 'default';
    }
}

if (!function_exists('currentActiveTemplatePath')) {
    function currentActiveTemplatePath()
    {
        return resource_path('views/frontend/' . currentActiveTemplate());
    }
}

if (!function_exists('userLayouts')) {
    function userLayouts()
    {
        return resource_path('views/user/');
    }
}

if (!function_exists('cons')) {
    function cons()
    {
        return new Constant();
    }
}

if (!function_exists('tt_trans')) {
    function tt_trans($key, $type = 'frontend', $setkey = '')
    {


        $default = tc()->get('default_language') ?? 'en';

        if ($type == cons()::LANGUAGE_BACKEND) {
            if (!session('language')) {
                $path = resource_path('lang/' . $default . '/backend.php');
            } else {
                $path = resource_path('lang/' . session('language') . '/backend.php');
            }
        } elseif ($type == cons()::LANGUAGE_FRONTEND) {
            if (!session('language')) {
                $path = resource_path('lang/' . $default . '/frontend.php');
            } else {
                $path = resource_path('lang/' . session('language') . '/frontend.php');
            }
        } else {
            if (!session('language')) {
                $path = resource_path('lang/' . $default . '/notification.php');
            } else {
                $path = resource_path('lang/' . session('language') . '/notification.php');
            }
        }

        $oldLanguageArray = require $path;

        if ($setkey) {
            if (array_key_exists($setkey, $oldLanguageArray)) {
                return $oldLanguageArray[$setkey];
            }

            $oldLanguageArray[$setkey] = $key;

            $php = '<?php return ' . var_export($oldLanguageArray, true) . ';';

            file_put_contents($path, $php);
        } else {
            if (array_key_exists($key, $oldLanguageArray)) {
                return $oldLanguageArray[$key];
            }
            $oldLanguageArray[$key] = $key;

            $php = '<?php return ' . var_export($oldLanguageArray, true) . ';';

            file_put_contents($path, $php);
        }

        return $key;
    }
}

if (!function_exists('getActiveStage')) {
    function getActiveStage()
    {
        $stage = Stage::runningStage()->first();

        return [
            'stage' => $stage,
            'setting' => IcoSetting::first(),
            'currencies' => Currency::active()->get()
        ];
    }
}


if (!function_exists('storeFile')) {
    function storeFile($image, $folder, $removeImage = '')
    {

        $isModule = config('app.theme_type');

        $module = config('app.active_theme');

        if($isModule == 'module'){
            $path = "project/Modules/{$module}/resources/assets/image/{$folder}";
        }else{
            $path = cons()::IMAGE_UPLOAD_ROOT_PATH . $folder;
        }

        if ($folder == 'cms') {

            if($isModule == 'module'){
                $path = "project/Modules/{$module}/resources/assets/image/{$folder}";
            }else{
                $path = cons()::IMAGE_UPLOAD_ROOT_PATH . currentActiveTemplate() . '/' . $folder;
            }

        }


        if ($removeImage) {
            File::exists($path . '/' . $removeImage) ? unlink($path . '/' . $removeImage) : '';
        }

        $imageName = uniqid() . '-' . time() . '.' . $image->getClientOriginalExtension();

        $image->move($path, $imageName);

        return $imageName;
    }
}

if (!function_exists('placeholderImage')) {
    function placeholderImage($size, $text = '')
    {
        [$width, $height] = explode('x', $size);

        return Placeholder::image($width, $height, '243244246', '107114128', $text);
    }
}

if (!function_exists('getFile')) {
    function getFile($folder, $file, $size = '100x100', $from = '', $module = '')
    {
        if($from == 'module'){
            $moduleImagePath = "project/Modules/{$module}/resources/assets/image/{$folder}/{$file}";

            
            if (File::exists($moduleImagePath) && is_file($moduleImagePath)) {
                return asset($moduleImagePath);
            }else{
                return placeholderImage($size);
            }
        }

        $path = cons()::IMAGE_UPLOAD_ROOT_PATH . $folder . '/' . $file;

        if (in_array($folder, ['cms', 'constant_image', 'logo', 'icon'])) {
            $path = cons()::IMAGE_UPLOAD_ROOT_PATH . currentActiveTemplate() . '/' . $folder . '/' . $file;

            if (File::exists($path) && is_file($path)) {
                return asset(cons()::IMAGE_UPLOAD_ROOT_PATH . currentActiveTemplate() . '/' . $folder . '/' . $file);
            }
        }

        if (File::exists($path) && is_file($path)) {
            return asset(cons()::IMAGE_UPLOAD_ROOT_PATH . $folder . '/' . $file);
        }

        return placeholderImage($size);
    }
}

if (!function_exists('offsetPerPage')) {
    function offsetPerPage($paginate = '')
    {
        return $paginate ? $paginate : tc()->get('pagination');
    }
}

if (!function_exists('admin')) {
    function admin()
    {
        return auth()->guard('admin')->user();
    }
}

if (!function_exists('user')) {
    function user()
    {
        return auth()->user();
    }
}

if (!function_exists('tc')) {
    function tc()
    {
        $settings = new CacheSettingService();

        return $settings;
    }
}

if (!function_exists('imageValidation')) {
    function imageValidation()
    {
        return 'image|mimes:jpg,png,jpeg,webp|max:1024';
    }
}

if (!function_exists('formatter')) {
    function formatter($number, $type = 'fiat')
    {
        if ($type == cons()::FIAT) {
            return number_format($number, tc()->get('precision'), '.', '');
        }
        return number_format($number, 8, '.', '');
    }
}

if (!function_exists('activeTab')) {
    function activeTab($tab, $tabContent = false)
    {
        if ($tabContent) {
            return session('tab') == $tab ? 'show active' : '';
        }

        return session('tab') == $tab ? 'active' : '';
    }
}

if (!function_exists('clearCache')) {
    function clearCache()
    {
        Artisan::call('view:clear');
        Artisan::call('cache:clear');
        Artisan::call('optimize:clear');
    }
}

if (!function_exists('selectedOption')) {
    function selectedOption($expression)
    {
        return $expression ? 'selected' : '';
    }
}

if (!function_exists('setEnvironmentValue')) {
    function setEnvironmentValue(array $env)
    {
        $editor = DotenvEditor::load();

        foreach ($env as $key => $value) {
            $editor->setKey($key, $value);
        }

        $editor->save();
    }
}

if (!function_exists('status')) {
    function status($collection, $islight = '', $type = '')
    {
        $html = '';

        if (in_array($collection->status, [cons()::ACTIVE, cons()::ACCEPTED])) {
            $html .= '<span class="badge badge-' . $islight . 'success">' . ($type == 'deposit' ? tt_trans('Completed', cons()::LANGUAGE_BACKEND) : tt_trans('Active', cons()::LANGUAGE_BACKEND)) . '</span>';
        } elseif ($collection->status == cons()::PENDING) {
            $html .= '<span class="badge badge-' . $islight . 'warning">' . tt_trans('Pending', cons()::LANGUAGE_BACKEND) . '</span>';
        } elseif ($collection->status == cons()::REJECTED) {
            $html .= '<span class="badge badge-' . $islight . 'danger">' . tt_trans('Rejected', cons()::LANGUAGE_BACKEND) . '</span>';
        } else {
            $html .= '<span class="badge badge-' . $islight . 'danger">' . tt_trans('Inactive', cons()::LANGUAGE_BACKEND) . '</span>';
        }

        return $html;
    }
}

if (!function_exists('dateFormatter')) {
    function dateFormatter($date, $format = 'd M Y')
    {
        if ($date instanceof Carbon) {
            return $date->format($format);
        }
        return Carbon::parse($date)->format($format);
    }
}

if (!function_exists('commissionFormatter')) {
    function commissionFormatter($collection, $level)
    {
        if ($collection->type == cons()::FIXED) {
            return formatter($level->commission) . ' ' . tc()->get('currency');
        }

        return formatter($level->commission) . ' %';
    }
}

if (!function_exists('redirectAfterOperation')) {
    function redirectAfterOperation($response, $route = '')
    {
        if ($route) {
            if ($response['status']) {
                return to_route($route)->with('success', $response['message']);
            } else {
                return back()->with('error', $response['message']);
            }
        }

        if (!$response['status']) {
            return back()->with('error', $response['message']);
        }

        return back()->with('success', $response['message']);
    }
}

if (!function_exists('removeImage')) {
    function removeImage($collection, $folder)
    {
        if ($collection->image) {
            $image = cons()::IMAGE_UPLOAD_ROOT_PATH . currentActiveTemplate() . '/' . $folder . '/' . $collection->image;

            if (file_exists($image)) {
                unlink($image);
            }
        }
    }
}

if (!function_exists('customPagination')) {
    function customPagination($collections, $pagename = '')
    {
        $perPage = tc()->get('pagination');
        $currentPage = LengthAwarePaginator::resolveCurrentPage($pagename);
        $currentPageItems = $collections->slice(($currentPage - 1) * $perPage, $perPage)->toArray();
        $paginatedMessages = new LengthAwarePaginator($currentPageItems, $collections->count(), $perPage, $currentPage, ['path' => request()->url(), 'pageName' => $pagename]);
        return $paginatedMessages;
    }
}

if (!function_exists('translations')) {
    function translations($lang, $filename, $pagename = '')
    {
        $filePath = resource_path("lang/{$lang->code}/{$filename}");
        if (file_exists($filePath)) {
            $messagesArray = require $filePath;
            $collections = collect($messagesArray);
            return customPagination($collections, $pagename);
        }

        return customPagination(collect([]));
    }
}

if (!function_exists('languages')) {
    function languages()
    {
        return Language::all();
    }
}

if (!function_exists('selectedLanguage')) {
    function selectedLanguage()
    {
        $language = Language::where('code', app()->getLocale() ?? tc()->get('default_language'))->first();

        if (app()->getLocale() == 'en' || !$language) {
            return [
                'code' => 'en',
                'name' => 'English',
                'image' => getFile('constant_image', 'en.png'),
            ];
        }

        return [
            'code' => $language->code,
            'name' => $language->name,
            'image' => getFile('language', $language->image),
        ];
    }
}

if (!function_exists('hex2rgb')) {
    function hex2rgb($colour)
    {
        $colour = preg_replace('/[^abcdef0-9]/i', '', $colour);
        if (strlen($colour) == 6) {
            [$r, $g, $b] = str_split($colour, 2);
            return ['r' => hexdec($r), 'g' => hexdec($g), 'b' => hexdec($b)];
        } elseif (strlen($colour) == 3) {
            [$r, $g, $b] = [$colour[0] . $colour[0], $colour[1] . $colour[1], $colour[2] . $colour[2]];
            return ['r' => hexdec($r), 'g' => hexdec($g), 'b' => hexdec($b)];
        }
        return false;
    }
}

if (!function_exists('emailTemplate')) {
    function emailTemplate($key)
    {
        return Template::where('key', $key)->active()->first();
    }
}

if (!function_exists('sendPhpMail')) {
    function sendPhpMail($user, $subject, $message, $template)
    {
        $to = $user;
        $subject = $subject;
        $message = htmlspecialchars($message);
        $headers = 'From:' . tc()->get('email_configurations')['email_from'] . "\r\n" . 'Reply-To:' . tc()->get('email_configurations')['email_from'] . "\r\n" . 'X-Mailer: PHP/' . phpversion();

        if (mail($to, $subject, $message, $headers)) {
            return ['status' => true, 'message' => tt_trans('mail sent successfully!', cons()::LANGUAGE_NOTIFICATION)];
        } else {
            return ['status' => false, 'message' => tt_trans('Failed to send mail.', cons()::LANGUAGE_NOTIFICATION)];
        }
    }
}

if (!function_exists('sendSmtpMail')) {
    function sendSmtpMail($user, $subject, $message, $template)
    {

        Mail::to($user)->queue(new SendMarkdownMail($user, $subject, $message, $template));
    }
}

if (!function_exists('sendMail')) {
    function sendMail($user, $payloads, $template = null)
    {

        if ($template) {
            $message = $template->message;

            foreach ($payloads as $key => $value) {
                $message = str_replace('{' . $key . '}', $value, $message);
            }
        } else {
            $message = $payloads['message'];
        }

        if (tc()->get('is_smtp_mail')) {
            sendSmtpMail($user, $payloads['subject'] ?? $template->subject, $message, $template);
        } else {
            sendPhpMail($user, $payloads['subject'] ?? $template->subject, $message, $template);
        }
    }
}

if (!function_exists('getTrx')) {
    function getTrx($length = 15)
    {
        return strtoupper(Str::random($length));
    }
}

if (!function_exists('pushNotification')) {
    function pushNotification($data, $eventName = 'user-notification')
    {
        if (tc()->get('pusher_status')) {
            $pusher = new Pusher(tc()->get('pusher_app_key'), tc()->get('pusher_app_secret'), tc()->get('pusher_app_id'), [
                'cluster' => tc()->get('pusher_app_cluster'),
            ]);

            $pusher->trigger('notifications', $eventName, $data);
        }
    }
}

if (!function_exists('pushMessageNotification')) {
    function pushMessageNotification($data, $eventName = 'user-message')
    {
        if (tc()->get('pusher_status')) {
            $pusher = new Pusher(tc()->get('pusher_app_key'), tc()->get('pusher_app_secret'), tc()->get('pusher_app_id'), [
                'cluster' => tc()->get('pusher_app_cluster'),
            ]);

            $pusher->trigger('message-notification', $eventName, $data);
        }
    }
}

if (!function_exists('sendNotification')) {
    function sendNotification($data)
    {

        if ($data['receiver'] == 'admin-notification') {
            Notification::send(Admin::all(), new AdminNotification($data));

            return;
        }

        $data['user']->notify(new UserNotification($data));
    }
}

if (!function_exists('notifications')) {
    function notifications($type = '', $limit = 6)
    {

        return admin()->unreadNotifications()->get();
    }
}

if (!function_exists('getTone')) {
    function getTone()
    {
        $file = asset("files/sound/tone.wav");
        return $file;
    }
}

if (!function_exists('tt_front')) {
    function tt_front($key)
    {
        return tt_trans($key, cons()::LANGUAGE_FRONTEND);
    }
}

if (!function_exists('gatewayMethod')) {
    function gatewayMethod($name)
    {
        $methods = [
            'stripe' => new Stripe(),
            'paytm' => new Paytm(),
            'flutterwave' => new Flutterwave(),
            'nowpayments' => new NowPayments(),
            'paystack' => new Paystack(),
            'paypal' => new Paypal(),
            'perfectmoney' => new PerfectMoney(),
            'sslcommerz' => new SSLCommerz(),
        ];

        return $methods[$name];
    }
}

if (!function_exists('sendReferralCommission')) {
    function sendReferralCommission($whoInitiateTheTransaction, $amount, $transactionType)
    {
        $settings = ReferralSetting::where('name', $transactionType)->first();

        $levels = $settings->levels;

        $levelUser = $whoInitiateTheTransaction->referredUser?->parent;

        foreach ($levels as $level) {
            $commissionAmount = $settings->type == cons()::FIXED ? $level->commission : ($amount * $level->commission) / 100;

            if ($levelUser) {
                $levelUser->balance = $levelUser->balance + $commissionAmount;

                $levelUser->save();

                $trx = getTrx();

                $commission = ReferralCommission::create([
                    'who_initiate' => $whoInitiateTheTransaction->id,
                    'who_received' => $levelUser->id,
                    'trx' => $trx,
                    'amount' => $commissionAmount,
                ]);

                UserEarnings::create([
                    'trx' => $trx,
                    'user_id' => $levelUser->id,
                    'amount' => $commissionAmount,
                    'reason' => 'Referral Commission from ' . $level->name,
                ]);

                Transaction::create([
                    'user_id' => $levelUser->id,
                    'amount' => $commissionAmount,
                    'reason' => 'Referral Commission from ' . $level->name,
                    'trx' => $trx,
                    'type' => '+',
                    'currency' => tc()->get('currency'),
                    'formatter' => 2
                ]);

                $message = 'Referral Commission from ' . $whoInitiateTheTransaction->username;

                event(new NotificationEvent($commission, $levelUser, $message, 'referral_commission'));

                $levelUser = $levelUser->referredUser?->parent;
            }
        }
    }
}

if (!function_exists('buildReferralTree')) {
    function buildReferralTree($parent, $id)
    {
        $children = $parent->referrals;

        if ($children->isEmpty()) {
            return [];
        }

        $tree = [];

        foreach ($children as $child) {
            $tree[] = [
                'parent' => $id,
                'user' => $child->user,
                'children' => buildReferralTree($child->user, $id),
            ];
        }

        return $tree;
    }
}

if (!function_exists('showReferralTree')) {
    function showReferralTree($user, $id)
    {
        $referralTree = buildReferralTree($user, $id);

        return ['node' => ['parent' => $id, 'user' => $user, 'children' => $referralTree]];
    }
}

if (!function_exists('checkExtenstion')) {
    function checkExtenstion($extension)
    {
        if (!extension_loaded($extension)) {
            $isExtensionLoaded = false;
        } else {
            $isExtensionLoaded = true;
        }

        return $isExtensionLoaded;
    }
}

if (!function_exists('folderPermissionCheck')) {
    function folderPermissionCheck($permission)
    {
        $permissionStatus = substr(sprintf('%o', fileperms($permission)), -4);
        if ($permissionStatus >= '0755') {
            $response = true;
        } else {
            $response = false;
        }
        return $response;
    }
}

if (!function_exists('isInstalled')) {
    function isInstalled()
    {
        $config = require base_path('licence.php');

        return $config['is_installed'];
    }
}

if (!function_exists('formBuilder')) {
    function formBuilder()
    {
        return new FormBuilder();
    }
}

if (!function_exists('getContent')) {
    function getContent($section, $type, $isSingleColumn = false)
    {
        $theme = Theme::where('is_active', 1)->first();

        $content = Content::all();

        $query = $content
            ->where('section_name', $section)
            ->where('theme_id', $theme->id)
            ->where('type', $type);

        if ($type == cons()::CONTENT) {
            return $query->first();
        }

        if ($isSingleColumn) {
            return $query->latest()->first();
        }

        return $query;
    }
}

if (!function_exists('loginLog')) {
    function loginLog($user)
    {
        $agent = new Agent();

        UserLogin::create([
            'user_id' => $user->id,
            'ip_address' => request()->ip(),
            'location' => Location::get(request()->ip())?->countryName ?? 'Bangladesh',
            'browser' => $agent->browser(),
            'operating_system' => $agent->platform(),
        ]);
    }
}

if (!function_exists('getProjectVersions')) {
    function getProjectVersions()
    {
        return [
            '1.0' => [
                'previous_version' => 1.0,
                'next_version' => '',
            ]
        ];
    }
}

if (!function_exists('isUpgradeAvailable')) {
    function isUpgradeAvailable()
    {
        return false;
    }
}

if (!function_exists('httpPostRequest')) {
    function httpPostRequest($url, $data, $header)
    {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTP_VERSION, 'CURL_HTTP_VERSION_1_1');
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $server_output = curl_exec($ch);

        curl_close($ch);

        return $server_output;
    }
}

if (!function_exists('currentLanguage')) {
    function currentLanguage($code)
    {
        $language = app()->getLocale();

        if ($language) {
            return $code == $language ? 'active' : '';
        }

        return $code == tc()->get('default_language') ? 'active' : '';
    }
}

if (!function_exists('pendingDepositCounter')) {
    function pendingDepositCounter()
    {
        return Deposit::offlineDeposits()
            ->where('status', cons()::PENDING)
            ->count();
    }
}

if (!function_exists('pendingPaymentCounter')) {
    function pendingPaymentCounter()
    {
        return StagePurchase::where('status', cons()::PENDING)
            ->count();
    }
}

if (!function_exists('titleFormatter')) {
    function titleFormatter($fullString, $partialString)
    {
        $position = strpos($fullString, $partialString);

        if ($position !== false) {
            $before = substr($fullString, 0, $position);

            $matching = substr($fullString, $position, strlen($partialString));
            $after = substr($fullString, $position + strlen($partialString));

            $result = tt_front($before) . '<span>' . tt_front($matching) . '</span>' . tt_front($after);

            echo $result;
        } else {
            echo tt_front($fullString);
        }
    }
}

if (!function_exists('passwordValidation')) {
    function passwordValidation()
    {
        if (tc()->get('strong_password')) {
            return ['bail', 'required', Password::min(6)->mixedCase()->numbers()->symbols(), 'confirmed'];
        }

        return 'bail|required|confirmed';
    }
}

if (!function_exists('getEmailTemplate')) {
    function getEmailTemplate($template)
    {
        return view('mail.templates.' . $template);
    }
}



if (!function_exists('cms')) {
    function cms($section = null, $key = null, $type = 'content', $id = null, $trans = true)
    {
        $data = getContent($section, $type);

        if ($id) {
            $iscontent = Content::where('id', $id)->first();

            return $iscontent ? tt_front($iscontent->content->$key) : '';
        }

        if ($type == cons()::CONTENT) {
            if ($data) {
                if (!$trans) {
                    return $data->content->$key ?? '';
                }
                if (in_array($key, $data->image_keys)) {
                    return tt_front($data->content->$key) ?? '';
                }



                return tt_front($data->content->$key ?? '');
            } else {
                return '';
            }
        }

        return $data->isNotEmpty() ? $data : [];
    }
}

if (!function_exists('cms_view_path')) {
    function cms_view_path($section, $type = 'content')
    {
        $themeType = config('app.theme_type', 'core');
        $themeModule = config('app.active_theme', null);

        $activeTemplate = currentActiveTemplate();

        $modules = Module::all();

        foreach ($modules as $module) {
            $configValue = require base_path("Modules/$module/config/config.php");

            if (isset($configValue['has_cms'])) {
                $moduleClass = "Modules\\$module\\config\\ThemeConfig";
                
                if (class_exists($moduleClass) && method_exists($moduleClass, 'getSections')) {

                    $moduleSections = $moduleClass::getSections();

                    if(in_array($section, $moduleSections)){

                        $moduleViewPath = strtolower($module)."::backend.cms.sections.$section";

                        if (view()->exists($moduleViewPath)) {
                            return $moduleViewPath;
                        }
                    }
                }
            }
        }

        if ($type == cons()::ELEMENT) {
            if ($themeType === 'module' && $themeModule) {
                $moduleViewPath = strtolower($themeModule)."::backend.cms.elements.$section";

                if (view()->exists($moduleViewPath)) {
                    return $moduleViewPath;
                }
            }

            $coreViewPath = "backend.cms.$activeTemplate.elements.$section";

            if (view()->exists($coreViewPath)) {
                return $coreViewPath;
            }
        }

        if ($themeType === 'module' && $themeModule) {

            $moduleViewPath = strtolower($themeModule)."::backend.cms.sections.$section";



            if (view()->exists($moduleViewPath)) {
                return $moduleViewPath;
            }
        }

        $coreViewPath = "backend.cms.$activeTemplate.sections.$section";

        if (view()->exists($coreViewPath)) {
            return $coreViewPath;
        }

        return null; // Return null if the view doesn't exist
    }
}

if (!function_exists('isEmailVerificationCodeSend')) {
    function isEmailVerificationCodeSend()
    {
        $user = user();

        if (auth()->check() && !$user->ability->email_verified && tc()->get('email_ver')) {
            if ($user->send_at) {
                if ($user->send_at->addMinute()->gt(now())) {
                    return ['status' => true, 'message' => tt_trans('Please wait a minute before sending email', cons()::LANGUAGE_NOTIFICATION)];
                }
            }

            $token = rand(1, 999999);

            $user->verification_code = $token;

            $user->send_at = now();

            $user->save();

            event(new NotificationEvent($user, $user, '', 'email_verify'));

            return ['status' => true, 'message' => tt_trans('Please verify your account', cons()::LANGUAGE_NOTIFICATION)];
        }

        return ['status' => false, 'message' => ''];
    }
}

if (!function_exists('isInfobipEnabled')) {
    function isInfobipEnabled()
    {
        return tc()->get('infobip_status');
    }
}

if (!function_exists('isSmsVerified')) {
    function isSmsVerified($user)
    {
        return $user->ability->sms_verified && !tc()->get('sms_ver');
    }
}

if (!function_exists('canSendSms')) {
    function canSendSms($user)
    {
        if (!$user->send_at) {
            return true; // Can send SMS if there is no previous send time
        }

        return $user->send_at->addMinute()->lt(now());
    }
}

if (!function_exists('generateVerificationCode')) {
    function generateVerificationCode()
    {
        return rand(100000, 999999); // Ensure the token is always 6 digits
    }
}

if (!function_exists('sendSms')) {
    function sendSms($mobile, $token)
    {
        $message = urlencode('Your verification pin is ' . $token);
        $url = sprintf('https://api.infobip.com/api/v3/sendsms/plain?user=%s&password=%s&sender=%s&SMSText=%s&GSM=%s&type=longSMS', tc()->get('infobip_username'), tc()->get('infobip_password'), tc()->get('infobip_sender_number'), $message, $mobile);

        return file_get_contents($url);
    }
}

if (!function_exists('send')) {
    function updateUserVerification($user, $token)
    {
        $user->verification_code = $token;
        $user->send_at = now();
        $user->save();
    }
}

if (!function_exists('isSMSVerificationCodeSend')) {
    function isSMSVerificationCodeSend()
    {
        $user = user();

        if (!isInfobipEnabled() || isSmsVerified($user)) {
            return ['status' => false, 'message' => ''];
        }

        if (!canSendSms($user)) {
            return [
                'status' => true,
                'message' => tt_trans('Please wait a minute before sending sms', cons()::LANGUAGE_NOTIFICATION),
            ];
        }

        $token = generateVerificationCode();

        updateUserVerification($user, $token);

        return [
            'status' => true,
            'message' => tt_trans('Please verify your account', cons()::LANGUAGE_NOTIFICATION),
        ];
    }
}


if (!function_exists('gateway_success')) {
    function gateway_success($type)
    {
        if ($type == cons()::DEPOSIT) {
            return 'deposit-success';
        } elseif ($type == cons()::PAYMENT) {
            return 'payment.success';
        }
    }
}

if (!function_exists('gateway_cancel')) {
    function gateway_cancel($type)
    {
        if ($type == cons()::DEPOSIT) {
            return 'deposit-cancel';
        } elseif ($type == cons()::PAYMENT) {
            return 'payment.cancel';
        }
    }
}

if (!function_exists('symbol')) {
    function symbol($amount, $currency = null, $type = 'fiat')
    {
        if (!$currency) {
            $currency = tc()->get('currency');
        }

        if ($type == cons()::FIAT) {
            return number_format($amount, tc()->get('precision'), '.', '') . ' ' . $currency;
        }

        return number_format($amount, 8) . ' ' . $currency;
    }
}

if (!function_exists('builder')) {
    function builder(array $builderProps)
    {
        return formBuilder()->buildHtml($builderProps);
    }
}


if (!function_exists('menus')) {
    function menus()
    {
        return Menu::withoutHome()->active()->header()->get();
    }
}

if (!function_exists('authMenus')) {
    function authMenus()
    {
        return Menu::footer()->active()->get();
    }
}

if (!function_exists('menuActive')) {
    function menuActive($routes, $activeClass = 'active')
    {

        $currentRoute = request()->route()->getName();
        if ($currentRoute == "page") {
            if ($routes == request()->route("page")) {
                return $activeClass;
            }
        }
        $isActive = is_array($routes)
            ? collect($routes)->contains(fn($route) => Str::is($route, $currentRoute))
            : Str::is($routes, $currentRoute);


        return $isActive ? $activeClass : '';
    }
}


if (!function_exists('mailTemplate')) {
    function mailTemplate($key = null)
    {
        $obj = new MailTemplate($key);
        return $obj->getTemplate();
    }
}


if (!function_exists('bannerOrBreadcrumb')) {
    function bannerOrBreadcrumb()
    {
        $route = request()->route()->getName();

        if ($route === 'home') {
            return view('frontend::sections.banner');
        }

        if (in_array($route, cons()::ROUTE_WITHOUT_BREADCRUMB)) {
            return false;
        }

        $path = $route === 'page' ? ucwords(request()->route('page')) : ucwords(str_replace('.', ' ', strtolower($route)));

        return view('frontend::partials.breadcrumb', ['path' => str_replace('-', ' ', $path)]);
    }
}


if (!function_exists('stageStatus')) {
    function stageStatus($id)
    {
        $stage = Stage::find($id);

        if (!$stage) {
            return [
                'status' => false
            ];
        }

        $time = now();

        if ($time->greaterThanOrEqualTo($stage->end_date)) {
            return [
                'status' => false,
                'is_buy' => false,
                'message' => 'Expired'
            ];
        }

        if ($time->greaterThanOrEqualTo($stage->start_date)) {
            return [
                'status' => true,
                'is_buy' => true,
                'message' => 'Open'
            ];
        }

        if ($time->lessThan($stage->start_date)) {
            return [
                'status' => true,
                'is_buy' => false,
                'message' => 'Coming'
            ];
        }

        return [
            'status' => false,
            'message' => 'Unknown'
        ];
    }
}

if (!function_exists('footerMenuBuilder')) {
    function footerMenuBuilder($dividerClass = 'col-lg-3 col-6')
    {
        // Fetch footer content
        $content = cms('footer', type: cons()::ELEMENT);

        $output = '';

        foreach ($content as $element) {
            $output .= '<div class="' . $dividerClass . '">';
            $output .= '<h4 class="title">' . tt_front($element->content->title) . '</h4>';
            $output .= '<ul class="it-footer-list-menu">';

            foreach ($element->content->menus as $id) {

                $page = Page::where('id', $id)->first();
                if ($page) {
                    $link = $page->slug == 'home' && $page ? route('home') : route('page', $page->slug);

                    $title = $page ? $page->name : '';
                    $output .= '<li><a href="' . htmlspecialchars($link) . '">' . htmlspecialchars(tt_front($title)) . '</a></li>';
                }
            }

            $output .= '</ul>';
            $output .= '</div>';
        }

        // Output the final HTML
        return $output;
    }
}

if (!function_exists('referrals')) {
    function referrals()
    {
        $setting = ReferralSetting::with('levels')
            ->where('name', cons()::REFERRAL)
            ->first();

        if (!$setting) {
            return [];
        }

        return $setting->levels;
    }
}

if (!function_exists('footer_menu')) {
    function footer_menu()
    {
        return Menu::where('type', cons()::FOOTER_MENU)->get();
    }
}


if (!function_exists('selectableSection')) {
    function selectableSection()
    {
        $themeType = config('app.theme_type', 'core');
        $themeModule = config('app.active_theme', null);

        $sections = sections()['sections'];

        $fixed_sections = sections()['fixed_position_sections'];

        $sections = array_diff_key($sections, array_flip($fixed_sections));

        if ($themeType === 'module' && $themeModule) {
            $moduleClass = "Modules\\$themeModule\\config\\ThemeConfig";

            if (class_exists($moduleClass) && method_exists($moduleClass, 'getSections')) {
                $moduleSections = $moduleClass::getSections();
                $sections = array_merge($sections, $moduleSections);
            }
        }

        $modules = Module::all();

        foreach ($modules as $module) {
            $configValue = require base_path("Modules/$module/config/config.php");

            if (isset($configValue['has_cms'])) {
                $moduleClass = "Modules\\$module\\config\\ThemeConfig";

                if (class_exists($moduleClass) && method_exists($moduleClass, 'getSections')) {
                    $moduleSections = $moduleClass::getSections();
                    $sections = array_merge($sections, $moduleSections);
                }
            }
        }

        $sections = array_unique($sections);

        return $sections;
    }
}


if (!function_exists('getThemeSideBar')) {
    function getThemeSideBar()
    {
        $themeType = config('app.theme_type', 'core');
        $themeModule = config('app.active_theme', null);

        $sections = sections()['sections'];

        if ($themeType === 'module' && $themeModule) {
            $moduleClass = "Modules\\$themeModule\\config\\ThemeConfig";

            if (class_exists($moduleClass) && method_exists($moduleClass, 'getSections')) {
                $moduleSections = $moduleClass::getSections();
                $sections = array_merge($sections, $moduleSections);
            }
        }

        $modules = Module::all();

        foreach ($modules as $module) {
            $configValue = require base_path("Modules/$module/config/config.php");

            if (isset($configValue['has_cms'])) {
                $moduleClass = "Modules\\$module\\config\\ThemeConfig";

                if (class_exists($moduleClass) && method_exists($moduleClass, 'getSections')) {
                    $moduleSections = $moduleClass::getSections();
                    $sections = array_merge($sections, $moduleSections);
                }
            }
        }

        $sections = array_unique($sections);

        $sidebarHtml = '';
        foreach ($sections as $sectionItem) {
            $sidebarHtml .=
                '<li>
                <a href="' .
                route('panel.content', $sectionItem) .
                '">' .
                tt_trans(ucwords(str_replace('_', ' ', $sectionItem)) . ' Section', cons()::LANGUAGE_BACKEND) .
                '</a>
            </li>';
        }

        return $sidebarHtml;
    }
}




if (!function_exists('sections')) {
    function sections()
    {
        $theme = new ConstantTheme();

        return $theme::THEMES[currentActiveTemplate()];
    }
}



if (!function_exists('getModuleSidebarMenus')) {
    function getModuleSidebarMenus($type = 'backend')
    {
        $modulesFilePath = 'project/modules_statuses.json';

        if (!file_exists($modulesFilePath)) {
            return '';
        }

        $modulesJson = file_get_contents($modulesFilePath);

        $modules = json_decode($modulesJson, true);

        if (json_last_error() !== JSON_ERROR_NONE) {
            return '';
        }

        $menus = '';

        foreach ($modules as $key => $module) {
            $viewPath = strtolower($key) . '::' . $type . '.sidebar';
            
            if (View::exists($viewPath)) {
                $menus .= view($viewPath);
            }
        }
        

        return $menus;
    }
}

if (!function_exists('getModule')) {
    function getModule($module)
    {
        return Module::find($module);
    }
}


if (!function_exists('theme_view')) {
    function theme_view($view, $data = [])
    {
        $theme = config('settings.active_theme', 'default');
        $themeType = config('settings.theme_type', 'core');
        $themeModule = config('settings.theme_module', null);

        if ($themeType === 'module' && $themeModule) {
            $moduleViewPath = "$themeModule::frontend.$theme.$view";
            if (view()->exists($moduleViewPath)) {
                return view($moduleViewPath, $data);
            }
        } else {
            $coreViewPath = "frontend.$theme.$view";
            if (view()->exists($coreViewPath)) {
                return view($coreViewPath, $data);
            }
        }
        return abort(404, 'Theme view not found');
    }
}


if (!function_exists('renderSections')) {
    function renderSections($section)
    {

        $html = '';

        $moduleArray = explode('_', $section->name, 2);

        $moduleName = ucwords($moduleArray[0]);

        $isModule = Module::has($moduleName);

        $moduleIsActive = false;

        if ($isModule) {
            $moduleIsActive = getModule($moduleName)->isEnabled();
        }

        if ($moduleIsActive && $isModule) {

            $path = strtolower($moduleName) . '::frontend.cms.' . $section->name;

            if(View::exists($path)){
                $html .= view($path)->render();
            }

        } else {

            $path = 'frontend::cms.' . $section->name;

            if(View::exists($path)){
                $html .= view($path)->render();
            }
        }

        return $html;

    }
}




if (!function_exists('editor_data')) {
    function editor_data($type = 'others', $section = '', $id = '')
    {

        $purifier = new \HTMLPurifier();


        $language = selectedLanguage();

        if ($type == 'others') {
            $data = json_decode(json_encode($section), true);


            return htmlspecialchars_decode($purifier->purify($data[$language['code']]['description'])) ?? '';
        }

        $content = getContent($section, cons()::CONTENT);


        if ($id) {
            $iscontent = Content::where('id', $id)->first();

            if ($iscontent) {

                $data = json_decode(json_encode($iscontent->content->editor_data), true);

                return htmlspecialchars_decode($purifier->purify($data[$language['code']]['description'])) ?? '';
            }
        }

        if ($content) {
            $data = json_decode(json_encode($iscontent->content->editor_data), true);
            return htmlspecialchars_decode($purifier->purify($data[$language['code']]['description'])) ?? '';
        }

        return '';
    }
}

if (!function_exists('tt_back')) {
    function tt_back($key)
    {
        return tt_trans($key, cons()::LANGUAGE_BACKEND);
    }
}
