<?php

namespace App\Http\Controllers\Backend\Admins;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Staff\StoreRequest;
use App\Http\Requests\Backend\Staff\UpdateRequest;
use App\Models\Admin;
use App\Services\Backend\Staff\StaffService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;

class AdminController extends Controller
{
    function __construct(){
        $this->middleware('permission:manage_staffs,admin');
    }
    
    function index(){
        $payloads['roles'] = Role::where('name','!=','admin')->latest()->get();

        $payloads['admins'] = Admin::with('roles')->latest()->isNotSuperAdmin()->paginate(offsetPerPage());

        return view('backend.staffs.index')->with($payloads);
    }

    function store(StoreRequest $storeRequest, StaffService $staffService){

        $payloads = $storeRequest->validated();

        try {
            DB::beginTransaction();
            $response = $staffService->storeStaff($payloads);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

       return redirectAfterOperation($response);
    }


    public function getOptions(Request $request)
    {
        $payloads['admin'] = Admin::find($request->admin);

        $payloads['roles'] = Role::latest()->get();

        return view('backend.staffs.roles')->with($payloads);
    }

    function update(UpdateRequest $updateRequest, StaffService $staffService, $id){

        $payloads = $updateRequest->validated();

        $admin = Admin::findOrFail($id);

        try {
            DB::beginTransaction();
            $response = $staffService->updateStaffInfo($payloads, $admin);
            DB::commit();
        }catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

       return redirectAfterOperation($response);

    }

    function destroy(StaffService $staffService, $id){
        $admin = Admin::findOrFail($id);
        try {
            DB::beginTransaction();
            $response = $staffService->delete($admin);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

       return redirectAfterOperation($response);
    }
}
