<?php

namespace App\Http\Controllers\Backend\Auction;

use App\Filters\DateFilter;
use App\Filters\StageFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Models\Auction;
use App\Models\AuctionPurchase;
use Illuminate\Support\Facades\DB;

class AuctionController extends Controller
{


    function __construct()
    {
        $this->middleware('permission:manage_auction,admin');
    }
    public function history()
    {
        $payloads['history'] = AuctionPurchase::filter([TrxFilter::class, DateFilter::class])->latest()->paginate(offsetPerPage());
        return view('backend.auction.history')->with($payloads);
    }

    public function runningAuction()
    {
        $payloads['auctions'] = Auction::active()->filter([DateFilter::class])->latest()->paginate(offsetPerPage());
        return view('backend.auction.running')->with($payloads);
    }
}
