<?php

namespace App\Http\Controllers\Backend\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Auth\CodeVerifyRequest;
use App\Http\Requests\Backend\Auth\ForgotPasswordRequest;
use App\Http\Requests\Backend\Auth\ResetPasswordRequest;
use App\Services\Backend\Auth\AuthenticationService;

class ForgotPasswordController extends Controller
{
    function forgotPassword(){
        return view('backend.auth.forgot_password');
    }

    function sendResetCode(ForgotPasswordRequest $forgotPasswordRequest, AuthenticationService $authenticationService){

        $payloads = $forgotPasswordRequest->validated();

        try {
            $response = $authenticationService->sendResetCode($payloads);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }

         return redirectAfterOperation($response, 'panel.verify-code');
    }

    function verifyCode(){
        return view('backend.auth.verify_code');
    }

    function verifyCodeConfirmation(CodeVerifyRequest $codeVerifyRequest, AuthenticationService $authenticationService){
        $payloads = $codeVerifyRequest->validated();

        try {
            $response = $authenticationService->codeVerify($payloads);
        } catch (\Throwable $th) {
           return redirect()->route('panel.forgot-password')->with('error', $th->getMessage());
        }

         return redirectAfterOperation($response, 'panel.reset-password');

    }

    function resetPassword(){
        return view('backend.auth.reset_password');
    }

    function resetPasswordConfirmation(ResetPasswordRequest $resetPasswordRequest, AuthenticationService $authenticationService){
        $payloads = $resetPasswordRequest->validated();

        try {
            $response = $authenticationService->resetPassword($payloads);
        } catch (\Throwable $th) {
            return redirect()->back()->with('error', $th->getMessage());
        }

         return redirectAfterOperation($response, 'panel.login');
    }
}
