<?php

namespace App\Http\Controllers\Backend\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Auth\LoginRequest;
use App\Services\Backend\Auth\AuthenticationService;

class LoginController extends Controller
{
    function loginPage()
    {
        return view('backend.auth.login');
    }

    function login(LoginRequest $loginRequest, AuthenticationService $authenticationService)
    {
        $payloads = $loginRequest->validated();

        try {
            $response = $authenticationService->login($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response, 'panel.dashboard');
        
    }
}
