<?php

namespace App\Http\Controllers\Backend\Blog;

use App\Filters\NameFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Blog\CategoryStoreRequest;
use App\Http\Requests\Backend\Blog\CategoryUpdateRequest;
use App\Models\BlogCategory;
use App\Services\Backend\Blog\CategoryService;

class BlogCategoryController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_blogs,admin');
    }

    function index()
    {
        $payloads['categories'] = BlogCategory::latest()
            ->filter([NameFilter::class])
            ->paginate(offsetPerPage());
        return view('backend.blog_categories.index')->with($payloads);
    }

    function store(CategoryStoreRequest $categoryStoreRequest, CategoryService $categoryService)
    {
        $payloads = $categoryStoreRequest->validated();

        try {
            $response = $categoryService->addCategory($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }
        return redirectAfterOperation($response);
    }

    function update(CategoryUpdateRequest $categoryUpdateRequest, CategoryService $categoryService, $id)
    {
        $payloads = $categoryUpdateRequest->validated();

        $category = BlogCategory::findOrFail($id);

        try {
            $response = $categoryService->updateCategory($payloads, $category);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }
        return redirectAfterOperation($response);
    }

    function destroy(CategoryService $categoryService, $id)
    {
        $category = BlogCategory::findOrFail($id);
        try {
            $response = $categoryService->deleteCategory($category);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }
        return redirectAfterOperation($response);
    }
}
