<?php
namespace App\Http\Controllers\Backend\Cms;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Cms\ContentUpdateRequest;
use App\Models\Content;
use App\Services\Backend\Cms\ContentManagementService;
use Illuminate\Support\Facades\Cache;

class ContentManagementController extends Controller
{
    function __construct()
    {
        return $this->middleware('permission:manage_frontend,admin');
    }

    function content($section)
    {
        $viewPath = cms_view_path($section);


        if ($viewPath) {
            return view($viewPath);
        }

        abort(404, "Section view not found: $section");
    }

    function contentCreate($section)
    {
        $viewPath = cms_view_path($section, cons()::ELEMENT);

        if ($viewPath) {
            return view($viewPath);
        }

        abort(404, "Section view not found: $section");
    }

    function contentStore(ContentUpdateRequest $contentUpdateRequest, ContentManagementService $contentManagementService, $section)
    {
        $response = $contentManagementService->updateContent($contentUpdateRequest->validated(), $section);
        try {
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        Cache::forget('cachedContent');

        return redirectAfterOperation($response);
    }

    function contentUpdate(ContentUpdateRequest $contentUpdateRequest, ContentManagementService $contentManagementService, $section)
    {
        $payloads = $contentUpdateRequest->validated();

        try {
            $response = $contentManagementService->updateContent($payloads, $section, getContent($section, cons()::CONTENT));
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        Cache::forget('cachedContent');

        clearCache();

        return redirectAfterOperation($response);
    }

    function elementEdit($id)
    {
        $payloads['element'] = Content::findOrFail($id);


        $viewPath = cms_view_path($payloads['element']->section_name, cons()::ELEMENT);

        if ($viewPath) {
            return view($viewPath)->with($payloads);
        }

        abort(404, "Section view not found:".$payloads['element']->section_name."");



        return view('backend.cms.' . currentActiveTemplate() . '.elements.' . $payloads['element']->section_name)->with($payloads);
    }

    function elementUpdate(ContentUpdateRequest $contentUpdateRequest, ContentManagementService $contentManagementService, $id)
    {
        $payloads = $contentUpdateRequest->validated();

        $element = Content::findOrFail($id);

        try {
            $response = $contentManagementService->updateContent($payloads, $element->section_name, $element);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        Cache::forget('cachedContent');

        return redirectAfterOperation($response);
    }

    function contentDelete($id)
    {
        $element = Content::findOrFail($id);

        if ($element->image_keys) {
            foreach ($element->image_keys as $value) {
                $image = cons()::IMAGE_UPLOAD_ROOT_PATH . 'cms/' . $element->content->$value;

                if (file_exists($image)) {
                    unlink($image);
                }
            }
        }

        $element->delete();

        Cache::forget('cachedContent');

        return back()->with('success', tt_trans('Record Deleted Successfully', cons()::LANGUAGE_NOTIFICATION));
    }
}
