<?php

namespace App\Http\Controllers\Backend\Deposit;

use App\Filters\DateFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Deposit\DepositRejectRequest;
use App\Models\Deposit;
use App\Services\Backend\Deposit\DepositService;

class ManageDepositController extends Controller
{
    function __construct(){
        $this->middleware('permission:manage_deposits,admin');
    }
    
    function offlineDeposits()
    {
        $payloads['deposits'] = Deposit::latest()
            ->filter([TrxFilter::class, DateFilter::class])
            ->with(['user', 'method'])
            ->offlineDeposits()
            ->paginate(offsetPerPage());

        return view('backend.deposits.offline')->with($payloads);
    }

    function offlineDepositDetails($id)
    {
        $payloads['deposit'] = Deposit::with(['user', 'method'])->findOrFail($id);

        return view('backend.deposits.details')->with($payloads);
    }

    function offlineDepositAccept($id, DepositService $depositService)
    {
        $deposit = Deposit::with(['user', 'method'])->findOrFail($id);

        try {
            $response = $depositService->acceptDeposit($deposit);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function offlineDepositReject(DepositRejectRequest $depositRejectRequest, DepositService $depositService, $id)
    {
        $payloads = $depositRejectRequest->validated();

        $deposit = Deposit::with(['user', 'method'])->findOrFail($id);

        try {
            $response = $depositService->rejectDeposit($deposit, $payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function onlineDeposits()
    {
        $payloads['deposits'] = Deposit::latest()
            ->filter([TrxFilter::class, DateFilter::class])
            ->with(['user', 'method'])
            ->onlineDeposits()
            ->paginate(offsetPerPage());

        return view('backend.deposits.online')->with($payloads);
    }

    function onlineDepositDetails($id){
        $deposit = Deposit::findOrFail($id);

        return view('backend.deposits.online_deposit_details',compact('deposit'));

    }
}
