<?php

namespace App\Http\Controllers\Backend\Email;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Email\EmailConfigUpdate;
use App\Models\Template;
use App\Services\Backend\Settings\SettingsService;

class EmailConfigurationController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_email,admin');
    }

    function emailConfig()
    {
        $payloads['templates'] = Template::latest()->where('is_editable_template', true)->paginate(offsetPerPage());

        return view('backend.email.index')->with($payloads);
    }

    function emailConfigUpdate(EmailConfigUpdate $emailConfigUpdate, SettingsService $settingsService)
    {
        $payloads = $emailConfigUpdate->validated();

        clearCache();

        try {
            $response = $settingsService->updateEmailConfig($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }
        return redirectAfterOperation($response);
    }
}
