<?php

namespace App\Http\Controllers\Backend\Email;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Email\EmailTemplateUpdate;
use App\Models\Template;
use App\Services\Backend\Email\EmailTemplateService;

class EmailTemplateController extends Controller
{

    function __construct()
    {
        $this->middleware('permission:manage_email,admin');
    }


    function emailTemplate($key)
    {
        $payloads['template'] = Template::where('key', $key)->firstOrFail();
        $payloads['setting'] = mailTemplate($key);
        return view('backend.email.edit_template')->with($payloads);
    }

    function emailTemplateUpdate(EmailTemplateUpdate $emailTemplateUpdate, EmailTemplateService $emailTemplateService, $key)
    {
        $payloads = $emailTemplateUpdate->validated();
        $template = Template::where('key', $key)->firstOrFail();

        try {
            $response = $emailTemplateService->updateTemplate($payloads, $template);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }
        return redirectAfterOperation($response);
    }
}
