<?php

namespace App\Http\Controllers\Backend\Gateway;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Gateway\CreateGatewayRequest;
use App\Http\Requests\Backend\Gateway\EditGatewayRequest;
use App\Http\Requests\Backend\Gateway\GatewayUpdateRequest;
use App\Models\Gateway;
use App\Services\Backend\Gateway\GatewayService;

class GatewayController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_gateways,admin');
    }

    function gateways(){

        $payloads['gateways'] = Gateway::latest()->online()->get();

        return view('backend.gateways.gateways')->with($payloads);
    }

    function gatewayEdit($id){
        $payloads['gateway'] = Gateway::findOrFail($id);

        if($payloads['gateway']->gateway_type == cons()::OFFLINE_GATEWAY){
            return view('backend.gateways.offline-edit')->with($payloads);
        }

        return view('backend.gateways.edit')->with($payloads);
    }

    function gatewayUpdate(GatewayUpdateRequest $gatewayUpdateRequest, GatewayService $gatewayService, $id){

        $payloads = $gatewayUpdateRequest->validated();

        $gateway = Gateway::findOrFail($id);
        
        try {
            $response = $gatewayService->updateGateway($payloads, $gateway);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function offlineGateways(){
        $payloads['gateways'] = Gateway::latest()->offline()->get();

        return view('backend.gateways.gateways')->with($payloads);
    }

    function offlineGatewayCreate(){
        return view('backend.gateways.offline-create');
    }

    function offlineGatewayStore(CreateGatewayRequest $createGatewayRequest, GatewayService $gatewayService){
        $payloads = $createGatewayRequest->validated();

        try {
            $response = $gatewayService->createGateway($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response,'panel.offline-gateways');
    }


    function offlineGatewayUpdate(EditGatewayRequest $editGatewayRequest, GatewayService $gatewayService, $id) {
        $payloads = $editGatewayRequest->validated();
        $gateway = Gateway::findOrFail($id);
        try {
            $response = $gatewayService->updateGateway($payloads, $gateway);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
