<?php

namespace App\Http\Controllers\Backend\IcoSetting;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\IcoSetting\IcoSettingRequest;
use App\Models\Currency;
use App\Models\IcoSetting;
use App\Services\Backend\IcoSetting\IcoSettingService;
use Illuminate\Support\Facades\DB;

class IcoSettingController extends Controller
{
    public function setting()
    {
        $payloads['setting'] = IcoSetting::first();
        $payloads['currencies'] = Currency::active()->get();
        return view('backend.ico_setting.setting')->with($payloads);
    }

    public function settingUpdate(IcoSettingRequest $request, IcoSettingService $service)
    {
        $payloads = $request->validated();

        try {
            DB::beginTransaction();
            $response = $service->storeOrUpdate($payloads);
            DB::commit();
        } catch (\Throwable $th) {
            return redirect()->back()->withErrors(['message' => $th->getMessage()]);
        }
        return redirectAfterOperation($response);
    }
}
