<?php

namespace App\Http\Controllers\Backend\Kyc;

use App\Filters\DateFilter;
use App\Filters\SortFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Kyc\KycRejectRequest;
use App\Models\KycRequest;
use App\Models\KycSetting;
use App\Services\Backend\Kyc\KycRequestService;
use Illuminate\Support\Facades\DB;

class KycRequestController extends Controller
{

    function __construct(){
        $this->middleware('permission:manage_kyc_request,admin');
    }

    function kycVerificationRequest()
    {

        $payloads['kycrequests'] = KycRequest::latest()->filter([SortFilter::class,DateFilter::class])->with('user')->paginate(offsetPerPage());
        $payloads['pending_kyc_request'] = KycRequest::pending()->count();
        $payloads['accept_kyc_request'] = KycRequest::accept()->count();
        $payloads['reject_kyc_request'] = KycRequest::reject()->count();
        return view('backend.kyc.index')->with($payloads);
    }

    function kycVerificationDetails($id)
    {
        $payloads['kyc'] = KycRequest::findOrFail($id);
        $payloads['settings'] = KycSetting::latest()->get();

        return view('backend.kyc.details')->with($payloads);
    }

    function kycVerificationAccept($id, KycRequestService $kycRequestService)
    {
        $kyc = KycRequest::findOrFail($id);

        try {
            DB::beginTransaction();
            $response = $kycRequestService->verifyKycRequest($kyc);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function kycVerificationReject(KycRejectRequest $kycRejectRequest,KycRequestService $kycRequestService, $id)
    {

        $payloads = $kycRejectRequest->validated();

        $kyc = KycRequest::findOrFail($id);


        try {
            DB::beginTransaction();
            $response = $kycRequestService->rejectKycRequest($payloads, $kyc);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
