<?php

namespace App\Http\Controllers\Backend\Menu;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Menu\UpdateRequest;
use App\Models\Menu;
use App\Models\Page;
use App\Services\Backend\Menu\MenuService;
use Illuminate\Support\Facades\DB;

class MenuController extends Controller
{

    function __construct(){
        $this->middleware('permission:manage_menus,admin');
    }


    function menu()
    {
        $payloads['pages'] = Page::latest()->active()->get();
        $payloads['headerMenus'] = Menu::latest()->header()->get();
        $payloads['footerMenus'] = Menu::latest()->footer()->get();

        return view('backend.menu.index')->with($payloads);
    }

    function menuUpdate(UpdateRequest $updateRequest, MenuService $menuService)
    {
        $payloads = $updateRequest->validated();

        try {
            DB::beginTransaction();
            $response = $menuService->updateMenu($payloads);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }
        return redirectAfterOperation($response);
    }
}
