<?php

namespace App\Http\Controllers\Backend\Notification;

use App\Http\Controllers\Controller;

class NotificationController extends Controller
{

    function __construct(){
        $this->middleware('permission:manage_notifications,admin');
    }

    function notifications(){
        return view('backend.notification.index');
    }

    function notificationMarkAsRead($id){

        $notification = admin()->unreadNotifications()->where('id', $id)->first();

        $notification->markAsRead();

        return ['status' => true, 'message' => tt_trans('Mark as read',cons()::LANGUAGE_NOTIFICATION)];
    }
}
