<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Admin\PasswordUpdateRequest;
use App\Http\Requests\Backend\Admin\ProfileUpdateRequest;
use App\Models\Auction;
use App\Models\AuctionPurchase;
use App\Models\Deposit;
use App\Models\Stage;
use App\Models\StagePurchase;
use App\Models\Support;
use App\Models\User;
use App\Models\UserEarnings;
use App\Models\Withdraw;
use App\Services\Backend\Admin\AdminProfileUpdate;
use Illuminate\Support\Facades\DB;

class PanelController extends Controller
{
    function dashboard()
    {


        $payloads['total_deposits'] = Deposit::select(DB::raw('SUM(total_amount) as total_amount'))
            ->whereIn('status', [cons()::ACCEPTED, cons()::ACTIVE])
            ->value('total_amount');


        $payloads['total_withdraw'] = Withdraw::accepted()->sum('withdraw_amount');

        $payloads['total_earnings'] = UserEarnings::sum('amount');

        $payloads['total_users'] = User::count();

        $payloads['active_users'] = User::active()->count();

        $payloads['inactive_users'] = User::inactive()->count();

        $payloads['email_unverified_users'] = User::emailUnverified()->count();

        $payloads['latest_users'] = User::latest()->get()->take(6);

        $payloads['user_status'] = User::latest()->get()->take(6);

        $payloads['pending_supports'] = Support::openSupport()->latest()->count();

        $payloads['deposits'] = Deposit::latest()->paginate(offsetPerPage(6));

        $payloads['withdraw_requests'] = Withdraw::latest()->paginate(offsetPerPage(6));

        $payloads['total_stages'] = Stage::count();
        $payloads['total_token_sale'] = StagePurchase::accepted()->sum('token');
        $payloads['total_auction'] = Auction::count();
        $payloads['auction_profit'] = AuctionPurchase::sum('admin_profit');

        $payloads['dates'] = Deposit::select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'))
            ->union(Withdraw::select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date')))
            ->orderBy(DB::raw('STR_TO_DATE(date, "%d %b")'), 'ASC')
            ->pluck('date');


        $payloads['tokenDates'] = StagePurchase::where('status', cons()::ACCEPTED)->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'))
            ->orderBy(DB::raw(' STR_TO_DATE(date, "%d %b")'), 'ASC')
            ->pluck('date')->unique();

        $payloads['depositData'] = Deposit::accepted()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(total_amount) as total_deposit'))->groupBy('date')->pluck('total_deposit', 'date');
        $payloads['withdrawData'] = Withdraw::accepted()->select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(withdraw_amount) as total_withdraw'))->groupBy('date')->pluck('total_withdraw', 'date');


        $payloads['tokenData'] = StagePurchase::select(DB::raw('DATE_FORMAT(created_at, "%d %b") as date'), DB::raw('SUM(token) as total_token'))
            ->where('status', cons()::ACCEPTED)
            ->groupBy(DB::raw('DATE_FORMAT(created_at, "%d %b")'))
            ->pluck('total_token', 'date');



        $payloads['finalDepositData'] = [];
        $payloads['finalWithdrawData'] = [];
        $payloads['finalFee'] = [];
        $payloads['finalTokenData'] = [];


        foreach ($payloads['dates'] as $date) {
            $payloads['finalDepositData'][] = $payloads['depositData'][$date] ?? 0;
            $payloads['finalWithdrawData'][] = $payloads['withdrawData'][$date] ?? 0;
            $payloads['finalFee'][] = $payloads['sending_fee'][$date] ?? 0;
        }

        foreach ($payloads['tokenDates'] as $date) {
            $payloads['finalTokenData'][] = $payloads['tokenData'][$date] ?? 0;
        }

        return view('backend.dashboard')->with($payloads);
    }

    function logout()
    {
        auth()->guard('admin')->logout();

        return redirect()
            ->route('panel.login')
            ->with('success', tt_trans('Logged out successfully', cons()::LANGUAGE_NOTIFICATION));
    }

    function adminProfile()
    {
        return view('backend.profile.index');
    }

    function adminProfileUpdate(ProfileUpdateRequest $profileUpdateRequest, AdminProfileUpdate $adminProfileUpdate)
    {
        $payloads = $profileUpdateRequest->validated();

        try {
            $response = $adminProfileUpdate->updateProfile($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function adminPasswordUpdate(PasswordUpdateRequest $passwordUpdateRequest, AdminProfileUpdate $adminProfileUpdate)
    {
        $payloads = $passwordUpdateRequest->validated();

        try {
            $response = $adminProfileUpdate->updatePassword($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
