<?php

namespace App\Http\Controllers\Backend\Referral;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Referral\SettingsUpdate;
use App\Http\Requests\Backend\Referral\StoreRequest;
use App\Http\Requests\Backend\Referral\UpdateRequest;
use App\Models\ReferralLevel;
use App\Models\ReferralSetting;
use App\Services\Backend\Referral\ReferralService;

class ReferralController extends Controller
{
    function __construct(){
        $this->middleware('permission:manage_referral,admin');
    }

    function referralSettings(){
        $payloads['settings'] = ReferralSetting::latest()->with('levels')->get();
       
        return view('backend.referral.index')->with($payloads);
    }

    function referralSettingsUpdate(SettingsUpdate $settingsUpdate, ReferralService $referralService){
        $payloads = $settingsUpdate->validated();

        try {
            $response = $referralService->referralSettingUpdate($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

       return redirectAfterOperation($response);
    }

    function referralLevelStore(StoreRequest $storeRequest, ReferralService $referralService){
        $payloads = $storeRequest->validated();

        try {
            $response = $referralService->store($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function referralLevelUpdate(UpdateRequest $updateRequest, ReferralService $referralService){
        $payloads = $updateRequest->validated();

        try {
            $response = $referralService->update($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function referralLevelDelete($levelid, ReferralService $referralService){
        $level = ReferralLevel::findOrFail($levelid);
        try {
            $response = $referralService->delete($level);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

       return redirectAfterOperation($response);
    }
}
