<?php

namespace App\Http\Controllers\Backend\Reports;

use App\Filters\DateFilter;
use App\Filters\LoginFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Models\ReferralCommission;
use App\Models\Transaction;
use App\Models\UserEarnings;
use App\Models\UserLogin;

class ReportController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_reports,admin');
    }

    function transactionsReport(){
        $payloads['transactions'] = Transaction::latest()->with('user')->filter([TrxFilter::class,DateFilter::class])->paginate(offsetPerPage());

        return view('backend.reports.transactions')->with($payloads);
    }

    function referralCommissionReport(){
        $payloads['comissions'] = ReferralCommission::latest()->with('commissionFrom','commissionTo')->filter([TrxFilter::class,DateFilter::class])->paginate(offsetPerPage());

        return view('backend.reports.comissions')->with($payloads);
    }

    function userEarningsReport(){
        $payloads['earnings'] = UserEarnings::latest()->with('user')->filter([DateFilter::class])->paginate(offsetPerPage());

        return view('backend.reports.earnings')->with($payloads);
    }

    function userLoginsReport(){
        $payloads['logins'] = UserLogin::latest()->with('user')->filter([DateFilter::class,LoginFilter::class])->paginate(offsetPerPage());

        return view('backend.reports.logins')->with($payloads);
    }

}
