<?php

namespace App\Http\Controllers\Backend\Role;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Role\RoleStoreRequest;
use App\Http\Requests\Backend\Role\RoleUpdateRequest;
use App\Services\Backend\Role\RoleService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class RoleController extends Controller
{
    function __construct()
    {
        $this->middleware(['permission:manage_role,admin']);
    }

    function index()
    {
        $payloads['roles'] = Role::where('name', '!=', 'Admin')->latest()->paginate(offsetPerPage());
        $payloads['permissions'] = Permission::latest()->get();

        return view('backend.role.index')->with($payloads);
    }

    function store(RoleStoreRequest $roleStoreRequest, RoleService $roleService)
    {
        $payloads = $roleStoreRequest->validated();

        try {
            DB::beginTransaction();
            $response = $roleService->insertRole($payloads);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function permissionFetch(Request $request)
    {
        $role = Role::find($request->id);

        $permissions = Permission::latest()->get();

        return view('backend.role.permissions', compact('role', 'permissions'));
    }

    function update(RoleUpdateRequest $roleUpdateRequest, RoleService $roleService, Role $role)
    {
        $payloads = $roleUpdateRequest->validated();

        try {
            DB::beginTransaction();
            $response = $roleService->updateRole($payloads, $role);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
