<?php

namespace App\Http\Controllers\Backend\Settings;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Settings\InvoiceUpdateRequest;
use App\Http\Requests\Backend\Settings\KycRequest;
use App\Http\Requests\Backend\Settings\MaintananceUpdateRequest;
use App\Http\Requests\Backend\Settings\PluginRequest;
use App\Http\Requests\Backend\Settings\SeoRequest;
use App\Http\Requests\Backend\Settings\SettingsRequest;
use App\Models\KycSetting;
use App\Services\Backend\Settings\SettingsService;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_settings,admin');
    }

    function settings(SettingsService $settingsService)
    {
        $payloads['zones'] = $settingsService->getTimzone();
        $payloads['kycSettings'] = KycSetting::latest()->get();

        clearCache();


        if (!session('tab')) {
            session()->put('tab', 'general');
        }

        return view('backend.settings.index')->with($payloads);
    }

    function settingsUpdate(SettingsRequest $settingsRequest, SettingsService $settingsService)
    {
        $payloads = $settingsRequest->validated();

        session()->put('tab', 'general');

        clearCache();

        try {
            $response = $settingsService->settingsUpdate($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function pluginUpdate(PluginRequest $pluginRequest, SettingsService $settingsService)
    {
        $payloads = $pluginRequest->validated();

        try {
            $response = $settingsService->pluginUpdate($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        session()->put('tab', 'plugin');

        clearCache();

        return redirectAfterOperation($response);
    }

    function kycUpdate(KycRequest $kycRequest, SettingsService $settingsService)
    {
        $payloads = $kycRequest->validated();

        session()->put('tab', 'kyc');

        try {
            $response = $settingsService->updateKycSettings($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        clearCache();

        return redirectAfterOperation($response);
    }

    function seoUpdate(SeoRequest $seoRequest, SettingsService $settingsService)
    {
        $payloads = $seoRequest->validated();

        session()->put('tab', 'cron');

        try {
            $response = $settingsService->seoSettings($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        clearCache();

        return redirectAfterOperation($response);
    }


    function invoiceBuilder(InvoiceUpdateRequest $invoiceUpdateRequest, SettingsService $settingsService){
        $payloads = $invoiceUpdateRequest->validated();

        session()->put('tab', 'invoice');

        try {
            $response = $settingsService->invoiceUpdate($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        clearCache();

        return redirectAfterOperation($response);
    }
    
    
    function maintananceUpdate(MaintananceUpdateRequest $maintananceUpdateRequest, SettingsService $settingsService)
    {
        $payloads = $maintananceUpdateRequest->validated();

        session()->put('tab', 'maintanance');

        try {
            $response = $settingsService->maintanaceSettings($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        clearCache();

        return redirectAfterOperation($response);
    }


    function cardUpdate(Request $request){
        $module = Module::find($request->module);

        if($module->isEnabled()){
            $module->disable();
        }else{
            $module->enable();
        }

        return redirect()->back()->with('success', $request->module.' status updated successfully');
    }
}
