<?php

namespace App\Http\Controllers\Backend\Support;

use App\Filters\SortFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Support\SupportReplyRequest;
use App\Models\Support;
use App\Models\SupportFile;
use App\Services\Backend\Support\SupportService;

class SupportController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_support,admin');   
    }

    function support(){

        $payloads['supports'] = Support::latest()->filter([TrxFilter::class,SortFilter::class])->paginate(offsetPerPage());

        return view('backend.support.index')->with($payloads);
    }

    function supportDetails($id){

        $payloads['support'] = Support::findOrFail($id);

        return view('backend.support.details')->with($payloads);
        
    }

    function supportFileDownload(SupportFile $supportFile){
        
        $path = cons()::IMAGE_UPLOAD_ROOT_PATH.'support/'.$supportFile->file;

        if (!file_exists($path)) {
            return back()->with('error', tt_trans('File Not Found', cons()::LANGUAGE_NOTIFICATION));
        }

        return response()->download($path);
    }

    function supportReply(SupportReplyRequest $supportReplyRequest, SupportService $supportService, $id){
        $payloads = $supportReplyRequest->validated();

        $support = Support::findOrFail($id);

        try {
            $response = $supportService->replySupport($payloads, $support);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function supportClosed($id, SupportService $supportService){

        $support = Support::findOrFail($id);

        try {
            $response = $supportService->closeTicket($support);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
