<?php

namespace App\Http\Controllers\Backend\Theme;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Theme\ThemeUpdateRequest;
use App\Models\Theme;
use Illuminate\Support\Facades\Cache;

class ThemesController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_theme,admin');
    }

    function theme()
    {
        $payloads['themes'] = Theme::latest()->get();

        if (request()->ajax()) {
            Cache::forget('cachedTheme');

            $theme = Theme::find(request()->theme);

            return view('backend.theme.form', compact('theme'));
        }

        return view('backend.theme.index')->with($payloads);
    }

    function themeUpdate(ThemeUpdateRequest $themeUpdateRequest)
    {
        $payloads = $themeUpdateRequest->validated();

        Cache::forget('cachedTheme');

        Theme::query()->update(['is_active' => false]);

        $theme = Theme::findOrFail($payloads['theme']);

        try {


            $logoPath = $theme->is_addon ? 'logo' : $theme->title . '/logo';
            $iconPath = $theme->is_addon ? 'icon' : $theme->title . '/icon';

            if (isset($payloads['logo'])) {
                $theme->logo = storeFile($payloads['logo'], $logoPath, $theme->logo);
            }

            if (isset($payloads['icon'])) {
                $theme->icon = storeFile($payloads['icon'], $iconPath, $theme->icon);
            }

            if (isset($payloads['dark_logo'])) {
                $theme->dark_logo = storeFile($payloads['dark_logo'], $logoPath, $theme->dark_logo);
            }
            $theme->primary_color = $payloads['primary_color'];
            $theme->secondary_color = $payloads['secondary_color'];

            $theme->heading_font = $payloads['heading_font'];
            $theme->heading_font_family = $payloads['heading_font_family'];
            $theme->paragraph_font = $payloads['paragraph_font'];
            $theme->paragraph_font_family = $payloads['paragraph_font_family'];

            $theme->is_active = true;
            $theme->save();

            setEnvironmentValue([
                'ACTIVE_THEME' => ucwords($theme->title),
                'THEME_TYPE' => $theme->is_addon? 'module' : 'core',
            ]);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        clearCache();

        Cache::forget('cachedContent');

        return back()->with('success', tt_trans('Theme Updated Successfully', cons()::LANGUAGE_NOTIFICATION));
    }
}
