<?php

namespace App\Http\Controllers\Backend\Update;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Update\UploadRequest;
use App\Services\Backend\Update\UpdateService;

class UpdateController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:manage_version,admin');
    }

    function uploadFile(UploadRequest $uploadRequest, UpdateService $updateService)
    {
        $payloads = $uploadRequest->validated();
        try {
            $response = $updateService->uploadVersion($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function update(UpdateService $updateService)
    {
        try {
            $response = $updateService->installUpdate('update');
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
