<?php

namespace App\Http\Controllers\Backend\Withdraw;

use App\Filters\DateFilter;
use App\Filters\SortFilter;
use App\Filters\TrxFilter;
use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Withdraw\WithdrawRejectRequest;
use App\Models\Withdraw;
use App\Services\Backend\Withdraw\WithdrawService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WithdrawController extends Controller
{

    function __construct(){
        $this->middleware('permission:manage_withdraw,admin');
    }


    function withdrawRequest()
    {
        $payloads['withdraw_requests'] = Withdraw::filter([TrxFilter::class, SortFilter::class,DateFilter::class])->latest()->paginate(offsetPerPage());

        return view('backend.withdraw.withdraw_request')->with($payloads);
    }

    function withdrawDetails(Request $request)
    {
        $withdraw = Withdraw::findOrFail($request->withdraw);

        return view('backend.withdraw.fetch_details',compact('withdraw'));
    }


    function withdrawAccept($id, WithdrawService $withdrawService){
        $withdraw = Withdraw::findOrFail($id);

        try {
            $response = $withdrawService->acceptWithdrawRequest($withdraw);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function withdrawReject($id,WithdrawRejectRequest $withdrawRejectRequest, WithdrawService $withdrawService){
        $withdraw = Withdraw::findOrFail($id);

        $payloads = $withdrawRejectRequest->validated();

        try {
            DB::beginTransaction();
            $response = $withdrawService->rejectWithdrawRequest($withdraw, $payloads);
            DB::commit();
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }
}
