<?php

namespace App\Http\Controllers\Backend\Withdraw;

use App\Http\Controllers\Controller;
use App\Http\Requests\Backend\Withdraw\StoreRequest;
use App\Http\Requests\Backend\Withdraw\UpdateRequest;
use App\Models\WithdrawMethod;
use App\Services\Backend\Withdraw\WithdrawService;
use Illuminate\Http\Request;

class WithdrawMethodController extends Controller
{

    function __construct(){
        $this->middleware('permission:manage_withdraw,admin');
    }

    
    function index(){
        $payloads['methods'] = WithdrawMethod::latest()->get();
        return view('backend.withdraw.index')->with($payloads);
    }

    function store(StoreRequest $storeRequest, WithdrawService $withdrawService){
        $payloads = $storeRequest->validated();

        try {
            $response = $withdrawService->createMethod($payloads);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }


    function methodFetch(Request $request){
        $payloads['method'] = WithdrawMethod::findOrFail($request->id);

        return view('backend.withdraw.fetch_method')->with($payloads);
    }

    function update(UpdateRequest $updateRequest, WithdrawService $withdrawService, $id){
        $payloads = $updateRequest->validated();
        $method = WithdrawMethod::findOrFail($id);

        try {
            $response = $withdrawService->updateMethod($payloads, $method);
        } catch (\Throwable $th) {
            return back()->with('error', $th->getMessage());
        }

        return redirectAfterOperation($response);
    }

    function destroy(){
        
    }
}
