<?php

namespace App\Http\Controllers;

use App\Models\Language;

class CommonController extends Controller
{
    function languageSwitch($code)
    {
        $lang = Language::where('code', $code)->first();

        if (!$lang) {
            session()->put('language', 'en');
        } else {
            session()->put('language', $lang->code);
        }

        return back()->with('success', tt_trans('Language changed successfully', cons()::LANGUAGE_NOTIFICATION));
    }

    function maintananceMode()
    {
        return view('frontend::maintanance');
    }

    function cookiePolicy()
    {
        if (!tc()->get('cookie_status')) {
            abort(404);
        }

        return view('frontend::cookie');
    }

    function notification()
    {
        $payloads['notifications'] = user()->unreadNotifications()->paginate(offsetPerPage());

        return view('user::notification')->with($payloads);
    }

    function markAsAllRead()
    {
        user()
            ->unreadNotifications()
            ->update(['read_at' => now()]);

        return back()->with('success', tt_trans('All notification mark as read', cons()::LANGUAGE_NOTIFICATION));
    }

    function notificationMarkAsRead($id)
    {
        $notification = user()->unreadNotifications()->where('id', $id)->first();

        $notification->markAsRead();

        return ['status' => true, 'message' => tt_trans('Mark as read', cons()::LANGUAGE_NOTIFICATION)];
    }
}
